package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.GatewayDiscordClient;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UserEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code UserEditMono.of()}.
 */
@Generated(from = "UserEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class UserEditMono extends UserEditMonoGenerator {
  private final String username_value;
  private final boolean username_absent;
  private final Image avatar_value;
  private final boolean avatar_absent;
  private final GatewayDiscordClient gateway;

  private UserEditMono(GatewayDiscordClient gateway) {
    this.gateway = Objects.requireNonNull(gateway, "gateway");
    Possible<String> username$impl = Possible.absent();
    Possible<Image> avatar$impl = Possible.absent();
    this.username_value = username$impl.toOptional().orElse(null);
    this.username_absent = username$impl.isAbsent();
    this.avatar_value = avatar$impl.toOptional().orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.initShim = null;
  }

  private UserEditMono(
      Possible<String> username,
      Possible<Image> avatar,
      GatewayDiscordClient gateway) {
    Possible<String> username$impl = username;
    Possible<Image> avatar$impl = avatar;
    this.gateway = gateway;
    this.username_value = username$impl.toOptional().orElse(null);
    this.username_absent = username$impl.isAbsent();
    this.avatar_value = avatar$impl.toOptional().orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "UserEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build UserEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @Override
  public Possible<String> username() {
    return username_absent ? Possible.absent() : Possible.of(username_value);
  }

  /**
   * @return The value of the {@code avatar} attribute
   */
  @Override
  public Possible<Image> avatar() {
    return avatar_absent ? Possible.absent() : Possible.of(avatar_value);
  }

  /**
   * @return The value of the {@code gateway} attribute
   */
  @Override
  public GatewayDiscordClient gateway() {
    return gateway;
  }

  public UserEditMono withUsername(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new UserEditMono(newValue, this.avatar(), this.gateway);
  }

  public UserEditMono withUsername(String value) {
    Possible<String> newValue = Possible.of(value);
    return new UserEditMono(newValue, this.avatar(), this.gateway);
  }

  public UserEditMono withAvatar(Possible<Image> value) {
    Possible<Image> newValue = Objects.requireNonNull(value);
    return new UserEditMono(this.username(), newValue, this.gateway);
  }

  public UserEditMono withAvatar(Image value) {
    Possible<Image> newValue = Possible.of(value);
    return new UserEditMono(this.username(), newValue, this.gateway);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserEditMono#gateway() gateway} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gateway
   * @return A modified copy of the {@code this} object
   */
  public final UserEditMono withGateway(GatewayDiscordClient value) {
    if (this.gateway == value) return this;
    GatewayDiscordClient newValue = Objects.requireNonNull(value, "gateway");
    return new UserEditMono(this.username(), this.avatar(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code UserEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserEditMono
        && equalTo(0, (UserEditMono) another);
  }

  private boolean equalTo(int synthetic, UserEditMono another) {
    return this.username().equals(another.username())
        && this.avatar().equals(another.avatar())
        && gateway.equals(another.gateway);
  }

  /**
   * Computes a hash code from attributes: {@code username}, {@code avatar}, {@code gateway}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (username().hashCode());
    h += (h << 5) + (avatar().hashCode());
    h += (h << 5) + gateway.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UserEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserEditMono{"
        + "username=" + (username().toString())
        + ", avatar=" + (avatar().toString())
        + ", gateway=" + gateway
        + "}";
  }

  /**
   * Construct a new immutable {@code UserEditMono} instance.
   * @param gateway The value for the {@code gateway} attribute
   * @return An immutable UserEditMono instance
   */
  public static UserEditMono of(GatewayDiscordClient gateway) {
    return new UserEditMono(gateway);
  }

  /**
   * Creates an immutable copy of a {@link UserEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UserEditMono instance
   */
  static UserEditMono copyOf(UserEditMonoGenerator instance) {
    if (instance instanceof UserEditMono) {
      return (UserEditMono) instance;
    }
    return UserEditMono.of(instance.gateway())
        .withUsername(instance.username())
        .withAvatar(instance.avatar());
  }

  public boolean isUsernamePresent() {
    return !username_absent;
  }

  public String usernameOrElse(String defaultValue) {
    return !username_absent ? username_value : defaultValue;
  }

  public boolean isAvatarPresent() {
    return !avatar_absent;
  }

  public Image avatarOrElse(Image defaultValue) {
    return !avatar_absent ? avatar_value : defaultValue;
  }
}
