package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link TextChannelCreateMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code TextChannelCreateMono.of()}.
 */
@Generated(from = "TextChannelCreateMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class TextChannelCreateMono extends TextChannelCreateMonoGenerator {
  private final @Nullable String reason;
  private final String name;
  private final String topic_value;
  private final boolean topic_absent;
  private final Integer rateLimitPerUser_value;
  private final boolean rateLimitPerUser_absent;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;
  private final Snowflake parentId_value;
  private final boolean parentId_absent;
  private final Boolean nsfw_value;
  private final boolean nsfw_absent;
  private final Guild guild;

  private TextChannelCreateMono(String name, Guild guild) {
    this.name = Objects.requireNonNull(name, "name");
    this.guild = Objects.requireNonNull(guild, "guild");
    this.reason = null;
    Possible<String> topic$impl = Possible.absent();
    Possible<Integer> rateLimitPerUser$impl = Possible.absent();
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    Possible<Snowflake> parentId$impl = Possible.absent();
    Possible<Boolean> nsfw$impl = Possible.absent();
    this.topic_value = topic$impl.toOptional().orElse(null);
    this.topic_absent = topic$impl.isAbsent();
    this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
    this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = parentId$impl.toOptional().orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.nsfw_value = nsfw$impl.toOptional().orElse(null);
    this.nsfw_absent = nsfw$impl.isAbsent();
    this.initShim = null;
  }

  private TextChannelCreateMono(
      @Nullable String reason,
      String name,
      Possible<String> topic,
      Possible<Integer> rateLimitPerUser,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites,
      Possible<Snowflake> parentId,
      Possible<Boolean> nsfw,
      Guild guild) {
    this.reason = reason;
    this.name = name;
    Possible<String> topic$impl = topic;
    Possible<Integer> rateLimitPerUser$impl = rateLimitPerUser;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    Possible<Snowflake> parentId$impl = parentId;
    Possible<Boolean> nsfw$impl = nsfw;
    this.guild = guild;
    this.topic_value = topic$impl.toOptional().orElse(null);
    this.topic_absent = topic$impl.isAbsent();
    this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
    this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = parentId$impl.toOptional().orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.nsfw_value = nsfw$impl.toOptional().orElse(null);
    this.nsfw_absent = nsfw$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "TextChannelCreateMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build TextChannelCreateMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code topic} attribute
   */
  @Override
  public Possible<String> topic() {
    return topic_absent ? Possible.absent() : Possible.of(topic_value);
  }

  /**
   * @return The value of the {@code rateLimitPerUser} attribute
   */
  @Override
  public Possible<Integer> rateLimitPerUser() {
    return rateLimitPerUser_absent ? Possible.absent() : Possible.of(rateLimitPerUser_value);
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @Override
  public Possible<Snowflake> parentId() {
    return parentId_absent ? Possible.absent() : Possible.of(parentId_value);
  }

  /**
   * @return The value of the {@code nsfw} attribute
   */
  @Override
  public Possible<Boolean> nsfw() {
    return nsfw_absent ? Possible.absent() : Possible.of(nsfw_value);
  }

  /**
   * @return The value of the {@code guild} attribute
   */
  @Override
  public Guild guild() {
    return guild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TextChannelCreateMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final TextChannelCreateMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new TextChannelCreateMono(
        value,
        this.name,
        this.topic(),
        this.rateLimitPerUser(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TextChannelCreateMono#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final TextChannelCreateMono withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new TextChannelCreateMono(
        this.reason,
        newValue,
        this.topic(),
        this.rateLimitPerUser(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public TextChannelCreateMono withTopic(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        newValue,
        this.rateLimitPerUser(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public TextChannelCreateMono withTopic(String value) {
    Possible<String> newValue = Possible.of(value);
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        newValue,
        this.rateLimitPerUser(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public TextChannelCreateMono withRateLimitPerUser(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public TextChannelCreateMono withRateLimitPerUser(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public TextChannelCreateMono withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.rateLimitPerUser(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public TextChannelCreateMono withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.rateLimitPerUser(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public TextChannelCreateMono withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.rateLimitPerUser(),
        this.position(),
        newValue,
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public TextChannelCreateMono withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.rateLimitPerUser(),
        this.position(),
        newValue,
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  @SafeVarargs
  public final TextChannelCreateMono withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.rateLimitPerUser(),
        this.position(),
        newValue,
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public TextChannelCreateMono withParentId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.rateLimitPerUser(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.nsfw(),
        this.guild);
  }

  public TextChannelCreateMono withParentId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.rateLimitPerUser(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.nsfw(),
        this.guild);
  }

  public TextChannelCreateMono withNsfw(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.rateLimitPerUser(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue,
        this.guild);
  }

  public TextChannelCreateMono withNsfw(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.rateLimitPerUser(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue,
        this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TextChannelCreateMono#guild() guild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guild
   * @return A modified copy of the {@code this} object
   */
  public final TextChannelCreateMono withGuild(Guild value) {
    if (this.guild == value) return this;
    Guild newValue = Objects.requireNonNull(value, "guild");
    return new TextChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.rateLimitPerUser(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code TextChannelCreateMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TextChannelCreateMono
        && equalTo(0, (TextChannelCreateMono) another);
  }

  private boolean equalTo(int synthetic, TextChannelCreateMono another) {
    return Objects.equals(reason, another.reason)
        && name.equals(another.name)
        && this.topic().equals(another.topic())
        && this.rateLimitPerUser().equals(another.rateLimitPerUser())
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value)
        && this.parentId().equals(another.parentId())
        && this.nsfw().equals(another.nsfw())
        && guild.equals(another.guild);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code topic}, {@code rateLimitPerUser}, {@code position}, {@code permissionOverwrites}, {@code parentId}, {@code nsfw}, {@code guild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (topic().hashCode());
    h += (h << 5) + (rateLimitPerUser().hashCode());
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    h += (h << 5) + (parentId().hashCode());
    h += (h << 5) + (nsfw().hashCode());
    h += (h << 5) + guild.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TextChannelCreateMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TextChannelCreateMono{"
        + "reason=" + reason
        + ", name=" + name
        + ", topic=" + (topic().toString())
        + ", rateLimitPerUser=" + (rateLimitPerUser().toString())
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + ", parentId=" + (parentId().toString())
        + ", nsfw=" + (nsfw().toString())
        + ", guild=" + guild
        + "}";
  }

  /**
   * Construct a new immutable {@code TextChannelCreateMono} instance.
   * @param name The value for the {@code name} attribute
   * @param guild The value for the {@code guild} attribute
   * @return An immutable TextChannelCreateMono instance
   */
  public static TextChannelCreateMono of(String name, Guild guild) {
    return new TextChannelCreateMono(name, guild);
  }

  /**
   * Creates an immutable copy of a {@link TextChannelCreateMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TextChannelCreateMono instance
   */
  static TextChannelCreateMono copyOf(TextChannelCreateMonoGenerator instance) {
    if (instance instanceof TextChannelCreateMono) {
      return (TextChannelCreateMono) instance;
    }
    return TextChannelCreateMono.of(instance.name(), instance.guild())
        .withReason(instance.reason())
        .withTopic(instance.topic())
        .withRateLimitPerUser(instance.rateLimitPerUser())
        .withPosition(instance.position())
        .withPermissionOverwrites(instance.permissionOverwrites())
        .withParentId(instance.parentId())
        .withNsfw(instance.nsfw());
  }

  public boolean isTopicPresent() {
    return !topic_absent;
  }

  public String topicOrElse(String defaultValue) {
    return !topic_absent ? topic_value : defaultValue;
  }

  public boolean isRateLimitPerUserPresent() {
    return !rateLimitPerUser_absent;
  }

  public Integer rateLimitPerUserOrElse(Integer defaultValue) {
    return !rateLimitPerUser_absent ? rateLimitPerUser_value : defaultValue;
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }

  public boolean isParentIdPresent() {
    return !parentId_absent;
  }

  public Snowflake parentIdOrElse(Snowflake defaultValue) {
    return !parentId_absent ? parentId_value : defaultValue;
  }

  public boolean isNsfwPresent() {
    return !nsfw_absent;
  }

  public Boolean nsfwOrElse(Boolean defaultValue) {
    return !nsfw_absent ? nsfw_value : defaultValue;
  }
}
