package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link StoreChannelEditSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code StoreChannelEditSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code StoreChannelEditSpec.create()}.
 */
@Generated(from = "StoreChannelEditSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class StoreChannelEditSpec implements StoreChannelEditSpecGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;
  private final Snowflake parentId_value;
  private final boolean parentId_absent;

  private StoreChannelEditSpec() {
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    Possible<Optional<Snowflake>> parentId$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.initShim = null;
  }

  private StoreChannelEditSpec(
      @Nullable String reason,
      Possible<String> name,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites,
      Possible<Optional<Snowflake>> parentId) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    Possible<Optional<Snowflake>> parentId$impl = parentId;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "StoreChannelEditSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build StoreChannelEditSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> parentId() {
    return parentId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(parentId_value));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StoreChannelEditSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final StoreChannelEditSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return validate(new StoreChannelEditSpec(value, this.name(), this.position(), this.permissionOverwrites(), this.parentId()));
  }

  public StoreChannelEditSpec withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new StoreChannelEditSpec(this.reason, newValue, this.position(), this.permissionOverwrites(), this.parentId()));
  }

  public StoreChannelEditSpec withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new StoreChannelEditSpec(this.reason, newValue, this.position(), this.permissionOverwrites(), this.parentId()));
  }

  public StoreChannelEditSpec withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return validate(new StoreChannelEditSpec(this.reason, this.name(), newValue, this.permissionOverwrites(), this.parentId()));
  }

  public StoreChannelEditSpec withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return validate(new StoreChannelEditSpec(this.reason, this.name(), newValue, this.permissionOverwrites(), this.parentId()));
  }

  public StoreChannelEditSpec withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), newValue, this.parentId()));
  }

  public StoreChannelEditSpec withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), newValue, this.parentId()));
  }

  @SafeVarargs
  public final StoreChannelEditSpec withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), newValue, this.parentId()));
  }

  public StoreChannelEditSpec withParentId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), this.permissionOverwrites(), newValue));
  }

  @Deprecated
  public StoreChannelEditSpec withParentId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), this.permissionOverwrites(), newValue));
  }

  public StoreChannelEditSpec withParentIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), this.permissionOverwrites(), newValue));
  }

  /**
   * This instance is equal to all instances of {@code StoreChannelEditSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof StoreChannelEditSpec
        && equalTo(0, (StoreChannelEditSpec) another);
  }

  private boolean equalTo(int synthetic, StoreChannelEditSpec another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value)
        && this.parentId().equals(another.parentId());
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code position}, {@code permissionOverwrites}, {@code parentId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    h += (h << 5) + (parentId().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code StoreChannelEditSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StoreChannelEditSpec{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + ", parentId=" + (parentId().toString())
        + "}";
  }

  private static final StoreChannelEditSpec INSTANCE = validate(new StoreChannelEditSpec());

  /**
   * Returns the default immutable singleton value of {@code StoreChannelEditSpec}
   * @return An immutable instance of StoreChannelEditSpec
   */
  public static StoreChannelEditSpec create() {
    return INSTANCE;
  }

  private static StoreChannelEditSpec validate(StoreChannelEditSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link StoreChannelEditSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StoreChannelEditSpec instance
   */
  static StoreChannelEditSpec copyOf(StoreChannelEditSpecGenerator instance) {
    if (instance instanceof StoreChannelEditSpec) {
      return (StoreChannelEditSpec) instance;
    }
    return StoreChannelEditSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }

  public boolean isParentIdPresent() {
    return !parentId_absent;
  }

  public Snowflake parentIdOrElse(Snowflake defaultValue) {
    return !parentId_absent ? parentId_value : defaultValue;
  }

  /**
   * Creates a builder for {@link StoreChannelEditSpec StoreChannelEditSpec}.
   * <pre>
   * StoreChannelEditSpec.builder()
   *    .reason(String | null) // nullable {@link StoreChannelEditSpec#reason() reason}
   *    .name(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link StoreChannelEditSpec#name() name}
   *    .position(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link StoreChannelEditSpec#position() position}
   *    .permissionOverwrites(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.object.PermissionOverwrite&amp;gt;&amp;gt;) // {@link StoreChannelEditSpec#permissionOverwrites() permissionOverwrites}
   *    .parentId(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.common.util.Snowflake&amp;gt;&amp;gt;) // {@link StoreChannelEditSpec#parentId() parentId}
   *    .build();
   * </pre>
   * @return A new StoreChannelEditSpec builder
   */
  public static StoreChannelEditSpec.Builder builder() {
    return new StoreChannelEditSpec.Builder();
  }

  /**
   * Builds instances of type {@link StoreChannelEditSpec StoreChannelEditSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StoreChannelEditSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<String> name_possible = Possible.absent();
    private Possible<Integer> position_possible = Possible.absent();
    private List<PermissionOverwrite> permissionOverwrites_list = null;
    private Possible<Optional<Snowflake>> parentId_possible = Possible.absent();
    private String reason;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StoreChannelEditSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StoreChannelEditSpec instance) {
      return from((StoreChannelEditSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code StoreChannelEditSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(StoreChannelEditSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      name(instance.name());
      position(instance.position());
      permissionOverwrites(instance.permissionOverwrites());
      parentId(instance.parentId());
      return this;
    }

    /**
     * Initializes the value for the {@link StoreChannelEditSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(Possible<String> value) {
      this.name_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(String value) {
      this.name_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder position(Possible<Integer> value) {
      this.position_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder position(Integer value) {
      this.position_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addPermissionOverwrite(PermissionOverwrite element) {
      permissionOverwrites_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllPermissionOverwrites(List<PermissionOverwrite> elements) {
      permissionOverwrites_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(Possible<List<PermissionOverwrite>> elements) {
      this.permissionOverwrites_list = null;
      elements.toOptional().ifPresent(e -> permissionOverwrites_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(List<PermissionOverwrite> elements) {
      this.permissionOverwrites_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(Iterable<PermissionOverwrite> elements) {
      this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder parentId(Possible<Optional<Snowflake>> value) {
      this.parentId_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder parentId(@Nullable Snowflake value) {
      this.parentId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder parentIdOrNull(@Nullable Snowflake value) {
      this.parentId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    /**
     * Builds a new {@link StoreChannelEditSpec StoreChannelEditSpec}.
     * @return An immutable instance of StoreChannelEditSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public StoreChannelEditSpec build() {
      return StoreChannelEditSpec.validate(new StoreChannelEditSpec(reason, name_build(), position_build(), permissionOverwrites_build(), parentId_build()));
    }

    private Possible<String> name_build() {
      return this.name_possible;
    }

    private Possible<Integer> position_build() {
      return this.position_possible;
    }

    private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
      return this.permissionOverwrites_list == null ? Possible.absent() :
          Possible.of(this.permissionOverwrites_list);
    }

    private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
      if (this.permissionOverwrites_list == null) {
        this.permissionOverwrites_list = new ArrayList<>();
      }
      return this.permissionOverwrites_list;
    }

    private Possible<Optional<Snowflake>> parentId_build() {
      return this.parentId_possible;
    }
  }
}
