package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.StoreChannel;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link StoreChannelEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code StoreChannelEditMono.of()}.
 */
@Generated(from = "StoreChannelEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class StoreChannelEditMono extends StoreChannelEditMonoGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;
  private final Snowflake parentId_value;
  private final boolean parentId_absent;
  private final StoreChannel channel;

  private StoreChannelEditMono(StoreChannel channel) {
    this.channel = Objects.requireNonNull(channel, "channel");
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    Possible<Optional<Snowflake>> parentId$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.initShim = null;
  }

  private StoreChannelEditMono(
      @Nullable String reason,
      Possible<String> name,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites,
      Possible<Optional<Snowflake>> parentId,
      StoreChannel channel) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    Possible<Optional<Snowflake>> parentId$impl = parentId;
    this.channel = channel;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "StoreChannelEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build StoreChannelEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> parentId() {
    return parentId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(parentId_value));
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @Override
  public StoreChannel channel() {
    return channel;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StoreChannelEditMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final StoreChannelEditMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new StoreChannelEditMono(value, this.name(), this.position(), this.permissionOverwrites(), this.parentId(), this.channel);
  }

  public StoreChannelEditMono withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new StoreChannelEditMono(
        this.reason,
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.channel);
  }

  public StoreChannelEditMono withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return new StoreChannelEditMono(
        this.reason,
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.channel);
  }

  public StoreChannelEditMono withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new StoreChannelEditMono(this.reason, this.name(), newValue, this.permissionOverwrites(), this.parentId(), this.channel);
  }

  public StoreChannelEditMono withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new StoreChannelEditMono(this.reason, this.name(), newValue, this.permissionOverwrites(), this.parentId(), this.channel);
  }

  public StoreChannelEditMono withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return new StoreChannelEditMono(this.reason, this.name(), this.position(), newValue, this.parentId(), this.channel);
  }

  public StoreChannelEditMono withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new StoreChannelEditMono(this.reason, this.name(), this.position(), newValue, this.parentId(), this.channel);
  }

  @SafeVarargs
  public final StoreChannelEditMono withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return new StoreChannelEditMono(this.reason, this.name(), this.position(), newValue, this.parentId(), this.channel);
  }

  public StoreChannelEditMono withParentId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return new StoreChannelEditMono(this.reason, this.name(), this.position(), this.permissionOverwrites(), newValue, this.channel);
  }

  @Deprecated
  public StoreChannelEditMono withParentId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new StoreChannelEditMono(this.reason, this.name(), this.position(), this.permissionOverwrites(), newValue, this.channel);
  }

  public StoreChannelEditMono withParentIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new StoreChannelEditMono(this.reason, this.name(), this.position(), this.permissionOverwrites(), newValue, this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StoreChannelEditMono#channel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final StoreChannelEditMono withChannel(StoreChannel value) {
    if (this.channel == value) return this;
    StoreChannel newValue = Objects.requireNonNull(value, "channel");
    return new StoreChannelEditMono(
        this.reason,
        this.name(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code StoreChannelEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof StoreChannelEditMono
        && equalTo(0, (StoreChannelEditMono) another);
  }

  private boolean equalTo(int synthetic, StoreChannelEditMono another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value)
        && this.parentId().equals(another.parentId())
        && channel.equals(another.channel);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code position}, {@code permissionOverwrites}, {@code parentId}, {@code channel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    h += (h << 5) + (parentId().hashCode());
    h += (h << 5) + channel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StoreChannelEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StoreChannelEditMono{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + ", parentId=" + (parentId().toString())
        + ", channel=" + channel
        + "}";
  }

  /**
   * Construct a new immutable {@code StoreChannelEditMono} instance.
   * @param channel The value for the {@code channel} attribute
   * @return An immutable StoreChannelEditMono instance
   */
  public static StoreChannelEditMono of(StoreChannel channel) {
    return new StoreChannelEditMono(channel);
  }

  /**
   * Creates an immutable copy of a {@link StoreChannelEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StoreChannelEditMono instance
   */
  static StoreChannelEditMono copyOf(StoreChannelEditMonoGenerator instance) {
    if (instance instanceof StoreChannelEditMono) {
      return (StoreChannelEditMono) instance;
    }
    return StoreChannelEditMono.of(instance.channel())
        .withReason(instance.reason())
        .withName(instance.name())
        .withPosition(instance.position())
        .withPermissionOverwrites(instance.permissionOverwrites())
        .withParentId(instance.parentId());
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }

  public boolean isParentIdPresent() {
    return !parentId_absent;
  }

  public Snowflake parentIdOrElse(Snowflake defaultValue) {
    return !parentId_absent ? parentId_value : defaultValue;
  }
}
