package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.entity.Role;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import discord4j.rest.util.PermissionSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link RoleEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code RoleEditMono.of()}.
 */
@Generated(from = "RoleEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class RoleEditMono extends RoleEditMonoGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final PermissionSet permissions_value;
  private final boolean permissions_absent;
  private final Color color_value;
  private final boolean color_absent;
  private final Boolean hoist_value;
  private final boolean hoist_absent;
  private final Boolean mentionable_value;
  private final boolean mentionable_absent;
  private final Role role;

  private RoleEditMono(Role role) {
    this.role = Objects.requireNonNull(role, "role");
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<PermissionSet> permissions$impl = Possible.absent();
    Possible<Color> color$impl = Possible.absent();
    Possible<Boolean> hoist$impl = Possible.absent();
    Possible<Boolean> mentionable$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.permissions_value = permissions$impl.toOptional().orElse(null);
    this.permissions_absent = permissions$impl.isAbsent();
    this.color_value = color$impl.toOptional().orElse(null);
    this.color_absent = color$impl.isAbsent();
    this.hoist_value = hoist$impl.toOptional().orElse(null);
    this.hoist_absent = hoist$impl.isAbsent();
    this.mentionable_value = mentionable$impl.toOptional().orElse(null);
    this.mentionable_absent = mentionable$impl.isAbsent();
    this.initShim = null;
  }

  private RoleEditMono(
      @Nullable String reason,
      Possible<String> name,
      Possible<PermissionSet> permissions,
      Possible<Color> color,
      Possible<Boolean> hoist,
      Possible<Boolean> mentionable,
      Role role) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<PermissionSet> permissions$impl = permissions;
    Possible<Color> color$impl = color;
    Possible<Boolean> hoist$impl = hoist;
    Possible<Boolean> mentionable$impl = mentionable;
    this.role = role;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.permissions_value = permissions$impl.toOptional().orElse(null);
    this.permissions_absent = permissions$impl.isAbsent();
    this.color_value = color$impl.toOptional().orElse(null);
    this.color_absent = color$impl.isAbsent();
    this.hoist_value = hoist$impl.toOptional().orElse(null);
    this.hoist_absent = hoist$impl.isAbsent();
    this.mentionable_value = mentionable$impl.toOptional().orElse(null);
    this.mentionable_absent = mentionable$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "RoleEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build RoleEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code permissions} attribute
   */
  @Override
  public Possible<PermissionSet> permissions() {
    return permissions_absent ? Possible.absent() : Possible.of(permissions_value);
  }

  /**
   * @return The value of the {@code color} attribute
   */
  @Override
  public Possible<Color> color() {
    return color_absent ? Possible.absent() : Possible.of(color_value);
  }

  /**
   * @return The value of the {@code hoist} attribute
   */
  @Override
  public Possible<Boolean> hoist() {
    return hoist_absent ? Possible.absent() : Possible.of(hoist_value);
  }

  /**
   * @return The value of the {@code mentionable} attribute
   */
  @Override
  public Possible<Boolean> mentionable() {
    return mentionable_absent ? Possible.absent() : Possible.of(mentionable_value);
  }

  /**
   * @return The value of the {@code role} attribute
   */
  @Override
  public Role role() {
    return role;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoleEditMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final RoleEditMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new RoleEditMono(
        value,
        this.name(),
        this.permissions(),
        this.color(),
        this.hoist(),
        this.mentionable(),
        this.role);
  }

  public RoleEditMono withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new RoleEditMono(
        this.reason,
        newValue,
        this.permissions(),
        this.color(),
        this.hoist(),
        this.mentionable(),
        this.role);
  }

  public RoleEditMono withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return new RoleEditMono(
        this.reason,
        newValue,
        this.permissions(),
        this.color(),
        this.hoist(),
        this.mentionable(),
        this.role);
  }

  public RoleEditMono withPermissions(Possible<PermissionSet> value) {
    Possible<PermissionSet> newValue = Objects.requireNonNull(value);
    return new RoleEditMono(this.reason, this.name(), newValue, this.color(), this.hoist(), this.mentionable(), this.role);
  }

  public RoleEditMono withPermissions(PermissionSet value) {
    Possible<PermissionSet> newValue = Possible.of(value);
    return new RoleEditMono(this.reason, this.name(), newValue, this.color(), this.hoist(), this.mentionable(), this.role);
  }

  public RoleEditMono withColor(Possible<Color> value) {
    Possible<Color> newValue = Objects.requireNonNull(value);
    return new RoleEditMono(
        this.reason,
        this.name(),
        this.permissions(),
        newValue,
        this.hoist(),
        this.mentionable(),
        this.role);
  }

  public RoleEditMono withColor(Color value) {
    Possible<Color> newValue = Possible.of(value);
    return new RoleEditMono(
        this.reason,
        this.name(),
        this.permissions(),
        newValue,
        this.hoist(),
        this.mentionable(),
        this.role);
  }

  public RoleEditMono withHoist(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new RoleEditMono(
        this.reason,
        this.name(),
        this.permissions(),
        this.color(),
        newValue,
        this.mentionable(),
        this.role);
  }

  public RoleEditMono withHoist(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new RoleEditMono(
        this.reason,
        this.name(),
        this.permissions(),
        this.color(),
        newValue,
        this.mentionable(),
        this.role);
  }

  public RoleEditMono withMentionable(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new RoleEditMono(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), newValue, this.role);
  }

  public RoleEditMono withMentionable(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new RoleEditMono(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), newValue, this.role);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoleEditMono#role() role} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for role
   * @return A modified copy of the {@code this} object
   */
  public final RoleEditMono withRole(Role value) {
    if (this.role == value) return this;
    Role newValue = Objects.requireNonNull(value, "role");
    return new RoleEditMono(
        this.reason,
        this.name(),
        this.permissions(),
        this.color(),
        this.hoist(),
        this.mentionable(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code RoleEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RoleEditMono
        && equalTo(0, (RoleEditMono) another);
  }

  private boolean equalTo(int synthetic, RoleEditMono another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.permissions().equals(another.permissions())
        && this.color().equals(another.color())
        && this.hoist().equals(another.hoist())
        && this.mentionable().equals(another.mentionable())
        && role.equals(another.role);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code permissions}, {@code color}, {@code hoist}, {@code mentionable}, {@code role}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (permissions().hashCode());
    h += (h << 5) + (color().hashCode());
    h += (h << 5) + (hoist().hashCode());
    h += (h << 5) + (mentionable().hashCode());
    h += (h << 5) + role.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RoleEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RoleEditMono{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", permissions=" + (permissions().toString())
        + ", color=" + (color().toString())
        + ", hoist=" + (hoist().toString())
        + ", mentionable=" + (mentionable().toString())
        + ", role=" + role
        + "}";
  }

  /**
   * Construct a new immutable {@code RoleEditMono} instance.
   * @param role The value for the {@code role} attribute
   * @return An immutable RoleEditMono instance
   */
  public static RoleEditMono of(Role role) {
    return new RoleEditMono(role);
  }

  /**
   * Creates an immutable copy of a {@link RoleEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RoleEditMono instance
   */
  static RoleEditMono copyOf(RoleEditMonoGenerator instance) {
    if (instance instanceof RoleEditMono) {
      return (RoleEditMono) instance;
    }
    return RoleEditMono.of(instance.role())
        .withReason(instance.reason())
        .withName(instance.name())
        .withPermissions(instance.permissions())
        .withColor(instance.color())
        .withHoist(instance.hoist())
        .withMentionable(instance.mentionable());
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isPermissionsPresent() {
    return !permissions_absent;
  }

  public PermissionSet permissionsOrElse(PermissionSet defaultValue) {
    return !permissions_absent ? permissions_value : defaultValue;
  }

  public boolean isColorPresent() {
    return !color_absent;
  }

  public Color colorOrElse(Color defaultValue) {
    return !color_absent ? color_value : defaultValue;
  }

  public boolean isHoistPresent() {
    return !hoist_absent;
  }

  public Boolean hoistOrElse(Boolean defaultValue) {
    return !hoist_absent ? hoist_value : defaultValue;
  }

  public boolean isMentionablePresent() {
    return !mentionable_absent;
  }

  public Boolean mentionableOrElse(Boolean defaultValue) {
    return !mentionable_absent ? mentionable_value : defaultValue;
  }
}
