package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import discord4j.rest.util.PermissionSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link RoleCreateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code RoleCreateSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code RoleCreateSpec.create()}.
 */
@Generated(from = "RoleCreateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class RoleCreateSpec implements RoleCreateSpecGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final PermissionSet permissions_value;
  private final boolean permissions_absent;
  private final Color color_value;
  private final boolean color_absent;
  private final Boolean hoist_value;
  private final boolean hoist_absent;
  private final Boolean mentionable_value;
  private final boolean mentionable_absent;

  private RoleCreateSpec() {
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<PermissionSet> permissions$impl = Possible.absent();
    Possible<Color> color$impl = Possible.absent();
    Possible<Boolean> hoist$impl = Possible.absent();
    Possible<Boolean> mentionable$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.permissions_value = permissions$impl.toOptional().orElse(null);
    this.permissions_absent = permissions$impl.isAbsent();
    this.color_value = color$impl.toOptional().orElse(null);
    this.color_absent = color$impl.isAbsent();
    this.hoist_value = hoist$impl.toOptional().orElse(null);
    this.hoist_absent = hoist$impl.isAbsent();
    this.mentionable_value = mentionable$impl.toOptional().orElse(null);
    this.mentionable_absent = mentionable$impl.isAbsent();
    this.initShim = null;
  }

  private RoleCreateSpec(
      @Nullable String reason,
      Possible<String> name,
      Possible<PermissionSet> permissions,
      Possible<Color> color,
      Possible<Boolean> hoist,
      Possible<Boolean> mentionable) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<PermissionSet> permissions$impl = permissions;
    Possible<Color> color$impl = color;
    Possible<Boolean> hoist$impl = hoist;
    Possible<Boolean> mentionable$impl = mentionable;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.permissions_value = permissions$impl.toOptional().orElse(null);
    this.permissions_absent = permissions$impl.isAbsent();
    this.color_value = color$impl.toOptional().orElse(null);
    this.color_absent = color$impl.isAbsent();
    this.hoist_value = hoist$impl.toOptional().orElse(null);
    this.hoist_absent = hoist$impl.isAbsent();
    this.mentionable_value = mentionable$impl.toOptional().orElse(null);
    this.mentionable_absent = mentionable$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "RoleCreateSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build RoleCreateSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code permissions} attribute
   */
  @Override
  public Possible<PermissionSet> permissions() {
    return permissions_absent ? Possible.absent() : Possible.of(permissions_value);
  }

  /**
   * @return The value of the {@code color} attribute
   */
  @Override
  public Possible<Color> color() {
    return color_absent ? Possible.absent() : Possible.of(color_value);
  }

  /**
   * @return The value of the {@code hoist} attribute
   */
  @Override
  public Possible<Boolean> hoist() {
    return hoist_absent ? Possible.absent() : Possible.of(hoist_value);
  }

  /**
   * @return The value of the {@code mentionable} attribute
   */
  @Override
  public Possible<Boolean> mentionable() {
    return mentionable_absent ? Possible.absent() : Possible.of(mentionable_value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RoleCreateSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final RoleCreateSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return validate(new RoleCreateSpec(value, this.name(), this.permissions(), this.color(), this.hoist(), this.mentionable()));
  }

  public RoleCreateSpec withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new RoleCreateSpec(this.reason, newValue, this.permissions(), this.color(), this.hoist(), this.mentionable()));
  }

  public RoleCreateSpec withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new RoleCreateSpec(this.reason, newValue, this.permissions(), this.color(), this.hoist(), this.mentionable()));
  }

  public RoleCreateSpec withPermissions(Possible<PermissionSet> value) {
    Possible<PermissionSet> newValue = Objects.requireNonNull(value);
    return validate(new RoleCreateSpec(this.reason, this.name(), newValue, this.color(), this.hoist(), this.mentionable()));
  }

  public RoleCreateSpec withPermissions(PermissionSet value) {
    Possible<PermissionSet> newValue = Possible.of(value);
    return validate(new RoleCreateSpec(this.reason, this.name(), newValue, this.color(), this.hoist(), this.mentionable()));
  }

  public RoleCreateSpec withColor(Possible<Color> value) {
    Possible<Color> newValue = Objects.requireNonNull(value);
    return validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), newValue, this.hoist(), this.mentionable()));
  }

  public RoleCreateSpec withColor(Color value) {
    Possible<Color> newValue = Possible.of(value);
    return validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), newValue, this.hoist(), this.mentionable()));
  }

  public RoleCreateSpec withHoist(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), this.color(), newValue, this.mentionable()));
  }

  public RoleCreateSpec withHoist(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), this.color(), newValue, this.mentionable()));
  }

  public RoleCreateSpec withMentionable(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), newValue));
  }

  public RoleCreateSpec withMentionable(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), newValue));
  }

  /**
   * This instance is equal to all instances of {@code RoleCreateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RoleCreateSpec
        && equalTo(0, (RoleCreateSpec) another);
  }

  private boolean equalTo(int synthetic, RoleCreateSpec another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.permissions().equals(another.permissions())
        && this.color().equals(another.color())
        && this.hoist().equals(another.hoist())
        && this.mentionable().equals(another.mentionable());
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code permissions}, {@code color}, {@code hoist}, {@code mentionable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (permissions().hashCode());
    h += (h << 5) + (color().hashCode());
    h += (h << 5) + (hoist().hashCode());
    h += (h << 5) + (mentionable().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code RoleCreateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RoleCreateSpec{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", permissions=" + (permissions().toString())
        + ", color=" + (color().toString())
        + ", hoist=" + (hoist().toString())
        + ", mentionable=" + (mentionable().toString())
        + "}";
  }

  private static final RoleCreateSpec INSTANCE = validate(new RoleCreateSpec());

  /**
   * Returns the default immutable singleton value of {@code RoleCreateSpec}
   * @return An immutable instance of RoleCreateSpec
   */
  public static RoleCreateSpec create() {
    return INSTANCE;
  }

  private static RoleCreateSpec validate(RoleCreateSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link RoleCreateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RoleCreateSpec instance
   */
  static RoleCreateSpec copyOf(RoleCreateSpecGenerator instance) {
    if (instance instanceof RoleCreateSpec) {
      return (RoleCreateSpec) instance;
    }
    return RoleCreateSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isPermissionsPresent() {
    return !permissions_absent;
  }

  public PermissionSet permissionsOrElse(PermissionSet defaultValue) {
    return !permissions_absent ? permissions_value : defaultValue;
  }

  public boolean isColorPresent() {
    return !color_absent;
  }

  public Color colorOrElse(Color defaultValue) {
    return !color_absent ? color_value : defaultValue;
  }

  public boolean isHoistPresent() {
    return !hoist_absent;
  }

  public Boolean hoistOrElse(Boolean defaultValue) {
    return !hoist_absent ? hoist_value : defaultValue;
  }

  public boolean isMentionablePresent() {
    return !mentionable_absent;
  }

  public Boolean mentionableOrElse(Boolean defaultValue) {
    return !mentionable_absent ? mentionable_value : defaultValue;
  }

  /**
   * Creates a builder for {@link RoleCreateSpec RoleCreateSpec}.
   * <pre>
   * RoleCreateSpec.builder()
   *    .reason(String | null) // nullable {@link RoleCreateSpec#reason() reason}
   *    .name(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link RoleCreateSpec#name() name}
   *    .permissions(discord4j.discordjson.possible.Possible&amp;lt;discord4j.rest.util.PermissionSet&amp;gt;) // {@link RoleCreateSpec#permissions() permissions}
   *    .color(discord4j.discordjson.possible.Possible&amp;lt;discord4j.rest.util.Color&amp;gt;) // {@link RoleCreateSpec#color() color}
   *    .hoist(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link RoleCreateSpec#hoist() hoist}
   *    .mentionable(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link RoleCreateSpec#mentionable() mentionable}
   *    .build();
   * </pre>
   * @return A new RoleCreateSpec builder
   */
  public static RoleCreateSpec.Builder builder() {
    return new RoleCreateSpec.Builder();
  }

  /**
   * Builds instances of type {@link RoleCreateSpec RoleCreateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RoleCreateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<String> name_possible = Possible.absent();
    private Possible<PermissionSet> permissions_possible = Possible.absent();
    private Possible<Color> color_possible = Possible.absent();
    private Possible<Boolean> hoist_possible = Possible.absent();
    private Possible<Boolean> mentionable_possible = Possible.absent();
    private String reason;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RoleCreateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RoleCreateSpec instance) {
      return from((RoleCreateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code RoleCreateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(RoleCreateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      name(instance.name());
      permissions(instance.permissions());
      color(instance.color());
      hoist(instance.hoist());
      mentionable(instance.mentionable());
      return this;
    }

    /**
     * Initializes the value for the {@link RoleCreateSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(Possible<String> value) {
      this.name_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(String value) {
      this.name_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissions(Possible<PermissionSet> value) {
      this.permissions_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissions(PermissionSet value) {
      this.permissions_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder color(Possible<Color> value) {
      this.color_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder color(Color value) {
      this.color_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder hoist(Possible<Boolean> value) {
      this.hoist_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder hoist(Boolean value) {
      this.hoist_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder mentionable(Possible<Boolean> value) {
      this.mentionable_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder mentionable(Boolean value) {
      this.mentionable_possible = Possible.of(value);
      return this;
    }

    /**
     * Builds a new {@link RoleCreateSpec RoleCreateSpec}.
     * @return An immutable instance of RoleCreateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RoleCreateSpec build() {
      return RoleCreateSpec.validate(new RoleCreateSpec(reason, name_build(), permissions_build(), color_build(), hoist_build(), mentionable_build()));
    }

    private Possible<String> name_build() {
      return this.name_possible;
    }

    private Possible<PermissionSet> permissions_build() {
      return this.permissions_possible;
    }

    private Possible<Color> color_build() {
      return this.color_possible;
    }

    private Possible<Boolean> hoist_build() {
      return this.hoist_possible;
    }

    private Possible<Boolean> mentionable_build() {
      return this.mentionable_possible;
    }
  }
}
