package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link NewsChannelCreateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code NewsChannelCreateSpec.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code NewsChannelCreateSpec.of()}.
 */
@Generated(from = "NewsChannelCreateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class NewsChannelCreateSpec implements NewsChannelCreateSpecGenerator {
  private final @Nullable String reason;
  private final String name;
  private final String topic_value;
  private final boolean topic_absent;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;
  private final Snowflake parentId_value;
  private final boolean parentId_absent;
  private final Boolean nsfw_value;
  private final boolean nsfw_absent;

  private NewsChannelCreateSpec(String name) {
    this.name = Objects.requireNonNull(name, "name");
    this.reason = null;
    Possible<String> topic$impl = Possible.absent();
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    Possible<Snowflake> parentId$impl = Possible.absent();
    Possible<Boolean> nsfw$impl = Possible.absent();
    this.topic_value = topic$impl.toOptional().orElse(null);
    this.topic_absent = topic$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = parentId$impl.toOptional().orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.nsfw_value = nsfw$impl.toOptional().orElse(null);
    this.nsfw_absent = nsfw$impl.isAbsent();
    this.initShim = null;
  }

  private NewsChannelCreateSpec(
      @Nullable String reason,
      String name,
      Possible<String> topic,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites,
      Possible<Snowflake> parentId,
      Possible<Boolean> nsfw) {
    this.reason = reason;
    this.name = name;
    Possible<String> topic$impl = topic;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    Possible<Snowflake> parentId$impl = parentId;
    Possible<Boolean> nsfw$impl = nsfw;
    this.topic_value = topic$impl.toOptional().orElse(null);
    this.topic_absent = topic$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = parentId$impl.toOptional().orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.nsfw_value = nsfw$impl.toOptional().orElse(null);
    this.nsfw_absent = nsfw$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "NewsChannelCreateSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build NewsChannelCreateSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code topic} attribute
   */
  @Override
  public Possible<String> topic() {
    return topic_absent ? Possible.absent() : Possible.of(topic_value);
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @Override
  public Possible<Snowflake> parentId() {
    return parentId_absent ? Possible.absent() : Possible.of(parentId_value);
  }

  /**
   * @return The value of the {@code nsfw} attribute
   */
  @Override
  public Possible<Boolean> nsfw() {
    return nsfw_absent ? Possible.absent() : Possible.of(nsfw_value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NewsChannelCreateSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final NewsChannelCreateSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new NewsChannelCreateSpec(
        value,
        this.name,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw());
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NewsChannelCreateSpec#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final NewsChannelCreateSpec withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new NewsChannelCreateSpec(
        this.reason,
        newValue,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw());
  }

  public NewsChannelCreateSpec withTopic(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new NewsChannelCreateSpec(
        this.reason,
        this.name,
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw());
  }

  public NewsChannelCreateSpec withTopic(String value) {
    Possible<String> newValue = Possible.of(value);
    return new NewsChannelCreateSpec(
        this.reason,
        this.name,
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw());
  }

  public NewsChannelCreateSpec withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new NewsChannelCreateSpec(
        this.reason,
        this.name,
        this.topic(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw());
  }

  public NewsChannelCreateSpec withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new NewsChannelCreateSpec(
        this.reason,
        this.name,
        this.topic(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw());
  }

  public NewsChannelCreateSpec withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return new NewsChannelCreateSpec(this.reason, this.name, this.topic(), this.position(), newValue, this.parentId(), this.nsfw());
  }

  public NewsChannelCreateSpec withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new NewsChannelCreateSpec(this.reason, this.name, this.topic(), this.position(), newValue, this.parentId(), this.nsfw());
  }

  @SafeVarargs
  public final NewsChannelCreateSpec withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return new NewsChannelCreateSpec(this.reason, this.name, this.topic(), this.position(), newValue, this.parentId(), this.nsfw());
  }

  public NewsChannelCreateSpec withParentId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return new NewsChannelCreateSpec(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.nsfw());
  }

  public NewsChannelCreateSpec withParentId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return new NewsChannelCreateSpec(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.nsfw());
  }

  public NewsChannelCreateSpec withNsfw(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new NewsChannelCreateSpec(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue);
  }

  public NewsChannelCreateSpec withNsfw(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new NewsChannelCreateSpec(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code NewsChannelCreateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof NewsChannelCreateSpec
        && equalTo(0, (NewsChannelCreateSpec) another);
  }

  private boolean equalTo(int synthetic, NewsChannelCreateSpec another) {
    return Objects.equals(reason, another.reason)
        && name.equals(another.name)
        && this.topic().equals(another.topic())
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value)
        && this.parentId().equals(another.parentId())
        && this.nsfw().equals(another.nsfw());
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code topic}, {@code position}, {@code permissionOverwrites}, {@code parentId}, {@code nsfw}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (topic().hashCode());
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    h += (h << 5) + (parentId().hashCode());
    h += (h << 5) + (nsfw().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code NewsChannelCreateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NewsChannelCreateSpec{"
        + "reason=" + reason
        + ", name=" + name
        + ", topic=" + (topic().toString())
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + ", parentId=" + (parentId().toString())
        + ", nsfw=" + (nsfw().toString())
        + "}";
  }

  /**
   * Construct a new immutable {@code NewsChannelCreateSpec} instance.
   * @param name The value for the {@code name} attribute
   * @return An immutable NewsChannelCreateSpec instance
   */
  public static NewsChannelCreateSpec of(String name) {
    return new NewsChannelCreateSpec(name);
  }

  /**
   * Creates an immutable copy of a {@link NewsChannelCreateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NewsChannelCreateSpec instance
   */
  static NewsChannelCreateSpec copyOf(NewsChannelCreateSpecGenerator instance) {
    if (instance instanceof NewsChannelCreateSpec) {
      return (NewsChannelCreateSpec) instance;
    }
    return NewsChannelCreateSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isTopicPresent() {
    return !topic_absent;
  }

  public String topicOrElse(String defaultValue) {
    return !topic_absent ? topic_value : defaultValue;
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }

  public boolean isParentIdPresent() {
    return !parentId_absent;
  }

  public Snowflake parentIdOrElse(Snowflake defaultValue) {
    return !parentId_absent ? parentId_value : defaultValue;
  }

  public boolean isNsfwPresent() {
    return !nsfw_absent;
  }

  public Boolean nsfwOrElse(Boolean defaultValue) {
    return !nsfw_absent ? nsfw_value : defaultValue;
  }

  /**
   * Creates a builder for {@link NewsChannelCreateSpec NewsChannelCreateSpec}.
   * <pre>
   * NewsChannelCreateSpec.builder()
   *    .reason(String | null) // nullable {@link NewsChannelCreateSpec#reason() reason}
   *    .name(String) // required {@link NewsChannelCreateSpec#name() name}
   *    .topic(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link NewsChannelCreateSpec#topic() topic}
   *    .position(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link NewsChannelCreateSpec#position() position}
   *    .permissionOverwrites(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.object.PermissionOverwrite&amp;gt;&amp;gt;) // {@link NewsChannelCreateSpec#permissionOverwrites() permissionOverwrites}
   *    .parentId(discord4j.discordjson.possible.Possible&amp;lt;discord4j.common.util.Snowflake&amp;gt;) // {@link NewsChannelCreateSpec#parentId() parentId}
   *    .nsfw(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link NewsChannelCreateSpec#nsfw() nsfw}
   *    .build();
   * </pre>
   * @return A new NewsChannelCreateSpec builder
   */
  public static NewsChannelCreateSpec.Builder builder() {
    return new NewsChannelCreateSpec.Builder();
  }

  /**
   * Builds instances of type {@link NewsChannelCreateSpec NewsChannelCreateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NewsChannelCreateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Possible<String> topic_possible = Possible.absent();
    private Possible<Integer> position_possible = Possible.absent();
    private List<PermissionOverwrite> permissionOverwrites_list = null;
    private Possible<Snowflake> parentId_possible = Possible.absent();
    private Possible<Boolean> nsfw_possible = Possible.absent();
    private String reason;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NewsChannelCreateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(NewsChannelCreateSpec instance) {
      return from((NewsChannelCreateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code NewsChannelCreateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(NewsChannelCreateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      name(instance.name());
      topic(instance.topic());
      position(instance.position());
      permissionOverwrites(instance.permissionOverwrites());
      parentId(instance.parentId());
      nsfw(instance.nsfw());
      return this;
    }

    /**
     * Initializes the value for the {@link NewsChannelCreateSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the value for the {@link NewsChannelCreateSpec#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder topic(Possible<String> value) {
      this.topic_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder topic(String value) {
      this.topic_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder position(Possible<Integer> value) {
      this.position_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder position(Integer value) {
      this.position_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addPermissionOverwrite(PermissionOverwrite element) {
      permissionOverwrites_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllPermissionOverwrites(List<PermissionOverwrite> elements) {
      permissionOverwrites_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(Possible<List<PermissionOverwrite>> elements) {
      this.permissionOverwrites_list = null;
      elements.toOptional().ifPresent(e -> permissionOverwrites_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(List<PermissionOverwrite> elements) {
      this.permissionOverwrites_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(Iterable<PermissionOverwrite> elements) {
      this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder parentId(Possible<Snowflake> value) {
      this.parentId_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder parentId(Snowflake value) {
      this.parentId_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder nsfw(Possible<Boolean> value) {
      this.nsfw_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder nsfw(Boolean value) {
      this.nsfw_possible = Possible.of(value);
      return this;
    }

    /**
     * Builds a new {@link NewsChannelCreateSpec NewsChannelCreateSpec}.
     * @return An immutable instance of NewsChannelCreateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public NewsChannelCreateSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new NewsChannelCreateSpec(
          reason,
          name,
          topic_build(),
          position_build(),
          permissionOverwrites_build(),
          parentId_build(),
          nsfw_build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build NewsChannelCreateSpec, some of required attributes are not set " + attributes;
    }

    private Possible<String> topic_build() {
      return this.topic_possible;
    }

    private Possible<Integer> position_build() {
      return this.position_possible;
    }

    private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
      return this.permissionOverwrites_list == null ? Possible.absent() :
          Possible.of(this.permissionOverwrites_list);
    }

    private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
      if (this.permissionOverwrites_list == null) {
        this.permissionOverwrites_list = new ArrayList<>();
      }
      return this.permissionOverwrites_list;
    }

    private Possible<Snowflake> parentId_build() {
      return this.parentId_possible;
    }

    private Possible<Boolean> nsfw_build() {
      return this.nsfw_possible;
    }
  }
}
