package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link NewsChannelCreateMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code NewsChannelCreateMono.of()}.
 */
@Generated(from = "NewsChannelCreateMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class NewsChannelCreateMono extends NewsChannelCreateMonoGenerator {
  private final @Nullable String reason;
  private final String name;
  private final String topic_value;
  private final boolean topic_absent;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;
  private final Snowflake parentId_value;
  private final boolean parentId_absent;
  private final Boolean nsfw_value;
  private final boolean nsfw_absent;
  private final Guild guild;

  private NewsChannelCreateMono(String name, Guild guild) {
    this.name = Objects.requireNonNull(name, "name");
    this.guild = Objects.requireNonNull(guild, "guild");
    this.reason = null;
    Possible<String> topic$impl = Possible.absent();
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    Possible<Snowflake> parentId$impl = Possible.absent();
    Possible<Boolean> nsfw$impl = Possible.absent();
    this.topic_value = topic$impl.toOptional().orElse(null);
    this.topic_absent = topic$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = parentId$impl.toOptional().orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.nsfw_value = nsfw$impl.toOptional().orElse(null);
    this.nsfw_absent = nsfw$impl.isAbsent();
    this.initShim = null;
  }

  private NewsChannelCreateMono(
      @Nullable String reason,
      String name,
      Possible<String> topic,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites,
      Possible<Snowflake> parentId,
      Possible<Boolean> nsfw,
      Guild guild) {
    this.reason = reason;
    this.name = name;
    Possible<String> topic$impl = topic;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    Possible<Snowflake> parentId$impl = parentId;
    Possible<Boolean> nsfw$impl = nsfw;
    this.guild = guild;
    this.topic_value = topic$impl.toOptional().orElse(null);
    this.topic_absent = topic$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = parentId$impl.toOptional().orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.nsfw_value = nsfw$impl.toOptional().orElse(null);
    this.nsfw_absent = nsfw$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "NewsChannelCreateMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build NewsChannelCreateMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code topic} attribute
   */
  @Override
  public Possible<String> topic() {
    return topic_absent ? Possible.absent() : Possible.of(topic_value);
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @Override
  public Possible<Snowflake> parentId() {
    return parentId_absent ? Possible.absent() : Possible.of(parentId_value);
  }

  /**
   * @return The value of the {@code nsfw} attribute
   */
  @Override
  public Possible<Boolean> nsfw() {
    return nsfw_absent ? Possible.absent() : Possible.of(nsfw_value);
  }

  /**
   * @return The value of the {@code guild} attribute
   */
  @Override
  public Guild guild() {
    return guild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NewsChannelCreateMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final NewsChannelCreateMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new NewsChannelCreateMono(
        value,
        this.name,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NewsChannelCreateMono#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final NewsChannelCreateMono withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new NewsChannelCreateMono(
        this.reason,
        newValue,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public NewsChannelCreateMono withTopic(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public NewsChannelCreateMono withTopic(String value) {
    Possible<String> newValue = Possible.of(value);
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public NewsChannelCreateMono withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public NewsChannelCreateMono withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public NewsChannelCreateMono withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        newValue,
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public NewsChannelCreateMono withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        newValue,
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  @SafeVarargs
  public final NewsChannelCreateMono withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        newValue,
        this.parentId(),
        this.nsfw(),
        this.guild);
  }

  public NewsChannelCreateMono withParentId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.nsfw(),
        this.guild);
  }

  public NewsChannelCreateMono withParentId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.nsfw(),
        this.guild);
  }

  public NewsChannelCreateMono withNsfw(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue,
        this.guild);
  }

  public NewsChannelCreateMono withNsfw(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue,
        this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NewsChannelCreateMono#guild() guild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guild
   * @return A modified copy of the {@code this} object
   */
  public final NewsChannelCreateMono withGuild(Guild value) {
    if (this.guild == value) return this;
    Guild newValue = Objects.requireNonNull(value, "guild");
    return new NewsChannelCreateMono(
        this.reason,
        this.name,
        this.topic(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.nsfw(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code NewsChannelCreateMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof NewsChannelCreateMono
        && equalTo(0, (NewsChannelCreateMono) another);
  }

  private boolean equalTo(int synthetic, NewsChannelCreateMono another) {
    return Objects.equals(reason, another.reason)
        && name.equals(another.name)
        && this.topic().equals(another.topic())
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value)
        && this.parentId().equals(another.parentId())
        && this.nsfw().equals(another.nsfw())
        && guild.equals(another.guild);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code topic}, {@code position}, {@code permissionOverwrites}, {@code parentId}, {@code nsfw}, {@code guild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (topic().hashCode());
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    h += (h << 5) + (parentId().hashCode());
    h += (h << 5) + (nsfw().hashCode());
    h += (h << 5) + guild.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NewsChannelCreateMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NewsChannelCreateMono{"
        + "reason=" + reason
        + ", name=" + name
        + ", topic=" + (topic().toString())
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + ", parentId=" + (parentId().toString())
        + ", nsfw=" + (nsfw().toString())
        + ", guild=" + guild
        + "}";
  }

  /**
   * Construct a new immutable {@code NewsChannelCreateMono} instance.
   * @param name The value for the {@code name} attribute
   * @param guild The value for the {@code guild} attribute
   * @return An immutable NewsChannelCreateMono instance
   */
  public static NewsChannelCreateMono of(String name, Guild guild) {
    return new NewsChannelCreateMono(name, guild);
  }

  /**
   * Creates an immutable copy of a {@link NewsChannelCreateMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NewsChannelCreateMono instance
   */
  static NewsChannelCreateMono copyOf(NewsChannelCreateMonoGenerator instance) {
    if (instance instanceof NewsChannelCreateMono) {
      return (NewsChannelCreateMono) instance;
    }
    return NewsChannelCreateMono.of(instance.name(), instance.guild())
        .withReason(instance.reason())
        .withTopic(instance.topic())
        .withPosition(instance.position())
        .withPermissionOverwrites(instance.permissionOverwrites())
        .withParentId(instance.parentId())
        .withNsfw(instance.nsfw());
  }

  public boolean isTopicPresent() {
    return !topic_absent;
  }

  public String topicOrElse(String defaultValue) {
    return !topic_absent ? topic_value : defaultValue;
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }

  public boolean isParentIdPresent() {
    return !parentId_absent;
  }

  public Snowflake parentIdOrElse(Snowflake defaultValue) {
    return !parentId_absent ? parentId_value : defaultValue;
  }

  public boolean isNsfwPresent() {
    return !nsfw_absent;
  }

  public Boolean nsfwOrElse(Boolean defaultValue) {
    return !nsfw_absent ? nsfw_value : defaultValue;
  }
}
