package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.entity.Message;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link MessageEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code MessageEditMono.of()}.
 */
@Generated(from = "MessageEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class MessageEditMono extends MessageEditMonoGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final List<EmbedCreateSpec> embeds_value;
  private final boolean embeds_absent;
  private final List<MessageCreateFields.File> files;
  private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<Message.Flag> flags_value;
  private final boolean flags_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;
  private final Message message;

  private MessageEditMono(Message message) {
    this.message = java.util.Objects.requireNonNull(message, "message");
    Possible<java.util.Optional<String>> content$impl = Possible.absent();
    Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds$impl = Possible.absent();
    Possible<java.util.Optional<AllowedMentions>> allowedMentions$impl = Possible.absent();
    Possible<java.util.Optional<List<Message.Flag>>> flags$impl = Possible.absent();
    Possible<java.util.Optional<List<LayoutComponent>>> components$impl = Possible.absent();
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.flags_value = Possible.flatOpt(flags$impl).orElse(null);
    this.flags_absent = flags$impl.isAbsent();
    this.components_value = Possible.flatOpt(components$impl).orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private MessageEditMono(
      Possible<java.util.Optional<String>> content,
      Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds,
      List<MessageCreateFields.File> files,
      List<MessageCreateFields.FileSpoiler> fileSpoilers,
      Possible<java.util.Optional<AllowedMentions>> allowedMentions,
      Possible<java.util.Optional<List<Message.Flag>>> flags,
      Possible<java.util.Optional<List<LayoutComponent>>> components,
      Message message) {
    Possible<java.util.Optional<String>> content$impl = content;
    Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds$impl = embeds;
    initShim.files(files);
    initShim.fileSpoilers(fileSpoilers);
    Possible<java.util.Optional<AllowedMentions>> allowedMentions$impl = allowedMentions;
    Possible<java.util.Optional<List<Message.Flag>>> flags$impl = flags;
    Possible<java.util.Optional<List<LayoutComponent>>> components$impl = components;
    this.message = message;
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.flags_value = Possible.flatOpt(flags$impl).orElse(null);
    this.flags_absent = flags$impl.isAbsent();
    this.components_value = Possible.flatOpt(components$impl).orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MessageEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private byte filesBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.File> files;

    List<MessageCreateFields.File> files() {
      if (filesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (filesBuildStage == STAGE_UNINITIALIZED) {
        filesBuildStage = STAGE_INITIALIZING;
        this.files = createUnmodifiableList(false, createSafeList(MessageEditMono.super.files(), true, false));
        filesBuildStage = STAGE_INITIALIZED;
      }
      return this.files;
    }

    void files(List<MessageCreateFields.File> files) {
      this.files = files;
      filesBuildStage = STAGE_INITIALIZED;
    }

    private byte fileSpoilersBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.FileSpoiler> fileSpoilers;

    List<MessageCreateFields.FileSpoiler> fileSpoilers() {
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fileSpoilersBuildStage == STAGE_UNINITIALIZED) {
        fileSpoilersBuildStage = STAGE_INITIALIZING;
        this.fileSpoilers = createUnmodifiableList(false, createSafeList(MessageEditMono.super.fileSpoilers(), true, false));
        fileSpoilersBuildStage = STAGE_INITIALIZED;
      }
      return this.fileSpoilers;
    }

    void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
      this.fileSpoilers = fileSpoilers;
      fileSpoilersBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (filesBuildStage == STAGE_INITIALIZING) attributes.add("files");
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) attributes.add("fileSpoilers");
      return "Cannot build MessageEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public Possible<java.util.Optional<String>> content() {
    return content_absent ? Possible.absent() :
        Possible.of(java.util.Optional.ofNullable(content_value));
  }

  /**
   * @return The value of the {@code embeds} attribute
   */
  @Override
  public Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds() {
    return embeds_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(embeds_value));
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @Override
  public List<MessageCreateFields.File> files() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.files()
        : this.files;
  }

  /**
   * @return The value of the {@code fileSpoilers} attribute
   */
  @Override
  public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.fileSpoilers()
        : this.fileSpoilers;
  }

  /**
   * @return The value of the {@code allowedMentions} attribute
   */
  @Override
  public Possible<java.util.Optional<AllowedMentions>> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() :
        Possible.of(java.util.Optional.ofNullable(allowedMentions_value));
  }

  /**
   * @return The value of the {@code flags} attribute
   */
  @Override
  public Possible<java.util.Optional<List<Message.Flag>>> flags() {
    return flags_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(flags_value));
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<java.util.Optional<List<LayoutComponent>>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(components_value));
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @Override
  public Message message() {
    return message;
  }

  public MessageEditMono withContent(Possible<java.util.Optional<String>> value) {
    Possible<java.util.Optional<String>> newValue = java.util.Objects.requireNonNull(value);
    return new MessageEditMono(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        this.message);
  }

  @Deprecated
  public MessageEditMono withContent(@Nullable String value) {
    Possible<java.util.Optional<String>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new MessageEditMono(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        this.message);
  }

  public MessageEditMono withContentOrNull(@Nullable String value) {
    Possible<java.util.Optional<String>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new MessageEditMono(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        this.message);
  }

  public MessageEditMono withEmbeds(Possible<java.util.Optional<List<EmbedCreateSpec>>> possible) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Objects.requireNonNull(possible);
    return new MessageEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        this.message);
  }

  @Deprecated
  public MessageEditMono withEmbeds(@Nullable java.lang.Iterable<EmbedCreateSpec> elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new MessageEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        this.message);
  }

  public MessageEditMono withEmbedsOrNull(@Nullable java.lang.Iterable<EmbedCreateSpec> elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new MessageEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        this.message);
  }

  @SafeVarargs
  public final MessageEditMono withEmbeds(EmbedCreateSpec... elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return new MessageEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        this.message);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageEditMono#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageEditMono withFiles(MessageCreateFields.File... elements) {
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(java.util.Arrays.asList(elements), true, false));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        this.message);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageEditMono#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageEditMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    if (this.files == elements) return this;
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        this.message);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageEditMono#fileSpoilers() fileSpoilers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageEditMono withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(java.util.Arrays.asList(elements), true, false));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        this.message);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageEditMono#fileSpoilers() fileSpoilers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSpoilers elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageEditMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    if (this.fileSpoilers == elements) return this;
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        this.message);
  }

  public MessageEditMono withAllowedMentions(Possible<java.util.Optional<AllowedMentions>> value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = java.util.Objects.requireNonNull(value);
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.flags(),
        this.components(),
        this.message);
  }

  @Deprecated
  public MessageEditMono withAllowedMentions(@Nullable AllowedMentions value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.flags(),
        this.components(),
        this.message);
  }

  public MessageEditMono withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.flags(),
        this.components(),
        this.message);
  }

  public MessageEditMono withFlags(Possible<java.util.Optional<List<Message.Flag>>> possible) {
    Possible<java.util.Optional<List<Message.Flag>>> newValue = Objects.requireNonNull(possible);
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.components(),
        this.message);
  }

  @Deprecated
  public MessageEditMono withFlags(@Nullable java.lang.Iterable<Message.Flag> elements) {
    Possible<java.util.Optional<List<Message.Flag>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.components(),
        this.message);
  }

  public MessageEditMono withFlagsOrNull(@Nullable java.lang.Iterable<Message.Flag> elements) {
    Possible<java.util.Optional<List<Message.Flag>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.components(),
        this.message);
  }

  @SafeVarargs
  public final MessageEditMono withFlags(Message.Flag... elements) {
    Possible<java.util.Optional<List<Message.Flag>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.components(),
        this.message);
  }

  public MessageEditMono withComponents(Possible<java.util.Optional<List<LayoutComponent>>> possible) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Objects.requireNonNull(possible);
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        newValue,
        this.message);
  }

  @Deprecated
  public MessageEditMono withComponents(@Nullable java.lang.Iterable<LayoutComponent> elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        newValue,
        this.message);
  }

  public MessageEditMono withComponentsOrNull(@Nullable java.lang.Iterable<LayoutComponent> elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        newValue,
        this.message);
  }

  @SafeVarargs
  public final MessageEditMono withComponents(LayoutComponent... elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        newValue,
        this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageEditMono#message() message} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final MessageEditMono withMessage(Message value) {
    if (this.message == value) return this;
    Message newValue = java.util.Objects.requireNonNull(value, "message");
    return new MessageEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.flags(),
        this.components(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code MessageEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MessageEditMono
        && equalTo(0, (MessageEditMono) another);
  }

  private boolean equalTo(int synthetic, MessageEditMono another) {
    return this.content().equals(another.content())
        && Objects.equals(embeds_value, another.embeds_value)
        && files.equals(another.files)
        && fileSpoilers.equals(another.fileSpoilers)
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(flags_value, another.flags_value)
        && Objects.equals(components_value, another.components_value)
        && message.equals(another.message);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code embeds}, {@code files}, {@code fileSpoilers}, {@code allowedMentions}, {@code flags}, {@code components}, {@code message}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (Objects.hashCode(embeds_value));
    h += (h << 5) + files.hashCode();
    h += (h << 5) + fileSpoilers.hashCode();
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(flags_value));
    h += (h << 5) + (Objects.hashCode(components_value));
    h += (h << 5) + message.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MessageEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MessageEditMono{"
        + "content=" + (content().toString())
        + ", embeds=" + (Objects.toString(embeds_value))
        + ", files=" + files
        + ", fileSpoilers=" + fileSpoilers
        + ", allowedMentions=" + (allowedMentions().toString())
        + ", flags=" + (Objects.toString(flags_value))
        + ", components=" + (Objects.toString(components_value))
        + ", message=" + message
        + "}";
  }

  /**
   * Construct a new immutable {@code MessageEditMono} instance.
   * @param message The value for the {@code message} attribute
   * @return An immutable MessageEditMono instance
   */
  public static MessageEditMono of(Message message) {
    return new MessageEditMono(message);
  }

  /**
   * Creates an immutable copy of a {@link MessageEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessageEditMono instance
   */
  static MessageEditMono copyOf(MessageEditMonoGenerator instance) {
    if (instance instanceof MessageEditMono) {
      return (MessageEditMono) instance;
    }
    return MessageEditMono.of(instance.message())
        .withContent(instance.content())
        .withEmbeds(instance.embeds())
        .withFiles(instance.files())
        .withFileSpoilers(instance.fileSpoilers())
        .withAllowedMentions(instance.allowedMentions())
        .withFlags(instance.flags())
        .withComponents(instance.components());
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isEmbedsPresent() {
    return !embeds_absent;
  }

  public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
    return !embeds_absent ? embeds_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isFlagsPresent() {
    return !flags_absent;
  }

  public List<Message.Flag> flagsOrElse(List<Message.Flag> defaultValue) {
    return !flags_absent ? flags_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) java.util.Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
