package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.component.LayoutComponent;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MessageCreateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code MessageCreateSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code MessageCreateSpec.create()}.
 */
@Generated(from = "MessageCreateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class MessageCreateSpec implements MessageCreateSpecGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final String nonce_value;
  private final boolean nonce_absent;
  private final Boolean tts_value;
  private final boolean tts_absent;
  private final List<EmbedCreateSpec> embeds_value;
  private final boolean embeds_absent;
  private final List<MessageCreateFields.File> files;
  private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final Snowflake messageReference_value;
  private final boolean messageReference_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;

  private MessageCreateSpec() {
    Possible<String> content$impl = Possible.absent();
    Possible<String> nonce$impl = Possible.absent();
    Possible<Boolean> tts$impl = Possible.absent();
    Possible<List<EmbedCreateSpec>> embeds$impl = Possible.absent();
    Possible<AllowedMentions> allowedMentions$impl = Possible.absent();
    Possible<Snowflake> messageReference$impl = Possible.absent();
    Possible<List<LayoutComponent>> components$impl = Possible.absent();
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.nonce_value = nonce$impl.toOptional().orElse(null);
    this.nonce_absent = nonce$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.messageReference_value = messageReference$impl.toOptional().orElse(null);
    this.messageReference_absent = messageReference$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private MessageCreateSpec(MessageCreateSpec.Builder builder) {
    Possible<String> content$impl = builder.content_build();
    Possible<String> nonce$impl = builder.nonce_build();
    Possible<Boolean> tts$impl = builder.tts_build();
    Possible<List<EmbedCreateSpec>> embeds$impl = builder.embeds_build();
    Possible<AllowedMentions> allowedMentions$impl = builder.allowedMentions_build();
    Possible<Snowflake> messageReference$impl = builder.messageReference_build();
    Possible<List<LayoutComponent>> components$impl = builder.components_build();
    if (builder.filesIsSet()) {
      initShim.files(createUnmodifiableList(true, builder.files));
    }
    if (builder.fileSpoilersIsSet()) {
      initShim.fileSpoilers(createUnmodifiableList(true, builder.fileSpoilers));
    }
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.nonce_value = nonce$impl.toOptional().orElse(null);
    this.nonce_absent = nonce$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.messageReference_value = messageReference$impl.toOptional().orElse(null);
    this.messageReference_absent = messageReference$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private MessageCreateSpec(
      Possible<String> content,
      Possible<String> nonce,
      Possible<Boolean> tts,
      Possible<List<EmbedCreateSpec>> embeds,
      List<MessageCreateFields.File> files,
      List<MessageCreateFields.FileSpoiler> fileSpoilers,
      Possible<AllowedMentions> allowedMentions,
      Possible<Snowflake> messageReference,
      Possible<List<LayoutComponent>> components) {
    Possible<String> content$impl = content;
    Possible<String> nonce$impl = nonce;
    Possible<Boolean> tts$impl = tts;
    Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
    initShim.files(files);
    initShim.fileSpoilers(fileSpoilers);
    Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
    Possible<Snowflake> messageReference$impl = messageReference;
    Possible<List<LayoutComponent>> components$impl = components;
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.nonce_value = nonce$impl.toOptional().orElse(null);
    this.nonce_absent = nonce$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.messageReference_value = messageReference$impl.toOptional().orElse(null);
    this.messageReference_absent = messageReference$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MessageCreateSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private byte filesBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.File> files;

    List<MessageCreateFields.File> files() {
      if (filesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (filesBuildStage == STAGE_UNINITIALIZED) {
        filesBuildStage = STAGE_INITIALIZING;
        this.files = createUnmodifiableList(false, createSafeList(filesInitialize(), true, false));
        filesBuildStage = STAGE_INITIALIZED;
      }
      return this.files;
    }

    void files(List<MessageCreateFields.File> files) {
      this.files = files;
      filesBuildStage = STAGE_INITIALIZED;
    }

    private byte fileSpoilersBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.FileSpoiler> fileSpoilers;

    List<MessageCreateFields.FileSpoiler> fileSpoilers() {
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fileSpoilersBuildStage == STAGE_UNINITIALIZED) {
        fileSpoilersBuildStage = STAGE_INITIALIZING;
        this.fileSpoilers = createUnmodifiableList(false, createSafeList(fileSpoilersInitialize(), true, false));
        fileSpoilersBuildStage = STAGE_INITIALIZED;
      }
      return this.fileSpoilers;
    }

    void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
      this.fileSpoilers = fileSpoilers;
      fileSpoilersBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (filesBuildStage == STAGE_INITIALIZING) attributes.add("files");
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) attributes.add("fileSpoilers");
      return "Cannot build MessageCreateSpec, attribute initializers form cycle " + attributes;
    }
  }

  private List<MessageCreateFields.File> filesInitialize() {
    return MessageCreateSpecGenerator.super.files();
  }

  private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
    return MessageCreateSpecGenerator.super.fileSpoilers();
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public Possible<String> content() {
    return content_absent ? Possible.absent() : Possible.of(content_value);
  }

  /**
   * @return The value of the {@code nonce} attribute
   */
  @Override
  public Possible<String> nonce() {
    return nonce_absent ? Possible.absent() : Possible.of(nonce_value);
  }

  /**
   * @return The value of the {@code tts} attribute
   */
  @Override
  public Possible<Boolean> tts() {
    return tts_absent ? Possible.absent() : Possible.of(tts_value);
  }

  /**
   * @return The value of the {@code embeds} attribute
   */
  @Override
  public Possible<List<EmbedCreateSpec>> embeds() {
    return embeds_absent ? Possible.absent() :
        Possible.of(embeds_value);
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @Override
  public List<MessageCreateFields.File> files() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.files()
        : this.files;
  }

  /**
   * @return The value of the {@code fileSpoilers} attribute
   */
  @Override
  public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.fileSpoilers()
        : this.fileSpoilers;
  }

  /**
   * @return The value of the {@code allowedMentions} attribute
   */
  @Override
  public Possible<AllowedMentions> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() : Possible.of(allowedMentions_value);
  }

  /**
   * @return The value of the {@code messageReference} attribute
   */
  @Override
  public Possible<Snowflake> messageReference() {
    return messageReference_absent ? Possible.absent() : Possible.of(messageReference_value);
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  public MessageCreateSpec withContent(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new MessageCreateSpec(
        newValue,
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  public MessageCreateSpec withContent(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new MessageCreateSpec(
        newValue,
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  public MessageCreateSpec withNonce(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new MessageCreateSpec(
        this.content(),
        newValue,
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  public MessageCreateSpec withNonce(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new MessageCreateSpec(
        this.content(),
        newValue,
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  public MessageCreateSpec withTts(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  public MessageCreateSpec withTts(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  public MessageCreateSpec withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
    Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  public MessageCreateSpec withEmbeds(java.lang.Iterable<EmbedCreateSpec> elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  @SafeVarargs
  public final MessageCreateSpec withEmbeds(EmbedCreateSpec... elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageCreateSpec#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageCreateSpec withFiles(MessageCreateFields.File... elements) {
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageCreateSpec#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageCreateSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    if (this.files == elements) return this;
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageCreateSpec#fileSpoilers() fileSpoilers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageCreateSpec withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageCreateSpec#fileSpoilers() fileSpoilers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSpoilers elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageCreateSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    if (this.fileSpoilers == elements) return this;
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.messageReference(),
        this.components()));
  }

  public MessageCreateSpec withAllowedMentions(Possible<AllowedMentions> value) {
    Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.messageReference(),
        this.components()));
  }

  public MessageCreateSpec withAllowedMentions(AllowedMentions value) {
    Possible<AllowedMentions> newValue = Possible.of(value);
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.messageReference(),
        this.components()));
  }

  public MessageCreateSpec withMessageReference(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.components()));
  }

  public MessageCreateSpec withMessageReference(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.components()));
  }

  public MessageCreateSpec withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        newValue));
  }

  public MessageCreateSpec withComponents(java.lang.Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        newValue));
  }

  @SafeVarargs
  public final MessageCreateSpec withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new MessageCreateSpec(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code MessageCreateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MessageCreateSpec
        && equalTo(0, (MessageCreateSpec) another);
  }

  private boolean equalTo(int synthetic, MessageCreateSpec another) {
    return this.content().equals(another.content())
        && this.nonce().equals(another.nonce())
        && this.tts().equals(another.tts())
        && Objects.equals(embeds_value, another.embeds_value)
        && files.equals(another.files)
        && fileSpoilers.equals(another.fileSpoilers)
        && this.allowedMentions().equals(another.allowedMentions())
        && this.messageReference().equals(another.messageReference())
        && Objects.equals(components_value, another.components_value);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code nonce}, {@code tts}, {@code embeds}, {@code files}, {@code fileSpoilers}, {@code allowedMentions}, {@code messageReference}, {@code components}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (nonce().hashCode());
    h += (h << 5) + (tts().hashCode());
    h += (h << 5) + (Objects.hashCode(embeds_value));
    h += (h << 5) + files.hashCode();
    h += (h << 5) + fileSpoilers.hashCode();
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (messageReference().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    return h;
  }

  /**
   * Prints the immutable value {@code MessageCreateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MessageCreateSpec{"
        + "content=" + (content().toString())
        + ", nonce=" + (nonce().toString())
        + ", tts=" + (tts().toString())
        + ", embeds=" + (Objects.toString(embeds_value))
        + ", files=" + files
        + ", fileSpoilers=" + fileSpoilers
        + ", allowedMentions=" + (allowedMentions().toString())
        + ", messageReference=" + (messageReference().toString())
        + ", components=" + (Objects.toString(components_value))
        + "}";
  }

  private static final MessageCreateSpec INSTANCE = validate(new MessageCreateSpec());

  /**
   * Returns the default immutable singleton value of {@code MessageCreateSpec}
   * @return An immutable instance of MessageCreateSpec
   */
  public static MessageCreateSpec create() {
    return INSTANCE;
  }

  private static MessageCreateSpec validate(MessageCreateSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link MessageCreateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessageCreateSpec instance
   */
  static MessageCreateSpec copyOf(MessageCreateSpecGenerator instance) {
    if (instance instanceof MessageCreateSpec) {
      return (MessageCreateSpec) instance;
    }
    return MessageCreateSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isNoncePresent() {
    return !nonce_absent;
  }

  public String nonceOrElse(String defaultValue) {
    return !nonce_absent ? nonce_value : defaultValue;
  }

  public boolean isTtsPresent() {
    return !tts_absent;
  }

  public Boolean ttsOrElse(Boolean defaultValue) {
    return !tts_absent ? tts_value : defaultValue;
  }

  public boolean isEmbedsPresent() {
    return !embeds_absent;
  }

  public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
    return !embeds_absent ? embeds_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isMessageReferencePresent() {
    return !messageReference_absent;
  }

  public Snowflake messageReferenceOrElse(Snowflake defaultValue) {
    return !messageReference_absent ? messageReference_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  /**
   * Creates a builder for {@link MessageCreateSpec MessageCreateSpec}.
   * <pre>
   * MessageCreateSpec.builder()
   *    .content(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link MessageCreateSpec#content() content}
   *    .nonce(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link MessageCreateSpec#nonce() nonce}
   *    .tts(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link MessageCreateSpec#tts() tts}
   *    .embeds(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;EmbedCreateSpec&amp;gt;&amp;gt;) // {@link MessageCreateSpec#embeds() embeds}
   *    .addFile|addAllFiles(discord4j.core.spec.MessageCreateFields.File) // {@link MessageCreateSpec#files() files} elements
   *    .addFileSpoiler|addAllFileSpoilers(discord4j.core.spec.MessageCreateFields.FileSpoiler) // {@link MessageCreateSpec#fileSpoilers() fileSpoilers} elements
   *    .allowedMentions(discord4j.discordjson.possible.Possible&amp;lt;discord4j.rest.util.AllowedMentions&amp;gt;) // {@link MessageCreateSpec#allowedMentions() allowedMentions}
   *    .messageReference(discord4j.discordjson.possible.Possible&amp;lt;discord4j.common.util.Snowflake&amp;gt;) // {@link MessageCreateSpec#messageReference() messageReference}
   *    .components(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.object.component.LayoutComponent&amp;gt;&amp;gt;) // {@link MessageCreateSpec#components() components}
   *    .build();
   * </pre>
   * @return A new MessageCreateSpec builder
   */
  public static MessageCreateSpec.Builder builder() {
    return new MessageCreateSpec.Builder();
  }

  /**
   * Builds instances of type {@link MessageCreateSpec MessageCreateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MessageCreateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long OPT_BIT_FILES = 0x1L;
    private static final long OPT_BIT_FILE_SPOILERS = 0x2L;
    private long optBits;

    private Possible<String> content_possible = Possible.absent();
    private Possible<String> nonce_possible = Possible.absent();
    private Possible<Boolean> tts_possible = Possible.absent();
    private List<EmbedCreateSpec> embeds_list = null;
    private Possible<AllowedMentions> allowedMentions_possible = Possible.absent();
    private Possible<Snowflake> messageReference_possible = Possible.absent();
    private List<LayoutComponent> components_list = null;
    private List<MessageCreateFields.File> files = new ArrayList<MessageCreateFields.File>();
    private List<MessageCreateFields.FileSpoiler> fileSpoilers = new ArrayList<MessageCreateFields.FileSpoiler>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MessageCreateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessageCreateSpec instance) {
      return from((MessageCreateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code MessageCreateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(MessageCreateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      content(instance.content());
      nonce(instance.nonce());
      tts(instance.tts());
      embeds(instance.embeds());
      addAllFiles(instance.files());
      addAllFileSpoilers(instance.fileSpoilers());
      allowedMentions(instance.allowedMentions());
      messageReference(instance.messageReference());
      components(instance.components());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder content(Possible<String> value) {
      this.content_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder content(String value) {
      this.content_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder nonce(Possible<String> value) {
      this.nonce_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder nonce(String value) {
      this.nonce_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder tts(Possible<Boolean> value) {
      this.tts_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder tts(Boolean value) {
      this.tts_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addEmbed(EmbedCreateSpec element) {
      embeds_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
      embeds_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(Possible<List<EmbedCreateSpec>> elements) {
      this.embeds_list = null;
      elements.toOptional().ifPresent(e -> embeds_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(List<EmbedCreateSpec> elements) {
      this.embeds_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(java.lang.Iterable<EmbedCreateSpec> elements) {
      this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    /**
     * Adds one element to {@link MessageCreateSpec#files() files} list.
     * @param element A files element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFile(MessageCreateFields.File element) {
      element = ImmutableMessageCreateFields.File.copyOf(element);
      this.files.add(Objects.requireNonNull(element, "files element"));
      optBits |= OPT_BIT_FILES;
      return this;
    }

    /**
     * Constructs and adds an element for the {@link MessageCreateSpec#files() files} list.
     * @param name The value for {@code files.name} 
     * @param inputStream The value for {@code files.inputStream} 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFile(String name, InputStream inputStream) {
      return addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
    }

    /**
     * Adds elements to {@link MessageCreateSpec#files() files} list.
     * @param elements An array of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFiles(MessageCreateFields.File... elements) {
      for (MessageCreateFields.File element : elements) {
        element = ImmutableMessageCreateFields.File.copyOf(element);
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      optBits |= OPT_BIT_FILES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MessageCreateSpec#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
      this.files.clear();
      return addAllFiles(elements);
    }

    /**
     * Adds elements to {@link MessageCreateSpec#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
      for (MessageCreateFields.File element : elements) {
        element = ImmutableMessageCreateFields.File.copyOf(element);
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      optBits |= OPT_BIT_FILES;
      return this;
    }

    /**
     * Adds one element to {@link MessageCreateSpec#fileSpoilers() fileSpoilers} list.
     * @param element A fileSpoilers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
      element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
      this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }

    /**
     * Constructs and adds an element for the {@link MessageCreateSpec#fileSpoilers() fileSpoilers} list.
     * @param name The value for {@code fileSpoilers.name} 
     * @param inputStream The value for {@code fileSpoilers.inputStream} 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFileSpoiler(String name, InputStream inputStream) {
      return addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
    }

    /**
     * Adds elements to {@link MessageCreateSpec#fileSpoilers() fileSpoilers} list.
     * @param elements An array of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
      for (MessageCreateFields.FileSpoiler element : elements) {
        element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
        this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
      }
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MessageCreateSpec#fileSpoilers() fileSpoilers} list.
     * @param elements An iterable of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
      this.fileSpoilers.clear();
      return addAllFileSpoilers(elements);
    }

    /**
     * Adds elements to {@link MessageCreateSpec#fileSpoilers() fileSpoilers} list.
     * @param elements An iterable of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
      for (MessageCreateFields.FileSpoiler element : elements) {
        element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
        this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
      }
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentions(Possible<AllowedMentions> value) {
      this.allowedMentions_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentions(AllowedMentions value) {
      this.allowedMentions_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder messageReference(Possible<Snowflake> value) {
      this.messageReference_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder messageReference(Snowflake value) {
      this.messageReference_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addComponent(LayoutComponent element) {
      components_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllComponents(List<LayoutComponent> elements) {
      components_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(Possible<List<LayoutComponent>> elements) {
      this.components_list = null;
      elements.toOptional().ifPresent(e -> components_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(List<LayoutComponent> elements) {
      this.components_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(java.lang.Iterable<LayoutComponent> elements) {
      this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    /**
     * Builds a new {@link MessageCreateSpec MessageCreateSpec}.
     * @return An immutable instance of MessageCreateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MessageCreateSpec build() {
      return MessageCreateSpec.validate(new MessageCreateSpec(this));
    }

    private boolean filesIsSet() {
      return (optBits & OPT_BIT_FILES) != 0;
    }

    private boolean fileSpoilersIsSet() {
      return (optBits & OPT_BIT_FILE_SPOILERS) != 0;
    }

    private Possible<String> content_build() {
      return this.content_possible;
    }

    private Possible<String> nonce_build() {
      return this.nonce_possible;
    }

    private Possible<Boolean> tts_build() {
      return this.tts_possible;
    }

    private Possible<List<EmbedCreateSpec>> embeds_build() {
      return this.embeds_list == null ? Possible.absent() :
          Possible.of(this.embeds_list);
    }

    private List<EmbedCreateSpec> embeds_getOrCreate() {
      if (this.embeds_list == null) {
        this.embeds_list = new ArrayList<>();
      }
      return this.embeds_list;
    }

    private Possible<AllowedMentions> allowedMentions_build() {
      return this.allowedMentions_possible;
    }

    private Possible<Snowflake> messageReference_build() {
      return this.messageReference_possible;
    }

    private Possible<List<LayoutComponent>> components_build() {
      return this.components_list == null ? Possible.absent() :
          Possible.of(this.components_list);
    }

    private List<LayoutComponent> components_getOrCreate() {
      if (this.components_list == null) {
        this.components_list = new ArrayList<>();
      }
      return this.components_list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
