package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MessageCreateMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code MessageCreateMono.of()}.
 */
@Generated(from = "MessageCreateMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class MessageCreateMono extends MessageCreateMonoGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final String nonce_value;
  private final boolean nonce_absent;
  private final Boolean tts_value;
  private final boolean tts_absent;
  private final List<EmbedCreateSpec> embeds_value;
  private final boolean embeds_absent;
  private final List<MessageCreateFields.File> files;
  private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final Snowflake messageReference_value;
  private final boolean messageReference_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;
  private final MessageChannel channel;

  private MessageCreateMono(MessageChannel channel) {
    this.channel = Objects.requireNonNull(channel, "channel");
    Possible<String> content$impl = Possible.absent();
    Possible<String> nonce$impl = Possible.absent();
    Possible<Boolean> tts$impl = Possible.absent();
    Possible<List<EmbedCreateSpec>> embeds$impl = Possible.absent();
    Possible<AllowedMentions> allowedMentions$impl = Possible.absent();
    Possible<Snowflake> messageReference$impl = Possible.absent();
    Possible<List<LayoutComponent>> components$impl = Possible.absent();
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.nonce_value = nonce$impl.toOptional().orElse(null);
    this.nonce_absent = nonce$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.messageReference_value = messageReference$impl.toOptional().orElse(null);
    this.messageReference_absent = messageReference$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private MessageCreateMono(
      Possible<String> content,
      Possible<String> nonce,
      Possible<Boolean> tts,
      Possible<List<EmbedCreateSpec>> embeds,
      List<MessageCreateFields.File> files,
      List<MessageCreateFields.FileSpoiler> fileSpoilers,
      Possible<AllowedMentions> allowedMentions,
      Possible<Snowflake> messageReference,
      Possible<List<LayoutComponent>> components,
      MessageChannel channel) {
    Possible<String> content$impl = content;
    Possible<String> nonce$impl = nonce;
    Possible<Boolean> tts$impl = tts;
    Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
    initShim.files(files);
    initShim.fileSpoilers(fileSpoilers);
    Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
    Possible<Snowflake> messageReference$impl = messageReference;
    Possible<List<LayoutComponent>> components$impl = components;
    this.channel = channel;
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.nonce_value = nonce$impl.toOptional().orElse(null);
    this.nonce_absent = nonce$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.messageReference_value = messageReference$impl.toOptional().orElse(null);
    this.messageReference_absent = messageReference$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MessageCreateMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private byte filesBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.File> files;

    List<MessageCreateFields.File> files() {
      if (filesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (filesBuildStage == STAGE_UNINITIALIZED) {
        filesBuildStage = STAGE_INITIALIZING;
        this.files = createUnmodifiableList(false, createSafeList(MessageCreateMono.super.files(), true, false));
        filesBuildStage = STAGE_INITIALIZED;
      }
      return this.files;
    }

    void files(List<MessageCreateFields.File> files) {
      this.files = files;
      filesBuildStage = STAGE_INITIALIZED;
    }

    private byte fileSpoilersBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.FileSpoiler> fileSpoilers;

    List<MessageCreateFields.FileSpoiler> fileSpoilers() {
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fileSpoilersBuildStage == STAGE_UNINITIALIZED) {
        fileSpoilersBuildStage = STAGE_INITIALIZING;
        this.fileSpoilers = createUnmodifiableList(false, createSafeList(MessageCreateMono.super.fileSpoilers(), true, false));
        fileSpoilersBuildStage = STAGE_INITIALIZED;
      }
      return this.fileSpoilers;
    }

    void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
      this.fileSpoilers = fileSpoilers;
      fileSpoilersBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (filesBuildStage == STAGE_INITIALIZING) attributes.add("files");
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) attributes.add("fileSpoilers");
      return "Cannot build MessageCreateMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public Possible<String> content() {
    return content_absent ? Possible.absent() : Possible.of(content_value);
  }

  /**
   * @return The value of the {@code nonce} attribute
   */
  @Override
  public Possible<String> nonce() {
    return nonce_absent ? Possible.absent() : Possible.of(nonce_value);
  }

  /**
   * @return The value of the {@code tts} attribute
   */
  @Override
  public Possible<Boolean> tts() {
    return tts_absent ? Possible.absent() : Possible.of(tts_value);
  }

  /**
   * @return The value of the {@code embeds} attribute
   */
  @Override
  public Possible<List<EmbedCreateSpec>> embeds() {
    return embeds_absent ? Possible.absent() :
        Possible.of(embeds_value);
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @Override
  public List<MessageCreateFields.File> files() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.files()
        : this.files;
  }

  /**
   * @return The value of the {@code fileSpoilers} attribute
   */
  @Override
  public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.fileSpoilers()
        : this.fileSpoilers;
  }

  /**
   * @return The value of the {@code allowedMentions} attribute
   */
  @Override
  public Possible<AllowedMentions> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() : Possible.of(allowedMentions_value);
  }

  /**
   * @return The value of the {@code messageReference} attribute
   */
  @Override
  public Possible<Snowflake> messageReference() {
    return messageReference_absent ? Possible.absent() : Possible.of(messageReference_value);
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @Override
  public MessageChannel channel() {
    return channel;
  }

  public MessageCreateMono withContent(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new MessageCreateMono(
        newValue,
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  public MessageCreateMono withContent(String value) {
    Possible<String> newValue = Possible.of(value);
    return new MessageCreateMono(
        newValue,
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  public MessageCreateMono withNonce(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new MessageCreateMono(
        this.content(),
        newValue,
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  public MessageCreateMono withNonce(String value) {
    Possible<String> newValue = Possible.of(value);
    return new MessageCreateMono(
        this.content(),
        newValue,
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  public MessageCreateMono withTts(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  public MessageCreateMono withTts(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  public MessageCreateMono withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
    Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  public MessageCreateMono withEmbeds(java.lang.Iterable<EmbedCreateSpec> elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  @SafeVarargs
  public final MessageCreateMono withEmbeds(EmbedCreateSpec... elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(Arrays.asList(elements));
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageCreateMono#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageCreateMono withFiles(MessageCreateFields.File... elements) {
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageCreateMono#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageCreateMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    if (this.files == elements) return this;
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageCreateMono#fileSpoilers() fileSpoilers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageCreateMono withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MessageCreateMono#fileSpoilers() fileSpoilers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSpoilers elements to set
   * @return A modified copy of {@code this} object
   */
  public final MessageCreateMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    if (this.fileSpoilers == elements) return this;
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        this.channel);
  }

  public MessageCreateMono withAllowedMentions(Possible<AllowedMentions> value) {
    Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.messageReference(),
        this.components(),
        this.channel);
  }

  public MessageCreateMono withAllowedMentions(AllowedMentions value) {
    Possible<AllowedMentions> newValue = Possible.of(value);
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.messageReference(),
        this.components(),
        this.channel);
  }

  public MessageCreateMono withMessageReference(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.components(),
        this.channel);
  }

  public MessageCreateMono withMessageReference(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.components(),
        this.channel);
  }

  public MessageCreateMono withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        newValue,
        this.channel);
  }

  public MessageCreateMono withComponents(java.lang.Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        newValue,
        this.channel);
  }

  @SafeVarargs
  public final MessageCreateMono withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        newValue,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageCreateMono#channel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final MessageCreateMono withChannel(MessageChannel value) {
    if (this.channel == value) return this;
    MessageChannel newValue = Objects.requireNonNull(value, "channel");
    return new MessageCreateMono(
        this.content(),
        this.nonce(),
        this.tts(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.messageReference(),
        this.components(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code MessageCreateMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MessageCreateMono
        && equalTo(0, (MessageCreateMono) another);
  }

  private boolean equalTo(int synthetic, MessageCreateMono another) {
    return this.content().equals(another.content())
        && this.nonce().equals(another.nonce())
        && this.tts().equals(another.tts())
        && Objects.equals(embeds_value, another.embeds_value)
        && files.equals(another.files)
        && fileSpoilers.equals(another.fileSpoilers)
        && this.allowedMentions().equals(another.allowedMentions())
        && this.messageReference().equals(another.messageReference())
        && Objects.equals(components_value, another.components_value)
        && channel.equals(another.channel);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code nonce}, {@code tts}, {@code embeds}, {@code files}, {@code fileSpoilers}, {@code allowedMentions}, {@code messageReference}, {@code components}, {@code channel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (nonce().hashCode());
    h += (h << 5) + (tts().hashCode());
    h += (h << 5) + (Objects.hashCode(embeds_value));
    h += (h << 5) + files.hashCode();
    h += (h << 5) + fileSpoilers.hashCode();
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (messageReference().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    h += (h << 5) + channel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MessageCreateMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MessageCreateMono{"
        + "content=" + (content().toString())
        + ", nonce=" + (nonce().toString())
        + ", tts=" + (tts().toString())
        + ", embeds=" + (Objects.toString(embeds_value))
        + ", files=" + files
        + ", fileSpoilers=" + fileSpoilers
        + ", allowedMentions=" + (allowedMentions().toString())
        + ", messageReference=" + (messageReference().toString())
        + ", components=" + (Objects.toString(components_value))
        + ", channel=" + channel
        + "}";
  }

  /**
   * Construct a new immutable {@code MessageCreateMono} instance.
   * @param channel The value for the {@code channel} attribute
   * @return An immutable MessageCreateMono instance
   */
  public static MessageCreateMono of(MessageChannel channel) {
    return new MessageCreateMono(channel);
  }

  /**
   * Creates an immutable copy of a {@link MessageCreateMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessageCreateMono instance
   */
  static MessageCreateMono copyOf(MessageCreateMonoGenerator instance) {
    if (instance instanceof MessageCreateMono) {
      return (MessageCreateMono) instance;
    }
    return MessageCreateMono.of(instance.channel())
        .withContent(instance.content())
        .withNonce(instance.nonce())
        .withTts(instance.tts())
        .withEmbeds(instance.embeds())
        .withFiles(instance.files())
        .withFileSpoilers(instance.fileSpoilers())
        .withAllowedMentions(instance.allowedMentions())
        .withMessageReference(instance.messageReference())
        .withComponents(instance.components());
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isNoncePresent() {
    return !nonce_absent;
  }

  public String nonceOrElse(String defaultValue) {
    return !nonce_absent ? nonce_value : defaultValue;
  }

  public boolean isTtsPresent() {
    return !tts_absent;
  }

  public Boolean ttsOrElse(Boolean defaultValue) {
    return !tts_absent ? tts_value : defaultValue;
  }

  public boolean isEmbedsPresent() {
    return !embeds_absent;
  }

  public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
    return !embeds_absent ? embeds_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isMessageReferencePresent() {
    return !messageReference_absent;
  }

  public Snowflake messageReferenceOrElse(Snowflake defaultValue) {
    return !messageReference_absent ? messageReference_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
