package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.entity.PartialMember;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link MemberBanQueryMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code MemberBanQueryMono.of()}.
 */
@Generated(from = "MemberBanQueryMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class MemberBanQueryMono extends MemberBanQueryMonoGenerator {
  private final @Nullable String reason;
  private final @Nullable Integer deleteMessageDays;
  private final PartialMember member;

  private MemberBanQueryMono(PartialMember member) {
    this.member = Objects.requireNonNull(member, "member");
    this.reason = null;
    this.deleteMessageDays = null;
  }

  private MemberBanQueryMono(
      @Nullable String reason,
      @Nullable Integer deleteMessageDays,
      PartialMember member) {
    this.reason = reason;
    this.deleteMessageDays = deleteMessageDays;
    this.member = member;
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code deleteMessageDays} attribute
   */
  @Override
  public @Nullable Integer deleteMessageDays() {
    return deleteMessageDays;
  }

  /**
   * @return The value of the {@code member} attribute
   */
  @Override
  public PartialMember member() {
    return member;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MemberBanQueryMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final MemberBanQueryMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new MemberBanQueryMono(value, this.deleteMessageDays, this.member);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MemberBanQueryMono#deleteMessageDays() deleteMessageDays} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deleteMessageDays (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final MemberBanQueryMono withDeleteMessageDays(@Nullable Integer value) {
    if (Objects.equals(this.deleteMessageDays, value)) return this;
    return new MemberBanQueryMono(this.reason, value, this.member);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MemberBanQueryMono#member() member} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for member
   * @return A modified copy of the {@code this} object
   */
  public final MemberBanQueryMono withMember(PartialMember value) {
    if (this.member == value) return this;
    PartialMember newValue = Objects.requireNonNull(value, "member");
    return new MemberBanQueryMono(this.reason, this.deleteMessageDays, newValue);
  }

  /**
   * This instance is equal to all instances of {@code MemberBanQueryMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MemberBanQueryMono
        && equalTo(0, (MemberBanQueryMono) another);
  }

  private boolean equalTo(int synthetic, MemberBanQueryMono another) {
    return Objects.equals(reason, another.reason)
        && Objects.equals(deleteMessageDays, another.deleteMessageDays)
        && member.equals(another.member);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code deleteMessageDays}, {@code member}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + Objects.hashCode(deleteMessageDays);
    h += (h << 5) + member.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MemberBanQueryMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MemberBanQueryMono{"
        + "reason=" + reason
        + ", deleteMessageDays=" + deleteMessageDays
        + ", member=" + member
        + "}";
  }

  /**
   * Construct a new immutable {@code MemberBanQueryMono} instance.
   * @param member The value for the {@code member} attribute
   * @return An immutable MemberBanQueryMono instance
   */
  public static MemberBanQueryMono of(PartialMember member) {
    return new MemberBanQueryMono(member);
  }

  /**
   * Creates an immutable copy of a {@link MemberBanQueryMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MemberBanQueryMono instance
   */
  static MemberBanQueryMono copyOf(MemberBanQueryMonoGenerator instance) {
    if (instance instanceof MemberBanQueryMono) {
      return (MemberBanQueryMono) instance;
    }
    return MemberBanQueryMono.of(instance.member())
        .withReason(instance.reason())
        .withDeleteMessageDays(instance.deleteMessageDays());
  }
}
