package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.Invite;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link InviteCreateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code InviteCreateSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code InviteCreateSpec.create()}.
 */
@Generated(from = "InviteCreateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class InviteCreateSpec implements InviteCreateSpecGenerator {
  private final @Nullable String reason;
  private final Integer maxAge_value;
  private final boolean maxAge_absent;
  private final Integer maxUses_value;
  private final boolean maxUses_absent;
  private final Boolean temporary_value;
  private final boolean temporary_absent;
  private final Boolean unique_value;
  private final boolean unique_absent;
  private final Invite.Type targetType_value;
  private final boolean targetType_absent;
  private final Snowflake targetUserId_value;
  private final boolean targetUserId_absent;
  private final Snowflake targetApplicationId_value;
  private final boolean targetApplicationId_absent;

  private InviteCreateSpec() {
    this.reason = null;
    Possible<Integer> maxAge$impl = Possible.absent();
    Possible<Integer> maxUses$impl = Possible.absent();
    Possible<Boolean> temporary$impl = Possible.absent();
    Possible<Boolean> unique$impl = Possible.absent();
    Possible<Invite.Type> targetType$impl = Possible.absent();
    Possible<Snowflake> targetUserId$impl = Possible.absent();
    Possible<Snowflake> targetApplicationId$impl = Possible.absent();
    this.maxAge_value = maxAge$impl.toOptional().orElse(null);
    this.maxAge_absent = maxAge$impl.isAbsent();
    this.maxUses_value = maxUses$impl.toOptional().orElse(null);
    this.maxUses_absent = maxUses$impl.isAbsent();
    this.temporary_value = temporary$impl.toOptional().orElse(null);
    this.temporary_absent = temporary$impl.isAbsent();
    this.unique_value = unique$impl.toOptional().orElse(null);
    this.unique_absent = unique$impl.isAbsent();
    this.targetType_value = targetType$impl.toOptional().orElse(null);
    this.targetType_absent = targetType$impl.isAbsent();
    this.targetUserId_value = targetUserId$impl.toOptional().orElse(null);
    this.targetUserId_absent = targetUserId$impl.isAbsent();
    this.targetApplicationId_value = targetApplicationId$impl.toOptional().orElse(null);
    this.targetApplicationId_absent = targetApplicationId$impl.isAbsent();
    this.initShim = null;
  }

  private InviteCreateSpec(
      @Nullable String reason,
      Possible<Integer> maxAge,
      Possible<Integer> maxUses,
      Possible<Boolean> temporary,
      Possible<Boolean> unique,
      Possible<Invite.Type> targetType,
      Possible<Snowflake> targetUserId,
      Possible<Snowflake> targetApplicationId) {
    this.reason = reason;
    Possible<Integer> maxAge$impl = maxAge;
    Possible<Integer> maxUses$impl = maxUses;
    Possible<Boolean> temporary$impl = temporary;
    Possible<Boolean> unique$impl = unique;
    Possible<Invite.Type> targetType$impl = targetType;
    Possible<Snowflake> targetUserId$impl = targetUserId;
    Possible<Snowflake> targetApplicationId$impl = targetApplicationId;
    this.maxAge_value = maxAge$impl.toOptional().orElse(null);
    this.maxAge_absent = maxAge$impl.isAbsent();
    this.maxUses_value = maxUses$impl.toOptional().orElse(null);
    this.maxUses_absent = maxUses$impl.isAbsent();
    this.temporary_value = temporary$impl.toOptional().orElse(null);
    this.temporary_absent = temporary$impl.isAbsent();
    this.unique_value = unique$impl.toOptional().orElse(null);
    this.unique_absent = unique$impl.isAbsent();
    this.targetType_value = targetType$impl.toOptional().orElse(null);
    this.targetType_absent = targetType$impl.isAbsent();
    this.targetUserId_value = targetUserId$impl.toOptional().orElse(null);
    this.targetUserId_absent = targetUserId$impl.isAbsent();
    this.targetApplicationId_value = targetApplicationId$impl.toOptional().orElse(null);
    this.targetApplicationId_absent = targetApplicationId$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "InviteCreateSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build InviteCreateSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code maxAge} attribute
   */
  @Override
  public Possible<Integer> maxAge() {
    return maxAge_absent ? Possible.absent() : Possible.of(maxAge_value);
  }

  /**
   * @return The value of the {@code maxUses} attribute
   */
  @Override
  public Possible<Integer> maxUses() {
    return maxUses_absent ? Possible.absent() : Possible.of(maxUses_value);
  }

  /**
   * @return The value of the {@code temporary} attribute
   */
  @Override
  public Possible<Boolean> temporary() {
    return temporary_absent ? Possible.absent() : Possible.of(temporary_value);
  }

  /**
   * @return The value of the {@code unique} attribute
   */
  @Override
  public Possible<Boolean> unique() {
    return unique_absent ? Possible.absent() : Possible.of(unique_value);
  }

  /**
   * @return The value of the {@code targetType} attribute
   */
  @Override
  public Possible<Invite.Type> targetType() {
    return targetType_absent ? Possible.absent() : Possible.of(targetType_value);
  }

  /**
   * @return The value of the {@code targetUserId} attribute
   */
  @Override
  public Possible<Snowflake> targetUserId() {
    return targetUserId_absent ? Possible.absent() : Possible.of(targetUserId_value);
  }

  /**
   * @return The value of the {@code targetApplicationId} attribute
   */
  @Override
  public Possible<Snowflake> targetApplicationId() {
    return targetApplicationId_absent ? Possible.absent() : Possible.of(targetApplicationId_value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InviteCreateSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final InviteCreateSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return validate(new InviteCreateSpec(
        value,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId()));
  }

  public InviteCreateSpec withMaxAge(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return validate(new InviteCreateSpec(
        this.reason,
        newValue,
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId()));
  }

  public InviteCreateSpec withMaxAge(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return validate(new InviteCreateSpec(
        this.reason,
        newValue,
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId()));
  }

  public InviteCreateSpec withMaxUses(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        newValue,
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId()));
  }

  public InviteCreateSpec withMaxUses(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        newValue,
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId()));
  }

  public InviteCreateSpec withTemporary(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        newValue,
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId()));
  }

  public InviteCreateSpec withTemporary(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        newValue,
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId()));
  }

  public InviteCreateSpec withUnique(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        newValue,
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId()));
  }

  public InviteCreateSpec withUnique(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        newValue,
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId()));
  }

  public InviteCreateSpec withTargetType(Possible<Invite.Type> value) {
    Possible<Invite.Type> newValue = Objects.requireNonNull(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        newValue,
        this.targetUserId(),
        this.targetApplicationId()));
  }

  public InviteCreateSpec withTargetType(Invite.Type value) {
    Possible<Invite.Type> newValue = Possible.of(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        newValue,
        this.targetUserId(),
        this.targetApplicationId()));
  }

  public InviteCreateSpec withTargetUserId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        newValue,
        this.targetApplicationId()));
  }

  public InviteCreateSpec withTargetUserId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        newValue,
        this.targetApplicationId()));
  }

  public InviteCreateSpec withTargetApplicationId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        newValue));
  }

  public InviteCreateSpec withTargetApplicationId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return validate(new InviteCreateSpec(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code InviteCreateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InviteCreateSpec
        && equalTo(0, (InviteCreateSpec) another);
  }

  private boolean equalTo(int synthetic, InviteCreateSpec another) {
    return Objects.equals(reason, another.reason)
        && this.maxAge().equals(another.maxAge())
        && this.maxUses().equals(another.maxUses())
        && this.temporary().equals(another.temporary())
        && this.unique().equals(another.unique())
        && this.targetType().equals(another.targetType())
        && this.targetUserId().equals(another.targetUserId())
        && this.targetApplicationId().equals(another.targetApplicationId());
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code maxAge}, {@code maxUses}, {@code temporary}, {@code unique}, {@code targetType}, {@code targetUserId}, {@code targetApplicationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (maxAge().hashCode());
    h += (h << 5) + (maxUses().hashCode());
    h += (h << 5) + (temporary().hashCode());
    h += (h << 5) + (unique().hashCode());
    h += (h << 5) + (targetType().hashCode());
    h += (h << 5) + (targetUserId().hashCode());
    h += (h << 5) + (targetApplicationId().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code InviteCreateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InviteCreateSpec{"
        + "reason=" + reason
        + ", maxAge=" + (maxAge().toString())
        + ", maxUses=" + (maxUses().toString())
        + ", temporary=" + (temporary().toString())
        + ", unique=" + (unique().toString())
        + ", targetType=" + (targetType().toString())
        + ", targetUserId=" + (targetUserId().toString())
        + ", targetApplicationId=" + (targetApplicationId().toString())
        + "}";
  }

  private static final InviteCreateSpec INSTANCE = validate(new InviteCreateSpec());

  /**
   * Returns the default immutable singleton value of {@code InviteCreateSpec}
   * @return An immutable instance of InviteCreateSpec
   */
  public static InviteCreateSpec create() {
    return INSTANCE;
  }

  private static InviteCreateSpec validate(InviteCreateSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link InviteCreateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InviteCreateSpec instance
   */
  static InviteCreateSpec copyOf(InviteCreateSpecGenerator instance) {
    if (instance instanceof InviteCreateSpec) {
      return (InviteCreateSpec) instance;
    }
    return InviteCreateSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isMaxAgePresent() {
    return !maxAge_absent;
  }

  public Integer maxAgeOrElse(Integer defaultValue) {
    return !maxAge_absent ? maxAge_value : defaultValue;
  }

  public boolean isMaxUsesPresent() {
    return !maxUses_absent;
  }

  public Integer maxUsesOrElse(Integer defaultValue) {
    return !maxUses_absent ? maxUses_value : defaultValue;
  }

  public boolean isTemporaryPresent() {
    return !temporary_absent;
  }

  public Boolean temporaryOrElse(Boolean defaultValue) {
    return !temporary_absent ? temporary_value : defaultValue;
  }

  public boolean isUniquePresent() {
    return !unique_absent;
  }

  public Boolean uniqueOrElse(Boolean defaultValue) {
    return !unique_absent ? unique_value : defaultValue;
  }

  public boolean isTargetTypePresent() {
    return !targetType_absent;
  }

  public Invite.Type targetTypeOrElse(Invite.Type defaultValue) {
    return !targetType_absent ? targetType_value : defaultValue;
  }

  public boolean isTargetUserIdPresent() {
    return !targetUserId_absent;
  }

  public Snowflake targetUserIdOrElse(Snowflake defaultValue) {
    return !targetUserId_absent ? targetUserId_value : defaultValue;
  }

  public boolean isTargetApplicationIdPresent() {
    return !targetApplicationId_absent;
  }

  public Snowflake targetApplicationIdOrElse(Snowflake defaultValue) {
    return !targetApplicationId_absent ? targetApplicationId_value : defaultValue;
  }

  /**
   * Creates a builder for {@link InviteCreateSpec InviteCreateSpec}.
   * <pre>
   * InviteCreateSpec.builder()
   *    .reason(String | null) // nullable {@link InviteCreateSpec#reason() reason}
   *    .maxAge(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link InviteCreateSpec#maxAge() maxAge}
   *    .maxUses(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link InviteCreateSpec#maxUses() maxUses}
   *    .temporary(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link InviteCreateSpec#temporary() temporary}
   *    .unique(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link InviteCreateSpec#unique() unique}
   *    .targetType(discord4j.discordjson.possible.Possible&amp;lt;discord4j.core.object.Invite.Type&amp;gt;) // {@link InviteCreateSpec#targetType() targetType}
   *    .targetUserId(discord4j.discordjson.possible.Possible&amp;lt;discord4j.common.util.Snowflake&amp;gt;) // {@link InviteCreateSpec#targetUserId() targetUserId}
   *    .targetApplicationId(discord4j.discordjson.possible.Possible&amp;lt;discord4j.common.util.Snowflake&amp;gt;) // {@link InviteCreateSpec#targetApplicationId() targetApplicationId}
   *    .build();
   * </pre>
   * @return A new InviteCreateSpec builder
   */
  public static InviteCreateSpec.Builder builder() {
    return new InviteCreateSpec.Builder();
  }

  /**
   * Builds instances of type {@link InviteCreateSpec InviteCreateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InviteCreateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<Integer> maxAge_possible = Possible.absent();
    private Possible<Integer> maxUses_possible = Possible.absent();
    private Possible<Boolean> temporary_possible = Possible.absent();
    private Possible<Boolean> unique_possible = Possible.absent();
    private Possible<Invite.Type> targetType_possible = Possible.absent();
    private Possible<Snowflake> targetUserId_possible = Possible.absent();
    private Possible<Snowflake> targetApplicationId_possible = Possible.absent();
    private String reason;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InviteCreateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InviteCreateSpec instance) {
      return from((InviteCreateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code InviteCreateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(InviteCreateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      maxAge(instance.maxAge());
      maxUses(instance.maxUses());
      temporary(instance.temporary());
      unique(instance.unique());
      targetType(instance.targetType());
      targetUserId(instance.targetUserId());
      targetApplicationId(instance.targetApplicationId());
      return this;
    }

    /**
     * Initializes the value for the {@link InviteCreateSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder maxAge(Possible<Integer> value) {
      this.maxAge_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder maxAge(Integer value) {
      this.maxAge_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder maxUses(Possible<Integer> value) {
      this.maxUses_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder maxUses(Integer value) {
      this.maxUses_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder temporary(Possible<Boolean> value) {
      this.temporary_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder temporary(Boolean value) {
      this.temporary_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder unique(Possible<Boolean> value) {
      this.unique_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder unique(Boolean value) {
      this.unique_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder targetType(Possible<Invite.Type> value) {
      this.targetType_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder targetType(Invite.Type value) {
      this.targetType_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder targetUserId(Possible<Snowflake> value) {
      this.targetUserId_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder targetUserId(Snowflake value) {
      this.targetUserId_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder targetApplicationId(Possible<Snowflake> value) {
      this.targetApplicationId_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder targetApplicationId(Snowflake value) {
      this.targetApplicationId_possible = Possible.of(value);
      return this;
    }

    /**
     * Builds a new {@link InviteCreateSpec InviteCreateSpec}.
     * @return An immutable instance of InviteCreateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InviteCreateSpec build() {
      return InviteCreateSpec.validate(new InviteCreateSpec(
          reason,
          maxAge_build(),
          maxUses_build(),
          temporary_build(),
          unique_build(),
          targetType_build(),
          targetUserId_build(),
          targetApplicationId_build()));
    }

    private Possible<Integer> maxAge_build() {
      return this.maxAge_possible;
    }

    private Possible<Integer> maxUses_build() {
      return this.maxUses_possible;
    }

    private Possible<Boolean> temporary_build() {
      return this.temporary_possible;
    }

    private Possible<Boolean> unique_build() {
      return this.unique_possible;
    }

    private Possible<Invite.Type> targetType_build() {
      return this.targetType_possible;
    }

    private Possible<Snowflake> targetUserId_build() {
      return this.targetUserId_possible;
    }

    private Possible<Snowflake> targetApplicationId_build() {
      return this.targetApplicationId_possible;
    }
  }
}
