package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.Invite;
import discord4j.core.object.entity.channel.CategorizableChannel;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link InviteCreateMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code InviteCreateMono.of()}.
 */
@Generated(from = "InviteCreateMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class InviteCreateMono extends InviteCreateMonoGenerator {
  private final @Nullable String reason;
  private final Integer maxAge_value;
  private final boolean maxAge_absent;
  private final Integer maxUses_value;
  private final boolean maxUses_absent;
  private final Boolean temporary_value;
  private final boolean temporary_absent;
  private final Boolean unique_value;
  private final boolean unique_absent;
  private final Invite.Type targetType_value;
  private final boolean targetType_absent;
  private final Snowflake targetUserId_value;
  private final boolean targetUserId_absent;
  private final Snowflake targetApplicationId_value;
  private final boolean targetApplicationId_absent;
  private final CategorizableChannel channel;

  private InviteCreateMono(CategorizableChannel channel) {
    this.channel = Objects.requireNonNull(channel, "channel");
    this.reason = null;
    Possible<Integer> maxAge$impl = Possible.absent();
    Possible<Integer> maxUses$impl = Possible.absent();
    Possible<Boolean> temporary$impl = Possible.absent();
    Possible<Boolean> unique$impl = Possible.absent();
    Possible<Invite.Type> targetType$impl = Possible.absent();
    Possible<Snowflake> targetUserId$impl = Possible.absent();
    Possible<Snowflake> targetApplicationId$impl = Possible.absent();
    this.maxAge_value = maxAge$impl.toOptional().orElse(null);
    this.maxAge_absent = maxAge$impl.isAbsent();
    this.maxUses_value = maxUses$impl.toOptional().orElse(null);
    this.maxUses_absent = maxUses$impl.isAbsent();
    this.temporary_value = temporary$impl.toOptional().orElse(null);
    this.temporary_absent = temporary$impl.isAbsent();
    this.unique_value = unique$impl.toOptional().orElse(null);
    this.unique_absent = unique$impl.isAbsent();
    this.targetType_value = targetType$impl.toOptional().orElse(null);
    this.targetType_absent = targetType$impl.isAbsent();
    this.targetUserId_value = targetUserId$impl.toOptional().orElse(null);
    this.targetUserId_absent = targetUserId$impl.isAbsent();
    this.targetApplicationId_value = targetApplicationId$impl.toOptional().orElse(null);
    this.targetApplicationId_absent = targetApplicationId$impl.isAbsent();
    this.initShim = null;
  }

  private InviteCreateMono(
      @Nullable String reason,
      Possible<Integer> maxAge,
      Possible<Integer> maxUses,
      Possible<Boolean> temporary,
      Possible<Boolean> unique,
      Possible<Invite.Type> targetType,
      Possible<Snowflake> targetUserId,
      Possible<Snowflake> targetApplicationId,
      CategorizableChannel channel) {
    this.reason = reason;
    Possible<Integer> maxAge$impl = maxAge;
    Possible<Integer> maxUses$impl = maxUses;
    Possible<Boolean> temporary$impl = temporary;
    Possible<Boolean> unique$impl = unique;
    Possible<Invite.Type> targetType$impl = targetType;
    Possible<Snowflake> targetUserId$impl = targetUserId;
    Possible<Snowflake> targetApplicationId$impl = targetApplicationId;
    this.channel = channel;
    this.maxAge_value = maxAge$impl.toOptional().orElse(null);
    this.maxAge_absent = maxAge$impl.isAbsent();
    this.maxUses_value = maxUses$impl.toOptional().orElse(null);
    this.maxUses_absent = maxUses$impl.isAbsent();
    this.temporary_value = temporary$impl.toOptional().orElse(null);
    this.temporary_absent = temporary$impl.isAbsent();
    this.unique_value = unique$impl.toOptional().orElse(null);
    this.unique_absent = unique$impl.isAbsent();
    this.targetType_value = targetType$impl.toOptional().orElse(null);
    this.targetType_absent = targetType$impl.isAbsent();
    this.targetUserId_value = targetUserId$impl.toOptional().orElse(null);
    this.targetUserId_absent = targetUserId$impl.isAbsent();
    this.targetApplicationId_value = targetApplicationId$impl.toOptional().orElse(null);
    this.targetApplicationId_absent = targetApplicationId$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "InviteCreateMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build InviteCreateMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code maxAge} attribute
   */
  @Override
  public Possible<Integer> maxAge() {
    return maxAge_absent ? Possible.absent() : Possible.of(maxAge_value);
  }

  /**
   * @return The value of the {@code maxUses} attribute
   */
  @Override
  public Possible<Integer> maxUses() {
    return maxUses_absent ? Possible.absent() : Possible.of(maxUses_value);
  }

  /**
   * @return The value of the {@code temporary} attribute
   */
  @Override
  public Possible<Boolean> temporary() {
    return temporary_absent ? Possible.absent() : Possible.of(temporary_value);
  }

  /**
   * @return The value of the {@code unique} attribute
   */
  @Override
  public Possible<Boolean> unique() {
    return unique_absent ? Possible.absent() : Possible.of(unique_value);
  }

  /**
   * @return The value of the {@code targetType} attribute
   */
  @Override
  public Possible<Invite.Type> targetType() {
    return targetType_absent ? Possible.absent() : Possible.of(targetType_value);
  }

  /**
   * @return The value of the {@code targetUserId} attribute
   */
  @Override
  public Possible<Snowflake> targetUserId() {
    return targetUserId_absent ? Possible.absent() : Possible.of(targetUserId_value);
  }

  /**
   * @return The value of the {@code targetApplicationId} attribute
   */
  @Override
  public Possible<Snowflake> targetApplicationId() {
    return targetApplicationId_absent ? Possible.absent() : Possible.of(targetApplicationId_value);
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @Override
  public CategorizableChannel channel() {
    return channel;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InviteCreateMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final InviteCreateMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new InviteCreateMono(
        value,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withMaxAge(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new InviteCreateMono(
        this.reason,
        newValue,
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withMaxAge(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new InviteCreateMono(
        this.reason,
        newValue,
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withMaxUses(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        newValue,
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withMaxUses(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        newValue,
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withTemporary(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        newValue,
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withTemporary(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        newValue,
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withUnique(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        newValue,
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withUnique(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        newValue,
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withTargetType(Possible<Invite.Type> value) {
    Possible<Invite.Type> newValue = Objects.requireNonNull(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        newValue,
        this.targetUserId(),
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withTargetType(Invite.Type value) {
    Possible<Invite.Type> newValue = Possible.of(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        newValue,
        this.targetUserId(),
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withTargetUserId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        newValue,
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withTargetUserId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        newValue,
        this.targetApplicationId(),
        this.channel);
  }

  public InviteCreateMono withTargetApplicationId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        newValue,
        this.channel);
  }

  public InviteCreateMono withTargetApplicationId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        newValue,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InviteCreateMono#channel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final InviteCreateMono withChannel(CategorizableChannel value) {
    if (this.channel == value) return this;
    CategorizableChannel newValue = Objects.requireNonNull(value, "channel");
    return new InviteCreateMono(
        this.reason,
        this.maxAge(),
        this.maxUses(),
        this.temporary(),
        this.unique(),
        this.targetType(),
        this.targetUserId(),
        this.targetApplicationId(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code InviteCreateMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InviteCreateMono
        && equalTo(0, (InviteCreateMono) another);
  }

  private boolean equalTo(int synthetic, InviteCreateMono another) {
    return Objects.equals(reason, another.reason)
        && this.maxAge().equals(another.maxAge())
        && this.maxUses().equals(another.maxUses())
        && this.temporary().equals(another.temporary())
        && this.unique().equals(another.unique())
        && this.targetType().equals(another.targetType())
        && this.targetUserId().equals(another.targetUserId())
        && this.targetApplicationId().equals(another.targetApplicationId())
        && channel.equals(another.channel);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code maxAge}, {@code maxUses}, {@code temporary}, {@code unique}, {@code targetType}, {@code targetUserId}, {@code targetApplicationId}, {@code channel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (maxAge().hashCode());
    h += (h << 5) + (maxUses().hashCode());
    h += (h << 5) + (temporary().hashCode());
    h += (h << 5) + (unique().hashCode());
    h += (h << 5) + (targetType().hashCode());
    h += (h << 5) + (targetUserId().hashCode());
    h += (h << 5) + (targetApplicationId().hashCode());
    h += (h << 5) + channel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InviteCreateMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InviteCreateMono{"
        + "reason=" + reason
        + ", maxAge=" + (maxAge().toString())
        + ", maxUses=" + (maxUses().toString())
        + ", temporary=" + (temporary().toString())
        + ", unique=" + (unique().toString())
        + ", targetType=" + (targetType().toString())
        + ", targetUserId=" + (targetUserId().toString())
        + ", targetApplicationId=" + (targetApplicationId().toString())
        + ", channel=" + channel
        + "}";
  }

  /**
   * Construct a new immutable {@code InviteCreateMono} instance.
   * @param channel The value for the {@code channel} attribute
   * @return An immutable InviteCreateMono instance
   */
  public static InviteCreateMono of(CategorizableChannel channel) {
    return new InviteCreateMono(channel);
  }

  /**
   * Creates an immutable copy of a {@link InviteCreateMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InviteCreateMono instance
   */
  static InviteCreateMono copyOf(InviteCreateMonoGenerator instance) {
    if (instance instanceof InviteCreateMono) {
      return (InviteCreateMono) instance;
    }
    return InviteCreateMono.of(instance.channel())
        .withReason(instance.reason())
        .withMaxAge(instance.maxAge())
        .withMaxUses(instance.maxUses())
        .withTemporary(instance.temporary())
        .withUnique(instance.unique())
        .withTargetType(instance.targetType())
        .withTargetUserId(instance.targetUserId())
        .withTargetApplicationId(instance.targetApplicationId());
  }

  public boolean isMaxAgePresent() {
    return !maxAge_absent;
  }

  public Integer maxAgeOrElse(Integer defaultValue) {
    return !maxAge_absent ? maxAge_value : defaultValue;
  }

  public boolean isMaxUsesPresent() {
    return !maxUses_absent;
  }

  public Integer maxUsesOrElse(Integer defaultValue) {
    return !maxUses_absent ? maxUses_value : defaultValue;
  }

  public boolean isTemporaryPresent() {
    return !temporary_absent;
  }

  public Boolean temporaryOrElse(Boolean defaultValue) {
    return !temporary_absent ? temporary_value : defaultValue;
  }

  public boolean isUniquePresent() {
    return !unique_absent;
  }

  public Boolean uniqueOrElse(Boolean defaultValue) {
    return !unique_absent ? unique_value : defaultValue;
  }

  public boolean isTargetTypePresent() {
    return !targetType_absent;
  }

  public Invite.Type targetTypeOrElse(Invite.Type defaultValue) {
    return !targetType_absent ? targetType_value : defaultValue;
  }

  public boolean isTargetUserIdPresent() {
    return !targetUserId_absent;
  }

  public Snowflake targetUserIdOrElse(Snowflake defaultValue) {
    return !targetUserId_absent ? targetUserId_value : defaultValue;
  }

  public boolean isTargetApplicationIdPresent() {
    return !targetApplicationId_absent;
  }

  public Snowflake targetApplicationIdOrElse(Snowflake defaultValue) {
    return !targetApplicationId_absent ? targetApplicationId_value : defaultValue;
  }
}
