package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.component.LayoutComponent;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.*;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link InteractionReplyEditSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code InteractionReplyEditSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code InteractionReplyEditSpec.create()}.
 */
@Generated(from = "InteractionReplyEditSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class InteractionReplyEditSpec implements InteractionReplyEditSpecGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final List<EmbedCreateSpec> embeds_value;
  private final boolean embeds_absent;
  private final List<MessageCreateFields.File> files;
  private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;

  private InteractionReplyEditSpec() {
    Possible<java.util.Optional<String>> content$impl = Possible.absent();
    Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds$impl = Possible.absent();
    Possible<java.util.Optional<AllowedMentions>> allowedMentions$impl = Possible.absent();
    Possible<java.util.Optional<List<LayoutComponent>>> components$impl = Possible.absent();
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = Possible.flatOpt(components$impl).orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private InteractionReplyEditSpec(InteractionReplyEditSpec.Builder builder) {
    Possible<java.util.Optional<String>> content$impl = builder.content_build();
    Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds$impl = builder.embeds_build();
    Possible<java.util.Optional<AllowedMentions>> allowedMentions$impl = builder.allowedMentions_build();
    Possible<java.util.Optional<List<LayoutComponent>>> components$impl = builder.components_build();
    if (builder.filesIsSet()) {
      initShim.files(createUnmodifiableList(true, builder.files));
    }
    if (builder.fileSpoilersIsSet()) {
      initShim.fileSpoilers(createUnmodifiableList(true, builder.fileSpoilers));
    }
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = Possible.flatOpt(components$impl).orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private InteractionReplyEditSpec(
      Possible<java.util.Optional<String>> content,
      Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds,
      List<MessageCreateFields.File> files,
      List<MessageCreateFields.FileSpoiler> fileSpoilers,
      Possible<java.util.Optional<AllowedMentions>> allowedMentions,
      Possible<java.util.Optional<List<LayoutComponent>>> components) {
    Possible<java.util.Optional<String>> content$impl = content;
    Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds$impl = embeds;
    initShim.files(files);
    initShim.fileSpoilers(fileSpoilers);
    Possible<java.util.Optional<AllowedMentions>> allowedMentions$impl = allowedMentions;
    Possible<java.util.Optional<List<LayoutComponent>>> components$impl = components;
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = Possible.flatOpt(components$impl).orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "InteractionReplyEditSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private byte filesBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.File> files;

    List<MessageCreateFields.File> files() {
      if (filesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (filesBuildStage == STAGE_UNINITIALIZED) {
        filesBuildStage = STAGE_INITIALIZING;
        this.files = createUnmodifiableList(false, createSafeList(filesInitialize(), true, false));
        filesBuildStage = STAGE_INITIALIZED;
      }
      return this.files;
    }

    void files(List<MessageCreateFields.File> files) {
      this.files = files;
      filesBuildStage = STAGE_INITIALIZED;
    }

    private byte fileSpoilersBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.FileSpoiler> fileSpoilers;

    List<MessageCreateFields.FileSpoiler> fileSpoilers() {
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fileSpoilersBuildStage == STAGE_UNINITIALIZED) {
        fileSpoilersBuildStage = STAGE_INITIALIZING;
        this.fileSpoilers = createUnmodifiableList(false, createSafeList(fileSpoilersInitialize(), true, false));
        fileSpoilersBuildStage = STAGE_INITIALIZED;
      }
      return this.fileSpoilers;
    }

    void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
      this.fileSpoilers = fileSpoilers;
      fileSpoilersBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new java.util.ArrayList<>();
      if (filesBuildStage == STAGE_INITIALIZING) attributes.add("files");
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) attributes.add("fileSpoilers");
      return "Cannot build InteractionReplyEditSpec, attribute initializers form cycle " + attributes;
    }
  }

  private List<MessageCreateFields.File> filesInitialize() {
    return InteractionReplyEditSpecGenerator.super.files();
  }

  private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
    return InteractionReplyEditSpecGenerator.super.fileSpoilers();
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public Possible<java.util.Optional<String>> content() {
    return content_absent ? Possible.absent() :
        Possible.of(java.util.Optional.ofNullable(content_value));
  }

  /**
   * @return The value of the {@code embeds} attribute
   */
  @Override
  public Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds() {
    return embeds_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(embeds_value));
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @Override
  public List<MessageCreateFields.File> files() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.files()
        : this.files;
  }

  /**
   * @return The value of the {@code fileSpoilers} attribute
   */
  @Override
  public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.fileSpoilers()
        : this.fileSpoilers;
  }

  /**
   * @return The value of the {@code allowedMentions} attribute
   */
  @Override
  public Possible<java.util.Optional<AllowedMentions>> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() :
        Possible.of(java.util.Optional.ofNullable(allowedMentions_value));
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<java.util.Optional<List<LayoutComponent>>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(components_value));
  }

  public InteractionReplyEditSpec withContent(Possible<java.util.Optional<String>> value) {
    Possible<java.util.Optional<String>> newValue = java.util.Objects.requireNonNull(value);
    return validate(new InteractionReplyEditSpec(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components()));
  }

  @Deprecated
  public InteractionReplyEditSpec withContent(@Nullable String value) {
    Possible<java.util.Optional<String>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return validate(new InteractionReplyEditSpec(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components()));
  }

  public InteractionReplyEditSpec withContentOrNull(@Nullable String value) {
    Possible<java.util.Optional<String>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return validate(new InteractionReplyEditSpec(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components()));
  }

  public InteractionReplyEditSpec withEmbeds(Possible<java.util.Optional<List<EmbedCreateSpec>>> possible) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Objects.requireNonNull(possible);
    return validate(new InteractionReplyEditSpec(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components()));
  }

  @Deprecated
  public InteractionReplyEditSpec withEmbeds(@Nullable java.lang.Iterable<EmbedCreateSpec> elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return validate(new InteractionReplyEditSpec(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components()));
  }

  public InteractionReplyEditSpec withEmbedsOrNull(@Nullable java.lang.Iterable<EmbedCreateSpec> elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return validate(new InteractionReplyEditSpec(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components()));
  }

  @SafeVarargs
  public final InteractionReplyEditSpec withEmbeds(EmbedCreateSpec... elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return validate(new InteractionReplyEditSpec(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InteractionReplyEditSpec#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final InteractionReplyEditSpec withFiles(MessageCreateFields.File... elements) {
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(java.util.Arrays.asList(elements), true, false));
    return validate(new InteractionReplyEditSpec(
        this.content(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InteractionReplyEditSpec#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final InteractionReplyEditSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    if (this.files == elements) return this;
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new InteractionReplyEditSpec(
        this.content(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InteractionReplyEditSpec#fileSpoilers() fileSpoilers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final InteractionReplyEditSpec withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(java.util.Arrays.asList(elements), true, false));
    return validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InteractionReplyEditSpec#fileSpoilers() fileSpoilers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSpoilers elements to set
   * @return A modified copy of {@code this} object
   */
  public final InteractionReplyEditSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    if (this.fileSpoilers == elements) return this;
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, newValue, this.allowedMentions(), this.components()));
  }

  public InteractionReplyEditSpec withAllowedMentions(Possible<java.util.Optional<AllowedMentions>> value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = java.util.Objects.requireNonNull(value);
    return validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, newValue, this.components()));
  }

  @Deprecated
  public InteractionReplyEditSpec withAllowedMentions(@Nullable AllowedMentions value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, newValue, this.components()));
  }

  public InteractionReplyEditSpec withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, newValue, this.components()));
  }

  public InteractionReplyEditSpec withComponents(Possible<java.util.Optional<List<LayoutComponent>>> possible) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Objects.requireNonNull(possible);
    return validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue));
  }

  @Deprecated
  public InteractionReplyEditSpec withComponents(@Nullable java.lang.Iterable<LayoutComponent> elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue));
  }

  public InteractionReplyEditSpec withComponentsOrNull(@Nullable java.lang.Iterable<LayoutComponent> elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue));
  }

  @SafeVarargs
  public final InteractionReplyEditSpec withComponents(LayoutComponent... elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return validate(new InteractionReplyEditSpec(this.content(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue));
  }

  /**
   * This instance is equal to all instances of {@code InteractionReplyEditSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InteractionReplyEditSpec
        && equalTo(0, (InteractionReplyEditSpec) another);
  }

  private boolean equalTo(int synthetic, InteractionReplyEditSpec another) {
    return this.content().equals(another.content())
        && Objects.equals(embeds_value, another.embeds_value)
        && files.equals(another.files)
        && fileSpoilers.equals(another.fileSpoilers)
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code embeds}, {@code files}, {@code fileSpoilers}, {@code allowedMentions}, {@code components}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (Objects.hashCode(embeds_value));
    h += (h << 5) + files.hashCode();
    h += (h << 5) + fileSpoilers.hashCode();
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    return h;
  }

  /**
   * Prints the immutable value {@code InteractionReplyEditSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InteractionReplyEditSpec{"
        + "content=" + (content().toString())
        + ", embeds=" + (Objects.toString(embeds_value))
        + ", files=" + files
        + ", fileSpoilers=" + fileSpoilers
        + ", allowedMentions=" + (allowedMentions().toString())
        + ", components=" + (Objects.toString(components_value))
        + "}";
  }

  private static final InteractionReplyEditSpec INSTANCE = validate(new InteractionReplyEditSpec());

  /**
   * Returns the default immutable singleton value of {@code InteractionReplyEditSpec}
   * @return An immutable instance of InteractionReplyEditSpec
   */
  public static InteractionReplyEditSpec create() {
    return INSTANCE;
  }

  private static InteractionReplyEditSpec validate(InteractionReplyEditSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link InteractionReplyEditSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InteractionReplyEditSpec instance
   */
  static InteractionReplyEditSpec copyOf(InteractionReplyEditSpecGenerator instance) {
    if (instance instanceof InteractionReplyEditSpec) {
      return (InteractionReplyEditSpec) instance;
    }
    return InteractionReplyEditSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isEmbedsPresent() {
    return !embeds_absent;
  }

  public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
    return !embeds_absent ? embeds_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  /**
   * Creates a builder for {@link InteractionReplyEditSpec InteractionReplyEditSpec}.
   * <pre>
   * InteractionReplyEditSpec.builder()
   *    .content(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;String&amp;gt;&amp;gt;) // {@link InteractionReplyEditSpec#content() content}
   *    .embeds(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;List&amp;lt;EmbedCreateSpec&amp;gt;&amp;gt;&amp;gt;) // {@link InteractionReplyEditSpec#embeds() embeds}
   *    .addFile|addAllFiles(discord4j.core.spec.MessageCreateFields.File) // {@link InteractionReplyEditSpec#files() files} elements
   *    .addFileSpoiler|addAllFileSpoilers(discord4j.core.spec.MessageCreateFields.FileSpoiler) // {@link InteractionReplyEditSpec#fileSpoilers() fileSpoilers} elements
   *    .allowedMentions(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.rest.util.AllowedMentions&amp;gt;&amp;gt;) // {@link InteractionReplyEditSpec#allowedMentions() allowedMentions}
   *    .components(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;List&amp;lt;discord4j.core.object.component.LayoutComponent&amp;gt;&amp;gt;&amp;gt;) // {@link InteractionReplyEditSpec#components() components}
   *    .build();
   * </pre>
   * @return A new InteractionReplyEditSpec builder
   */
  public static InteractionReplyEditSpec.Builder builder() {
    return new InteractionReplyEditSpec.Builder();
  }

  /**
   * Builds instances of type {@link InteractionReplyEditSpec InteractionReplyEditSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InteractionReplyEditSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long OPT_BIT_FILES = 0x1L;
    private static final long OPT_BIT_FILE_SPOILERS = 0x2L;
    private long optBits;

    private Possible<java.util.Optional<String>> content_possible = Possible.absent();
    private List<EmbedCreateSpec> embeds_list = null;
    private boolean embeds_explicitNull;
    private Possible<java.util.Optional<AllowedMentions>> allowedMentions_possible = Possible.absent();
    private List<LayoutComponent> components_list = null;
    private boolean components_explicitNull;
    private List<MessageCreateFields.File> files = new java.util.ArrayList<MessageCreateFields.File>();
    private List<MessageCreateFields.FileSpoiler> fileSpoilers = new java.util.ArrayList<MessageCreateFields.FileSpoiler>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InteractionReplyEditSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InteractionReplyEditSpec instance) {
      return from((InteractionReplyEditSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code InteractionReplyEditSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(InteractionReplyEditSpecGenerator instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      content(instance.content());
      embeds(instance.embeds());
      addAllFiles(instance.files());
      addAllFileSpoilers(instance.fileSpoilers());
      allowedMentions(instance.allowedMentions());
      components(instance.components());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder content(Possible<java.util.Optional<String>> value) {
      this.content_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder content(@Nullable String value) {
      this.content_possible = Possible.of(java.util.Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder contentOrNull(@Nullable String value) {
      this.content_possible = Possible.of(java.util.Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addEmbed(EmbedCreateSpec element) {
      embeds_getOrCreate().add(element);
      this.embeds_explicitNull = false;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
      embeds_getOrCreate().addAll(elements);
      this.embeds_explicitNull = false;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(Possible<java.util.Optional<List<EmbedCreateSpec>>> elements) {
      this.embeds_list = null;
      this.embeds_explicitNull = false;
      elements.toOptional().ifPresent(e -> {
        if (e.isPresent()) {
          embeds_getOrCreate().addAll(e.get());
        } else {
          this.embeds_explicitNull = true;
        }
      });
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(List<EmbedCreateSpec> elements) {
      this.embeds_list = new ArrayList<>(elements);
      this.embeds_explicitNull = false;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder embeds(@Nullable java.lang.Iterable<EmbedCreateSpec> elements) {
      if (elements == null) {
        this.embeds_list = null;
        this.embeds_explicitNull = true;
      } else {
        this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
        this.embeds_explicitNull = false;
      }
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embedsOrNull(@Nullable java.lang.Iterable<EmbedCreateSpec> elements) {
      if (elements == null) {
        this.embeds_list = null;
        this.embeds_explicitNull = true;
      } else {
        this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
        this.embeds_explicitNull = false;
      }
      return this;
    }

    /**
     * Adds one element to {@link InteractionReplyEditSpec#files() files} list.
     * @param element A files element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFile(MessageCreateFields.File element) {
      element = ImmutableMessageCreateFields.File.copyOf(element);
      this.files.add(java.util.Objects.requireNonNull(element, "files element"));
      optBits |= OPT_BIT_FILES;
      return this;
    }

    /**
     * Constructs and adds an element for the {@link InteractionReplyEditSpec#files() files} list.
     * @param name The value for {@code files.name} 
     * @param inputStream The value for {@code files.inputStream} 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFile(String name, InputStream inputStream) {
      return addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
    }

    /**
     * Adds elements to {@link InteractionReplyEditSpec#files() files} list.
     * @param elements An array of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFiles(MessageCreateFields.File... elements) {
      for (MessageCreateFields.File element : elements) {
        element = ImmutableMessageCreateFields.File.copyOf(element);
        this.files.add(java.util.Objects.requireNonNull(element, "files element"));
      }
      optBits |= OPT_BIT_FILES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InteractionReplyEditSpec#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
      this.files.clear();
      return addAllFiles(elements);
    }

    /**
     * Adds elements to {@link InteractionReplyEditSpec#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
      for (MessageCreateFields.File element : elements) {
        element = ImmutableMessageCreateFields.File.copyOf(element);
        this.files.add(java.util.Objects.requireNonNull(element, "files element"));
      }
      optBits |= OPT_BIT_FILES;
      return this;
    }

    /**
     * Adds one element to {@link InteractionReplyEditSpec#fileSpoilers() fileSpoilers} list.
     * @param element A fileSpoilers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
      element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
      this.fileSpoilers.add(java.util.Objects.requireNonNull(element, "fileSpoilers element"));
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }

    /**
     * Constructs and adds an element for the {@link InteractionReplyEditSpec#fileSpoilers() fileSpoilers} list.
     * @param name The value for {@code fileSpoilers.name} 
     * @param inputStream The value for {@code fileSpoilers.inputStream} 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFileSpoiler(String name, InputStream inputStream) {
      return addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
    }

    /**
     * Adds elements to {@link InteractionReplyEditSpec#fileSpoilers() fileSpoilers} list.
     * @param elements An array of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
      for (MessageCreateFields.FileSpoiler element : elements) {
        element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
        this.fileSpoilers.add(java.util.Objects.requireNonNull(element, "fileSpoilers element"));
      }
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InteractionReplyEditSpec#fileSpoilers() fileSpoilers} list.
     * @param elements An iterable of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
      this.fileSpoilers.clear();
      return addAllFileSpoilers(elements);
    }

    /**
     * Adds elements to {@link InteractionReplyEditSpec#fileSpoilers() fileSpoilers} list.
     * @param elements An iterable of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
      for (MessageCreateFields.FileSpoiler element : elements) {
        element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
        this.fileSpoilers.add(java.util.Objects.requireNonNull(element, "fileSpoilers element"));
      }
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentions(Possible<java.util.Optional<AllowedMentions>> value) {
      this.allowedMentions_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder allowedMentions(@Nullable AllowedMentions value) {
      this.allowedMentions_possible = Possible.of(java.util.Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentionsOrNull(@Nullable AllowedMentions value) {
      this.allowedMentions_possible = Possible.of(java.util.Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addComponent(LayoutComponent element) {
      components_getOrCreate().add(element);
      this.components_explicitNull = false;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllComponents(List<LayoutComponent> elements) {
      components_getOrCreate().addAll(elements);
      this.components_explicitNull = false;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(Possible<java.util.Optional<List<LayoutComponent>>> elements) {
      this.components_list = null;
      this.components_explicitNull = false;
      elements.toOptional().ifPresent(e -> {
        if (e.isPresent()) {
          components_getOrCreate().addAll(e.get());
        } else {
          this.components_explicitNull = true;
        }
      });
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(List<LayoutComponent> elements) {
      this.components_list = new ArrayList<>(elements);
      this.components_explicitNull = false;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder components(@Nullable java.lang.Iterable<LayoutComponent> elements) {
      if (elements == null) {
        this.components_list = null;
        this.components_explicitNull = true;
      } else {
        this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
        this.components_explicitNull = false;
      }
      return this;
    }

    @CanIgnoreReturnValue
    public Builder componentsOrNull(@Nullable java.lang.Iterable<LayoutComponent> elements) {
      if (elements == null) {
        this.components_list = null;
        this.components_explicitNull = true;
      } else {
        this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
        this.components_explicitNull = false;
      }
      return this;
    }

    /**
     * Builds a new {@link InteractionReplyEditSpec InteractionReplyEditSpec}.
     * @return An immutable instance of InteractionReplyEditSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InteractionReplyEditSpec build() {
      return InteractionReplyEditSpec.validate(new InteractionReplyEditSpec(this));
    }

    private boolean filesIsSet() {
      return (optBits & OPT_BIT_FILES) != 0;
    }

    private boolean fileSpoilersIsSet() {
      return (optBits & OPT_BIT_FILE_SPOILERS) != 0;
    }

    private Possible<java.util.Optional<String>> content_build() {
      return this.content_possible;
    }

    private Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds_build() {
      return this.embeds_list == null && !embeds_explicitNull ? Possible.absent() :
          Possible.of(Optional.ofNullable(this.embeds_list));
    }

    private List<EmbedCreateSpec> embeds_getOrCreate() {
      if (this.embeds_list == null) {
        this.embeds_list = new ArrayList<>();
      }
      return this.embeds_list;
    }

    private Possible<java.util.Optional<AllowedMentions>> allowedMentions_build() {
      return this.allowedMentions_possible;
    }

    private Possible<java.util.Optional<List<LayoutComponent>>> components_build() {
      return this.components_list == null && !components_explicitNull ? Possible.absent() :
          Possible.of(Optional.ofNullable(this.components_list));
    }

    private List<LayoutComponent> components_getOrCreate() {
      if (this.components_list == null) {
        this.components_list = new ArrayList<>();
      }
      return this.components_list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    java.util.ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new java.util.ArrayList<>();
    } else {
      list = new java.util.ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) java.util.Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new java.util.ArrayList<>(list));
      } else {
        if (list instanceof java.util.ArrayList<?>) {
          ((java.util.ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
