package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.event.domain.interaction.DeferrableInteractionEvent;
import discord4j.core.object.component.LayoutComponent;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link InteractionReplyEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code InteractionReplyEditMono.of()}.
 */
@Generated(from = "InteractionReplyEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class InteractionReplyEditMono extends InteractionReplyEditMonoGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final List<EmbedCreateSpec> embeds_value;
  private final boolean embeds_absent;
  private final List<MessageCreateFields.File> files;
  private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;
  private final DeferrableInteractionEvent event;

  private InteractionReplyEditMono(DeferrableInteractionEvent event) {
    this.event = java.util.Objects.requireNonNull(event, "event");
    Possible<java.util.Optional<String>> content$impl = Possible.absent();
    Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds$impl = Possible.absent();
    Possible<java.util.Optional<AllowedMentions>> allowedMentions$impl = Possible.absent();
    Possible<java.util.Optional<List<LayoutComponent>>> components$impl = Possible.absent();
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = Possible.flatOpt(components$impl).orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private InteractionReplyEditMono(
      Possible<java.util.Optional<String>> content,
      Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds,
      List<MessageCreateFields.File> files,
      List<MessageCreateFields.FileSpoiler> fileSpoilers,
      Possible<java.util.Optional<AllowedMentions>> allowedMentions,
      Possible<java.util.Optional<List<LayoutComponent>>> components,
      DeferrableInteractionEvent event) {
    Possible<java.util.Optional<String>> content$impl = content;
    Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds$impl = embeds;
    initShim.files(files);
    initShim.fileSpoilers(fileSpoilers);
    Possible<java.util.Optional<AllowedMentions>> allowedMentions$impl = allowedMentions;
    Possible<java.util.Optional<List<LayoutComponent>>> components$impl = components;
    this.event = event;
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.embeds_value = Possible.flatOpt(embeds$impl).orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = Possible.flatOpt(components$impl).orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "InteractionReplyEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private byte filesBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.File> files;

    List<MessageCreateFields.File> files() {
      if (filesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (filesBuildStage == STAGE_UNINITIALIZED) {
        filesBuildStage = STAGE_INITIALIZING;
        this.files = createUnmodifiableList(false, createSafeList(InteractionReplyEditMono.super.files(), true, false));
        filesBuildStage = STAGE_INITIALIZED;
      }
      return this.files;
    }

    void files(List<MessageCreateFields.File> files) {
      this.files = files;
      filesBuildStage = STAGE_INITIALIZED;
    }

    private byte fileSpoilersBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.FileSpoiler> fileSpoilers;

    List<MessageCreateFields.FileSpoiler> fileSpoilers() {
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fileSpoilersBuildStage == STAGE_UNINITIALIZED) {
        fileSpoilersBuildStage = STAGE_INITIALIZING;
        this.fileSpoilers = createUnmodifiableList(false, createSafeList(InteractionReplyEditMono.super.fileSpoilers(), true, false));
        fileSpoilersBuildStage = STAGE_INITIALIZED;
      }
      return this.fileSpoilers;
    }

    void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
      this.fileSpoilers = fileSpoilers;
      fileSpoilersBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (filesBuildStage == STAGE_INITIALIZING) attributes.add("files");
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) attributes.add("fileSpoilers");
      return "Cannot build InteractionReplyEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public Possible<java.util.Optional<String>> content() {
    return content_absent ? Possible.absent() :
        Possible.of(java.util.Optional.ofNullable(content_value));
  }

  /**
   * @return The value of the {@code embeds} attribute
   */
  @Override
  public Possible<java.util.Optional<List<EmbedCreateSpec>>> embeds() {
    return embeds_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(embeds_value));
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @Override
  public List<MessageCreateFields.File> files() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.files()
        : this.files;
  }

  /**
   * @return The value of the {@code fileSpoilers} attribute
   */
  @Override
  public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.fileSpoilers()
        : this.fileSpoilers;
  }

  /**
   * @return The value of the {@code allowedMentions} attribute
   */
  @Override
  public Possible<java.util.Optional<AllowedMentions>> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() :
        Possible.of(java.util.Optional.ofNullable(allowedMentions_value));
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<java.util.Optional<List<LayoutComponent>>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(components_value));
  }

  /**
   * @return The value of the {@code event} attribute
   */
  @Override
  public DeferrableInteractionEvent event() {
    return event;
  }

  public InteractionReplyEditMono withContent(Possible<java.util.Optional<String>> value) {
    Possible<java.util.Optional<String>> newValue = java.util.Objects.requireNonNull(value);
    return new InteractionReplyEditMono(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  @Deprecated
  public InteractionReplyEditMono withContent(@Nullable String value) {
    Possible<java.util.Optional<String>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new InteractionReplyEditMono(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionReplyEditMono withContentOrNull(@Nullable String value) {
    Possible<java.util.Optional<String>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new InteractionReplyEditMono(
        newValue,
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionReplyEditMono withEmbeds(Possible<java.util.Optional<List<EmbedCreateSpec>>> possible) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Objects.requireNonNull(possible);
    return new InteractionReplyEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  @Deprecated
  public InteractionReplyEditMono withEmbeds(@Nullable java.lang.Iterable<EmbedCreateSpec> elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new InteractionReplyEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionReplyEditMono withEmbedsOrNull(@Nullable java.lang.Iterable<EmbedCreateSpec> elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new InteractionReplyEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  @SafeVarargs
  public final InteractionReplyEditMono withEmbeds(EmbedCreateSpec... elements) {
    Possible<java.util.Optional<List<EmbedCreateSpec>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return new InteractionReplyEditMono(
        this.content(),
        newValue,
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InteractionReplyEditMono#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final InteractionReplyEditMono withFiles(MessageCreateFields.File... elements) {
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(java.util.Arrays.asList(elements), true, false));
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InteractionReplyEditMono#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final InteractionReplyEditMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    if (this.files == elements) return this;
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        newValue,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InteractionReplyEditMono#fileSpoilers() fileSpoilers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final InteractionReplyEditMono withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(java.util.Arrays.asList(elements), true, false));
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InteractionReplyEditMono#fileSpoilers() fileSpoilers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSpoilers elements to set
   * @return A modified copy of {@code this} object
   */
  public final InteractionReplyEditMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    if (this.fileSpoilers == elements) return this;
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionReplyEditMono withAllowedMentions(Possible<java.util.Optional<AllowedMentions>> value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = java.util.Objects.requireNonNull(value);
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components(),
        this.event);
  }

  @Deprecated
  public InteractionReplyEditMono withAllowedMentions(@Nullable AllowedMentions value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components(),
        this.event);
  }

  public InteractionReplyEditMono withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
    Possible<java.util.Optional<AllowedMentions>> newValue = Possible.of(java.util.Optional.ofNullable(value));
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.components(),
        this.event);
  }

  public InteractionReplyEditMono withComponents(Possible<java.util.Optional<List<LayoutComponent>>> possible) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Objects.requireNonNull(possible);
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.event);
  }

  @Deprecated
  public InteractionReplyEditMono withComponents(@Nullable java.lang.Iterable<LayoutComponent> elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.event);
  }

  public InteractionReplyEditMono withComponentsOrNull(@Nullable java.lang.Iterable<LayoutComponent> elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.ofNullable(elements)
      .map(els -> StreamSupport.stream(els.spliterator(), false).collect(Collectors.toList())));
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.event);
  }

  @SafeVarargs
  public final InteractionReplyEditMono withComponents(LayoutComponent... elements) {
    Possible<java.util.Optional<List<LayoutComponent>>> newValue = Possible.of(Optional.of(Arrays.asList(elements)));
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        newValue,
        this.event);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractionReplyEditMono#event() event} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for event
   * @return A modified copy of the {@code this} object
   */
  public final InteractionReplyEditMono withEvent(DeferrableInteractionEvent value) {
    if (this.event == value) return this;
    DeferrableInteractionEvent newValue = java.util.Objects.requireNonNull(value, "event");
    return new InteractionReplyEditMono(
        this.content(),
        this.embeds(),
        this.files,
        this.fileSpoilers,
        this.allowedMentions(),
        this.components(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code InteractionReplyEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InteractionReplyEditMono
        && equalTo(0, (InteractionReplyEditMono) another);
  }

  private boolean equalTo(int synthetic, InteractionReplyEditMono another) {
    return this.content().equals(another.content())
        && Objects.equals(embeds_value, another.embeds_value)
        && files.equals(another.files)
        && fileSpoilers.equals(another.fileSpoilers)
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value)
        && event.equals(another.event);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code embeds}, {@code files}, {@code fileSpoilers}, {@code allowedMentions}, {@code components}, {@code event}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (Objects.hashCode(embeds_value));
    h += (h << 5) + files.hashCode();
    h += (h << 5) + fileSpoilers.hashCode();
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    h += (h << 5) + event.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InteractionReplyEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InteractionReplyEditMono{"
        + "content=" + (content().toString())
        + ", embeds=" + (Objects.toString(embeds_value))
        + ", files=" + files
        + ", fileSpoilers=" + fileSpoilers
        + ", allowedMentions=" + (allowedMentions().toString())
        + ", components=" + (Objects.toString(components_value))
        + ", event=" + event
        + "}";
  }

  /**
   * Construct a new immutable {@code InteractionReplyEditMono} instance.
   * @param event The value for the {@code event} attribute
   * @return An immutable InteractionReplyEditMono instance
   */
  public static InteractionReplyEditMono of(DeferrableInteractionEvent event) {
    return new InteractionReplyEditMono(event);
  }

  /**
   * Creates an immutable copy of a {@link InteractionReplyEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InteractionReplyEditMono instance
   */
  static InteractionReplyEditMono copyOf(InteractionReplyEditMonoGenerator instance) {
    if (instance instanceof InteractionReplyEditMono) {
      return (InteractionReplyEditMono) instance;
    }
    return InteractionReplyEditMono.of(instance.event())
        .withContent(instance.content())
        .withEmbeds(instance.embeds())
        .withFiles(instance.files())
        .withFileSpoilers(instance.fileSpoilers())
        .withAllowedMentions(instance.allowedMentions())
        .withComponents(instance.components());
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isEmbedsPresent() {
    return !embeds_absent;
  }

  public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
    return !embeds_absent ? embeds_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) java.util.Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
