package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.component.LayoutComponent;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InteractionPresentModalSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code InteractionPresentModalSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code InteractionPresentModalSpec.create()}.
 */
@Generated(from = "InteractionPresentModalSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class InteractionPresentModalSpec
    implements InteractionPresentModalSpecGenerator {
  private final String title_value;
  private final boolean title_absent;
  private final String customId_value;
  private final boolean customId_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;

  private InteractionPresentModalSpec() {
    Possible<String> title$impl = Possible.absent();
    Possible<String> customId$impl = Possible.absent();
    Possible<List<LayoutComponent>> components$impl = Possible.absent();
    this.title_value = title$impl.toOptional().orElse(null);
    this.title_absent = title$impl.isAbsent();
    this.customId_value = customId$impl.toOptional().orElse(null);
    this.customId_absent = customId$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private InteractionPresentModalSpec(
      Possible<String> title,
      Possible<String> customId,
      Possible<List<LayoutComponent>> components) {
    Possible<String> title$impl = title;
    Possible<String> customId$impl = customId;
    Possible<List<LayoutComponent>> components$impl = components;
    this.title_value = title$impl.toOptional().orElse(null);
    this.title_absent = title$impl.isAbsent();
    this.customId_value = customId$impl.toOptional().orElse(null);
    this.customId_absent = customId$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "InteractionPresentModalSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build InteractionPresentModalSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public Possible<String> title() {
    return title_absent ? Possible.absent() : Possible.of(title_value);
  }

  /**
   * @return The value of the {@code customId} attribute
   */
  @Override
  public Possible<String> customId() {
    return customId_absent ? Possible.absent() : Possible.of(customId_value);
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  public InteractionPresentModalSpec withTitle(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new InteractionPresentModalSpec(newValue, this.customId(), this.components()));
  }

  public InteractionPresentModalSpec withTitle(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new InteractionPresentModalSpec(newValue, this.customId(), this.components()));
  }

  public InteractionPresentModalSpec withCustomId(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new InteractionPresentModalSpec(this.title(), newValue, this.components()));
  }

  public InteractionPresentModalSpec withCustomId(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new InteractionPresentModalSpec(this.title(), newValue, this.components()));
  }

  public InteractionPresentModalSpec withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return validate(new InteractionPresentModalSpec(this.title(), this.customId(), newValue));
  }

  public InteractionPresentModalSpec withComponents(Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new InteractionPresentModalSpec(this.title(), this.customId(), newValue));
  }

  @SafeVarargs
  public final InteractionPresentModalSpec withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new InteractionPresentModalSpec(this.title(), this.customId(), newValue));
  }

  /**
   * This instance is equal to all instances of {@code InteractionPresentModalSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InteractionPresentModalSpec
        && equalTo(0, (InteractionPresentModalSpec) another);
  }

  private boolean equalTo(int synthetic, InteractionPresentModalSpec another) {
    return this.title().equals(another.title())
        && this.customId().equals(another.customId())
        && Objects.equals(components_value, another.components_value);
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code customId}, {@code components}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (title().hashCode());
    h += (h << 5) + (customId().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    return h;
  }

  /**
   * Prints the immutable value {@code InteractionPresentModalSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InteractionPresentModalSpec{"
        + "title=" + (title().toString())
        + ", customId=" + (customId().toString())
        + ", components=" + (Objects.toString(components_value))
        + "}";
  }

  private static final InteractionPresentModalSpec INSTANCE = validate(new InteractionPresentModalSpec());

  /**
   * Returns the default immutable singleton value of {@code InteractionPresentModalSpec}
   * @return An immutable instance of InteractionPresentModalSpec
   */
  public static InteractionPresentModalSpec create() {
    return INSTANCE;
  }

  private static InteractionPresentModalSpec validate(InteractionPresentModalSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link InteractionPresentModalSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InteractionPresentModalSpec instance
   */
  static InteractionPresentModalSpec copyOf(InteractionPresentModalSpecGenerator instance) {
    if (instance instanceof InteractionPresentModalSpec) {
      return (InteractionPresentModalSpec) instance;
    }
    return InteractionPresentModalSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isTitlePresent() {
    return !title_absent;
  }

  public String titleOrElse(String defaultValue) {
    return !title_absent ? title_value : defaultValue;
  }

  public boolean isCustomIdPresent() {
    return !customId_absent;
  }

  public String customIdOrElse(String defaultValue) {
    return !customId_absent ? customId_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  /**
   * Creates a builder for {@link InteractionPresentModalSpec InteractionPresentModalSpec}.
   * <pre>
   * InteractionPresentModalSpec.builder()
   *    .title(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link InteractionPresentModalSpec#title() title}
   *    .customId(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link InteractionPresentModalSpec#customId() customId}
   *    .components(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.object.component.LayoutComponent&amp;gt;&amp;gt;) // {@link InteractionPresentModalSpec#components() components}
   *    .build();
   * </pre>
   * @return A new InteractionPresentModalSpec builder
   */
  public static InteractionPresentModalSpec.Builder builder() {
    return new InteractionPresentModalSpec.Builder();
  }

  /**
   * Builds instances of type {@link InteractionPresentModalSpec InteractionPresentModalSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InteractionPresentModalSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<String> title_possible = Possible.absent();
    private Possible<String> customId_possible = Possible.absent();
    private List<LayoutComponent> components_list = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InteractionPresentModalSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InteractionPresentModalSpec instance) {
      return from((InteractionPresentModalSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code InteractionPresentModalSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(InteractionPresentModalSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      title(instance.title());
      customId(instance.customId());
      components(instance.components());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder title(Possible<String> value) {
      this.title_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder title(String value) {
      this.title_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder customId(Possible<String> value) {
      this.customId_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder customId(String value) {
      this.customId_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addComponent(LayoutComponent element) {
      components_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllComponents(List<LayoutComponent> elements) {
      components_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(Possible<List<LayoutComponent>> elements) {
      this.components_list = null;
      elements.toOptional().ifPresent(e -> components_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(List<LayoutComponent> elements) {
      this.components_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(Iterable<LayoutComponent> elements) {
      this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    /**
     * Builds a new {@link InteractionPresentModalSpec InteractionPresentModalSpec}.
     * @return An immutable instance of InteractionPresentModalSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InteractionPresentModalSpec build() {
      return InteractionPresentModalSpec.validate(new InteractionPresentModalSpec(title_build(), customId_build(), components_build()));
    }

    private Possible<String> title_build() {
      return this.title_possible;
    }

    private Possible<String> customId_build() {
      return this.customId_possible;
    }

    private Possible<List<LayoutComponent>> components_build() {
      return this.components_list == null ? Possible.absent() :
          Possible.of(this.components_list);
    }

    private List<LayoutComponent> components_getOrCreate() {
      if (this.components_list == null) {
        this.components_list = new ArrayList<>();
      }
      return this.components_list;
    }
  }
}
