package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.event.domain.interaction.DeferrableInteractionEvent;
import discord4j.core.object.component.LayoutComponent;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InteractionPresentModalMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code InteractionPresentModalMono.of()}.
 */
@Generated(from = "InteractionPresentModalMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class InteractionPresentModalMono
    extends InteractionPresentModalMonoGenerator {
  private final String title_value;
  private final boolean title_absent;
  private final String customId_value;
  private final boolean customId_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;
  private final DeferrableInteractionEvent event;

  private InteractionPresentModalMono(DeferrableInteractionEvent event) {
    this.event = Objects.requireNonNull(event, "event");
    Possible<String> title$impl = Possible.absent();
    Possible<String> customId$impl = Possible.absent();
    Possible<List<LayoutComponent>> components$impl = Possible.absent();
    this.title_value = title$impl.toOptional().orElse(null);
    this.title_absent = title$impl.isAbsent();
    this.customId_value = customId$impl.toOptional().orElse(null);
    this.customId_absent = customId$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private InteractionPresentModalMono(
      Possible<String> title,
      Possible<String> customId,
      Possible<List<LayoutComponent>> components,
      DeferrableInteractionEvent event) {
    Possible<String> title$impl = title;
    Possible<String> customId$impl = customId;
    Possible<List<LayoutComponent>> components$impl = components;
    this.event = event;
    this.title_value = title$impl.toOptional().orElse(null);
    this.title_absent = title$impl.isAbsent();
    this.customId_value = customId$impl.toOptional().orElse(null);
    this.customId_absent = customId$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "InteractionPresentModalMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build InteractionPresentModalMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public Possible<String> title() {
    return title_absent ? Possible.absent() : Possible.of(title_value);
  }

  /**
   * @return The value of the {@code customId} attribute
   */
  @Override
  public Possible<String> customId() {
    return customId_absent ? Possible.absent() : Possible.of(customId_value);
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  /**
   * @return The value of the {@code event} attribute
   */
  @Override
  public DeferrableInteractionEvent event() {
    return event;
  }

  public InteractionPresentModalMono withTitle(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new InteractionPresentModalMono(newValue, this.customId(), this.components(), this.event);
  }

  public InteractionPresentModalMono withTitle(String value) {
    Possible<String> newValue = Possible.of(value);
    return new InteractionPresentModalMono(newValue, this.customId(), this.components(), this.event);
  }

  public InteractionPresentModalMono withCustomId(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new InteractionPresentModalMono(this.title(), newValue, this.components(), this.event);
  }

  public InteractionPresentModalMono withCustomId(String value) {
    Possible<String> newValue = Possible.of(value);
    return new InteractionPresentModalMono(this.title(), newValue, this.components(), this.event);
  }

  public InteractionPresentModalMono withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return new InteractionPresentModalMono(this.title(), this.customId(), newValue, this.event);
  }

  public InteractionPresentModalMono withComponents(Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new InteractionPresentModalMono(this.title(), this.customId(), newValue, this.event);
  }

  @SafeVarargs
  public final InteractionPresentModalMono withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return new InteractionPresentModalMono(this.title(), this.customId(), newValue, this.event);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractionPresentModalMono#event() event} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for event
   * @return A modified copy of the {@code this} object
   */
  public final InteractionPresentModalMono withEvent(DeferrableInteractionEvent value) {
    if (this.event == value) return this;
    DeferrableInteractionEvent newValue = Objects.requireNonNull(value, "event");
    return new InteractionPresentModalMono(this.title(), this.customId(), this.components(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code InteractionPresentModalMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InteractionPresentModalMono
        && equalTo(0, (InteractionPresentModalMono) another);
  }

  private boolean equalTo(int synthetic, InteractionPresentModalMono another) {
    return this.title().equals(another.title())
        && this.customId().equals(another.customId())
        && Objects.equals(components_value, another.components_value)
        && event.equals(another.event);
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code customId}, {@code components}, {@code event}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (title().hashCode());
    h += (h << 5) + (customId().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    h += (h << 5) + event.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InteractionPresentModalMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InteractionPresentModalMono{"
        + "title=" + (title().toString())
        + ", customId=" + (customId().toString())
        + ", components=" + (Objects.toString(components_value))
        + ", event=" + event
        + "}";
  }

  /**
   * Construct a new immutable {@code InteractionPresentModalMono} instance.
   * @param event The value for the {@code event} attribute
   * @return An immutable InteractionPresentModalMono instance
   */
  public static InteractionPresentModalMono of(DeferrableInteractionEvent event) {
    return new InteractionPresentModalMono(event);
  }

  /**
   * Creates an immutable copy of a {@link InteractionPresentModalMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InteractionPresentModalMono instance
   */
  static InteractionPresentModalMono copyOf(InteractionPresentModalMonoGenerator instance) {
    if (instance instanceof InteractionPresentModalMono) {
      return (InteractionPresentModalMono) instance;
    }
    return InteractionPresentModalMono.of(instance.event())
        .withTitle(instance.title())
        .withCustomId(instance.customId())
        .withComponents(instance.components());
  }

  public boolean isTitlePresent() {
    return !title_absent;
  }

  public String titleOrElse(String defaultValue) {
    return !title_absent ? title_value : defaultValue;
  }

  public boolean isCustomIdPresent() {
    return !customId_absent;
  }

  public String customIdOrElse(String defaultValue) {
    return !customId_absent ? customId_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }
}
