package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.event.domain.interaction.ComponentInteractionEvent;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InteractionCallbackSpecDeferEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code InteractionCallbackSpecDeferEditMono.of()}.
 */
@Generated(from = "InteractionCallbackSpecDeferEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class InteractionCallbackSpecDeferEditMono
    extends InteractionCallbackSpecDeferEditMonoGenerator {
  private final Boolean ephemeral_value;
  private final boolean ephemeral_absent;
  private final ComponentInteractionEvent event;

  private InteractionCallbackSpecDeferEditMono(ComponentInteractionEvent event) {
    this.event = Objects.requireNonNull(event, "event");
    Possible<Boolean> ephemeral$impl = Possible.absent();
    this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
    this.ephemeral_absent = ephemeral$impl.isAbsent();
    this.initShim = null;
  }

  private InteractionCallbackSpecDeferEditMono(
      Possible<Boolean> ephemeral,
      ComponentInteractionEvent event) {
    Possible<Boolean> ephemeral$impl = ephemeral;
    this.event = event;
    this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
    this.ephemeral_absent = ephemeral$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "InteractionCallbackSpecDeferEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build InteractionCallbackSpecDeferEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code ephemeral} attribute
   */
  @Override
  public Possible<Boolean> ephemeral() {
    return ephemeral_absent ? Possible.absent() : Possible.of(ephemeral_value);
  }

  /**
   * @return The value of the {@code event} attribute
   */
  @Override
  public ComponentInteractionEvent event() {
    return event;
  }

  public InteractionCallbackSpecDeferEditMono withEphemeral(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new InteractionCallbackSpecDeferEditMono(newValue, this.event);
  }

  public InteractionCallbackSpecDeferEditMono withEphemeral(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new InteractionCallbackSpecDeferEditMono(newValue, this.event);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractionCallbackSpecDeferEditMono#event() event} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for event
   * @return A modified copy of the {@code this} object
   */
  public final InteractionCallbackSpecDeferEditMono withEvent(ComponentInteractionEvent value) {
    if (this.event == value) return this;
    ComponentInteractionEvent newValue = Objects.requireNonNull(value, "event");
    return new InteractionCallbackSpecDeferEditMono(this.ephemeral(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code InteractionCallbackSpecDeferEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InteractionCallbackSpecDeferEditMono
        && equalTo(0, (InteractionCallbackSpecDeferEditMono) another);
  }

  private boolean equalTo(int synthetic, InteractionCallbackSpecDeferEditMono another) {
    return this.ephemeral().equals(another.ephemeral())
        && event.equals(another.event);
  }

  /**
   * Computes a hash code from attributes: {@code ephemeral}, {@code event}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (ephemeral().hashCode());
    h += (h << 5) + event.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InteractionCallbackSpecDeferEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InteractionCallbackSpecDeferEditMono{"
        + "ephemeral=" + (ephemeral().toString())
        + ", event=" + event
        + "}";
  }

  /**
   * Construct a new immutable {@code InteractionCallbackSpecDeferEditMono} instance.
   * @param event The value for the {@code event} attribute
   * @return An immutable InteractionCallbackSpecDeferEditMono instance
   */
  public static InteractionCallbackSpecDeferEditMono of(ComponentInteractionEvent event) {
    return new InteractionCallbackSpecDeferEditMono(event);
  }

  /**
   * Creates an immutable copy of a {@link InteractionCallbackSpecDeferEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InteractionCallbackSpecDeferEditMono instance
   */
  static InteractionCallbackSpecDeferEditMono copyOf(InteractionCallbackSpecDeferEditMonoGenerator instance) {
    if (instance instanceof InteractionCallbackSpecDeferEditMono) {
      return (InteractionCallbackSpecDeferEditMono) instance;
    }
    return InteractionCallbackSpecDeferEditMono.of(instance.event())
        .withEphemeral(instance.ephemeral());
  }

  public boolean isEphemeralPresent() {
    return !ephemeral_absent;
  }

  public Boolean ephemeralOrElse(Boolean defaultValue) {
    return !ephemeral_absent ? ephemeral_value : defaultValue;
  }
}
