package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InteractionCallbackSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code InteractionCallbackSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code InteractionCallbackSpec.create()}.
 */
@Generated(from = "InteractionCallbackSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class InteractionCallbackSpec implements InteractionCallbackSpecGenerator {
  private final Boolean ephemeral_value;
  private final boolean ephemeral_absent;

  private InteractionCallbackSpec() {
    Possible<Boolean> ephemeral$impl = Possible.absent();
    this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
    this.ephemeral_absent = ephemeral$impl.isAbsent();
    this.initShim = null;
  }

  private InteractionCallbackSpec(Possible<Boolean> ephemeral) {
    Possible<Boolean> ephemeral$impl = ephemeral;
    this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
    this.ephemeral_absent = ephemeral$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "InteractionCallbackSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build InteractionCallbackSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code ephemeral} attribute
   */
  @Override
  public Possible<Boolean> ephemeral() {
    return ephemeral_absent ? Possible.absent() : Possible.of(ephemeral_value);
  }

  public InteractionCallbackSpec withEphemeral(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return validate(new InteractionCallbackSpec(newValue));
  }

  public InteractionCallbackSpec withEphemeral(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return validate(new InteractionCallbackSpec(newValue));
  }

  /**
   * This instance is equal to all instances of {@code InteractionCallbackSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InteractionCallbackSpec
        && equalTo(0, (InteractionCallbackSpec) another);
  }

  private boolean equalTo(int synthetic, InteractionCallbackSpec another) {
    return this.ephemeral().equals(another.ephemeral());
  }

  /**
   * Computes a hash code from attributes: {@code ephemeral}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (ephemeral().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code InteractionCallbackSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InteractionCallbackSpec{"
        + "ephemeral=" + (ephemeral().toString())
        + "}";
  }

  private static final InteractionCallbackSpec INSTANCE = validate(new InteractionCallbackSpec());

  /**
   * Returns the default immutable singleton value of {@code InteractionCallbackSpec}
   * @return An immutable instance of InteractionCallbackSpec
   */
  public static InteractionCallbackSpec create() {
    return INSTANCE;
  }

  private static InteractionCallbackSpec validate(InteractionCallbackSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link InteractionCallbackSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InteractionCallbackSpec instance
   */
  static InteractionCallbackSpec copyOf(InteractionCallbackSpecGenerator instance) {
    if (instance instanceof InteractionCallbackSpec) {
      return (InteractionCallbackSpec) instance;
    }
    return InteractionCallbackSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isEphemeralPresent() {
    return !ephemeral_absent;
  }

  public Boolean ephemeralOrElse(Boolean defaultValue) {
    return !ephemeral_absent ? ephemeral_value : defaultValue;
  }

  /**
   * Creates a builder for {@link InteractionCallbackSpec InteractionCallbackSpec}.
   * <pre>
   * InteractionCallbackSpec.builder()
   *    .ephemeral(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link InteractionCallbackSpec#ephemeral() ephemeral}
   *    .build();
   * </pre>
   * @return A new InteractionCallbackSpec builder
   */
  public static InteractionCallbackSpec.Builder builder() {
    return new InteractionCallbackSpec.Builder();
  }

  /**
   * Builds instances of type {@link InteractionCallbackSpec InteractionCallbackSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InteractionCallbackSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<Boolean> ephemeral_possible = Possible.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InteractionCallbackSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InteractionCallbackSpec instance) {
      return from((InteractionCallbackSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code InteractionCallbackSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(InteractionCallbackSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      ephemeral(instance.ephemeral());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder ephemeral(Possible<Boolean> value) {
      this.ephemeral_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder ephemeral(Boolean value) {
      this.ephemeral_possible = Possible.of(value);
      return this;
    }

    /**
     * Builds a new {@link InteractionCallbackSpec InteractionCallbackSpec}.
     * @return An immutable instance of InteractionCallbackSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InteractionCallbackSpec build() {
      return InteractionCallbackSpec.validate(new InteractionCallbackSpec(ephemeral_build()));
    }

    private Possible<Boolean> ephemeral_build() {
      return this.ephemeral_possible;
    }
  }
}
