package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.component.LayoutComponent;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InteractionApplicationCommandCallbackSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code InteractionApplicationCommandCallbackSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code InteractionApplicationCommandCallbackSpec.create()}.
 */
@Generated(from = "InteractionApplicationCommandCallbackSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class InteractionApplicationCommandCallbackSpec
    implements InteractionApplicationCommandCallbackSpecGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final Boolean tts_value;
  private final boolean tts_absent;
  private final Boolean ephemeral_value;
  private final boolean ephemeral_absent;
  private final List<EmbedCreateSpec> embeds_value;
  private final boolean embeds_absent;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;

  private InteractionApplicationCommandCallbackSpec() {
    Possible<String> content$impl = Possible.absent();
    Possible<Boolean> tts$impl = Possible.absent();
    Possible<Boolean> ephemeral$impl = Possible.absent();
    Possible<List<EmbedCreateSpec>> embeds$impl = Possible.absent();
    Possible<AllowedMentions> allowedMentions$impl = Possible.absent();
    Possible<List<LayoutComponent>> components$impl = Possible.absent();
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
    this.ephemeral_absent = ephemeral$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private InteractionApplicationCommandCallbackSpec(
      Possible<String> content,
      Possible<Boolean> tts,
      Possible<Boolean> ephemeral,
      Possible<List<EmbedCreateSpec>> embeds,
      Possible<AllowedMentions> allowedMentions,
      Possible<List<LayoutComponent>> components) {
    Possible<String> content$impl = content;
    Possible<Boolean> tts$impl = tts;
    Possible<Boolean> ephemeral$impl = ephemeral;
    Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
    Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
    Possible<List<LayoutComponent>> components$impl = components;
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
    this.ephemeral_absent = ephemeral$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "InteractionApplicationCommandCallbackSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build InteractionApplicationCommandCallbackSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public Possible<String> content() {
    return content_absent ? Possible.absent() : Possible.of(content_value);
  }

  /**
   * @return The value of the {@code tts} attribute
   */
  @Override
  public Possible<Boolean> tts() {
    return tts_absent ? Possible.absent() : Possible.of(tts_value);
  }

  /**
   * @return The value of the {@code ephemeral} attribute
   */
  @Override
  public Possible<Boolean> ephemeral() {
    return ephemeral_absent ? Possible.absent() : Possible.of(ephemeral_value);
  }

  /**
   * @return The value of the {@code embeds} attribute
   */
  @Override
  public Possible<List<EmbedCreateSpec>> embeds() {
    return embeds_absent ? Possible.absent() :
        Possible.of(embeds_value);
  }

  /**
   * @return The value of the {@code allowedMentions} attribute
   */
  @Override
  public Possible<AllowedMentions> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() : Possible.of(allowedMentions_value);
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  public InteractionApplicationCommandCallbackSpec withContent(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new InteractionApplicationCommandCallbackSpec(
        newValue,
        this.tts(),
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        this.components()));
  }

  public InteractionApplicationCommandCallbackSpec withContent(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new InteractionApplicationCommandCallbackSpec(
        newValue,
        this.tts(),
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        this.components()));
  }

  public InteractionApplicationCommandCallbackSpec withTts(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return validate(new InteractionApplicationCommandCallbackSpec(
        this.content(),
        newValue,
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        this.components()));
  }

  public InteractionApplicationCommandCallbackSpec withTts(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return validate(new InteractionApplicationCommandCallbackSpec(
        this.content(),
        newValue,
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        this.components()));
  }

  public InteractionApplicationCommandCallbackSpec withEphemeral(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), newValue, this.embeds(), this.allowedMentions(), this.components()));
  }

  public InteractionApplicationCommandCallbackSpec withEphemeral(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), newValue, this.embeds(), this.allowedMentions(), this.components()));
  }

  public InteractionApplicationCommandCallbackSpec withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
    Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
    return validate(new InteractionApplicationCommandCallbackSpec(
        this.content(),
        this.tts(),
        this.ephemeral(),
        newValue,
        this.allowedMentions(),
        this.components()));
  }

  public InteractionApplicationCommandCallbackSpec withEmbeds(Iterable<EmbedCreateSpec> elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new InteractionApplicationCommandCallbackSpec(
        this.content(),
        this.tts(),
        this.ephemeral(),
        newValue,
        this.allowedMentions(),
        this.components()));
  }

  @SafeVarargs
  public final InteractionApplicationCommandCallbackSpec withEmbeds(EmbedCreateSpec... elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new InteractionApplicationCommandCallbackSpec(
        this.content(),
        this.tts(),
        this.ephemeral(),
        newValue,
        this.allowedMentions(),
        this.components()));
  }

  public InteractionApplicationCommandCallbackSpec withAllowedMentions(Possible<AllowedMentions> value) {
    Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
    return validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), newValue, this.components()));
  }

  public InteractionApplicationCommandCallbackSpec withAllowedMentions(AllowedMentions value) {
    Possible<AllowedMentions> newValue = Possible.of(value);
    return validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), newValue, this.components()));
  }

  public InteractionApplicationCommandCallbackSpec withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.allowedMentions(), newValue));
  }

  public InteractionApplicationCommandCallbackSpec withComponents(Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.allowedMentions(), newValue));
  }

  @SafeVarargs
  public final InteractionApplicationCommandCallbackSpec withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.allowedMentions(), newValue));
  }

  /**
   * This instance is equal to all instances of {@code InteractionApplicationCommandCallbackSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InteractionApplicationCommandCallbackSpec
        && equalTo(0, (InteractionApplicationCommandCallbackSpec) another);
  }

  private boolean equalTo(int synthetic, InteractionApplicationCommandCallbackSpec another) {
    return this.content().equals(another.content())
        && this.tts().equals(another.tts())
        && this.ephemeral().equals(another.ephemeral())
        && Objects.equals(embeds_value, another.embeds_value)
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code tts}, {@code ephemeral}, {@code embeds}, {@code allowedMentions}, {@code components}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (tts().hashCode());
    h += (h << 5) + (ephemeral().hashCode());
    h += (h << 5) + (Objects.hashCode(embeds_value));
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    return h;
  }

  /**
   * Prints the immutable value {@code InteractionApplicationCommandCallbackSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InteractionApplicationCommandCallbackSpec{"
        + "content=" + (content().toString())
        + ", tts=" + (tts().toString())
        + ", ephemeral=" + (ephemeral().toString())
        + ", embeds=" + (Objects.toString(embeds_value))
        + ", allowedMentions=" + (allowedMentions().toString())
        + ", components=" + (Objects.toString(components_value))
        + "}";
  }

  private static final InteractionApplicationCommandCallbackSpec INSTANCE = validate(new InteractionApplicationCommandCallbackSpec());

  /**
   * Returns the default immutable singleton value of {@code InteractionApplicationCommandCallbackSpec}
   * @return An immutable instance of InteractionApplicationCommandCallbackSpec
   */
  public static InteractionApplicationCommandCallbackSpec create() {
    return INSTANCE;
  }

  private static InteractionApplicationCommandCallbackSpec validate(InteractionApplicationCommandCallbackSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link InteractionApplicationCommandCallbackSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InteractionApplicationCommandCallbackSpec instance
   */
  static InteractionApplicationCommandCallbackSpec copyOf(InteractionApplicationCommandCallbackSpecGenerator instance) {
    if (instance instanceof InteractionApplicationCommandCallbackSpec) {
      return (InteractionApplicationCommandCallbackSpec) instance;
    }
    return InteractionApplicationCommandCallbackSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isTtsPresent() {
    return !tts_absent;
  }

  public Boolean ttsOrElse(Boolean defaultValue) {
    return !tts_absent ? tts_value : defaultValue;
  }

  public boolean isEphemeralPresent() {
    return !ephemeral_absent;
  }

  public Boolean ephemeralOrElse(Boolean defaultValue) {
    return !ephemeral_absent ? ephemeral_value : defaultValue;
  }

  public boolean isEmbedsPresent() {
    return !embeds_absent;
  }

  public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
    return !embeds_absent ? embeds_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  /**
   * Creates a builder for {@link InteractionApplicationCommandCallbackSpec InteractionApplicationCommandCallbackSpec}.
   * <pre>
   * InteractionApplicationCommandCallbackSpec.builder()
   *    .content(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link InteractionApplicationCommandCallbackSpec#content() content}
   *    .tts(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link InteractionApplicationCommandCallbackSpec#tts() tts}
   *    .ephemeral(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link InteractionApplicationCommandCallbackSpec#ephemeral() ephemeral}
   *    .embeds(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;EmbedCreateSpec&amp;gt;&amp;gt;) // {@link InteractionApplicationCommandCallbackSpec#embeds() embeds}
   *    .allowedMentions(discord4j.discordjson.possible.Possible&amp;lt;discord4j.rest.util.AllowedMentions&amp;gt;) // {@link InteractionApplicationCommandCallbackSpec#allowedMentions() allowedMentions}
   *    .components(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.object.component.LayoutComponent&amp;gt;&amp;gt;) // {@link InteractionApplicationCommandCallbackSpec#components() components}
   *    .build();
   * </pre>
   * @return A new InteractionApplicationCommandCallbackSpec builder
   */
  public static InteractionApplicationCommandCallbackSpec.Builder builder() {
    return new InteractionApplicationCommandCallbackSpec.Builder();
  }

  /**
   * Builds instances of type {@link InteractionApplicationCommandCallbackSpec InteractionApplicationCommandCallbackSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InteractionApplicationCommandCallbackSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<String> content_possible = Possible.absent();
    private Possible<Boolean> tts_possible = Possible.absent();
    private Possible<Boolean> ephemeral_possible = Possible.absent();
    private List<EmbedCreateSpec> embeds_list = null;
    private Possible<AllowedMentions> allowedMentions_possible = Possible.absent();
    private List<LayoutComponent> components_list = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InteractionApplicationCommandCallbackSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InteractionApplicationCommandCallbackSpec instance) {
      return from((InteractionApplicationCommandCallbackSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code InteractionApplicationCommandCallbackSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(InteractionApplicationCommandCallbackSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      content(instance.content());
      tts(instance.tts());
      ephemeral(instance.ephemeral());
      embeds(instance.embeds());
      allowedMentions(instance.allowedMentions());
      components(instance.components());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder content(Possible<String> value) {
      this.content_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder content(String value) {
      this.content_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder tts(Possible<Boolean> value) {
      this.tts_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder tts(Boolean value) {
      this.tts_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder ephemeral(Possible<Boolean> value) {
      this.ephemeral_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder ephemeral(Boolean value) {
      this.ephemeral_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addEmbed(EmbedCreateSpec element) {
      embeds_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
      embeds_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(Possible<List<EmbedCreateSpec>> elements) {
      this.embeds_list = null;
      elements.toOptional().ifPresent(e -> embeds_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(List<EmbedCreateSpec> elements) {
      this.embeds_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder embeds(Iterable<EmbedCreateSpec> elements) {
      this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentions(Possible<AllowedMentions> value) {
      this.allowedMentions_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentions(AllowedMentions value) {
      this.allowedMentions_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addComponent(LayoutComponent element) {
      components_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllComponents(List<LayoutComponent> elements) {
      components_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(Possible<List<LayoutComponent>> elements) {
      this.components_list = null;
      elements.toOptional().ifPresent(e -> components_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(List<LayoutComponent> elements) {
      this.components_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(Iterable<LayoutComponent> elements) {
      this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    /**
     * Builds a new {@link InteractionApplicationCommandCallbackSpec InteractionApplicationCommandCallbackSpec}.
     * @return An immutable instance of InteractionApplicationCommandCallbackSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InteractionApplicationCommandCallbackSpec build() {
      return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(
          content_build(),
          tts_build(),
          ephemeral_build(),
          embeds_build(),
          allowedMentions_build(),
          components_build()));
    }

    private Possible<String> content_build() {
      return this.content_possible;
    }

    private Possible<Boolean> tts_build() {
      return this.tts_possible;
    }

    private Possible<Boolean> ephemeral_build() {
      return this.ephemeral_possible;
    }

    private Possible<List<EmbedCreateSpec>> embeds_build() {
      return this.embeds_list == null ? Possible.absent() :
          Possible.of(this.embeds_list);
    }

    private List<EmbedCreateSpec> embeds_getOrCreate() {
      if (this.embeds_list == null) {
        this.embeds_list = new ArrayList<>();
      }
      return this.embeds_list;
    }

    private Possible<AllowedMentions> allowedMentions_build() {
      return this.allowedMentions_possible;
    }

    private Possible<List<LayoutComponent>> components_build() {
      return this.components_list == null ? Possible.absent() :
          Possible.of(this.components_list);
    }

    private List<LayoutComponent> components_getOrCreate() {
      if (this.components_list == null) {
        this.components_list = new ArrayList<>();
      }
      return this.components_list;
    }
  }
}
