package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.event.domain.interaction.ComponentInteractionEvent;
import discord4j.core.object.component.LayoutComponent;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InteractionApplicationCommandCallbackEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code InteractionApplicationCommandCallbackEditMono.of()}.
 */
@Generated(from = "InteractionApplicationCommandCallbackEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class InteractionApplicationCommandCallbackEditMono
    extends InteractionApplicationCommandCallbackEditMonoGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final Boolean tts_value;
  private final boolean tts_absent;
  private final Boolean ephemeral_value;
  private final boolean ephemeral_absent;
  private final List<EmbedCreateSpec> embeds_value;
  private final boolean embeds_absent;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;
  private final ComponentInteractionEvent event;

  private InteractionApplicationCommandCallbackEditMono(ComponentInteractionEvent event) {
    this.event = Objects.requireNonNull(event, "event");
    Possible<String> content$impl = Possible.absent();
    Possible<Boolean> tts$impl = Possible.absent();
    Possible<Boolean> ephemeral$impl = Possible.absent();
    Possible<List<EmbedCreateSpec>> embeds$impl = Possible.absent();
    Possible<AllowedMentions> allowedMentions$impl = Possible.absent();
    Possible<List<LayoutComponent>> components$impl = Possible.absent();
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
    this.ephemeral_absent = ephemeral$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private InteractionApplicationCommandCallbackEditMono(
      Possible<String> content,
      Possible<Boolean> tts,
      Possible<Boolean> ephemeral,
      Possible<List<EmbedCreateSpec>> embeds,
      Possible<AllowedMentions> allowedMentions,
      Possible<List<LayoutComponent>> components,
      ComponentInteractionEvent event) {
    Possible<String> content$impl = content;
    Possible<Boolean> tts$impl = tts;
    Possible<Boolean> ephemeral$impl = ephemeral;
    Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
    Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
    Possible<List<LayoutComponent>> components$impl = components;
    this.event = event;
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.tts_value = tts$impl.toOptional().orElse(null);
    this.tts_absent = tts$impl.isAbsent();
    this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
    this.ephemeral_absent = ephemeral$impl.isAbsent();
    this.embeds_value = embeds$impl.toOptional().orElse(null);
    this.embeds_absent = embeds$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "InteractionApplicationCommandCallbackEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build InteractionApplicationCommandCallbackEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public Possible<String> content() {
    return content_absent ? Possible.absent() : Possible.of(content_value);
  }

  /**
   * @return The value of the {@code tts} attribute
   */
  @Override
  public Possible<Boolean> tts() {
    return tts_absent ? Possible.absent() : Possible.of(tts_value);
  }

  /**
   * @return The value of the {@code ephemeral} attribute
   */
  @Override
  public Possible<Boolean> ephemeral() {
    return ephemeral_absent ? Possible.absent() : Possible.of(ephemeral_value);
  }

  /**
   * @return The value of the {@code embeds} attribute
   */
  @Override
  public Possible<List<EmbedCreateSpec>> embeds() {
    return embeds_absent ? Possible.absent() :
        Possible.of(embeds_value);
  }

  /**
   * @return The value of the {@code allowedMentions} attribute
   */
  @Override
  public Possible<AllowedMentions> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() : Possible.of(allowedMentions_value);
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  /**
   * @return The value of the {@code event} attribute
   */
  @Override
  public ComponentInteractionEvent event() {
    return event;
  }

  public InteractionApplicationCommandCallbackEditMono withContent(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new InteractionApplicationCommandCallbackEditMono(
        newValue,
        this.tts(),
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionApplicationCommandCallbackEditMono withContent(String value) {
    Possible<String> newValue = Possible.of(value);
    return new InteractionApplicationCommandCallbackEditMono(
        newValue,
        this.tts(),
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionApplicationCommandCallbackEditMono withTts(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        newValue,
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionApplicationCommandCallbackEditMono withTts(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        newValue,
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionApplicationCommandCallbackEditMono withEphemeral(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        this.tts(),
        newValue,
        this.embeds(),
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionApplicationCommandCallbackEditMono withEphemeral(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        this.tts(),
        newValue,
        this.embeds(),
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionApplicationCommandCallbackEditMono withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
    Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        this.tts(),
        this.ephemeral(),
        newValue,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionApplicationCommandCallbackEditMono withEmbeds(Iterable<EmbedCreateSpec> elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        this.tts(),
        this.ephemeral(),
        newValue,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  @SafeVarargs
  public final InteractionApplicationCommandCallbackEditMono withEmbeds(EmbedCreateSpec... elements) {
    Possible<List<EmbedCreateSpec>> newValue = Possible.of(Arrays.asList(elements));
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        this.tts(),
        this.ephemeral(),
        newValue,
        this.allowedMentions(),
        this.components(),
        this.event);
  }

  public InteractionApplicationCommandCallbackEditMono withAllowedMentions(Possible<AllowedMentions> value) {
    Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        this.tts(),
        this.ephemeral(),
        this.embeds(),
        newValue,
        this.components(),
        this.event);
  }

  public InteractionApplicationCommandCallbackEditMono withAllowedMentions(AllowedMentions value) {
    Possible<AllowedMentions> newValue = Possible.of(value);
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        this.tts(),
        this.ephemeral(),
        this.embeds(),
        newValue,
        this.components(),
        this.event);
  }

  public InteractionApplicationCommandCallbackEditMono withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        this.tts(),
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        newValue,
        this.event);
  }

  public InteractionApplicationCommandCallbackEditMono withComponents(Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        this.tts(),
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        newValue,
        this.event);
  }

  @SafeVarargs
  public final InteractionApplicationCommandCallbackEditMono withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        this.tts(),
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        newValue,
        this.event);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InteractionApplicationCommandCallbackEditMono#event() event} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for event
   * @return A modified copy of the {@code this} object
   */
  public final InteractionApplicationCommandCallbackEditMono withEvent(ComponentInteractionEvent value) {
    if (this.event == value) return this;
    ComponentInteractionEvent newValue = Objects.requireNonNull(value, "event");
    return new InteractionApplicationCommandCallbackEditMono(
        this.content(),
        this.tts(),
        this.ephemeral(),
        this.embeds(),
        this.allowedMentions(),
        this.components(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code InteractionApplicationCommandCallbackEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InteractionApplicationCommandCallbackEditMono
        && equalTo(0, (InteractionApplicationCommandCallbackEditMono) another);
  }

  private boolean equalTo(int synthetic, InteractionApplicationCommandCallbackEditMono another) {
    return this.content().equals(another.content())
        && this.tts().equals(another.tts())
        && this.ephemeral().equals(another.ephemeral())
        && Objects.equals(embeds_value, another.embeds_value)
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value)
        && event.equals(another.event);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code tts}, {@code ephemeral}, {@code embeds}, {@code allowedMentions}, {@code components}, {@code event}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (tts().hashCode());
    h += (h << 5) + (ephemeral().hashCode());
    h += (h << 5) + (Objects.hashCode(embeds_value));
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    h += (h << 5) + event.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InteractionApplicationCommandCallbackEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InteractionApplicationCommandCallbackEditMono{"
        + "content=" + (content().toString())
        + ", tts=" + (tts().toString())
        + ", ephemeral=" + (ephemeral().toString())
        + ", embeds=" + (Objects.toString(embeds_value))
        + ", allowedMentions=" + (allowedMentions().toString())
        + ", components=" + (Objects.toString(components_value))
        + ", event=" + event
        + "}";
  }

  /**
   * Construct a new immutable {@code InteractionApplicationCommandCallbackEditMono} instance.
   * @param event The value for the {@code event} attribute
   * @return An immutable InteractionApplicationCommandCallbackEditMono instance
   */
  public static InteractionApplicationCommandCallbackEditMono of(ComponentInteractionEvent event) {
    return new InteractionApplicationCommandCallbackEditMono(event);
  }

  /**
   * Creates an immutable copy of a {@link InteractionApplicationCommandCallbackEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InteractionApplicationCommandCallbackEditMono instance
   */
  static InteractionApplicationCommandCallbackEditMono copyOf(InteractionApplicationCommandCallbackEditMonoGenerator instance) {
    if (instance instanceof InteractionApplicationCommandCallbackEditMono) {
      return (InteractionApplicationCommandCallbackEditMono) instance;
    }
    return InteractionApplicationCommandCallbackEditMono.of(instance.event())
        .withContent(instance.content())
        .withTts(instance.tts())
        .withEphemeral(instance.ephemeral())
        .withEmbeds(instance.embeds())
        .withAllowedMentions(instance.allowedMentions())
        .withComponents(instance.components());
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isTtsPresent() {
    return !tts_absent;
  }

  public Boolean ttsOrElse(Boolean defaultValue) {
    return !tts_absent ? tts_value : defaultValue;
  }

  public boolean isEphemeralPresent() {
    return !ephemeral_absent;
  }

  public Boolean ephemeralOrElse(Boolean defaultValue) {
    return !ephemeral_absent ? ephemeral_value : defaultValue;
  }

  public boolean isEmbedsPresent() {
    return !embeds_absent;
  }

  public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
    return !embeds_absent ? embeds_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }
}
