package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * {@code ImmutableMessageCreateFields} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link MessageCreateFields}.
 * @see ImmutableMessageCreateFields.File
 * @see ImmutableMessageCreateFields.FileSpoiler
 */
@Generated(from = "MessageCreateFields", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableMessageCreateFields {
  private ImmutableMessageCreateFields() {}

  /**
   * Immutable implementation of {@link MessageCreateFields.File}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableMessageCreateFields.File.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableMessageCreateFields.File.of()}.
   */
  @Generated(from = "MessageCreateFields.File", generator = "Immutables")
  static final class File implements MessageCreateFields.File {
    private final String name;
    private final InputStream inputStream;

    private File(String name, InputStream inputStream) {
      this.name = Objects.requireNonNull(name, "name");
      this.inputStream = Objects.requireNonNull(inputStream, "inputStream");
    }

    private File(
        ImmutableMessageCreateFields.File original,
        String name,
        InputStream inputStream) {
      this.name = name;
      this.inputStream = inputStream;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    public String name() {
      return name;
    }

    /**
     * @return The value of the {@code inputStream} attribute
     */
    @Override
    public InputStream inputStream() {
      return inputStream;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link MessageCreateFields.File#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableMessageCreateFields.File withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableMessageCreateFields.File(this, newValue, this.inputStream);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link MessageCreateFields.File#inputStream() inputStream} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for inputStream
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableMessageCreateFields.File withInputStream(InputStream value) {
      if (this.inputStream == value) return this;
      InputStream newValue = Objects.requireNonNull(value, "inputStream");
      return new ImmutableMessageCreateFields.File(this, this.name, newValue);
    }

    /**
     * This instance is equal to all instances of {@code File} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableMessageCreateFields.File
          && equalTo(0, (ImmutableMessageCreateFields.File) another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageCreateFields.File another) {
      return name.equals(another.name)
          && inputStream.equals(another.inputStream);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code inputStream}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + inputStream.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code File} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "File{"
          + "name=" + name
          + ", inputStream=" + inputStream
          + "}";
    }

    /**
     * Construct a new immutable {@code File} instance.
     * @param name The value for the {@code name} attribute
     * @param inputStream The value for the {@code inputStream} attribute
     * @return An immutable File instance
     */
    public static ImmutableMessageCreateFields.File of(String name, InputStream inputStream) {
      return new ImmutableMessageCreateFields.File(name, inputStream);
    }

    /**
     * Creates an immutable copy of a {@link MessageCreateFields.File} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable File instance
     */
    public static ImmutableMessageCreateFields.File copyOf(MessageCreateFields.File instance) {
      if (instance instanceof ImmutableMessageCreateFields.File) {
        return (ImmutableMessageCreateFields.File) instance;
      }
      return ImmutableMessageCreateFields.File.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableMessageCreateFields.File File}.
     * <pre>
     * ImmutableMessageCreateFields.File.builder()
     *    .name(String) // required {@link MessageCreateFields.File#name() name}
     *    .inputStream(java.io.InputStream) // required {@link MessageCreateFields.File#inputStream() inputStream}
     *    .build();
     * </pre>
     * @return A new File builder
     */
    public static ImmutableMessageCreateFields.File.Builder builder() {
      return new ImmutableMessageCreateFields.File.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableMessageCreateFields.File File}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "MessageCreateFields.File", generator = "Immutables")
    public static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private static final long INIT_BIT_INPUT_STREAM = 0x2L;
      private long initBits = 0x3L;

      private String name;
      private InputStream inputStream;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code File} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(MessageCreateFields.File instance) {
        Objects.requireNonNull(instance, "instance");
        name(instance.name());
        inputStream(instance.inputStream());
        return this;
      }

      /**
       * Initializes the value for the {@link MessageCreateFields.File#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Initializes the value for the {@link MessageCreateFields.File#inputStream() inputStream} attribute.
       * @param inputStream The value for inputStream 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder inputStream(InputStream inputStream) {
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream");
        initBits &= ~INIT_BIT_INPUT_STREAM;
        return this;
      }

      /**
       * Builds a new {@link ImmutableMessageCreateFields.File File}.
       * @return An immutable instance of File
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableMessageCreateFields.File build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableMessageCreateFields.File(null, name, inputStream);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        if ((initBits & INIT_BIT_INPUT_STREAM) != 0) attributes.add("inputStream");
        return "Cannot build File, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link MessageCreateFields.FileSpoiler}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableMessageCreateFields.FileSpoiler.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableMessageCreateFields.FileSpoiler.of()}.
   */
  @Generated(from = "MessageCreateFields.FileSpoiler", generator = "Immutables")
  static final class FileSpoiler implements MessageCreateFields.FileSpoiler {
    private final String name;
    private final InputStream inputStream;

    private FileSpoiler(String name, InputStream inputStream) {
      this.name = Objects.requireNonNull(name, "name");
      this.inputStream = Objects.requireNonNull(inputStream, "inputStream");
    }

    private FileSpoiler(
        ImmutableMessageCreateFields.FileSpoiler original,
        String name,
        InputStream inputStream) {
      this.name = name;
      this.inputStream = inputStream;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    public String name() {
      return name;
    }

    /**
     * @return The value of the {@code inputStream} attribute
     */
    @Override
    public InputStream inputStream() {
      return inputStream;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link MessageCreateFields.FileSpoiler#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableMessageCreateFields.FileSpoiler withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableMessageCreateFields.FileSpoiler(this, newValue, this.inputStream);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link MessageCreateFields.FileSpoiler#inputStream() inputStream} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for inputStream
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableMessageCreateFields.FileSpoiler withInputStream(InputStream value) {
      if (this.inputStream == value) return this;
      InputStream newValue = Objects.requireNonNull(value, "inputStream");
      return new ImmutableMessageCreateFields.FileSpoiler(this, this.name, newValue);
    }

    /**
     * This instance is equal to all instances of {@code FileSpoiler} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableMessageCreateFields.FileSpoiler
          && equalTo(0, (ImmutableMessageCreateFields.FileSpoiler) another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageCreateFields.FileSpoiler another) {
      return name.equals(another.name)
          && inputStream.equals(another.inputStream);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code inputStream}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + inputStream.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code FileSpoiler} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "FileSpoiler{"
          + "name=" + name
          + ", inputStream=" + inputStream
          + "}";
    }

    /**
     * Construct a new immutable {@code FileSpoiler} instance.
     * @param name The value for the {@code name} attribute
     * @param inputStream The value for the {@code inputStream} attribute
     * @return An immutable FileSpoiler instance
     */
    public static ImmutableMessageCreateFields.FileSpoiler of(String name, InputStream inputStream) {
      return new ImmutableMessageCreateFields.FileSpoiler(name, inputStream);
    }

    /**
     * Creates an immutable copy of a {@link MessageCreateFields.FileSpoiler} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable FileSpoiler instance
     */
    public static ImmutableMessageCreateFields.FileSpoiler copyOf(MessageCreateFields.FileSpoiler instance) {
      if (instance instanceof ImmutableMessageCreateFields.FileSpoiler) {
        return (ImmutableMessageCreateFields.FileSpoiler) instance;
      }
      return ImmutableMessageCreateFields.FileSpoiler.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableMessageCreateFields.FileSpoiler FileSpoiler}.
     * <pre>
     * ImmutableMessageCreateFields.FileSpoiler.builder()
     *    .name(String) // required {@link MessageCreateFields.FileSpoiler#name() name}
     *    .inputStream(java.io.InputStream) // required {@link MessageCreateFields.FileSpoiler#inputStream() inputStream}
     *    .build();
     * </pre>
     * @return A new FileSpoiler builder
     */
    public static ImmutableMessageCreateFields.FileSpoiler.Builder builder() {
      return new ImmutableMessageCreateFields.FileSpoiler.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableMessageCreateFields.FileSpoiler FileSpoiler}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "MessageCreateFields.FileSpoiler", generator = "Immutables")
    public static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private static final long INIT_BIT_INPUT_STREAM = 0x2L;
      private long initBits = 0x3L;

      private String name;
      private InputStream inputStream;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code discord4j.core.spec.MessageCreateFields.File} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(MessageCreateFields.File instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code discord4j.core.spec.MessageCreateFields.FileSpoiler} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(MessageCreateFields.FileSpoiler instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        @Var long bits = 0;
        if (object instanceof MessageCreateFields.File) {
          MessageCreateFields.File instance = (MessageCreateFields.File) object;
          if ((bits & 0x1L) == 0) {
            name(instance.name());
            bits |= 0x1L;
          }
          if ((bits & 0x2L) == 0) {
            inputStream(instance.inputStream());
            bits |= 0x2L;
          }
        }
        if (object instanceof MessageCreateFields.FileSpoiler) {
          MessageCreateFields.FileSpoiler instance = (MessageCreateFields.FileSpoiler) object;
          if ((bits & 0x1L) == 0) {
            name(instance.name());
            bits |= 0x1L;
          }
          if ((bits & 0x2L) == 0) {
            inputStream(instance.inputStream());
            bits |= 0x2L;
          }
        }
      }

      /**
       * Initializes the value for the {@link MessageCreateFields.FileSpoiler#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Initializes the value for the {@link MessageCreateFields.FileSpoiler#inputStream() inputStream} attribute.
       * @param inputStream The value for inputStream 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder inputStream(InputStream inputStream) {
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream");
        initBits &= ~INIT_BIT_INPUT_STREAM;
        return this;
      }

      /**
       * Builds a new {@link ImmutableMessageCreateFields.FileSpoiler FileSpoiler}.
       * @return An immutable instance of FileSpoiler
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableMessageCreateFields.FileSpoiler build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableMessageCreateFields.FileSpoiler(null, name, inputStream);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        if ((initBits & INIT_BIT_INPUT_STREAM) != 0) attributes.add("inputStream");
        return "Cannot build FileSpoiler, some of required attributes are not set " + attributes;
      }
    }
  }
}
