package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.entity.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * {@code ImmutableGuildCreateFields} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link GuildCreateFields}.
 * @see ImmutableGuildCreateFields.PartialChannel
 */
@Generated(from = "GuildCreateFields", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableGuildCreateFields {
  private ImmutableGuildCreateFields() {}

  /**
   * Immutable implementation of {@link GuildCreateFields.PartialChannel}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableGuildCreateFields.PartialChannel.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableGuildCreateFields.PartialChannel.of()}.
   */
  @Generated(from = "GuildCreateFields.PartialChannel", generator = "Immutables")
  static final class PartialChannel implements GuildCreateFields.PartialChannel {
    private final String name;
    private final Channel.Type type;

    private PartialChannel(String name, Channel.Type type) {
      this.name = Objects.requireNonNull(name, "name");
      this.type = Objects.requireNonNull(type, "type");
    }

    private PartialChannel(
        ImmutableGuildCreateFields.PartialChannel original,
        String name,
        Channel.Type type) {
      this.name = name;
      this.type = type;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    public String name() {
      return name;
    }

    /**
     * @return The value of the {@code type} attribute
     */
    @Override
    public Channel.Type type() {
      return type;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link GuildCreateFields.PartialChannel#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableGuildCreateFields.PartialChannel withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableGuildCreateFields.PartialChannel(this, newValue, this.type);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link GuildCreateFields.PartialChannel#type() type} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for type
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableGuildCreateFields.PartialChannel withType(Channel.Type value) {
      Channel.Type newValue = Objects.requireNonNull(value, "type");
      if (this.type == newValue) return this;
      return new ImmutableGuildCreateFields.PartialChannel(this, this.name, newValue);
    }

    /**
     * This instance is equal to all instances of {@code PartialChannel} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableGuildCreateFields.PartialChannel
          && equalTo(0, (ImmutableGuildCreateFields.PartialChannel) another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildCreateFields.PartialChannel another) {
      return name.equals(another.name)
          && type.equals(another.type);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code type}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + type.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code PartialChannel} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "PartialChannel{"
          + "name=" + name
          + ", type=" + type
          + "}";
    }

    /**
     * Construct a new immutable {@code PartialChannel} instance.
     * @param name The value for the {@code name} attribute
     * @param type The value for the {@code type} attribute
     * @return An immutable PartialChannel instance
     */
    public static ImmutableGuildCreateFields.PartialChannel of(String name, Channel.Type type) {
      return new ImmutableGuildCreateFields.PartialChannel(name, type);
    }

    /**
     * Creates an immutable copy of a {@link GuildCreateFields.PartialChannel} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable PartialChannel instance
     */
    public static ImmutableGuildCreateFields.PartialChannel copyOf(GuildCreateFields.PartialChannel instance) {
      if (instance instanceof ImmutableGuildCreateFields.PartialChannel) {
        return (ImmutableGuildCreateFields.PartialChannel) instance;
      }
      return ImmutableGuildCreateFields.PartialChannel.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableGuildCreateFields.PartialChannel PartialChannel}.
     * <pre>
     * ImmutableGuildCreateFields.PartialChannel.builder()
     *    .name(String) // required {@link GuildCreateFields.PartialChannel#name() name}
     *    .type(discord4j.core.object.entity.channel.Channel.Type) // required {@link GuildCreateFields.PartialChannel#type() type}
     *    .build();
     * </pre>
     * @return A new PartialChannel builder
     */
    public static ImmutableGuildCreateFields.PartialChannel.Builder builder() {
      return new ImmutableGuildCreateFields.PartialChannel.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableGuildCreateFields.PartialChannel PartialChannel}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "GuildCreateFields.PartialChannel", generator = "Immutables")
    public static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private static final long INIT_BIT_TYPE = 0x2L;
      private long initBits = 0x3L;

      private String name;
      private Channel.Type type;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code PartialChannel} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(GuildCreateFields.PartialChannel instance) {
        Objects.requireNonNull(instance, "instance");
        name(instance.name());
        type(instance.type());
        return this;
      }

      /**
       * Initializes the value for the {@link GuildCreateFields.PartialChannel#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Initializes the value for the {@link GuildCreateFields.PartialChannel#type() type} attribute.
       * @param type The value for type 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder type(Channel.Type type) {
        this.type = Objects.requireNonNull(type, "type");
        initBits &= ~INIT_BIT_TYPE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableGuildCreateFields.PartialChannel PartialChannel}.
       * @return An immutable instance of PartialChannel
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableGuildCreateFields.PartialChannel build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableGuildCreateFields.PartialChannel(null, name, type);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
        return "Cannot build PartialChannel, some of required attributes are not set " + attributes;
      }
    }
  }
}
