package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * {@code ImmutableEmbedCreateFields} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link EmbedCreateFields}.
 * @see ImmutableEmbedCreateFields.Footer
 * @see ImmutableEmbedCreateFields.Author
 * @see ImmutableEmbedCreateFields.Field
 */
@Generated(from = "EmbedCreateFields", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableEmbedCreateFields {
  private ImmutableEmbedCreateFields() {}

  /**
   * Immutable implementation of {@link EmbedCreateFields.Footer}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEmbedCreateFields.Footer.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEmbedCreateFields.Footer.of()}.
   */
  @Generated(from = "EmbedCreateFields.Footer", generator = "Immutables")
  static final class Footer implements EmbedCreateFields.Footer {
    private final String text;
    private final @Nullable String iconUrl;

    private Footer(String text, @Nullable String iconUrl) {
      this.text = Objects.requireNonNull(text, "text");
      this.iconUrl = iconUrl;
    }

    private Footer(
        ImmutableEmbedCreateFields.Footer original,
        String text,
        @Nullable String iconUrl) {
      this.text = text;
      this.iconUrl = iconUrl;
    }

    /**
     * @return The value of the {@code text} attribute
     */
    @Override
    public String text() {
      return text;
    }

    /**
     * @return The value of the {@code iconUrl} attribute
     */
    @Override
    public @Nullable String iconUrl() {
      return iconUrl;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EmbedCreateFields.Footer#text() text} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for text
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEmbedCreateFields.Footer withText(String value) {
      String newValue = Objects.requireNonNull(value, "text");
      if (this.text.equals(newValue)) return this;
      return new ImmutableEmbedCreateFields.Footer(this, newValue, this.iconUrl);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EmbedCreateFields.Footer#iconUrl() iconUrl} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for iconUrl (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEmbedCreateFields.Footer withIconUrl(@Nullable String value) {
      if (Objects.equals(this.iconUrl, value)) return this;
      return new ImmutableEmbedCreateFields.Footer(this, this.text, value);
    }

    /**
     * This instance is equal to all instances of {@code Footer} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEmbedCreateFields.Footer
          && equalTo(0, (ImmutableEmbedCreateFields.Footer) another);
    }

    private boolean equalTo(int synthetic, ImmutableEmbedCreateFields.Footer another) {
      return text.equals(another.text)
          && Objects.equals(iconUrl, another.iconUrl);
    }

    /**
     * Computes a hash code from attributes: {@code text}, {@code iconUrl}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + text.hashCode();
      h += (h << 5) + Objects.hashCode(iconUrl);
      return h;
    }

    /**
     * Prints the immutable value {@code Footer} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Footer{"
          + "text=" + text
          + ", iconUrl=" + iconUrl
          + "}";
    }

    /**
     * Construct a new immutable {@code Footer} instance.
     * @param text The value for the {@code text} attribute
     * @param iconUrl The value for the {@code iconUrl} attribute
     * @return An immutable Footer instance
     */
    public static ImmutableEmbedCreateFields.Footer of(String text, @Nullable String iconUrl) {
      return new ImmutableEmbedCreateFields.Footer(text, iconUrl);
    }

    /**
     * Creates an immutable copy of a {@link EmbedCreateFields.Footer} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Footer instance
     */
    public static ImmutableEmbedCreateFields.Footer copyOf(EmbedCreateFields.Footer instance) {
      if (instance instanceof ImmutableEmbedCreateFields.Footer) {
        return (ImmutableEmbedCreateFields.Footer) instance;
      }
      return ImmutableEmbedCreateFields.Footer.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEmbedCreateFields.Footer Footer}.
     * <pre>
     * ImmutableEmbedCreateFields.Footer.builder()
     *    .text(String) // required {@link EmbedCreateFields.Footer#text() text}
     *    .iconUrl(String | null) // nullable {@link EmbedCreateFields.Footer#iconUrl() iconUrl}
     *    .build();
     * </pre>
     * @return A new Footer builder
     */
    public static ImmutableEmbedCreateFields.Footer.Builder builder() {
      return new ImmutableEmbedCreateFields.Footer.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEmbedCreateFields.Footer Footer}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EmbedCreateFields.Footer", generator = "Immutables")
    public static final class Builder {
      private static final long INIT_BIT_TEXT = 0x1L;
      private long initBits = 0x1L;

      private String text;
      private String iconUrl;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Footer} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EmbedCreateFields.Footer instance) {
        Objects.requireNonNull(instance, "instance");
        text(instance.text());
        String iconUrlValue = instance.iconUrl();
        if (iconUrlValue != null) {
          iconUrl(iconUrlValue);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link EmbedCreateFields.Footer#text() text} attribute.
       * @param text The value for text 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder text(String text) {
        this.text = Objects.requireNonNull(text, "text");
        initBits &= ~INIT_BIT_TEXT;
        return this;
      }

      /**
       * Initializes the value for the {@link EmbedCreateFields.Footer#iconUrl() iconUrl} attribute.
       * @param iconUrl The value for iconUrl (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder iconUrl(@Nullable String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEmbedCreateFields.Footer Footer}.
       * @return An immutable instance of Footer
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEmbedCreateFields.Footer build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEmbedCreateFields.Footer(null, text, iconUrl);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_TEXT) != 0) attributes.add("text");
        return "Cannot build Footer, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EmbedCreateFields.Author}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEmbedCreateFields.Author.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEmbedCreateFields.Author.of()}.
   */
  @Generated(from = "EmbedCreateFields.Author", generator = "Immutables")
  static final class Author implements EmbedCreateFields.Author {
    private final String name;
    private final @Nullable String url;
    private final @Nullable String iconUrl;

    private Author(
        String name,
        @Nullable String url,
        @Nullable String iconUrl) {
      this.name = Objects.requireNonNull(name, "name");
      this.url = url;
      this.iconUrl = iconUrl;
    }

    private Author(
        ImmutableEmbedCreateFields.Author original,
        String name,
        @Nullable String url,
        @Nullable String iconUrl) {
      this.name = name;
      this.url = url;
      this.iconUrl = iconUrl;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    public String name() {
      return name;
    }

    /**
     * @return The value of the {@code url} attribute
     */
    @Override
    public @Nullable String url() {
      return url;
    }

    /**
     * @return The value of the {@code iconUrl} attribute
     */
    @Override
    public @Nullable String iconUrl() {
      return iconUrl;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EmbedCreateFields.Author#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEmbedCreateFields.Author withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableEmbedCreateFields.Author(this, newValue, this.url, this.iconUrl);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EmbedCreateFields.Author#url() url} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for url (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEmbedCreateFields.Author withUrl(@Nullable String value) {
      if (Objects.equals(this.url, value)) return this;
      return new ImmutableEmbedCreateFields.Author(this, this.name, value, this.iconUrl);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EmbedCreateFields.Author#iconUrl() iconUrl} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for iconUrl (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEmbedCreateFields.Author withIconUrl(@Nullable String value) {
      if (Objects.equals(this.iconUrl, value)) return this;
      return new ImmutableEmbedCreateFields.Author(this, this.name, this.url, value);
    }

    /**
     * This instance is equal to all instances of {@code Author} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEmbedCreateFields.Author
          && equalTo(0, (ImmutableEmbedCreateFields.Author) another);
    }

    private boolean equalTo(int synthetic, ImmutableEmbedCreateFields.Author another) {
      return name.equals(another.name)
          && Objects.equals(url, another.url)
          && Objects.equals(iconUrl, another.iconUrl);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code url}, {@code iconUrl}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + Objects.hashCode(url);
      h += (h << 5) + Objects.hashCode(iconUrl);
      return h;
    }

    /**
     * Prints the immutable value {@code Author} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Author{"
          + "name=" + name
          + ", url=" + url
          + ", iconUrl=" + iconUrl
          + "}";
    }

    /**
     * Construct a new immutable {@code Author} instance.
     * @param name The value for the {@code name} attribute
     * @param url The value for the {@code url} attribute
     * @param iconUrl The value for the {@code iconUrl} attribute
     * @return An immutable Author instance
     */
    public static ImmutableEmbedCreateFields.Author of(String name, @Nullable String url, @Nullable String iconUrl) {
      return new ImmutableEmbedCreateFields.Author(name, url, iconUrl);
    }

    /**
     * Creates an immutable copy of a {@link EmbedCreateFields.Author} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Author instance
     */
    public static ImmutableEmbedCreateFields.Author copyOf(EmbedCreateFields.Author instance) {
      if (instance instanceof ImmutableEmbedCreateFields.Author) {
        return (ImmutableEmbedCreateFields.Author) instance;
      }
      return ImmutableEmbedCreateFields.Author.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEmbedCreateFields.Author Author}.
     * <pre>
     * ImmutableEmbedCreateFields.Author.builder()
     *    .name(String) // required {@link EmbedCreateFields.Author#name() name}
     *    .url(String | null) // nullable {@link EmbedCreateFields.Author#url() url}
     *    .iconUrl(String | null) // nullable {@link EmbedCreateFields.Author#iconUrl() iconUrl}
     *    .build();
     * </pre>
     * @return A new Author builder
     */
    public static ImmutableEmbedCreateFields.Author.Builder builder() {
      return new ImmutableEmbedCreateFields.Author.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEmbedCreateFields.Author Author}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EmbedCreateFields.Author", generator = "Immutables")
    public static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private long initBits = 0x1L;

      private String name;
      private String url;
      private String iconUrl;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Author} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EmbedCreateFields.Author instance) {
        Objects.requireNonNull(instance, "instance");
        name(instance.name());
        String urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
        String iconUrlValue = instance.iconUrl();
        if (iconUrlValue != null) {
          iconUrl(iconUrlValue);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link EmbedCreateFields.Author#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Initializes the value for the {@link EmbedCreateFields.Author#url() url} attribute.
       * @param url The value for url (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder url(@Nullable String url) {
        this.url = url;
        return this;
      }

      /**
       * Initializes the value for the {@link EmbedCreateFields.Author#iconUrl() iconUrl} attribute.
       * @param iconUrl The value for iconUrl (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder iconUrl(@Nullable String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEmbedCreateFields.Author Author}.
       * @return An immutable instance of Author
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEmbedCreateFields.Author build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEmbedCreateFields.Author(null, name, url, iconUrl);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        return "Cannot build Author, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link EmbedCreateFields.Field}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableEmbedCreateFields.Field.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableEmbedCreateFields.Field.of()}.
   */
  @Generated(from = "EmbedCreateFields.Field", generator = "Immutables")
  static final class Field implements EmbedCreateFields.Field {
    private final String name;
    private final String value;
    private final boolean inline;

    private Field(String name, String value, boolean inline) {
      this.name = Objects.requireNonNull(name, "name");
      this.value = Objects.requireNonNull(value, "value");
      this.inline = inline;
    }

    private Field(
        ImmutableEmbedCreateFields.Field original,
        String name,
        String value,
        boolean inline) {
      this.name = name;
      this.value = value;
      this.inline = inline;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    public String name() {
      return name;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public String value() {
      return value;
    }

    /**
     * @return The value of the {@code inline} attribute
     */
    @Override
    public boolean inline() {
      return inline;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EmbedCreateFields.Field#name() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEmbedCreateFields.Field withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableEmbedCreateFields.Field(this, newValue, this.value, this.inline);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EmbedCreateFields.Field#value() value} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEmbedCreateFields.Field withValue(String value) {
      String newValue = Objects.requireNonNull(value, "value");
      if (this.value.equals(newValue)) return this;
      return new ImmutableEmbedCreateFields.Field(this, this.name, newValue, this.inline);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link EmbedCreateFields.Field#inline() inline} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for inline
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEmbedCreateFields.Field withInline(boolean value) {
      if (this.inline == value) return this;
      return new ImmutableEmbedCreateFields.Field(this, this.name, this.value, value);
    }

    /**
     * This instance is equal to all instances of {@code Field} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEmbedCreateFields.Field
          && equalTo(0, (ImmutableEmbedCreateFields.Field) another);
    }

    private boolean equalTo(int synthetic, ImmutableEmbedCreateFields.Field another) {
      return name.equals(another.name)
          && value.equals(another.value)
          && inline == another.inline;
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code value}, {@code inline}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + value.hashCode();
      h += (h << 5) + Boolean.hashCode(inline);
      return h;
    }

    /**
     * Prints the immutable value {@code Field} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Field{"
          + "name=" + name
          + ", value=" + value
          + ", inline=" + inline
          + "}";
    }

    /**
     * Construct a new immutable {@code Field} instance.
     * @param name The value for the {@code name} attribute
     * @param value The value for the {@code value} attribute
     * @param inline The value for the {@code inline} attribute
     * @return An immutable Field instance
     */
    public static ImmutableEmbedCreateFields.Field of(String name, String value, boolean inline) {
      return new ImmutableEmbedCreateFields.Field(name, value, inline);
    }

    /**
     * Creates an immutable copy of a {@link EmbedCreateFields.Field} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Field instance
     */
    public static ImmutableEmbedCreateFields.Field copyOf(EmbedCreateFields.Field instance) {
      if (instance instanceof ImmutableEmbedCreateFields.Field) {
        return (ImmutableEmbedCreateFields.Field) instance;
      }
      return ImmutableEmbedCreateFields.Field.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableEmbedCreateFields.Field Field}.
     * <pre>
     * ImmutableEmbedCreateFields.Field.builder()
     *    .name(String) // required {@link EmbedCreateFields.Field#name() name}
     *    .value(String) // required {@link EmbedCreateFields.Field#value() value}
     *    .inline(boolean) // required {@link EmbedCreateFields.Field#inline() inline}
     *    .build();
     * </pre>
     * @return A new Field builder
     */
    public static ImmutableEmbedCreateFields.Field.Builder builder() {
      return new ImmutableEmbedCreateFields.Field.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableEmbedCreateFields.Field Field}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "EmbedCreateFields.Field", generator = "Immutables")
    public static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private static final long INIT_BIT_VALUE = 0x2L;
      private static final long INIT_BIT_INLINE = 0x4L;
      private long initBits = 0x7L;

      private String name;
      private String value;
      private boolean inline;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Field} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(EmbedCreateFields.Field instance) {
        Objects.requireNonNull(instance, "instance");
        name(instance.name());
        value(instance.value());
        inline(instance.inline());
        return this;
      }

      /**
       * Initializes the value for the {@link EmbedCreateFields.Field#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Initializes the value for the {@link EmbedCreateFields.Field#value() value} attribute.
       * @param value The value for value 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder value(String value) {
        this.value = Objects.requireNonNull(value, "value");
        initBits &= ~INIT_BIT_VALUE;
        return this;
      }

      /**
       * Initializes the value for the {@link EmbedCreateFields.Field#inline() inline} attribute.
       * @param inline The value for inline 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder inline(boolean inline) {
        this.inline = inline;
        initBits &= ~INIT_BIT_INLINE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableEmbedCreateFields.Field Field}.
       * @return An immutable instance of Field
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEmbedCreateFields.Field build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEmbedCreateFields.Field(null, name, value, inline);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
        if ((initBits & INIT_BIT_INLINE) != 0) attributes.add("inline");
        return "Cannot build Field, some of required attributes are not set " + attributes;
      }
    }
  }
}
