package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildTemplateEditSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GuildTemplateEditSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code GuildTemplateEditSpec.create()}.
 */
@Generated(from = "GuildTemplateEditSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildTemplateEditSpec implements GuildTemplateEditSpecGenerator {
  private final String name_value;
  private final boolean name_absent;
  private final String description_value;
  private final boolean description_absent;

  private GuildTemplateEditSpec() {
    Possible<String> name$impl = Possible.absent();
    Possible<Optional<String>> description$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private GuildTemplateEditSpec(
      Possible<String> name,
      Possible<Optional<String>> description) {
    Possible<String> name$impl = name;
    Possible<Optional<String>> description$impl = description;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildTemplateEditSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildTemplateEditSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public Possible<Optional<String>> description() {
    return description_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(description_value));
  }

  public GuildTemplateEditSpec withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new GuildTemplateEditSpec(newValue, this.description()));
  }

  public GuildTemplateEditSpec withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new GuildTemplateEditSpec(newValue, this.description()));
  }

  public GuildTemplateEditSpec withDescription(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return validate(new GuildTemplateEditSpec(this.name(), newValue));
  }

  @Deprecated
  public GuildTemplateEditSpec withDescription(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildTemplateEditSpec(this.name(), newValue));
  }

  public GuildTemplateEditSpec withDescriptionOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildTemplateEditSpec(this.name(), newValue));
  }

  /**
   * This instance is equal to all instances of {@code GuildTemplateEditSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildTemplateEditSpec
        && equalTo(0, (GuildTemplateEditSpec) another);
  }

  private boolean equalTo(int synthetic, GuildTemplateEditSpec another) {
    return this.name().equals(another.name())
        && this.description().equals(another.description());
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (description().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code GuildTemplateEditSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildTemplateEditSpec{"
        + "name=" + (name().toString())
        + ", description=" + (description().toString())
        + "}";
  }

  private static final GuildTemplateEditSpec INSTANCE = validate(new GuildTemplateEditSpec());

  /**
   * Returns the default immutable singleton value of {@code GuildTemplateEditSpec}
   * @return An immutable instance of GuildTemplateEditSpec
   */
  public static GuildTemplateEditSpec create() {
    return INSTANCE;
  }

  private static GuildTemplateEditSpec validate(GuildTemplateEditSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link GuildTemplateEditSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildTemplateEditSpec instance
   */
  static GuildTemplateEditSpec copyOf(GuildTemplateEditSpecGenerator instance) {
    if (instance instanceof GuildTemplateEditSpec) {
      return (GuildTemplateEditSpec) instance;
    }
    return GuildTemplateEditSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isDescriptionPresent() {
    return !description_absent;
  }

  public String descriptionOrElse(String defaultValue) {
    return !description_absent ? description_value : defaultValue;
  }

  /**
   * Creates a builder for {@link GuildTemplateEditSpec GuildTemplateEditSpec}.
   * <pre>
   * GuildTemplateEditSpec.builder()
   *    .name(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link GuildTemplateEditSpec#name() name}
   *    .description(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;String&amp;gt;&amp;gt;) // {@link GuildTemplateEditSpec#description() description}
   *    .build();
   * </pre>
   * @return A new GuildTemplateEditSpec builder
   */
  public static GuildTemplateEditSpec.Builder builder() {
    return new GuildTemplateEditSpec.Builder();
  }

  /**
   * Builds instances of type {@link GuildTemplateEditSpec GuildTemplateEditSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GuildTemplateEditSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<String> name_possible = Possible.absent();
    private Possible<Optional<String>> description_possible = Possible.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GuildTemplateEditSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GuildTemplateEditSpec instance) {
      return from((GuildTemplateEditSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code GuildTemplateEditSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(GuildTemplateEditSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      description(instance.description());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(Possible<String> value) {
      this.name_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(String value) {
      this.name_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder description(Possible<Optional<String>> value) {
      this.description_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder description(@Nullable String value) {
      this.description_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder descriptionOrNull(@Nullable String value) {
      this.description_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    /**
     * Builds a new {@link GuildTemplateEditSpec GuildTemplateEditSpec}.
     * @return An immutable instance of GuildTemplateEditSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GuildTemplateEditSpec build() {
      return GuildTemplateEditSpec.validate(new GuildTemplateEditSpec(name_build(), description_build()));
    }

    private Possible<String> name_build() {
      return this.name_possible;
    }

    private Possible<Optional<String>> description_build() {
      return this.description_possible;
    }
  }
}
