package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.GuildTemplate;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildTemplateEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code GuildTemplateEditMono.of()}.
 */
@Generated(from = "GuildTemplateEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildTemplateEditMono extends GuildTemplateEditMonoGenerator {
  private final String name_value;
  private final boolean name_absent;
  private final String description_value;
  private final boolean description_absent;
  private final GuildTemplate guildTemplate;

  private GuildTemplateEditMono(GuildTemplate guildTemplate) {
    this.guildTemplate = Objects.requireNonNull(guildTemplate, "guildTemplate");
    Possible<String> name$impl = Possible.absent();
    Possible<Optional<String>> description$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private GuildTemplateEditMono(
      Possible<String> name,
      Possible<Optional<String>> description,
      GuildTemplate guildTemplate) {
    Possible<String> name$impl = name;
    Possible<Optional<String>> description$impl = description;
    this.guildTemplate = guildTemplate;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildTemplateEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildTemplateEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public Possible<Optional<String>> description() {
    return description_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(description_value));
  }

  /**
   * @return The value of the {@code guildTemplate} attribute
   */
  @Override
  public GuildTemplate guildTemplate() {
    return guildTemplate;
  }

  public GuildTemplateEditMono withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new GuildTemplateEditMono(newValue, this.description(), this.guildTemplate);
  }

  public GuildTemplateEditMono withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return new GuildTemplateEditMono(newValue, this.description(), this.guildTemplate);
  }

  public GuildTemplateEditMono withDescription(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return new GuildTemplateEditMono(this.name(), newValue, this.guildTemplate);
  }

  @Deprecated
  public GuildTemplateEditMono withDescription(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildTemplateEditMono(this.name(), newValue, this.guildTemplate);
  }

  public GuildTemplateEditMono withDescriptionOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildTemplateEditMono(this.name(), newValue, this.guildTemplate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildTemplateEditMono#guildTemplate() guildTemplate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guildTemplate
   * @return A modified copy of the {@code this} object
   */
  public final GuildTemplateEditMono withGuildTemplate(GuildTemplate value) {
    if (this.guildTemplate == value) return this;
    GuildTemplate newValue = Objects.requireNonNull(value, "guildTemplate");
    return new GuildTemplateEditMono(this.name(), this.description(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildTemplateEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildTemplateEditMono
        && equalTo(0, (GuildTemplateEditMono) another);
  }

  private boolean equalTo(int synthetic, GuildTemplateEditMono another) {
    return this.name().equals(another.name())
        && this.description().equals(another.description())
        && guildTemplate.equals(another.guildTemplate);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}, {@code guildTemplate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (description().hashCode());
    h += (h << 5) + guildTemplate.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildTemplateEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildTemplateEditMono{"
        + "name=" + (name().toString())
        + ", description=" + (description().toString())
        + ", guildTemplate=" + guildTemplate
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildTemplateEditMono} instance.
   * @param guildTemplate The value for the {@code guildTemplate} attribute
   * @return An immutable GuildTemplateEditMono instance
   */
  public static GuildTemplateEditMono of(GuildTemplate guildTemplate) {
    return new GuildTemplateEditMono(guildTemplate);
  }

  /**
   * Creates an immutable copy of a {@link GuildTemplateEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildTemplateEditMono instance
   */
  static GuildTemplateEditMono copyOf(GuildTemplateEditMonoGenerator instance) {
    if (instance instanceof GuildTemplateEditMono) {
      return (GuildTemplateEditMono) instance;
    }
    return GuildTemplateEditMono.of(instance.guildTemplate())
        .withName(instance.name())
        .withDescription(instance.description());
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isDescriptionPresent() {
    return !description_absent;
  }

  public String descriptionOrElse(String defaultValue) {
    return !description_absent ? description_value : defaultValue;
  }
}
