package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildTemplateCreateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GuildTemplateCreateSpec.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code GuildTemplateCreateSpec.of()}.
 */
@Generated(from = "GuildTemplateCreateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildTemplateCreateSpec implements GuildTemplateCreateSpecGenerator {
  private final String name;
  private final String description_value;
  private final boolean description_absent;

  private GuildTemplateCreateSpec(String name) {
    this.name = Objects.requireNonNull(name, "name");
    Possible<Optional<String>> description$impl = Possible.absent();
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private GuildTemplateCreateSpec(
      String name,
      Possible<Optional<String>> description) {
    this.name = name;
    Possible<Optional<String>> description$impl = description;
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildTemplateCreateSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildTemplateCreateSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public Possible<Optional<String>> description() {
    return description_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(description_value));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildTemplateCreateSpec#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final GuildTemplateCreateSpec withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new GuildTemplateCreateSpec(newValue, this.description());
  }

  public GuildTemplateCreateSpec withDescription(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return new GuildTemplateCreateSpec(this.name, newValue);
  }

  @Deprecated
  public GuildTemplateCreateSpec withDescription(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildTemplateCreateSpec(this.name, newValue);
  }

  public GuildTemplateCreateSpec withDescriptionOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildTemplateCreateSpec(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildTemplateCreateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildTemplateCreateSpec
        && equalTo(0, (GuildTemplateCreateSpec) another);
  }

  private boolean equalTo(int synthetic, GuildTemplateCreateSpec another) {
    return name.equals(another.name)
        && this.description().equals(another.description());
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (description().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code GuildTemplateCreateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildTemplateCreateSpec{"
        + "name=" + name
        + ", description=" + (description().toString())
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildTemplateCreateSpec} instance.
   * @param name The value for the {@code name} attribute
   * @return An immutable GuildTemplateCreateSpec instance
   */
  public static GuildTemplateCreateSpec of(String name) {
    return new GuildTemplateCreateSpec(name);
  }

  /**
   * Creates an immutable copy of a {@link GuildTemplateCreateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildTemplateCreateSpec instance
   */
  static GuildTemplateCreateSpec copyOf(GuildTemplateCreateSpecGenerator instance) {
    if (instance instanceof GuildTemplateCreateSpec) {
      return (GuildTemplateCreateSpec) instance;
    }
    return GuildTemplateCreateSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isDescriptionPresent() {
    return !description_absent;
  }

  public String descriptionOrElse(String defaultValue) {
    return !description_absent ? description_value : defaultValue;
  }

  /**
   * Creates a builder for {@link GuildTemplateCreateSpec GuildTemplateCreateSpec}.
   * <pre>
   * GuildTemplateCreateSpec.builder()
   *    .name(String) // required {@link GuildTemplateCreateSpec#name() name}
   *    .description(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;String&amp;gt;&amp;gt;) // {@link GuildTemplateCreateSpec#description() description}
   *    .build();
   * </pre>
   * @return A new GuildTemplateCreateSpec builder
   */
  public static GuildTemplateCreateSpec.Builder builder() {
    return new GuildTemplateCreateSpec.Builder();
  }

  /**
   * Builds instances of type {@link GuildTemplateCreateSpec GuildTemplateCreateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GuildTemplateCreateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Possible<Optional<String>> description_possible = Possible.absent();
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GuildTemplateCreateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GuildTemplateCreateSpec instance) {
      return from((GuildTemplateCreateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code GuildTemplateCreateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(GuildTemplateCreateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      description(instance.description());
      return this;
    }

    /**
     * Initializes the value for the {@link GuildTemplateCreateSpec#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder description(Possible<Optional<String>> value) {
      this.description_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder description(@Nullable String value) {
      this.description_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder descriptionOrNull(@Nullable String value) {
      this.description_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    /**
     * Builds a new {@link GuildTemplateCreateSpec GuildTemplateCreateSpec}.
     * @return An immutable instance of GuildTemplateCreateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GuildTemplateCreateSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GuildTemplateCreateSpec(name, description_build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build GuildTemplateCreateSpec, some of required attributes are not set " + attributes;
    }

    private Possible<Optional<String>> description_build() {
      return this.description_possible;
    }
  }
}
