package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.entity.Guild;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildTemplateCreateMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code GuildTemplateCreateMono.of()}.
 */
@Generated(from = "GuildTemplateCreateMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildTemplateCreateMono extends GuildTemplateCreateMonoGenerator {
  private final String name;
  private final String description_value;
  private final boolean description_absent;
  private final Guild guild;

  private GuildTemplateCreateMono(String name, Guild guild) {
    this.name = Objects.requireNonNull(name, "name");
    this.guild = Objects.requireNonNull(guild, "guild");
    Possible<Optional<String>> description$impl = Possible.absent();
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private GuildTemplateCreateMono(
      String name,
      Possible<Optional<String>> description,
      Guild guild) {
    this.name = name;
    Possible<Optional<String>> description$impl = description;
    this.guild = guild;
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildTemplateCreateMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildTemplateCreateMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public Possible<Optional<String>> description() {
    return description_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(description_value));
  }

  /**
   * @return The value of the {@code guild} attribute
   */
  @Override
  public Guild guild() {
    return guild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildTemplateCreateMono#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final GuildTemplateCreateMono withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new GuildTemplateCreateMono(newValue, this.description(), this.guild);
  }

  public GuildTemplateCreateMono withDescription(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return new GuildTemplateCreateMono(this.name, newValue, this.guild);
  }

  @Deprecated
  public GuildTemplateCreateMono withDescription(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildTemplateCreateMono(this.name, newValue, this.guild);
  }

  public GuildTemplateCreateMono withDescriptionOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildTemplateCreateMono(this.name, newValue, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildTemplateCreateMono#guild() guild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guild
   * @return A modified copy of the {@code this} object
   */
  public final GuildTemplateCreateMono withGuild(Guild value) {
    if (this.guild == value) return this;
    Guild newValue = Objects.requireNonNull(value, "guild");
    return new GuildTemplateCreateMono(this.name, this.description(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildTemplateCreateMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildTemplateCreateMono
        && equalTo(0, (GuildTemplateCreateMono) another);
  }

  private boolean equalTo(int synthetic, GuildTemplateCreateMono another) {
    return name.equals(another.name)
        && this.description().equals(another.description())
        && guild.equals(another.guild);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}, {@code guild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (description().hashCode());
    h += (h << 5) + guild.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildTemplateCreateMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildTemplateCreateMono{"
        + "name=" + name
        + ", description=" + (description().toString())
        + ", guild=" + guild
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildTemplateCreateMono} instance.
   * @param name The value for the {@code name} attribute
   * @param guild The value for the {@code guild} attribute
   * @return An immutable GuildTemplateCreateMono instance
   */
  public static GuildTemplateCreateMono of(String name, Guild guild) {
    return new GuildTemplateCreateMono(name, guild);
  }

  /**
   * Creates an immutable copy of a {@link GuildTemplateCreateMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildTemplateCreateMono instance
   */
  static GuildTemplateCreateMono copyOf(GuildTemplateCreateMonoGenerator instance) {
    if (instance instanceof GuildTemplateCreateMono) {
      return (GuildTemplateCreateMono) instance;
    }
    return GuildTemplateCreateMono.of(instance.name(), instance.guild())
        .withDescription(instance.description());
  }

  public boolean isDescriptionPresent() {
    return !description_absent;
  }

  public String descriptionOrElse(String defaultValue) {
    return !description_absent ? description_value : defaultValue;
  }
}
