package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildPruneSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GuildPruneSpec.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code GuildPruneSpec.of()}.
 */
@Generated(from = "GuildPruneSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildPruneSpec implements GuildPruneSpecGenerator {
  private final @Nullable String reason;
  private final Integer days;
  private final @Nullable Set<Snowflake> roles;
  private final @Nullable Boolean computePruneCount;

  private GuildPruneSpec(Integer days) {
    this.days = Objects.requireNonNull(days, "days");
    this.reason = null;
    this.roles = null;
    this.computePruneCount = null;
  }

  private GuildPruneSpec(
      @Nullable String reason,
      Integer days,
      @Nullable Set<Snowflake> roles,
      @Nullable Boolean computePruneCount) {
    this.reason = reason;
    this.days = days;
    this.roles = roles;
    this.computePruneCount = computePruneCount;
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code days} attribute
   */
  @Override
  public Integer days() {
    return days;
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public @Nullable Set<Snowflake> roles() {
    return roles;
  }

  /**
   * @return The value of the {@code computePruneCount} attribute
   */
  @Override
  public @Nullable Boolean computePruneCount() {
    return computePruneCount;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildPruneSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildPruneSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new GuildPruneSpec(value, this.days, this.roles, this.computePruneCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildPruneSpec#days() days} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for days
   * @return A modified copy of the {@code this} object
   */
  public final GuildPruneSpec withDays(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "days");
    if (this.days.equals(newValue)) return this;
    return new GuildPruneSpec(this.reason, newValue, this.roles, this.computePruneCount);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildPruneSpec#roles() roles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildPruneSpec withRoles(@Nullable Snowflake... elements) {
    if (elements == null) {
      return new GuildPruneSpec(this.reason, this.days, null, this.computePruneCount);
    }
    Set<Snowflake> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new GuildPruneSpec(this.reason, this.days, newValue, this.computePruneCount);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildPruneSpec#roles() roles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of roles elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildPruneSpec withRoles(@Nullable Iterable<? extends Snowflake> elements) {
    if (this.roles == elements) return this;
    Set<Snowflake> newValue = elements == null ? null : createUnmodifiableSet(createSafeList(elements, true, false));
    return new GuildPruneSpec(this.reason, this.days, newValue, this.computePruneCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildPruneSpec#computePruneCount() computePruneCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for computePruneCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildPruneSpec withComputePruneCount(@Nullable Boolean value) {
    if (Objects.equals(this.computePruneCount, value)) return this;
    return new GuildPruneSpec(this.reason, this.days, this.roles, value);
  }

  /**
   * This instance is equal to all instances of {@code GuildPruneSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildPruneSpec
        && equalTo(0, (GuildPruneSpec) another);
  }

  private boolean equalTo(int synthetic, GuildPruneSpec another) {
    return Objects.equals(reason, another.reason)
        && days.equals(another.days)
        && Objects.equals(roles, another.roles)
        && Objects.equals(computePruneCount, another.computePruneCount);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code days}, {@code roles}, {@code computePruneCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + days.hashCode();
    h += (h << 5) + Objects.hashCode(roles);
    h += (h << 5) + Objects.hashCode(computePruneCount);
    return h;
  }

  /**
   * Prints the immutable value {@code GuildPruneSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildPruneSpec{"
        + "reason=" + reason
        + ", days=" + days
        + ", roles=" + roles
        + ", computePruneCount=" + computePruneCount
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildPruneSpec} instance.
   * @param days The value for the {@code days} attribute
   * @return An immutable GuildPruneSpec instance
   */
  public static GuildPruneSpec of(Integer days) {
    return new GuildPruneSpec(days);
  }

  /**
   * Creates an immutable copy of a {@link GuildPruneSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildPruneSpec instance
   */
  static GuildPruneSpec copyOf(GuildPruneSpecGenerator instance) {
    if (instance instanceof GuildPruneSpec) {
      return (GuildPruneSpec) instance;
    }
    return GuildPruneSpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link GuildPruneSpec GuildPruneSpec}.
   * <pre>
   * GuildPruneSpec.builder()
   *    .reason(String | null) // nullable {@link GuildPruneSpec#reason() reason}
   *    .days(Integer) // required {@link GuildPruneSpec#days() days}
   *    .roles(Set&amp;lt;discord4j.common.util.Snowflake&amp;gt; | null) // nullable {@link GuildPruneSpec#roles() roles}
   *    .computePruneCount(Boolean | null) // nullable {@link GuildPruneSpec#computePruneCount() computePruneCount}
   *    .build();
   * </pre>
   * @return A new GuildPruneSpec builder
   */
  public static GuildPruneSpec.Builder builder() {
    return new GuildPruneSpec.Builder();
  }

  /**
   * Builds instances of type {@link GuildPruneSpec GuildPruneSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GuildPruneSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DAYS = 0x1L;
    private long initBits = 0x1L;

    private String reason;
    private Integer days;
    private List<Snowflake> roles = null;
    private Boolean computePruneCount;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GuildPruneSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GuildPruneSpec instance) {
      return from((GuildPruneSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code GuildPruneSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(GuildPruneSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      days(instance.days());
      Set<Snowflake> rolesValue = instance.roles();
      if (rolesValue != null) {
        addAllRoles(rolesValue);
      }
      Boolean computePruneCountValue = instance.computePruneCount();
      if (computePruneCountValue != null) {
        computePruneCount(computePruneCountValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GuildPruneSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the value for the {@link GuildPruneSpec#days() days} attribute.
     * @param days The value for days 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder days(Integer days) {
      this.days = Objects.requireNonNull(days, "days");
      initBits &= ~INIT_BIT_DAYS;
      return this;
    }

    /**
     * Adds one element to {@link GuildPruneSpec#roles() roles} set.
     * @param element A roles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRole(Snowflake element) {
      if (this.roles == null) {
        this.roles = new ArrayList<Snowflake>();
      }
      this.roles.add(Objects.requireNonNull(element, "roles element"));
      return this;
    }

    /**
     * Adds elements to {@link GuildPruneSpec#roles() roles} set.
     * @param elements An array of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRoles(Snowflake... elements) {
      if (this.roles == null) {
        this.roles = new ArrayList<Snowflake>();
      }
      for (Snowflake element : elements) {
        this.roles.add(Objects.requireNonNull(element, "roles element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GuildPruneSpec#roles() roles} set.
     * @param elements An iterable of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder roles(@Nullable Iterable<? extends Snowflake> elements) {
      if (elements == null) {
        this.roles = null;
        return this;
      }
      this.roles = new ArrayList<Snowflake>();
      return addAllRoles(elements);
    }

    /**
     * Adds elements to {@link GuildPruneSpec#roles() roles} set.
     * @param elements An iterable of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRoles(Iterable<? extends Snowflake> elements) {
      Objects.requireNonNull(elements, "roles element");
      if (this.roles == null) {
        this.roles = new ArrayList<Snowflake>();
      }
      for (Snowflake element : elements) {
        this.roles.add(Objects.requireNonNull(element, "roles element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GuildPruneSpec#computePruneCount() computePruneCount} attribute.
     * @param computePruneCount The value for computePruneCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder computePruneCount(@Nullable Boolean computePruneCount) {
      this.computePruneCount = computePruneCount;
      return this;
    }

    /**
     * Builds a new {@link GuildPruneSpec GuildPruneSpec}.
     * @return An immutable instance of GuildPruneSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GuildPruneSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GuildPruneSpec(reason, days, roles == null ? null : createUnmodifiableSet(roles), computePruneCount);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DAYS) != 0) attributes.add("days");
      return "Cannot build GuildPruneSpec, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
