package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildPruneMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code GuildPruneMono.of()}.
 */
@Generated(from = "GuildPruneMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildPruneMono extends GuildPruneMonoGenerator {
  private final @Nullable String reason;
  private final Integer days;
  private final @Nullable Set<Snowflake> roles;
  private final @Nullable Boolean computePruneCount;
  private final Guild guild;

  private GuildPruneMono(Integer days, Guild guild) {
    this.days = Objects.requireNonNull(days, "days");
    this.guild = Objects.requireNonNull(guild, "guild");
    this.reason = null;
    this.roles = null;
    this.computePruneCount = null;
  }

  private GuildPruneMono(
      @Nullable String reason,
      Integer days,
      @Nullable Set<Snowflake> roles,
      @Nullable Boolean computePruneCount,
      Guild guild) {
    this.reason = reason;
    this.days = days;
    this.roles = roles;
    this.computePruneCount = computePruneCount;
    this.guild = guild;
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code days} attribute
   */
  @Override
  public Integer days() {
    return days;
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public @Nullable Set<Snowflake> roles() {
    return roles;
  }

  /**
   * @return The value of the {@code computePruneCount} attribute
   */
  @Override
  public @Nullable Boolean computePruneCount() {
    return computePruneCount;
  }

  /**
   * @return The value of the {@code guild} attribute
   */
  @Override
  public Guild guild() {
    return guild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildPruneMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildPruneMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new GuildPruneMono(value, this.days, this.roles, this.computePruneCount, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildPruneMono#days() days} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for days
   * @return A modified copy of the {@code this} object
   */
  public final GuildPruneMono withDays(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "days");
    if (this.days.equals(newValue)) return this;
    return new GuildPruneMono(this.reason, newValue, this.roles, this.computePruneCount, this.guild);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildPruneMono#roles() roles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildPruneMono withRoles(@Nullable Snowflake... elements) {
    if (elements == null) {
      return new GuildPruneMono(this.reason, this.days, null, this.computePruneCount, this.guild);
    }
    Set<Snowflake> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new GuildPruneMono(this.reason, this.days, newValue, this.computePruneCount, this.guild);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildPruneMono#roles() roles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of roles elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildPruneMono withRoles(@Nullable Iterable<? extends Snowflake> elements) {
    if (this.roles == elements) return this;
    Set<Snowflake> newValue = elements == null ? null : createUnmodifiableSet(createSafeList(elements, true, false));
    return new GuildPruneMono(this.reason, this.days, newValue, this.computePruneCount, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildPruneMono#computePruneCount() computePruneCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for computePruneCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildPruneMono withComputePruneCount(@Nullable Boolean value) {
    if (Objects.equals(this.computePruneCount, value)) return this;
    return new GuildPruneMono(this.reason, this.days, this.roles, value, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildPruneMono#guild() guild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guild
   * @return A modified copy of the {@code this} object
   */
  public final GuildPruneMono withGuild(Guild value) {
    if (this.guild == value) return this;
    Guild newValue = Objects.requireNonNull(value, "guild");
    return new GuildPruneMono(this.reason, this.days, this.roles, this.computePruneCount, newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildPruneMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildPruneMono
        && equalTo(0, (GuildPruneMono) another);
  }

  private boolean equalTo(int synthetic, GuildPruneMono another) {
    return Objects.equals(reason, another.reason)
        && days.equals(another.days)
        && Objects.equals(roles, another.roles)
        && Objects.equals(computePruneCount, another.computePruneCount)
        && guild.equals(another.guild);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code days}, {@code roles}, {@code computePruneCount}, {@code guild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + days.hashCode();
    h += (h << 5) + Objects.hashCode(roles);
    h += (h << 5) + Objects.hashCode(computePruneCount);
    h += (h << 5) + guild.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildPruneMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildPruneMono{"
        + "reason=" + reason
        + ", days=" + days
        + ", roles=" + roles
        + ", computePruneCount=" + computePruneCount
        + ", guild=" + guild
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildPruneMono} instance.
   * @param days The value for the {@code days} attribute
   * @param guild The value for the {@code guild} attribute
   * @return An immutable GuildPruneMono instance
   */
  public static GuildPruneMono of(Integer days, Guild guild) {
    return new GuildPruneMono(days, guild);
  }

  /**
   * Creates an immutable copy of a {@link GuildPruneMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildPruneMono instance
   */
  static GuildPruneMono copyOf(GuildPruneMonoGenerator instance) {
    if (instance instanceof GuildPruneMono) {
      return (GuildPruneMono) instance;
    }
    return GuildPruneMono.of(instance.days(), instance.guild())
        .withReason(instance.reason())
        .withRoles(instance.roles())
        .withComputePruneCount(instance.computePruneCount());
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
