package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildPruneCountSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GuildPruneCountSpec.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code GuildPruneCountSpec.of()}.
 */
@Generated(from = "GuildPruneCountSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildPruneCountSpec implements GuildPruneCountSpecGenerator {
  private final Integer days;
  private final @Nullable Set<Snowflake> roles;

  private GuildPruneCountSpec(Integer days) {
    this.days = Objects.requireNonNull(days, "days");
    this.roles = null;
  }

  private GuildPruneCountSpec(
      Integer days,
      @Nullable Set<Snowflake> roles) {
    this.days = days;
    this.roles = roles;
  }

  /**
   * @return The value of the {@code days} attribute
   */
  @Override
  public Integer days() {
    return days;
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public @Nullable Set<Snowflake> roles() {
    return roles;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildPruneCountSpec#days() days} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for days
   * @return A modified copy of the {@code this} object
   */
  public final GuildPruneCountSpec withDays(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "days");
    if (this.days.equals(newValue)) return this;
    return new GuildPruneCountSpec(newValue, this.roles);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildPruneCountSpec#roles() roles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildPruneCountSpec withRoles(@Nullable Snowflake... elements) {
    if (elements == null) {
      return new GuildPruneCountSpec(this.days, null);
    }
    Set<Snowflake> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new GuildPruneCountSpec(this.days, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildPruneCountSpec#roles() roles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of roles elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildPruneCountSpec withRoles(@Nullable Iterable<? extends Snowflake> elements) {
    if (this.roles == elements) return this;
    Set<Snowflake> newValue = elements == null ? null : createUnmodifiableSet(createSafeList(elements, true, false));
    return new GuildPruneCountSpec(this.days, newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildPruneCountSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildPruneCountSpec
        && equalTo(0, (GuildPruneCountSpec) another);
  }

  private boolean equalTo(int synthetic, GuildPruneCountSpec another) {
    return days.equals(another.days)
        && Objects.equals(roles, another.roles);
  }

  /**
   * Computes a hash code from attributes: {@code days}, {@code roles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + days.hashCode();
    h += (h << 5) + Objects.hashCode(roles);
    return h;
  }

  /**
   * Prints the immutable value {@code GuildPruneCountSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildPruneCountSpec{"
        + "days=" + days
        + ", roles=" + roles
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildPruneCountSpec} instance.
   * @param days The value for the {@code days} attribute
   * @return An immutable GuildPruneCountSpec instance
   */
  public static GuildPruneCountSpec of(Integer days) {
    return new GuildPruneCountSpec(days);
  }

  /**
   * Creates an immutable copy of a {@link GuildPruneCountSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildPruneCountSpec instance
   */
  static GuildPruneCountSpec copyOf(GuildPruneCountSpecGenerator instance) {
    if (instance instanceof GuildPruneCountSpec) {
      return (GuildPruneCountSpec) instance;
    }
    return GuildPruneCountSpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link GuildPruneCountSpec GuildPruneCountSpec}.
   * <pre>
   * GuildPruneCountSpec.builder()
   *    .days(Integer) // required {@link GuildPruneCountSpec#days() days}
   *    .roles(Set&amp;lt;discord4j.common.util.Snowflake&amp;gt; | null) // nullable {@link GuildPruneCountSpec#roles() roles}
   *    .build();
   * </pre>
   * @return A new GuildPruneCountSpec builder
   */
  public static GuildPruneCountSpec.Builder builder() {
    return new GuildPruneCountSpec.Builder();
  }

  /**
   * Builds instances of type {@link GuildPruneCountSpec GuildPruneCountSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GuildPruneCountSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DAYS = 0x1L;
    private long initBits = 0x1L;

    private Integer days;
    private List<Snowflake> roles = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GuildPruneCountSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GuildPruneCountSpec instance) {
      return from((GuildPruneCountSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code GuildPruneCountSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(GuildPruneCountSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      days(instance.days());
      Set<Snowflake> rolesValue = instance.roles();
      if (rolesValue != null) {
        addAllRoles(rolesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GuildPruneCountSpec#days() days} attribute.
     * @param days The value for days 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder days(Integer days) {
      this.days = Objects.requireNonNull(days, "days");
      initBits &= ~INIT_BIT_DAYS;
      return this;
    }

    /**
     * Adds one element to {@link GuildPruneCountSpec#roles() roles} set.
     * @param element A roles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRole(Snowflake element) {
      if (this.roles == null) {
        this.roles = new ArrayList<Snowflake>();
      }
      this.roles.add(Objects.requireNonNull(element, "roles element"));
      return this;
    }

    /**
     * Adds elements to {@link GuildPruneCountSpec#roles() roles} set.
     * @param elements An array of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRoles(Snowflake... elements) {
      if (this.roles == null) {
        this.roles = new ArrayList<Snowflake>();
      }
      for (Snowflake element : elements) {
        this.roles.add(Objects.requireNonNull(element, "roles element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GuildPruneCountSpec#roles() roles} set.
     * @param elements An iterable of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder roles(@Nullable Iterable<? extends Snowflake> elements) {
      if (elements == null) {
        this.roles = null;
        return this;
      }
      this.roles = new ArrayList<Snowflake>();
      return addAllRoles(elements);
    }

    /**
     * Adds elements to {@link GuildPruneCountSpec#roles() roles} set.
     * @param elements An iterable of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRoles(Iterable<? extends Snowflake> elements) {
      Objects.requireNonNull(elements, "roles element");
      if (this.roles == null) {
        this.roles = new ArrayList<Snowflake>();
      }
      for (Snowflake element : elements) {
        this.roles.add(Objects.requireNonNull(element, "roles element"));
      }
      return this;
    }

    /**
     * Builds a new {@link GuildPruneCountSpec GuildPruneCountSpec}.
     * @return An immutable instance of GuildPruneCountSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GuildPruneCountSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GuildPruneCountSpec(days, roles == null ? null : createUnmodifiableSet(roles));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DAYS) != 0) attributes.add("days");
      return "Cannot build GuildPruneCountSpec, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
