package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildPruneCountMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code GuildPruneCountMono.of()}.
 */
@Generated(from = "GuildPruneCountMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildPruneCountMono extends GuildPruneCountMonoGenerator {
  private final Integer days;
  private final @Nullable Set<Snowflake> roles;
  private final Guild guild;

  private GuildPruneCountMono(Integer days, Guild guild) {
    this.days = Objects.requireNonNull(days, "days");
    this.guild = Objects.requireNonNull(guild, "guild");
    this.roles = null;
  }

  private GuildPruneCountMono(
      Integer days,
      @Nullable Set<Snowflake> roles,
      Guild guild) {
    this.days = days;
    this.roles = roles;
    this.guild = guild;
  }

  /**
   * @return The value of the {@code days} attribute
   */
  @Override
  public Integer days() {
    return days;
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public @Nullable Set<Snowflake> roles() {
    return roles;
  }

  /**
   * @return The value of the {@code guild} attribute
   */
  @Override
  public Guild guild() {
    return guild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildPruneCountMono#days() days} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for days
   * @return A modified copy of the {@code this} object
   */
  public final GuildPruneCountMono withDays(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "days");
    if (this.days.equals(newValue)) return this;
    return new GuildPruneCountMono(newValue, this.roles, this.guild);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildPruneCountMono#roles() roles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildPruneCountMono withRoles(@Nullable Snowflake... elements) {
    if (elements == null) {
      return new GuildPruneCountMono(this.days, null, this.guild);
    }
    Set<Snowflake> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new GuildPruneCountMono(this.days, newValue, this.guild);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildPruneCountMono#roles() roles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of roles elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildPruneCountMono withRoles(@Nullable Iterable<? extends Snowflake> elements) {
    if (this.roles == elements) return this;
    Set<Snowflake> newValue = elements == null ? null : createUnmodifiableSet(createSafeList(elements, true, false));
    return new GuildPruneCountMono(this.days, newValue, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildPruneCountMono#guild() guild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guild
   * @return A modified copy of the {@code this} object
   */
  public final GuildPruneCountMono withGuild(Guild value) {
    if (this.guild == value) return this;
    Guild newValue = Objects.requireNonNull(value, "guild");
    return new GuildPruneCountMono(this.days, this.roles, newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildPruneCountMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildPruneCountMono
        && equalTo(0, (GuildPruneCountMono) another);
  }

  private boolean equalTo(int synthetic, GuildPruneCountMono another) {
    return days.equals(another.days)
        && Objects.equals(roles, another.roles)
        && guild.equals(another.guild);
  }

  /**
   * Computes a hash code from attributes: {@code days}, {@code roles}, {@code guild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + days.hashCode();
    h += (h << 5) + Objects.hashCode(roles);
    h += (h << 5) + guild.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildPruneCountMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildPruneCountMono{"
        + "days=" + days
        + ", roles=" + roles
        + ", guild=" + guild
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildPruneCountMono} instance.
   * @param days The value for the {@code days} attribute
   * @param guild The value for the {@code guild} attribute
   * @return An immutable GuildPruneCountMono instance
   */
  public static GuildPruneCountMono of(Integer days, Guild guild) {
    return new GuildPruneCountMono(days, guild);
  }

  /**
   * Creates an immutable copy of a {@link GuildPruneCountMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildPruneCountMono instance
   */
  static GuildPruneCountMono copyOf(GuildPruneCountMonoGenerator instance) {
    if (instance instanceof GuildPruneCountMono) {
      return (GuildPruneCountMono) instance;
    }
    return GuildPruneCountMono.of(instance.days(), instance.guild())
        .withRoles(instance.roles());
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
