package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.discordjson.possible.Possible;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildMemberEditSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GuildMemberEditSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code GuildMemberEditSpec.create()}.
 */
@Generated(from = "GuildMemberEditSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildMemberEditSpec implements GuildMemberEditSpecGenerator {
  private final @Nullable String reason;
  private final Snowflake newVoiceChannel_value;
  private final boolean newVoiceChannel_absent;
  private final Boolean mute_value;
  private final boolean mute_absent;
  private final Boolean deafen_value;
  private final boolean deafen_absent;
  private final String nickname_value;
  private final boolean nickname_absent;
  private final List<Snowflake> roles_value;
  private final boolean roles_absent;
  private final Instant communicationDisabledUntil_value;
  private final boolean communicationDisabledUntil_absent;

  private GuildMemberEditSpec() {
    this.reason = null;
    Possible<Optional<Snowflake>> newVoiceChannel$impl = Possible.absent();
    Possible<Boolean> mute$impl = Possible.absent();
    Possible<Boolean> deafen$impl = Possible.absent();
    Possible<Optional<String>> nickname$impl = Possible.absent();
    Possible<List<Snowflake>> roles$impl = Possible.absent();
    Possible<Optional<Instant>> communicationDisabledUntil$impl = Possible.absent();
    this.newVoiceChannel_value = Possible.flatOpt(newVoiceChannel$impl).orElse(null);
    this.newVoiceChannel_absent = newVoiceChannel$impl.isAbsent();
    this.mute_value = mute$impl.toOptional().orElse(null);
    this.mute_absent = mute$impl.isAbsent();
    this.deafen_value = deafen$impl.toOptional().orElse(null);
    this.deafen_absent = deafen$impl.isAbsent();
    this.nickname_value = Possible.flatOpt(nickname$impl).orElse(null);
    this.nickname_absent = nickname$impl.isAbsent();
    this.roles_value = roles$impl.toOptional().orElse(null);
    this.roles_absent = roles$impl.isAbsent();
    this.communicationDisabledUntil_value = Possible.flatOpt(communicationDisabledUntil$impl).orElse(null);
    this.communicationDisabledUntil_absent = communicationDisabledUntil$impl.isAbsent();
    this.initShim = null;
  }

  private GuildMemberEditSpec(
      @Nullable String reason,
      Possible<Optional<Snowflake>> newVoiceChannel,
      Possible<Boolean> mute,
      Possible<Boolean> deafen,
      Possible<Optional<String>> nickname,
      Possible<List<Snowflake>> roles,
      Possible<Optional<Instant>> communicationDisabledUntil) {
    this.reason = reason;
    Possible<Optional<Snowflake>> newVoiceChannel$impl = newVoiceChannel;
    Possible<Boolean> mute$impl = mute;
    Possible<Boolean> deafen$impl = deafen;
    Possible<Optional<String>> nickname$impl = nickname;
    Possible<List<Snowflake>> roles$impl = roles;
    Possible<Optional<Instant>> communicationDisabledUntil$impl = communicationDisabledUntil;
    this.newVoiceChannel_value = Possible.flatOpt(newVoiceChannel$impl).orElse(null);
    this.newVoiceChannel_absent = newVoiceChannel$impl.isAbsent();
    this.mute_value = mute$impl.toOptional().orElse(null);
    this.mute_absent = mute$impl.isAbsent();
    this.deafen_value = deafen$impl.toOptional().orElse(null);
    this.deafen_absent = deafen$impl.isAbsent();
    this.nickname_value = Possible.flatOpt(nickname$impl).orElse(null);
    this.nickname_absent = nickname$impl.isAbsent();
    this.roles_value = roles$impl.toOptional().orElse(null);
    this.roles_absent = roles$impl.isAbsent();
    this.communicationDisabledUntil_value = Possible.flatOpt(communicationDisabledUntil$impl).orElse(null);
    this.communicationDisabledUntil_absent = communicationDisabledUntil$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildMemberEditSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildMemberEditSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code newVoiceChannel} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> newVoiceChannel() {
    return newVoiceChannel_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(newVoiceChannel_value));
  }

  /**
   * @return The value of the {@code mute} attribute
   */
  @Override
  public Possible<Boolean> mute() {
    return mute_absent ? Possible.absent() : Possible.of(mute_value);
  }

  /**
   * @return The value of the {@code deafen} attribute
   */
  @Override
  public Possible<Boolean> deafen() {
    return deafen_absent ? Possible.absent() : Possible.of(deafen_value);
  }

  /**
   * @return The value of the {@code nickname} attribute
   */
  @Override
  public Possible<Optional<String>> nickname() {
    return nickname_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(nickname_value));
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public Possible<List<Snowflake>> roles() {
    return roles_absent ? Possible.absent() :
        Possible.of(roles_value);
  }

  /**
   * @return The value of the {@code communicationDisabledUntil} attribute
   */
  @Override
  public Possible<Optional<Instant>> communicationDisabledUntil() {
    return communicationDisabledUntil_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(communicationDisabledUntil_value));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildMemberEditSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildMemberEditSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return validate(new GuildMemberEditSpec(
        value,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil()));
  }

  public GuildMemberEditSpec withNewVoiceChannel(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return validate(new GuildMemberEditSpec(
        this.reason,
        newValue,
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil()));
  }

  @Deprecated
  public GuildMemberEditSpec withNewVoiceChannel(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildMemberEditSpec(
        this.reason,
        newValue,
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil()));
  }

  public GuildMemberEditSpec withNewVoiceChannelOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildMemberEditSpec(
        this.reason,
        newValue,
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil()));
  }

  public GuildMemberEditSpec withMute(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        newValue,
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil()));
  }

  public GuildMemberEditSpec withMute(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        newValue,
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil()));
  }

  public GuildMemberEditSpec withDeafen(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        newValue,
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil()));
  }

  public GuildMemberEditSpec withDeafen(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        newValue,
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil()));
  }

  public GuildMemberEditSpec withNickname(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        newValue,
        this.roles(),
        this.communicationDisabledUntil()));
  }

  @Deprecated
  public GuildMemberEditSpec withNickname(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        newValue,
        this.roles(),
        this.communicationDisabledUntil()));
  }

  public GuildMemberEditSpec withNicknameOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        newValue,
        this.roles(),
        this.communicationDisabledUntil()));
  }

  public GuildMemberEditSpec withRoles(Possible<List<Snowflake>> possible) {
    Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        newValue,
        this.communicationDisabledUntil()));
  }

  public GuildMemberEditSpec withRoles(Iterable<Snowflake> elements) {
    Possible<List<Snowflake>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        newValue,
        this.communicationDisabledUntil()));
  }

  @SafeVarargs
  public final GuildMemberEditSpec withRoles(Snowflake... elements) {
    Possible<List<Snowflake>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        newValue,
        this.communicationDisabledUntil()));
  }

  public GuildMemberEditSpec withCommunicationDisabledUntil(Possible<Optional<Instant>> value) {
    Possible<Optional<Instant>> newValue = Objects.requireNonNull(value);
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        newValue));
  }

  @Deprecated
  public GuildMemberEditSpec withCommunicationDisabledUntil(@Nullable Instant value) {
    Possible<Optional<Instant>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        newValue));
  }

  public GuildMemberEditSpec withCommunicationDisabledUntilOrNull(@Nullable Instant value) {
    Possible<Optional<Instant>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildMemberEditSpec(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code GuildMemberEditSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildMemberEditSpec
        && equalTo(0, (GuildMemberEditSpec) another);
  }

  private boolean equalTo(int synthetic, GuildMemberEditSpec another) {
    return Objects.equals(reason, another.reason)
        && this.newVoiceChannel().equals(another.newVoiceChannel())
        && this.mute().equals(another.mute())
        && this.deafen().equals(another.deafen())
        && this.nickname().equals(another.nickname())
        && Objects.equals(roles_value, another.roles_value)
        && this.communicationDisabledUntil().equals(another.communicationDisabledUntil());
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code newVoiceChannel}, {@code mute}, {@code deafen}, {@code nickname}, {@code roles}, {@code communicationDisabledUntil}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (newVoiceChannel().hashCode());
    h += (h << 5) + (mute().hashCode());
    h += (h << 5) + (deafen().hashCode());
    h += (h << 5) + (nickname().hashCode());
    h += (h << 5) + (Objects.hashCode(roles_value));
    h += (h << 5) + (communicationDisabledUntil().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code GuildMemberEditSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildMemberEditSpec{"
        + "reason=" + reason
        + ", newVoiceChannel=" + (newVoiceChannel().toString())
        + ", mute=" + (mute().toString())
        + ", deafen=" + (deafen().toString())
        + ", nickname=" + (nickname().toString())
        + ", roles=" + (Objects.toString(roles_value))
        + ", communicationDisabledUntil=" + (communicationDisabledUntil().toString())
        + "}";
  }

  private static final GuildMemberEditSpec INSTANCE = validate(new GuildMemberEditSpec());

  /**
   * Returns the default immutable singleton value of {@code GuildMemberEditSpec}
   * @return An immutable instance of GuildMemberEditSpec
   */
  public static GuildMemberEditSpec create() {
    return INSTANCE;
  }

  private static GuildMemberEditSpec validate(GuildMemberEditSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link GuildMemberEditSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildMemberEditSpec instance
   */
  static GuildMemberEditSpec copyOf(GuildMemberEditSpecGenerator instance) {
    if (instance instanceof GuildMemberEditSpec) {
      return (GuildMemberEditSpec) instance;
    }
    return GuildMemberEditSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isNewVoiceChannelPresent() {
    return !newVoiceChannel_absent;
  }

  public Snowflake newVoiceChannelOrElse(Snowflake defaultValue) {
    return !newVoiceChannel_absent ? newVoiceChannel_value : defaultValue;
  }

  public boolean isMutePresent() {
    return !mute_absent;
  }

  public Boolean muteOrElse(Boolean defaultValue) {
    return !mute_absent ? mute_value : defaultValue;
  }

  public boolean isDeafenPresent() {
    return !deafen_absent;
  }

  public Boolean deafenOrElse(Boolean defaultValue) {
    return !deafen_absent ? deafen_value : defaultValue;
  }

  public boolean isNicknamePresent() {
    return !nickname_absent;
  }

  public String nicknameOrElse(String defaultValue) {
    return !nickname_absent ? nickname_value : defaultValue;
  }

  public boolean isRolesPresent() {
    return !roles_absent;
  }

  public List<Snowflake> rolesOrElse(List<Snowflake> defaultValue) {
    return !roles_absent ? roles_value : defaultValue;
  }

  public boolean isCommunicationDisabledUntilPresent() {
    return !communicationDisabledUntil_absent;
  }

  public Instant communicationDisabledUntilOrElse(Instant defaultValue) {
    return !communicationDisabledUntil_absent ? communicationDisabledUntil_value : defaultValue;
  }

  /**
   * Creates a builder for {@link GuildMemberEditSpec GuildMemberEditSpec}.
   * <pre>
   * GuildMemberEditSpec.builder()
   *    .reason(String | null) // nullable {@link GuildMemberEditSpec#reason() reason}
   *    .newVoiceChannel(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.common.util.Snowflake&amp;gt;&amp;gt;) // {@link GuildMemberEditSpec#newVoiceChannel() newVoiceChannel}
   *    .mute(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link GuildMemberEditSpec#mute() mute}
   *    .deafen(discord4j.discordjson.possible.Possible&amp;lt;Boolean&amp;gt;) // {@link GuildMemberEditSpec#deafen() deafen}
   *    .nickname(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;String&amp;gt;&amp;gt;) // {@link GuildMemberEditSpec#nickname() nickname}
   *    .roles(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.common.util.Snowflake&amp;gt;&amp;gt;) // {@link GuildMemberEditSpec#roles() roles}
   *    .communicationDisabledUntil(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;java.time.Instant&amp;gt;&amp;gt;) // {@link GuildMemberEditSpec#communicationDisabledUntil() communicationDisabledUntil}
   *    .build();
   * </pre>
   * @return A new GuildMemberEditSpec builder
   */
  public static GuildMemberEditSpec.Builder builder() {
    return new GuildMemberEditSpec.Builder();
  }

  /**
   * Builds instances of type {@link GuildMemberEditSpec GuildMemberEditSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GuildMemberEditSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<Optional<Snowflake>> newVoiceChannel_possible = Possible.absent();
    private Possible<Boolean> mute_possible = Possible.absent();
    private Possible<Boolean> deafen_possible = Possible.absent();
    private Possible<Optional<String>> nickname_possible = Possible.absent();
    private List<Snowflake> roles_list = null;
    private Possible<Optional<Instant>> communicationDisabledUntil_possible = Possible.absent();
    private String reason;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GuildMemberEditSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GuildMemberEditSpec instance) {
      return from((GuildMemberEditSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code GuildMemberEditSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(GuildMemberEditSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      newVoiceChannel(instance.newVoiceChannel());
      mute(instance.mute());
      deafen(instance.deafen());
      nickname(instance.nickname());
      roles(instance.roles());
      communicationDisabledUntil(instance.communicationDisabledUntil());
      return this;
    }

    /**
     * Initializes the value for the {@link GuildMemberEditSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder newVoiceChannel(Possible<Optional<Snowflake>> value) {
      this.newVoiceChannel_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder newVoiceChannel(@Nullable Snowflake value) {
      this.newVoiceChannel_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder newVoiceChannelOrNull(@Nullable Snowflake value) {
      this.newVoiceChannel_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder mute(Possible<Boolean> value) {
      this.mute_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder mute(Boolean value) {
      this.mute_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder deafen(Possible<Boolean> value) {
      this.deafen_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder deafen(Boolean value) {
      this.deafen_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder nickname(Possible<Optional<String>> value) {
      this.nickname_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder nickname(@Nullable String value) {
      this.nickname_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder nicknameOrNull(@Nullable String value) {
      this.nickname_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addRole(Snowflake element) {
      roles_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllRoles(List<Snowflake> elements) {
      roles_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder roles(Possible<List<Snowflake>> elements) {
      this.roles_list = null;
      elements.toOptional().ifPresent(e -> roles_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder roles(List<Snowflake> elements) {
      this.roles_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder roles(Iterable<Snowflake> elements) {
      this.roles_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder communicationDisabledUntil(Possible<Optional<Instant>> value) {
      this.communicationDisabledUntil_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder communicationDisabledUntil(@Nullable Instant value) {
      this.communicationDisabledUntil_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder communicationDisabledUntilOrNull(@Nullable Instant value) {
      this.communicationDisabledUntil_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    /**
     * Builds a new {@link GuildMemberEditSpec GuildMemberEditSpec}.
     * @return An immutable instance of GuildMemberEditSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GuildMemberEditSpec build() {
      return GuildMemberEditSpec.validate(new GuildMemberEditSpec(
          reason,
          newVoiceChannel_build(),
          mute_build(),
          deafen_build(),
          nickname_build(),
          roles_build(),
          communicationDisabledUntil_build()));
    }

    private Possible<Optional<Snowflake>> newVoiceChannel_build() {
      return this.newVoiceChannel_possible;
    }

    private Possible<Boolean> mute_build() {
      return this.mute_possible;
    }

    private Possible<Boolean> deafen_build() {
      return this.deafen_possible;
    }

    private Possible<Optional<String>> nickname_build() {
      return this.nickname_possible;
    }

    private Possible<List<Snowflake>> roles_build() {
      return this.roles_list == null ? Possible.absent() :
          Possible.of(this.roles_list);
    }

    private List<Snowflake> roles_getOrCreate() {
      if (this.roles_list == null) {
        this.roles_list = new ArrayList<>();
      }
      return this.roles_list;
    }

    private Possible<Optional<Instant>> communicationDisabledUntil_build() {
      return this.communicationDisabledUntil_possible;
    }
  }
}
