package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.PartialMember;
import discord4j.discordjson.possible.Possible;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildMemberEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code GuildMemberEditMono.of()}.
 */
@Generated(from = "GuildMemberEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildMemberEditMono extends GuildMemberEditMonoGenerator {
  private final @Nullable String reason;
  private final Snowflake newVoiceChannel_value;
  private final boolean newVoiceChannel_absent;
  private final Boolean mute_value;
  private final boolean mute_absent;
  private final Boolean deafen_value;
  private final boolean deafen_absent;
  private final String nickname_value;
  private final boolean nickname_absent;
  private final List<Snowflake> roles_value;
  private final boolean roles_absent;
  private final Instant communicationDisabledUntil_value;
  private final boolean communicationDisabledUntil_absent;
  private final PartialMember member;

  private GuildMemberEditMono(PartialMember member) {
    this.member = Objects.requireNonNull(member, "member");
    this.reason = null;
    Possible<Optional<Snowflake>> newVoiceChannel$impl = Possible.absent();
    Possible<Boolean> mute$impl = Possible.absent();
    Possible<Boolean> deafen$impl = Possible.absent();
    Possible<Optional<String>> nickname$impl = Possible.absent();
    Possible<List<Snowflake>> roles$impl = Possible.absent();
    Possible<Optional<Instant>> communicationDisabledUntil$impl = Possible.absent();
    this.newVoiceChannel_value = Possible.flatOpt(newVoiceChannel$impl).orElse(null);
    this.newVoiceChannel_absent = newVoiceChannel$impl.isAbsent();
    this.mute_value = mute$impl.toOptional().orElse(null);
    this.mute_absent = mute$impl.isAbsent();
    this.deafen_value = deafen$impl.toOptional().orElse(null);
    this.deafen_absent = deafen$impl.isAbsent();
    this.nickname_value = Possible.flatOpt(nickname$impl).orElse(null);
    this.nickname_absent = nickname$impl.isAbsent();
    this.roles_value = roles$impl.toOptional().orElse(null);
    this.roles_absent = roles$impl.isAbsent();
    this.communicationDisabledUntil_value = Possible.flatOpt(communicationDisabledUntil$impl).orElse(null);
    this.communicationDisabledUntil_absent = communicationDisabledUntil$impl.isAbsent();
    this.initShim = null;
  }

  private GuildMemberEditMono(
      @Nullable String reason,
      Possible<Optional<Snowflake>> newVoiceChannel,
      Possible<Boolean> mute,
      Possible<Boolean> deafen,
      Possible<Optional<String>> nickname,
      Possible<List<Snowflake>> roles,
      Possible<Optional<Instant>> communicationDisabledUntil,
      PartialMember member) {
    this.reason = reason;
    Possible<Optional<Snowflake>> newVoiceChannel$impl = newVoiceChannel;
    Possible<Boolean> mute$impl = mute;
    Possible<Boolean> deafen$impl = deafen;
    Possible<Optional<String>> nickname$impl = nickname;
    Possible<List<Snowflake>> roles$impl = roles;
    Possible<Optional<Instant>> communicationDisabledUntil$impl = communicationDisabledUntil;
    this.member = member;
    this.newVoiceChannel_value = Possible.flatOpt(newVoiceChannel$impl).orElse(null);
    this.newVoiceChannel_absent = newVoiceChannel$impl.isAbsent();
    this.mute_value = mute$impl.toOptional().orElse(null);
    this.mute_absent = mute$impl.isAbsent();
    this.deafen_value = deafen$impl.toOptional().orElse(null);
    this.deafen_absent = deafen$impl.isAbsent();
    this.nickname_value = Possible.flatOpt(nickname$impl).orElse(null);
    this.nickname_absent = nickname$impl.isAbsent();
    this.roles_value = roles$impl.toOptional().orElse(null);
    this.roles_absent = roles$impl.isAbsent();
    this.communicationDisabledUntil_value = Possible.flatOpt(communicationDisabledUntil$impl).orElse(null);
    this.communicationDisabledUntil_absent = communicationDisabledUntil$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildMemberEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildMemberEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code newVoiceChannel} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> newVoiceChannel() {
    return newVoiceChannel_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(newVoiceChannel_value));
  }

  /**
   * @return The value of the {@code mute} attribute
   */
  @Override
  public Possible<Boolean> mute() {
    return mute_absent ? Possible.absent() : Possible.of(mute_value);
  }

  /**
   * @return The value of the {@code deafen} attribute
   */
  @Override
  public Possible<Boolean> deafen() {
    return deafen_absent ? Possible.absent() : Possible.of(deafen_value);
  }

  /**
   * @return The value of the {@code nickname} attribute
   */
  @Override
  public Possible<Optional<String>> nickname() {
    return nickname_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(nickname_value));
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public Possible<List<Snowflake>> roles() {
    return roles_absent ? Possible.absent() :
        Possible.of(roles_value);
  }

  /**
   * @return The value of the {@code communicationDisabledUntil} attribute
   */
  @Override
  public Possible<Optional<Instant>> communicationDisabledUntil() {
    return communicationDisabledUntil_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(communicationDisabledUntil_value));
  }

  /**
   * @return The value of the {@code member} attribute
   */
  @Override
  public PartialMember member() {
    return member;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildMemberEditMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildMemberEditMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new GuildMemberEditMono(
        value,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil(),
        this.member);
  }

  public GuildMemberEditMono withNewVoiceChannel(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return new GuildMemberEditMono(
        this.reason,
        newValue,
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil(),
        this.member);
  }

  @Deprecated
  public GuildMemberEditMono withNewVoiceChannel(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildMemberEditMono(
        this.reason,
        newValue,
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil(),
        this.member);
  }

  public GuildMemberEditMono withNewVoiceChannelOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildMemberEditMono(
        this.reason,
        newValue,
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil(),
        this.member);
  }

  public GuildMemberEditMono withMute(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        newValue,
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil(),
        this.member);
  }

  public GuildMemberEditMono withMute(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        newValue,
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil(),
        this.member);
  }

  public GuildMemberEditMono withDeafen(Possible<Boolean> value) {
    Possible<Boolean> newValue = Objects.requireNonNull(value);
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        newValue,
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil(),
        this.member);
  }

  public GuildMemberEditMono withDeafen(Boolean value) {
    Possible<Boolean> newValue = Possible.of(value);
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        newValue,
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil(),
        this.member);
  }

  public GuildMemberEditMono withNickname(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        newValue,
        this.roles(),
        this.communicationDisabledUntil(),
        this.member);
  }

  @Deprecated
  public GuildMemberEditMono withNickname(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        newValue,
        this.roles(),
        this.communicationDisabledUntil(),
        this.member);
  }

  public GuildMemberEditMono withNicknameOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        newValue,
        this.roles(),
        this.communicationDisabledUntil(),
        this.member);
  }

  public GuildMemberEditMono withRoles(Possible<List<Snowflake>> possible) {
    Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        newValue,
        this.communicationDisabledUntil(),
        this.member);
  }

  public GuildMemberEditMono withRoles(Iterable<Snowflake> elements) {
    Possible<List<Snowflake>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        newValue,
        this.communicationDisabledUntil(),
        this.member);
  }

  @SafeVarargs
  public final GuildMemberEditMono withRoles(Snowflake... elements) {
    Possible<List<Snowflake>> newValue = Possible.of(Arrays.asList(elements));
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        newValue,
        this.communicationDisabledUntil(),
        this.member);
  }

  public GuildMemberEditMono withCommunicationDisabledUntil(Possible<Optional<Instant>> value) {
    Possible<Optional<Instant>> newValue = Objects.requireNonNull(value);
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        newValue,
        this.member);
  }

  @Deprecated
  public GuildMemberEditMono withCommunicationDisabledUntil(@Nullable Instant value) {
    Possible<Optional<Instant>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        newValue,
        this.member);
  }

  public GuildMemberEditMono withCommunicationDisabledUntilOrNull(@Nullable Instant value) {
    Possible<Optional<Instant>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        newValue,
        this.member);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildMemberEditMono#member() member} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for member
   * @return A modified copy of the {@code this} object
   */
  public final GuildMemberEditMono withMember(PartialMember value) {
    if (this.member == value) return this;
    PartialMember newValue = Objects.requireNonNull(value, "member");
    return new GuildMemberEditMono(
        this.reason,
        this.newVoiceChannel(),
        this.mute(),
        this.deafen(),
        this.nickname(),
        this.roles(),
        this.communicationDisabledUntil(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildMemberEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildMemberEditMono
        && equalTo(0, (GuildMemberEditMono) another);
  }

  private boolean equalTo(int synthetic, GuildMemberEditMono another) {
    return Objects.equals(reason, another.reason)
        && this.newVoiceChannel().equals(another.newVoiceChannel())
        && this.mute().equals(another.mute())
        && this.deafen().equals(another.deafen())
        && this.nickname().equals(another.nickname())
        && Objects.equals(roles_value, another.roles_value)
        && this.communicationDisabledUntil().equals(another.communicationDisabledUntil())
        && member.equals(another.member);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code newVoiceChannel}, {@code mute}, {@code deafen}, {@code nickname}, {@code roles}, {@code communicationDisabledUntil}, {@code member}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (newVoiceChannel().hashCode());
    h += (h << 5) + (mute().hashCode());
    h += (h << 5) + (deafen().hashCode());
    h += (h << 5) + (nickname().hashCode());
    h += (h << 5) + (Objects.hashCode(roles_value));
    h += (h << 5) + (communicationDisabledUntil().hashCode());
    h += (h << 5) + member.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildMemberEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildMemberEditMono{"
        + "reason=" + reason
        + ", newVoiceChannel=" + (newVoiceChannel().toString())
        + ", mute=" + (mute().toString())
        + ", deafen=" + (deafen().toString())
        + ", nickname=" + (nickname().toString())
        + ", roles=" + (Objects.toString(roles_value))
        + ", communicationDisabledUntil=" + (communicationDisabledUntil().toString())
        + ", member=" + member
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildMemberEditMono} instance.
   * @param member The value for the {@code member} attribute
   * @return An immutable GuildMemberEditMono instance
   */
  public static GuildMemberEditMono of(PartialMember member) {
    return new GuildMemberEditMono(member);
  }

  /**
   * Creates an immutable copy of a {@link GuildMemberEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildMemberEditMono instance
   */
  static GuildMemberEditMono copyOf(GuildMemberEditMonoGenerator instance) {
    if (instance instanceof GuildMemberEditMono) {
      return (GuildMemberEditMono) instance;
    }
    return GuildMemberEditMono.of(instance.member())
        .withReason(instance.reason())
        .withNewVoiceChannel(instance.newVoiceChannel())
        .withMute(instance.mute())
        .withDeafen(instance.deafen())
        .withNickname(instance.nickname())
        .withRoles(instance.roles())
        .withCommunicationDisabledUntil(instance.communicationDisabledUntil());
  }

  public boolean isNewVoiceChannelPresent() {
    return !newVoiceChannel_absent;
  }

  public Snowflake newVoiceChannelOrElse(Snowflake defaultValue) {
    return !newVoiceChannel_absent ? newVoiceChannel_value : defaultValue;
  }

  public boolean isMutePresent() {
    return !mute_absent;
  }

  public Boolean muteOrElse(Boolean defaultValue) {
    return !mute_absent ? mute_value : defaultValue;
  }

  public boolean isDeafenPresent() {
    return !deafen_absent;
  }

  public Boolean deafenOrElse(Boolean defaultValue) {
    return !deafen_absent ? deafen_value : defaultValue;
  }

  public boolean isNicknamePresent() {
    return !nickname_absent;
  }

  public String nicknameOrElse(String defaultValue) {
    return !nickname_absent ? nickname_value : defaultValue;
  }

  public boolean isRolesPresent() {
    return !roles_absent;
  }

  public List<Snowflake> rolesOrElse(List<Snowflake> defaultValue) {
    return !roles_absent ? roles_value : defaultValue;
  }

  public boolean isCommunicationDisabledUntilPresent() {
    return !communicationDisabledUntil_absent;
  }

  public Instant communicationDisabledUntilOrElse(Instant defaultValue) {
    return !communicationDisabledUntil_absent ? communicationDisabledUntil_value : defaultValue;
  }
}
