package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildEmojiEditSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GuildEmojiEditSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code GuildEmojiEditSpec.create()}.
 */
@Generated(from = "GuildEmojiEditSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildEmojiEditSpec implements GuildEmojiEditSpecGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final List<Snowflake> roles_value;
  private final boolean roles_absent;

  private GuildEmojiEditSpec() {
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<List<Snowflake>> roles$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.roles_value = roles$impl.toOptional().orElse(null);
    this.roles_absent = roles$impl.isAbsent();
    this.initShim = null;
  }

  private GuildEmojiEditSpec(
      @Nullable String reason,
      Possible<String> name,
      Possible<List<Snowflake>> roles) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<List<Snowflake>> roles$impl = roles;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.roles_value = roles$impl.toOptional().orElse(null);
    this.roles_absent = roles$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildEmojiEditSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildEmojiEditSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public Possible<List<Snowflake>> roles() {
    return roles_absent ? Possible.absent() :
        Possible.of(roles_value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEmojiEditSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildEmojiEditSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return validate(new GuildEmojiEditSpec(value, this.name(), this.roles()));
  }

  public GuildEmojiEditSpec withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new GuildEmojiEditSpec(this.reason, newValue, this.roles()));
  }

  public GuildEmojiEditSpec withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new GuildEmojiEditSpec(this.reason, newValue, this.roles()));
  }

  public GuildEmojiEditSpec withRoles(Possible<List<Snowflake>> possible) {
    Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
    return validate(new GuildEmojiEditSpec(this.reason, this.name(), newValue));
  }

  public GuildEmojiEditSpec withRoles(Iterable<Snowflake> elements) {
    Possible<List<Snowflake>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new GuildEmojiEditSpec(this.reason, this.name(), newValue));
  }

  @SafeVarargs
  public final GuildEmojiEditSpec withRoles(Snowflake... elements) {
    Possible<List<Snowflake>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new GuildEmojiEditSpec(this.reason, this.name(), newValue));
  }

  /**
   * This instance is equal to all instances of {@code GuildEmojiEditSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildEmojiEditSpec
        && equalTo(0, (GuildEmojiEditSpec) another);
  }

  private boolean equalTo(int synthetic, GuildEmojiEditSpec another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && Objects.equals(roles_value, another.roles_value);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code roles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (Objects.hashCode(roles_value));
    return h;
  }

  /**
   * Prints the immutable value {@code GuildEmojiEditSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildEmojiEditSpec{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", roles=" + (Objects.toString(roles_value))
        + "}";
  }

  private static final GuildEmojiEditSpec INSTANCE = validate(new GuildEmojiEditSpec());

  /**
   * Returns the default immutable singleton value of {@code GuildEmojiEditSpec}
   * @return An immutable instance of GuildEmojiEditSpec
   */
  public static GuildEmojiEditSpec create() {
    return INSTANCE;
  }

  private static GuildEmojiEditSpec validate(GuildEmojiEditSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link GuildEmojiEditSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildEmojiEditSpec instance
   */
  static GuildEmojiEditSpec copyOf(GuildEmojiEditSpecGenerator instance) {
    if (instance instanceof GuildEmojiEditSpec) {
      return (GuildEmojiEditSpec) instance;
    }
    return GuildEmojiEditSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isRolesPresent() {
    return !roles_absent;
  }

  public List<Snowflake> rolesOrElse(List<Snowflake> defaultValue) {
    return !roles_absent ? roles_value : defaultValue;
  }

  /**
   * Creates a builder for {@link GuildEmojiEditSpec GuildEmojiEditSpec}.
   * <pre>
   * GuildEmojiEditSpec.builder()
   *    .reason(String | null) // nullable {@link GuildEmojiEditSpec#reason() reason}
   *    .name(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link GuildEmojiEditSpec#name() name}
   *    .roles(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.common.util.Snowflake&amp;gt;&amp;gt;) // {@link GuildEmojiEditSpec#roles() roles}
   *    .build();
   * </pre>
   * @return A new GuildEmojiEditSpec builder
   */
  public static GuildEmojiEditSpec.Builder builder() {
    return new GuildEmojiEditSpec.Builder();
  }

  /**
   * Builds instances of type {@link GuildEmojiEditSpec GuildEmojiEditSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GuildEmojiEditSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<String> name_possible = Possible.absent();
    private List<Snowflake> roles_list = null;
    private String reason;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GuildEmojiEditSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GuildEmojiEditSpec instance) {
      return from((GuildEmojiEditSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code GuildEmojiEditSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(GuildEmojiEditSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      name(instance.name());
      roles(instance.roles());
      return this;
    }

    /**
     * Initializes the value for the {@link GuildEmojiEditSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(Possible<String> value) {
      this.name_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(String value) {
      this.name_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addRole(Snowflake element) {
      roles_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllRoles(List<Snowflake> elements) {
      roles_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder roles(Possible<List<Snowflake>> elements) {
      this.roles_list = null;
      elements.toOptional().ifPresent(e -> roles_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder roles(List<Snowflake> elements) {
      this.roles_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder roles(Iterable<Snowflake> elements) {
      this.roles_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    /**
     * Builds a new {@link GuildEmojiEditSpec GuildEmojiEditSpec}.
     * @return An immutable instance of GuildEmojiEditSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GuildEmojiEditSpec build() {
      return GuildEmojiEditSpec.validate(new GuildEmojiEditSpec(reason, name_build(), roles_build()));
    }

    private Possible<String> name_build() {
      return this.name_possible;
    }

    private Possible<List<Snowflake>> roles_build() {
      return this.roles_list == null ? Possible.absent() :
          Possible.of(this.roles_list);
    }

    private List<Snowflake> roles_getOrCreate() {
      if (this.roles_list == null) {
        this.roles_list = new ArrayList<>();
      }
      return this.roles_list;
    }
  }
}
