package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildEmojiEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code GuildEmojiEditMono.of()}.
 */
@Generated(from = "GuildEmojiEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildEmojiEditMono extends GuildEmojiEditMonoGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final List<Snowflake> roles_value;
  private final boolean roles_absent;
  private final GuildEmoji guildEmoji;

  private GuildEmojiEditMono(GuildEmoji guildEmoji) {
    this.guildEmoji = Objects.requireNonNull(guildEmoji, "guildEmoji");
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<List<Snowflake>> roles$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.roles_value = roles$impl.toOptional().orElse(null);
    this.roles_absent = roles$impl.isAbsent();
    this.initShim = null;
  }

  private GuildEmojiEditMono(
      @Nullable String reason,
      Possible<String> name,
      Possible<List<Snowflake>> roles,
      GuildEmoji guildEmoji) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<List<Snowflake>> roles$impl = roles;
    this.guildEmoji = guildEmoji;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.roles_value = roles$impl.toOptional().orElse(null);
    this.roles_absent = roles$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildEmojiEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildEmojiEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public Possible<List<Snowflake>> roles() {
    return roles_absent ? Possible.absent() :
        Possible.of(roles_value);
  }

  /**
   * @return The value of the {@code guildEmoji} attribute
   */
  @Override
  public GuildEmoji guildEmoji() {
    return guildEmoji;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEmojiEditMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildEmojiEditMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new GuildEmojiEditMono(value, this.name(), this.roles(), this.guildEmoji);
  }

  public GuildEmojiEditMono withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new GuildEmojiEditMono(this.reason, newValue, this.roles(), this.guildEmoji);
  }

  public GuildEmojiEditMono withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return new GuildEmojiEditMono(this.reason, newValue, this.roles(), this.guildEmoji);
  }

  public GuildEmojiEditMono withRoles(Possible<List<Snowflake>> possible) {
    Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
    return new GuildEmojiEditMono(this.reason, this.name(), newValue, this.guildEmoji);
  }

  public GuildEmojiEditMono withRoles(Iterable<Snowflake> elements) {
    Possible<List<Snowflake>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new GuildEmojiEditMono(this.reason, this.name(), newValue, this.guildEmoji);
  }

  @SafeVarargs
  public final GuildEmojiEditMono withRoles(Snowflake... elements) {
    Possible<List<Snowflake>> newValue = Possible.of(Arrays.asList(elements));
    return new GuildEmojiEditMono(this.reason, this.name(), newValue, this.guildEmoji);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEmojiEditMono#guildEmoji() guildEmoji} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guildEmoji
   * @return A modified copy of the {@code this} object
   */
  public final GuildEmojiEditMono withGuildEmoji(GuildEmoji value) {
    if (this.guildEmoji == value) return this;
    GuildEmoji newValue = Objects.requireNonNull(value, "guildEmoji");
    return new GuildEmojiEditMono(this.reason, this.name(), this.roles(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildEmojiEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildEmojiEditMono
        && equalTo(0, (GuildEmojiEditMono) another);
  }

  private boolean equalTo(int synthetic, GuildEmojiEditMono another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && Objects.equals(roles_value, another.roles_value)
        && guildEmoji.equals(another.guildEmoji);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code roles}, {@code guildEmoji}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (Objects.hashCode(roles_value));
    h += (h << 5) + guildEmoji.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildEmojiEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildEmojiEditMono{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", roles=" + (Objects.toString(roles_value))
        + ", guildEmoji=" + guildEmoji
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildEmojiEditMono} instance.
   * @param guildEmoji The value for the {@code guildEmoji} attribute
   * @return An immutable GuildEmojiEditMono instance
   */
  public static GuildEmojiEditMono of(GuildEmoji guildEmoji) {
    return new GuildEmojiEditMono(guildEmoji);
  }

  /**
   * Creates an immutable copy of a {@link GuildEmojiEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildEmojiEditMono instance
   */
  static GuildEmojiEditMono copyOf(GuildEmojiEditMonoGenerator instance) {
    if (instance instanceof GuildEmojiEditMono) {
      return (GuildEmojiEditMono) instance;
    }
    return GuildEmojiEditMono.of(instance.guildEmoji())
        .withReason(instance.reason())
        .withName(instance.name())
        .withRoles(instance.roles());
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isRolesPresent() {
    return !roles_absent;
  }

  public List<Snowflake> rolesOrElse(List<Snowflake> defaultValue) {
    return !roles_absent ? roles_value : defaultValue;
  }
}
