package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildEmojiCreateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GuildEmojiCreateSpec.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code GuildEmojiCreateSpec.of()}.
 */
@Generated(from = "GuildEmojiCreateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildEmojiCreateSpec implements GuildEmojiCreateSpecGenerator {
  private final @Nullable String reason;
  private final String name;
  private final Image image;
  private final List<Snowflake> roles;

  private GuildEmojiCreateSpec(String name, Image image) {
    this.name = Objects.requireNonNull(name, "name");
    this.image = Objects.requireNonNull(image, "image");
    this.reason = null;
    this.roles = createUnmodifiableList(false, createSafeList(GuildEmojiCreateSpecGenerator.super.roles(), true, false));
  }

  private GuildEmojiCreateSpec(GuildEmojiCreateSpec.Builder builder) {
    this.reason = builder.reason;
    this.name = builder.name;
    this.image = builder.image;
    this.roles = builder.rolesIsSet()
        ? createUnmodifiableList(true, builder.roles)
        : createUnmodifiableList(false, createSafeList(GuildEmojiCreateSpecGenerator.super.roles(), true, false));
  }

  private GuildEmojiCreateSpec(
      @Nullable String reason,
      String name,
      Image image,
      List<Snowflake> roles) {
    this.reason = reason;
    this.name = name;
    this.image = image;
    this.roles = roles;
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code image} attribute
   */
  @Override
  public Image image() {
    return image;
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public List<Snowflake> roles() {
    return roles;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEmojiCreateSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildEmojiCreateSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new GuildEmojiCreateSpec(value, this.name, this.image, this.roles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEmojiCreateSpec#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final GuildEmojiCreateSpec withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new GuildEmojiCreateSpec(this.reason, newValue, this.image, this.roles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEmojiCreateSpec#image() image} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for image
   * @return A modified copy of the {@code this} object
   */
  public final GuildEmojiCreateSpec withImage(Image value) {
    if (this.image == value) return this;
    Image newValue = Objects.requireNonNull(value, "image");
    return new GuildEmojiCreateSpec(this.reason, this.name, newValue, this.roles);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildEmojiCreateSpec#roles() roles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildEmojiCreateSpec withRoles(Snowflake... elements) {
    List<Snowflake> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new GuildEmojiCreateSpec(this.reason, this.name, this.image, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildEmojiCreateSpec#roles() roles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of roles elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildEmojiCreateSpec withRoles(Iterable<? extends Snowflake> elements) {
    if (this.roles == elements) return this;
    List<Snowflake> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new GuildEmojiCreateSpec(this.reason, this.name, this.image, newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildEmojiCreateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildEmojiCreateSpec
        && equalTo(0, (GuildEmojiCreateSpec) another);
  }

  private boolean equalTo(int synthetic, GuildEmojiCreateSpec another) {
    return Objects.equals(reason, another.reason)
        && name.equals(another.name)
        && image.equals(another.image)
        && roles.equals(another.roles);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code image}, {@code roles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + image.hashCode();
    h += (h << 5) + roles.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildEmojiCreateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildEmojiCreateSpec{"
        + "reason=" + reason
        + ", name=" + name
        + ", image=" + image
        + ", roles=" + roles
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildEmojiCreateSpec} instance.
   * @param name The value for the {@code name} attribute
   * @param image The value for the {@code image} attribute
   * @return An immutable GuildEmojiCreateSpec instance
   */
  public static GuildEmojiCreateSpec of(String name, Image image) {
    return new GuildEmojiCreateSpec(name, image);
  }

  /**
   * Creates an immutable copy of a {@link GuildEmojiCreateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildEmojiCreateSpec instance
   */
  static GuildEmojiCreateSpec copyOf(GuildEmojiCreateSpecGenerator instance) {
    if (instance instanceof GuildEmojiCreateSpec) {
      return (GuildEmojiCreateSpec) instance;
    }
    return GuildEmojiCreateSpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link GuildEmojiCreateSpec GuildEmojiCreateSpec}.
   * <pre>
   * GuildEmojiCreateSpec.builder()
   *    .reason(String | null) // nullable {@link GuildEmojiCreateSpec#reason() reason}
   *    .name(String) // required {@link GuildEmojiCreateSpec#name() name}
   *    .image(discord4j.rest.util.Image) // required {@link GuildEmojiCreateSpec#image() image}
   *    .addRole|addAllRoles(discord4j.common.util.Snowflake) // {@link GuildEmojiCreateSpec#roles() roles} elements
   *    .build();
   * </pre>
   * @return A new GuildEmojiCreateSpec builder
   */
  public static GuildEmojiCreateSpec.Builder builder() {
    return new GuildEmojiCreateSpec.Builder();
  }

  /**
   * Builds instances of type {@link GuildEmojiCreateSpec GuildEmojiCreateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GuildEmojiCreateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_IMAGE = 0x2L;
    private static final long OPT_BIT_ROLES = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private String reason;
    private String name;
    private Image image;
    private List<Snowflake> roles = new ArrayList<Snowflake>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GuildEmojiCreateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GuildEmojiCreateSpec instance) {
      return from((GuildEmojiCreateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code GuildEmojiCreateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(GuildEmojiCreateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      name(instance.name());
      image(instance.image());
      addAllRoles(instance.roles());
      return this;
    }

    /**
     * Initializes the value for the {@link GuildEmojiCreateSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the value for the {@link GuildEmojiCreateSpec#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link GuildEmojiCreateSpec#image() image} attribute.
     * @param image The value for image 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder image(Image image) {
      this.image = Objects.requireNonNull(image, "image");
      initBits &= ~INIT_BIT_IMAGE;
      return this;
    }

    /**
     * Adds one element to {@link GuildEmojiCreateSpec#roles() roles} list.
     * @param element A roles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRole(Snowflake element) {
      this.roles.add(Objects.requireNonNull(element, "roles element"));
      optBits |= OPT_BIT_ROLES;
      return this;
    }

    /**
     * Adds elements to {@link GuildEmojiCreateSpec#roles() roles} list.
     * @param elements An array of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRoles(Snowflake... elements) {
      for (Snowflake element : elements) {
        this.roles.add(Objects.requireNonNull(element, "roles element"));
      }
      optBits |= OPT_BIT_ROLES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GuildEmojiCreateSpec#roles() roles} list.
     * @param elements An iterable of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder roles(Iterable<? extends Snowflake> elements) {
      this.roles.clear();
      return addAllRoles(elements);
    }

    /**
     * Adds elements to {@link GuildEmojiCreateSpec#roles() roles} list.
     * @param elements An iterable of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRoles(Iterable<? extends Snowflake> elements) {
      for (Snowflake element : elements) {
        this.roles.add(Objects.requireNonNull(element, "roles element"));
      }
      optBits |= OPT_BIT_ROLES;
      return this;
    }

    /**
     * Builds a new {@link GuildEmojiCreateSpec GuildEmojiCreateSpec}.
     * @return An immutable instance of GuildEmojiCreateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GuildEmojiCreateSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GuildEmojiCreateSpec(this);
    }

    private boolean rolesIsSet() {
      return (optBits & OPT_BIT_ROLES) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_IMAGE) != 0) attributes.add("image");
      return "Cannot build GuildEmojiCreateSpec, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
