package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildEmojiCreateMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code GuildEmojiCreateMono.of()}.
 */
@Generated(from = "GuildEmojiCreateMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildEmojiCreateMono extends GuildEmojiCreateMonoGenerator {
  private final @Nullable String reason;
  private final String name;
  private final Image image;
  private final List<Snowflake> roles;
  private final Guild guild;

  private GuildEmojiCreateMono(String name, Image image, Guild guild) {
    this.name = Objects.requireNonNull(name, "name");
    this.image = Objects.requireNonNull(image, "image");
    this.guild = Objects.requireNonNull(guild, "guild");
    this.reason = null;
    this.roles = createUnmodifiableList(false, createSafeList(super.roles(), true, false));
  }

  private GuildEmojiCreateMono(
      @Nullable String reason,
      String name,
      Image image,
      List<Snowflake> roles,
      Guild guild) {
    this.reason = reason;
    this.name = name;
    this.image = image;
    this.roles = roles;
    this.guild = guild;
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code image} attribute
   */
  @Override
  public Image image() {
    return image;
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public List<Snowflake> roles() {
    return roles;
  }

  /**
   * @return The value of the {@code guild} attribute
   */
  @Override
  public Guild guild() {
    return guild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEmojiCreateMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildEmojiCreateMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new GuildEmojiCreateMono(value, this.name, this.image, this.roles, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEmojiCreateMono#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final GuildEmojiCreateMono withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new GuildEmojiCreateMono(this.reason, newValue, this.image, this.roles, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEmojiCreateMono#image() image} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for image
   * @return A modified copy of the {@code this} object
   */
  public final GuildEmojiCreateMono withImage(Image value) {
    if (this.image == value) return this;
    Image newValue = Objects.requireNonNull(value, "image");
    return new GuildEmojiCreateMono(this.reason, this.name, newValue, this.roles, this.guild);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildEmojiCreateMono#roles() roles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildEmojiCreateMono withRoles(Snowflake... elements) {
    List<Snowflake> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new GuildEmojiCreateMono(this.reason, this.name, this.image, newValue, this.guild);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildEmojiCreateMono#roles() roles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of roles elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildEmojiCreateMono withRoles(Iterable<? extends Snowflake> elements) {
    if (this.roles == elements) return this;
    List<Snowflake> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new GuildEmojiCreateMono(this.reason, this.name, this.image, newValue, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEmojiCreateMono#guild() guild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guild
   * @return A modified copy of the {@code this} object
   */
  public final GuildEmojiCreateMono withGuild(Guild value) {
    if (this.guild == value) return this;
    Guild newValue = Objects.requireNonNull(value, "guild");
    return new GuildEmojiCreateMono(this.reason, this.name, this.image, this.roles, newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildEmojiCreateMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildEmojiCreateMono
        && equalTo(0, (GuildEmojiCreateMono) another);
  }

  private boolean equalTo(int synthetic, GuildEmojiCreateMono another) {
    return Objects.equals(reason, another.reason)
        && name.equals(another.name)
        && image.equals(another.image)
        && roles.equals(another.roles)
        && guild.equals(another.guild);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code image}, {@code roles}, {@code guild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + image.hashCode();
    h += (h << 5) + roles.hashCode();
    h += (h << 5) + guild.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildEmojiCreateMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildEmojiCreateMono{"
        + "reason=" + reason
        + ", name=" + name
        + ", image=" + image
        + ", roles=" + roles
        + ", guild=" + guild
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildEmojiCreateMono} instance.
   * @param name The value for the {@code name} attribute
   * @param image The value for the {@code image} attribute
   * @param guild The value for the {@code guild} attribute
   * @return An immutable GuildEmojiCreateMono instance
   */
  public static GuildEmojiCreateMono of(String name, Image image, Guild guild) {
    return new GuildEmojiCreateMono(name, image, guild);
  }

  /**
   * Creates an immutable copy of a {@link GuildEmojiCreateMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildEmojiCreateMono instance
   */
  static GuildEmojiCreateMono copyOf(GuildEmojiCreateMonoGenerator instance) {
    if (instance instanceof GuildEmojiCreateMono) {
      return (GuildEmojiCreateMono) instance;
    }
    return GuildEmojiCreateMono.of(instance.name(), instance.image(), instance.guild())
        .withReason(instance.reason())
        .withRoles(instance.roles());
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
