package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildEditSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GuildEditSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code GuildEditSpec.create()}.
 */
@Generated(from = "GuildEditSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildEditSpec implements GuildEditSpecGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final Region region_value;
  private final boolean region_absent;
  private final Guild.VerificationLevel verificationLevel_value;
  private final boolean verificationLevel_absent;
  private final Guild.NotificationLevel defaultMessageNotificationsLevel_value;
  private final boolean defaultMessageNotificationsLevel_absent;
  private final Guild.ContentFilterLevel explicitContentFilter_value;
  private final boolean explicitContentFilter_absent;
  private final Snowflake afkChannelId_value;
  private final boolean afkChannelId_absent;
  private final Integer afkTimeout_value;
  private final boolean afkTimeout_absent;
  private final Image icon_value;
  private final boolean icon_absent;
  private final Snowflake ownerId_value;
  private final boolean ownerId_absent;
  private final Image splash_value;
  private final boolean splash_absent;
  private final Image discoverySplash_value;
  private final boolean discoverySplash_absent;
  private final Image banner_value;
  private final boolean banner_absent;
  private final Snowflake systemChannelId_value;
  private final boolean systemChannelId_absent;
  private final Guild.SystemChannelFlag systemChannelFlags_value;
  private final boolean systemChannelFlags_absent;
  private final Snowflake rulesChannelId_value;
  private final boolean rulesChannelId_absent;
  private final Snowflake publicUpdatesChannelId_value;
  private final boolean publicUpdatesChannelId_absent;
  private final Locale preferredLocale_value;
  private final boolean preferredLocale_absent;
  private final List<String> features_value;
  private final boolean features_absent;
  private final String description_value;
  private final boolean description_absent;

  private GuildEditSpec() {
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<Optional<Region>> region$impl = Possible.absent();
    Possible<Optional<Guild.VerificationLevel>> verificationLevel$impl = Possible.absent();
    Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel$impl = Possible.absent();
    Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter$impl = Possible.absent();
    Possible<Optional<Snowflake>> afkChannelId$impl = Possible.absent();
    Possible<Integer> afkTimeout$impl = Possible.absent();
    Possible<Optional<Image>> icon$impl = Possible.absent();
    Possible<Snowflake> ownerId$impl = Possible.absent();
    Possible<Optional<Image>> splash$impl = Possible.absent();
    Possible<Optional<Image>> discoverySplash$impl = Possible.absent();
    Possible<Optional<Image>> banner$impl = Possible.absent();
    Possible<Optional<Snowflake>> systemChannelId$impl = Possible.absent();
    Possible<Guild.SystemChannelFlag> systemChannelFlags$impl = Possible.absent();
    Possible<Optional<Snowflake>> rulesChannelId$impl = Possible.absent();
    Possible<Optional<Snowflake>> publicUpdatesChannelId$impl = Possible.absent();
    Possible<Optional<Locale>> preferredLocale$impl = Possible.absent();
    Possible<List<String>> features$impl = Possible.absent();
    Possible<Optional<String>> description$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.region_value = Possible.flatOpt(region$impl).orElse(null);
    this.region_absent = region$impl.isAbsent();
    this.verificationLevel_value = Possible.flatOpt(verificationLevel$impl).orElse(null);
    this.verificationLevel_absent = verificationLevel$impl.isAbsent();
    this.defaultMessageNotificationsLevel_value = Possible.flatOpt(defaultMessageNotificationsLevel$impl).orElse(null);
    this.defaultMessageNotificationsLevel_absent = defaultMessageNotificationsLevel$impl.isAbsent();
    this.explicitContentFilter_value = Possible.flatOpt(explicitContentFilter$impl).orElse(null);
    this.explicitContentFilter_absent = explicitContentFilter$impl.isAbsent();
    this.afkChannelId_value = Possible.flatOpt(afkChannelId$impl).orElse(null);
    this.afkChannelId_absent = afkChannelId$impl.isAbsent();
    this.afkTimeout_value = afkTimeout$impl.toOptional().orElse(null);
    this.afkTimeout_absent = afkTimeout$impl.isAbsent();
    this.icon_value = Possible.flatOpt(icon$impl).orElse(null);
    this.icon_absent = icon$impl.isAbsent();
    this.ownerId_value = ownerId$impl.toOptional().orElse(null);
    this.ownerId_absent = ownerId$impl.isAbsent();
    this.splash_value = Possible.flatOpt(splash$impl).orElse(null);
    this.splash_absent = splash$impl.isAbsent();
    this.discoverySplash_value = Possible.flatOpt(discoverySplash$impl).orElse(null);
    this.discoverySplash_absent = discoverySplash$impl.isAbsent();
    this.banner_value = Possible.flatOpt(banner$impl).orElse(null);
    this.banner_absent = banner$impl.isAbsent();
    this.systemChannelId_value = Possible.flatOpt(systemChannelId$impl).orElse(null);
    this.systemChannelId_absent = systemChannelId$impl.isAbsent();
    this.systemChannelFlags_value = systemChannelFlags$impl.toOptional().orElse(null);
    this.systemChannelFlags_absent = systemChannelFlags$impl.isAbsent();
    this.rulesChannelId_value = Possible.flatOpt(rulesChannelId$impl).orElse(null);
    this.rulesChannelId_absent = rulesChannelId$impl.isAbsent();
    this.publicUpdatesChannelId_value = Possible.flatOpt(publicUpdatesChannelId$impl).orElse(null);
    this.publicUpdatesChannelId_absent = publicUpdatesChannelId$impl.isAbsent();
    this.preferredLocale_value = Possible.flatOpt(preferredLocale$impl).orElse(null);
    this.preferredLocale_absent = preferredLocale$impl.isAbsent();
    this.features_value = features$impl.toOptional().orElse(null);
    this.features_absent = features$impl.isAbsent();
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private GuildEditSpec(
      @Nullable String reason,
      Possible<String> name,
      Possible<Optional<Region>> region,
      Possible<Optional<Guild.VerificationLevel>> verificationLevel,
      Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel,
      Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter,
      Possible<Optional<Snowflake>> afkChannelId,
      Possible<Integer> afkTimeout,
      Possible<Optional<Image>> icon,
      Possible<Snowflake> ownerId,
      Possible<Optional<Image>> splash,
      Possible<Optional<Image>> discoverySplash,
      Possible<Optional<Image>> banner,
      Possible<Optional<Snowflake>> systemChannelId,
      Possible<Guild.SystemChannelFlag> systemChannelFlags,
      Possible<Optional<Snowflake>> rulesChannelId,
      Possible<Optional<Snowflake>> publicUpdatesChannelId,
      Possible<Optional<Locale>> preferredLocale,
      Possible<List<String>> features,
      Possible<Optional<String>> description) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<Optional<Region>> region$impl = region;
    Possible<Optional<Guild.VerificationLevel>> verificationLevel$impl = verificationLevel;
    Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel$impl = defaultMessageNotificationsLevel;
    Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter$impl = explicitContentFilter;
    Possible<Optional<Snowflake>> afkChannelId$impl = afkChannelId;
    Possible<Integer> afkTimeout$impl = afkTimeout;
    Possible<Optional<Image>> icon$impl = icon;
    Possible<Snowflake> ownerId$impl = ownerId;
    Possible<Optional<Image>> splash$impl = splash;
    Possible<Optional<Image>> discoverySplash$impl = discoverySplash;
    Possible<Optional<Image>> banner$impl = banner;
    Possible<Optional<Snowflake>> systemChannelId$impl = systemChannelId;
    Possible<Guild.SystemChannelFlag> systemChannelFlags$impl = systemChannelFlags;
    Possible<Optional<Snowflake>> rulesChannelId$impl = rulesChannelId;
    Possible<Optional<Snowflake>> publicUpdatesChannelId$impl = publicUpdatesChannelId;
    Possible<Optional<Locale>> preferredLocale$impl = preferredLocale;
    Possible<List<String>> features$impl = features;
    Possible<Optional<String>> description$impl = description;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.region_value = Possible.flatOpt(region$impl).orElse(null);
    this.region_absent = region$impl.isAbsent();
    this.verificationLevel_value = Possible.flatOpt(verificationLevel$impl).orElse(null);
    this.verificationLevel_absent = verificationLevel$impl.isAbsent();
    this.defaultMessageNotificationsLevel_value = Possible.flatOpt(defaultMessageNotificationsLevel$impl).orElse(null);
    this.defaultMessageNotificationsLevel_absent = defaultMessageNotificationsLevel$impl.isAbsent();
    this.explicitContentFilter_value = Possible.flatOpt(explicitContentFilter$impl).orElse(null);
    this.explicitContentFilter_absent = explicitContentFilter$impl.isAbsent();
    this.afkChannelId_value = Possible.flatOpt(afkChannelId$impl).orElse(null);
    this.afkChannelId_absent = afkChannelId$impl.isAbsent();
    this.afkTimeout_value = afkTimeout$impl.toOptional().orElse(null);
    this.afkTimeout_absent = afkTimeout$impl.isAbsent();
    this.icon_value = Possible.flatOpt(icon$impl).orElse(null);
    this.icon_absent = icon$impl.isAbsent();
    this.ownerId_value = ownerId$impl.toOptional().orElse(null);
    this.ownerId_absent = ownerId$impl.isAbsent();
    this.splash_value = Possible.flatOpt(splash$impl).orElse(null);
    this.splash_absent = splash$impl.isAbsent();
    this.discoverySplash_value = Possible.flatOpt(discoverySplash$impl).orElse(null);
    this.discoverySplash_absent = discoverySplash$impl.isAbsent();
    this.banner_value = Possible.flatOpt(banner$impl).orElse(null);
    this.banner_absent = banner$impl.isAbsent();
    this.systemChannelId_value = Possible.flatOpt(systemChannelId$impl).orElse(null);
    this.systemChannelId_absent = systemChannelId$impl.isAbsent();
    this.systemChannelFlags_value = systemChannelFlags$impl.toOptional().orElse(null);
    this.systemChannelFlags_absent = systemChannelFlags$impl.isAbsent();
    this.rulesChannelId_value = Possible.flatOpt(rulesChannelId$impl).orElse(null);
    this.rulesChannelId_absent = rulesChannelId$impl.isAbsent();
    this.publicUpdatesChannelId_value = Possible.flatOpt(publicUpdatesChannelId$impl).orElse(null);
    this.publicUpdatesChannelId_absent = publicUpdatesChannelId$impl.isAbsent();
    this.preferredLocale_value = Possible.flatOpt(preferredLocale$impl).orElse(null);
    this.preferredLocale_absent = preferredLocale$impl.isAbsent();
    this.features_value = features$impl.toOptional().orElse(null);
    this.features_absent = features$impl.isAbsent();
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildEditSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildEditSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code region} attribute
   */
  @Override
  public Possible<Optional<Region>> region() {
    return region_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(region_value));
  }

  /**
   * @return The value of the {@code verificationLevel} attribute
   */
  @Override
  public Possible<Optional<Guild.VerificationLevel>> verificationLevel() {
    return verificationLevel_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(verificationLevel_value));
  }

  /**
   * @return The value of the {@code defaultMessageNotificationsLevel} attribute
   */
  @Override
  public Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel() {
    return defaultMessageNotificationsLevel_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(defaultMessageNotificationsLevel_value));
  }

  /**
   * @return The value of the {@code explicitContentFilter} attribute
   */
  @Override
  public Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter() {
    return explicitContentFilter_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(explicitContentFilter_value));
  }

  /**
   * @return The value of the {@code afkChannelId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> afkChannelId() {
    return afkChannelId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(afkChannelId_value));
  }

  /**
   * @return The value of the {@code afkTimeout} attribute
   */
  @Override
  public Possible<Integer> afkTimeout() {
    return afkTimeout_absent ? Possible.absent() : Possible.of(afkTimeout_value);
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @Override
  public Possible<Optional<Image>> icon() {
    return icon_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(icon_value));
  }

  /**
   * @return The value of the {@code ownerId} attribute
   */
  @Override
  public Possible<Snowflake> ownerId() {
    return ownerId_absent ? Possible.absent() : Possible.of(ownerId_value);
  }

  /**
   * @return The value of the {@code splash} attribute
   */
  @Override
  public Possible<Optional<Image>> splash() {
    return splash_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(splash_value));
  }

  /**
   * @return The value of the {@code discoverySplash} attribute
   */
  @Override
  public Possible<Optional<Image>> discoverySplash() {
    return discoverySplash_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(discoverySplash_value));
  }

  /**
   * @return The value of the {@code banner} attribute
   */
  @Override
  public Possible<Optional<Image>> banner() {
    return banner_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(banner_value));
  }

  /**
   * @return The value of the {@code systemChannelId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> systemChannelId() {
    return systemChannelId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(systemChannelId_value));
  }

  /**
   * @return The value of the {@code systemChannelFlags} attribute
   */
  @Override
  public Possible<Guild.SystemChannelFlag> systemChannelFlags() {
    return systemChannelFlags_absent ? Possible.absent() : Possible.of(systemChannelFlags_value);
  }

  /**
   * @return The value of the {@code rulesChannelId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> rulesChannelId() {
    return rulesChannelId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(rulesChannelId_value));
  }

  /**
   * @return The value of the {@code publicUpdatesChannelId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> publicUpdatesChannelId() {
    return publicUpdatesChannelId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(publicUpdatesChannelId_value));
  }

  /**
   * @return The value of the {@code preferredLocale} attribute
   */
  @Override
  public Possible<Optional<Locale>> preferredLocale() {
    return preferredLocale_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(preferredLocale_value));
  }

  /**
   * @return The value of the {@code features} attribute
   */
  @Override
  public Possible<List<String>> features() {
    return features_absent ? Possible.absent() :
        Possible.of(features_value);
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public Possible<Optional<String>> description() {
    return description_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(description_value));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEditSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildEditSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return validate(new GuildEditSpec(
        value,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        newValue,
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new GuildEditSpec(
        this.reason,
        newValue,
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withRegion(Possible<Optional<Region>> value) {
    Possible<Optional<Region>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        newValue,
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withRegion(@Nullable Region value) {
    Possible<Optional<Region>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        newValue,
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withRegionOrNull(@Nullable Region value) {
    Possible<Optional<Region>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        newValue,
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withVerificationLevel(Possible<Optional<Guild.VerificationLevel>> value) {
    Possible<Optional<Guild.VerificationLevel>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        newValue,
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withVerificationLevel(@Nullable Guild.VerificationLevel value) {
    Possible<Optional<Guild.VerificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        newValue,
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withVerificationLevelOrNull(@Nullable Guild.VerificationLevel value) {
    Possible<Optional<Guild.VerificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        newValue,
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withDefaultMessageNotificationsLevel(Possible<Optional<Guild.NotificationLevel>> value) {
    Possible<Optional<Guild.NotificationLevel>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        newValue,
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withDefaultMessageNotificationsLevel(@Nullable Guild.NotificationLevel value) {
    Possible<Optional<Guild.NotificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        newValue,
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withDefaultMessageNotificationsLevelOrNull(@Nullable Guild.NotificationLevel value) {
    Possible<Optional<Guild.NotificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        newValue,
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withExplicitContentFilter(Possible<Optional<Guild.ContentFilterLevel>> value) {
    Possible<Optional<Guild.ContentFilterLevel>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        newValue,
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withExplicitContentFilter(@Nullable Guild.ContentFilterLevel value) {
    Possible<Optional<Guild.ContentFilterLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        newValue,
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withExplicitContentFilterOrNull(@Nullable Guild.ContentFilterLevel value) {
    Possible<Optional<Guild.ContentFilterLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        newValue,
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withAfkChannelId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        newValue,
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withAfkChannelId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        newValue,
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withAfkChannelIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        newValue,
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withAfkTimeout(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        newValue,
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withAfkTimeout(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        newValue,
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withIcon(Possible<Optional<Image>> value) {
    Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        newValue,
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withIcon(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        newValue,
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withIconOrNull(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        newValue,
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withOwnerId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        newValue,
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withOwnerId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        newValue,
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withSplash(Possible<Optional<Image>> value) {
    Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        newValue,
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withSplash(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        newValue,
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withSplashOrNull(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        newValue,
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withDiscoverySplash(Possible<Optional<Image>> value) {
    Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        newValue,
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withDiscoverySplash(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        newValue,
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withDiscoverySplashOrNull(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        newValue,
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withBanner(Possible<Optional<Image>> value) {
    Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        newValue,
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withBanner(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        newValue,
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withBannerOrNull(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        newValue,
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withSystemChannelId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        newValue,
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withSystemChannelId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        newValue,
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withSystemChannelIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        newValue,
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withSystemChannelFlags(Possible<Guild.SystemChannelFlag> value) {
    Possible<Guild.SystemChannelFlag> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        newValue,
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withSystemChannelFlags(Guild.SystemChannelFlag value) {
    Possible<Guild.SystemChannelFlag> newValue = Possible.of(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        newValue,
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withRulesChannelId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        newValue,
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withRulesChannelId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        newValue,
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withRulesChannelIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        newValue,
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withPublicUpdatesChannelId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        newValue,
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withPublicUpdatesChannelId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        newValue,
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withPublicUpdatesChannelIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        newValue,
        this.preferredLocale(),
        this.features(),
        this.description()));
  }

  public GuildEditSpec withPreferredLocale(Possible<Optional<Locale>> value) {
    Possible<Optional<Locale>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        newValue,
        this.features(),
        this.description()));
  }

  @Deprecated
  public GuildEditSpec withPreferredLocale(@Nullable Locale value) {
    Possible<Optional<Locale>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        newValue,
        this.features(),
        this.description()));
  }

  public GuildEditSpec withPreferredLocaleOrNull(@Nullable Locale value) {
    Possible<Optional<Locale>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        newValue,
        this.features(),
        this.description()));
  }

  public GuildEditSpec withFeatures(Possible<List<String>> possible) {
    Possible<List<String>> newValue = Objects.requireNonNull(possible);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        newValue,
        this.description()));
  }

  public GuildEditSpec withFeatures(Iterable<String> elements) {
    Possible<List<String>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        newValue,
        this.description()));
  }

  @SafeVarargs
  public final GuildEditSpec withFeatures(String... elements) {
    Possible<List<String>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        newValue,
        this.description()));
  }

  public GuildEditSpec withDescription(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        newValue));
  }

  @Deprecated
  public GuildEditSpec withDescription(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        newValue));
  }

  public GuildEditSpec withDescriptionOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new GuildEditSpec(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code GuildEditSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildEditSpec
        && equalTo(0, (GuildEditSpec) another);
  }

  private boolean equalTo(int synthetic, GuildEditSpec another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.region().equals(another.region())
        && this.verificationLevel().equals(another.verificationLevel())
        && this.defaultMessageNotificationsLevel().equals(another.defaultMessageNotificationsLevel())
        && this.explicitContentFilter().equals(another.explicitContentFilter())
        && this.afkChannelId().equals(another.afkChannelId())
        && this.afkTimeout().equals(another.afkTimeout())
        && this.icon().equals(another.icon())
        && this.ownerId().equals(another.ownerId())
        && this.splash().equals(another.splash())
        && this.discoverySplash().equals(another.discoverySplash())
        && this.banner().equals(another.banner())
        && this.systemChannelId().equals(another.systemChannelId())
        && this.systemChannelFlags().equals(another.systemChannelFlags())
        && this.rulesChannelId().equals(another.rulesChannelId())
        && this.publicUpdatesChannelId().equals(another.publicUpdatesChannelId())
        && this.preferredLocale().equals(another.preferredLocale())
        && Objects.equals(features_value, another.features_value)
        && this.description().equals(another.description());
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code region}, {@code verificationLevel}, {@code defaultMessageNotificationsLevel}, {@code explicitContentFilter}, {@code afkChannelId}, {@code afkTimeout}, {@code icon}, {@code ownerId}, {@code splash}, {@code discoverySplash}, {@code banner}, {@code systemChannelId}, {@code systemChannelFlags}, {@code rulesChannelId}, {@code publicUpdatesChannelId}, {@code preferredLocale}, {@code features}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (region().hashCode());
    h += (h << 5) + (verificationLevel().hashCode());
    h += (h << 5) + (defaultMessageNotificationsLevel().hashCode());
    h += (h << 5) + (explicitContentFilter().hashCode());
    h += (h << 5) + (afkChannelId().hashCode());
    h += (h << 5) + (afkTimeout().hashCode());
    h += (h << 5) + (icon().hashCode());
    h += (h << 5) + (ownerId().hashCode());
    h += (h << 5) + (splash().hashCode());
    h += (h << 5) + (discoverySplash().hashCode());
    h += (h << 5) + (banner().hashCode());
    h += (h << 5) + (systemChannelId().hashCode());
    h += (h << 5) + (systemChannelFlags().hashCode());
    h += (h << 5) + (rulesChannelId().hashCode());
    h += (h << 5) + (publicUpdatesChannelId().hashCode());
    h += (h << 5) + (preferredLocale().hashCode());
    h += (h << 5) + (Objects.hashCode(features_value));
    h += (h << 5) + (description().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code GuildEditSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildEditSpec{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", region=" + (region().toString())
        + ", verificationLevel=" + (verificationLevel().toString())
        + ", defaultMessageNotificationsLevel=" + (defaultMessageNotificationsLevel().toString())
        + ", explicitContentFilter=" + (explicitContentFilter().toString())
        + ", afkChannelId=" + (afkChannelId().toString())
        + ", afkTimeout=" + (afkTimeout().toString())
        + ", icon=" + (icon().toString())
        + ", ownerId=" + (ownerId().toString())
        + ", splash=" + (splash().toString())
        + ", discoverySplash=" + (discoverySplash().toString())
        + ", banner=" + (banner().toString())
        + ", systemChannelId=" + (systemChannelId().toString())
        + ", systemChannelFlags=" + (systemChannelFlags().toString())
        + ", rulesChannelId=" + (rulesChannelId().toString())
        + ", publicUpdatesChannelId=" + (publicUpdatesChannelId().toString())
        + ", preferredLocale=" + (preferredLocale().toString())
        + ", features=" + (Objects.toString(features_value))
        + ", description=" + (description().toString())
        + "}";
  }

  private static final GuildEditSpec INSTANCE = validate(new GuildEditSpec());

  /**
   * Returns the default immutable singleton value of {@code GuildEditSpec}
   * @return An immutable instance of GuildEditSpec
   */
  public static GuildEditSpec create() {
    return INSTANCE;
  }

  private static GuildEditSpec validate(GuildEditSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link GuildEditSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildEditSpec instance
   */
  static GuildEditSpec copyOf(GuildEditSpecGenerator instance) {
    if (instance instanceof GuildEditSpec) {
      return (GuildEditSpec) instance;
    }
    return GuildEditSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isRegionPresent() {
    return !region_absent;
  }

  public Region regionOrElse(Region defaultValue) {
    return !region_absent ? region_value : defaultValue;
  }

  public boolean isVerificationLevelPresent() {
    return !verificationLevel_absent;
  }

  public Guild.VerificationLevel verificationLevelOrElse(Guild.VerificationLevel defaultValue) {
    return !verificationLevel_absent ? verificationLevel_value : defaultValue;
  }

  public boolean isDefaultMessageNotificationsLevelPresent() {
    return !defaultMessageNotificationsLevel_absent;
  }

  public Guild.NotificationLevel defaultMessageNotificationsLevelOrElse(Guild.NotificationLevel defaultValue) {
    return !defaultMessageNotificationsLevel_absent ? defaultMessageNotificationsLevel_value : defaultValue;
  }

  public boolean isExplicitContentFilterPresent() {
    return !explicitContentFilter_absent;
  }

  public Guild.ContentFilterLevel explicitContentFilterOrElse(Guild.ContentFilterLevel defaultValue) {
    return !explicitContentFilter_absent ? explicitContentFilter_value : defaultValue;
  }

  public boolean isAfkChannelIdPresent() {
    return !afkChannelId_absent;
  }

  public Snowflake afkChannelIdOrElse(Snowflake defaultValue) {
    return !afkChannelId_absent ? afkChannelId_value : defaultValue;
  }

  public boolean isAfkTimeoutPresent() {
    return !afkTimeout_absent;
  }

  public Integer afkTimeoutOrElse(Integer defaultValue) {
    return !afkTimeout_absent ? afkTimeout_value : defaultValue;
  }

  public boolean isIconPresent() {
    return !icon_absent;
  }

  public Image iconOrElse(Image defaultValue) {
    return !icon_absent ? icon_value : defaultValue;
  }

  public boolean isOwnerIdPresent() {
    return !ownerId_absent;
  }

  public Snowflake ownerIdOrElse(Snowflake defaultValue) {
    return !ownerId_absent ? ownerId_value : defaultValue;
  }

  public boolean isSplashPresent() {
    return !splash_absent;
  }

  public Image splashOrElse(Image defaultValue) {
    return !splash_absent ? splash_value : defaultValue;
  }

  public boolean isDiscoverySplashPresent() {
    return !discoverySplash_absent;
  }

  public Image discoverySplashOrElse(Image defaultValue) {
    return !discoverySplash_absent ? discoverySplash_value : defaultValue;
  }

  public boolean isBannerPresent() {
    return !banner_absent;
  }

  public Image bannerOrElse(Image defaultValue) {
    return !banner_absent ? banner_value : defaultValue;
  }

  public boolean isSystemChannelIdPresent() {
    return !systemChannelId_absent;
  }

  public Snowflake systemChannelIdOrElse(Snowflake defaultValue) {
    return !systemChannelId_absent ? systemChannelId_value : defaultValue;
  }

  public boolean isSystemChannelFlagsPresent() {
    return !systemChannelFlags_absent;
  }

  public Guild.SystemChannelFlag systemChannelFlagsOrElse(Guild.SystemChannelFlag defaultValue) {
    return !systemChannelFlags_absent ? systemChannelFlags_value : defaultValue;
  }

  public boolean isRulesChannelIdPresent() {
    return !rulesChannelId_absent;
  }

  public Snowflake rulesChannelIdOrElse(Snowflake defaultValue) {
    return !rulesChannelId_absent ? rulesChannelId_value : defaultValue;
  }

  public boolean isPublicUpdatesChannelIdPresent() {
    return !publicUpdatesChannelId_absent;
  }

  public Snowflake publicUpdatesChannelIdOrElse(Snowflake defaultValue) {
    return !publicUpdatesChannelId_absent ? publicUpdatesChannelId_value : defaultValue;
  }

  public boolean isPreferredLocalePresent() {
    return !preferredLocale_absent;
  }

  public Locale preferredLocaleOrElse(Locale defaultValue) {
    return !preferredLocale_absent ? preferredLocale_value : defaultValue;
  }

  public boolean isFeaturesPresent() {
    return !features_absent;
  }

  public List<String> featuresOrElse(List<String> defaultValue) {
    return !features_absent ? features_value : defaultValue;
  }

  public boolean isDescriptionPresent() {
    return !description_absent;
  }

  public String descriptionOrElse(String defaultValue) {
    return !description_absent ? description_value : defaultValue;
  }

  /**
   * Creates a builder for {@link GuildEditSpec GuildEditSpec}.
   * <pre>
   * GuildEditSpec.builder()
   *    .reason(String | null) // nullable {@link GuildEditSpec#reason() reason}
   *    .name(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link GuildEditSpec#name() name}
   *    .region(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.core.object.Region&amp;gt;&amp;gt;) // {@link GuildEditSpec#region() region}
   *    .verificationLevel(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.core.object.entity.Guild.VerificationLevel&amp;gt;&amp;gt;) // {@link GuildEditSpec#verificationLevel() verificationLevel}
   *    .defaultMessageNotificationsLevel(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.core.object.entity.Guild.NotificationLevel&amp;gt;&amp;gt;) // {@link GuildEditSpec#defaultMessageNotificationsLevel() defaultMessageNotificationsLevel}
   *    .explicitContentFilter(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.core.object.entity.Guild.ContentFilterLevel&amp;gt;&amp;gt;) // {@link GuildEditSpec#explicitContentFilter() explicitContentFilter}
   *    .afkChannelId(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.common.util.Snowflake&amp;gt;&amp;gt;) // {@link GuildEditSpec#afkChannelId() afkChannelId}
   *    .afkTimeout(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link GuildEditSpec#afkTimeout() afkTimeout}
   *    .icon(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.rest.util.Image&amp;gt;&amp;gt;) // {@link GuildEditSpec#icon() icon}
   *    .ownerId(discord4j.discordjson.possible.Possible&amp;lt;discord4j.common.util.Snowflake&amp;gt;) // {@link GuildEditSpec#ownerId() ownerId}
   *    .splash(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.rest.util.Image&amp;gt;&amp;gt;) // {@link GuildEditSpec#splash() splash}
   *    .discoverySplash(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.rest.util.Image&amp;gt;&amp;gt;) // {@link GuildEditSpec#discoverySplash() discoverySplash}
   *    .banner(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.rest.util.Image&amp;gt;&amp;gt;) // {@link GuildEditSpec#banner() banner}
   *    .systemChannelId(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.common.util.Snowflake&amp;gt;&amp;gt;) // {@link GuildEditSpec#systemChannelId() systemChannelId}
   *    .systemChannelFlags(discord4j.discordjson.possible.Possible&amp;lt;discord4j.core.object.entity.Guild.SystemChannelFlag&amp;gt;) // {@link GuildEditSpec#systemChannelFlags() systemChannelFlags}
   *    .rulesChannelId(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.common.util.Snowflake&amp;gt;&amp;gt;) // {@link GuildEditSpec#rulesChannelId() rulesChannelId}
   *    .publicUpdatesChannelId(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.common.util.Snowflake&amp;gt;&amp;gt;) // {@link GuildEditSpec#publicUpdatesChannelId() publicUpdatesChannelId}
   *    .preferredLocale(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;Locale&amp;gt;&amp;gt;) // {@link GuildEditSpec#preferredLocale() preferredLocale}
   *    .features(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;String&amp;gt;&amp;gt;) // {@link GuildEditSpec#features() features}
   *    .description(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;String&amp;gt;&amp;gt;) // {@link GuildEditSpec#description() description}
   *    .build();
   * </pre>
   * @return A new GuildEditSpec builder
   */
  public static GuildEditSpec.Builder builder() {
    return new GuildEditSpec.Builder();
  }

  /**
   * Builds instances of type {@link GuildEditSpec GuildEditSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GuildEditSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<String> name_possible = Possible.absent();
    private Possible<Optional<Region>> region_possible = Possible.absent();
    private Possible<Optional<Guild.VerificationLevel>> verificationLevel_possible = Possible.absent();
    private Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel_possible = Possible.absent();
    private Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter_possible = Possible.absent();
    private Possible<Optional<Snowflake>> afkChannelId_possible = Possible.absent();
    private Possible<Integer> afkTimeout_possible = Possible.absent();
    private Possible<Optional<Image>> icon_possible = Possible.absent();
    private Possible<Snowflake> ownerId_possible = Possible.absent();
    private Possible<Optional<Image>> splash_possible = Possible.absent();
    private Possible<Optional<Image>> discoverySplash_possible = Possible.absent();
    private Possible<Optional<Image>> banner_possible = Possible.absent();
    private Possible<Optional<Snowflake>> systemChannelId_possible = Possible.absent();
    private Possible<Guild.SystemChannelFlag> systemChannelFlags_possible = Possible.absent();
    private Possible<Optional<Snowflake>> rulesChannelId_possible = Possible.absent();
    private Possible<Optional<Snowflake>> publicUpdatesChannelId_possible = Possible.absent();
    private Possible<Optional<Locale>> preferredLocale_possible = Possible.absent();
    private List<String> features_list = null;
    private Possible<Optional<String>> description_possible = Possible.absent();
    private String reason;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GuildEditSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GuildEditSpec instance) {
      return from((GuildEditSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code GuildEditSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(GuildEditSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      name(instance.name());
      region(instance.region());
      verificationLevel(instance.verificationLevel());
      defaultMessageNotificationsLevel(instance.defaultMessageNotificationsLevel());
      explicitContentFilter(instance.explicitContentFilter());
      afkChannelId(instance.afkChannelId());
      afkTimeout(instance.afkTimeout());
      icon(instance.icon());
      ownerId(instance.ownerId());
      splash(instance.splash());
      discoverySplash(instance.discoverySplash());
      banner(instance.banner());
      systemChannelId(instance.systemChannelId());
      systemChannelFlags(instance.systemChannelFlags());
      rulesChannelId(instance.rulesChannelId());
      publicUpdatesChannelId(instance.publicUpdatesChannelId());
      preferredLocale(instance.preferredLocale());
      features(instance.features());
      description(instance.description());
      return this;
    }

    /**
     * Initializes the value for the {@link GuildEditSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(Possible<String> value) {
      this.name_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(String value) {
      this.name_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder region(Possible<Optional<Region>> value) {
      this.region_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder region(@Nullable Region value) {
      this.region_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder regionOrNull(@Nullable Region value) {
      this.region_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder verificationLevel(Possible<Optional<Guild.VerificationLevel>> value) {
      this.verificationLevel_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder verificationLevel(@Nullable Guild.VerificationLevel value) {
      this.verificationLevel_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder verificationLevelOrNull(@Nullable Guild.VerificationLevel value) {
      this.verificationLevel_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder defaultMessageNotificationsLevel(Possible<Optional<Guild.NotificationLevel>> value) {
      this.defaultMessageNotificationsLevel_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder defaultMessageNotificationsLevel(@Nullable Guild.NotificationLevel value) {
      this.defaultMessageNotificationsLevel_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder defaultMessageNotificationsLevelOrNull(@Nullable Guild.NotificationLevel value) {
      this.defaultMessageNotificationsLevel_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder explicitContentFilter(Possible<Optional<Guild.ContentFilterLevel>> value) {
      this.explicitContentFilter_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder explicitContentFilter(@Nullable Guild.ContentFilterLevel value) {
      this.explicitContentFilter_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder explicitContentFilterOrNull(@Nullable Guild.ContentFilterLevel value) {
      this.explicitContentFilter_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder afkChannelId(Possible<Optional<Snowflake>> value) {
      this.afkChannelId_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder afkChannelId(@Nullable Snowflake value) {
      this.afkChannelId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder afkChannelIdOrNull(@Nullable Snowflake value) {
      this.afkChannelId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder afkTimeout(Possible<Integer> value) {
      this.afkTimeout_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder afkTimeout(Integer value) {
      this.afkTimeout_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder icon(Possible<Optional<Image>> value) {
      this.icon_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder icon(@Nullable Image value) {
      this.icon_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder iconOrNull(@Nullable Image value) {
      this.icon_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder ownerId(Possible<Snowflake> value) {
      this.ownerId_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder ownerId(Snowflake value) {
      this.ownerId_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder splash(Possible<Optional<Image>> value) {
      this.splash_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder splash(@Nullable Image value) {
      this.splash_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder splashOrNull(@Nullable Image value) {
      this.splash_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder discoverySplash(Possible<Optional<Image>> value) {
      this.discoverySplash_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder discoverySplash(@Nullable Image value) {
      this.discoverySplash_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder discoverySplashOrNull(@Nullable Image value) {
      this.discoverySplash_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder banner(Possible<Optional<Image>> value) {
      this.banner_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder banner(@Nullable Image value) {
      this.banner_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder bannerOrNull(@Nullable Image value) {
      this.banner_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder systemChannelId(Possible<Optional<Snowflake>> value) {
      this.systemChannelId_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder systemChannelId(@Nullable Snowflake value) {
      this.systemChannelId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder systemChannelIdOrNull(@Nullable Snowflake value) {
      this.systemChannelId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder systemChannelFlags(Possible<Guild.SystemChannelFlag> value) {
      this.systemChannelFlags_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder systemChannelFlags(Guild.SystemChannelFlag value) {
      this.systemChannelFlags_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder rulesChannelId(Possible<Optional<Snowflake>> value) {
      this.rulesChannelId_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder rulesChannelId(@Nullable Snowflake value) {
      this.rulesChannelId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder rulesChannelIdOrNull(@Nullable Snowflake value) {
      this.rulesChannelId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder publicUpdatesChannelId(Possible<Optional<Snowflake>> value) {
      this.publicUpdatesChannelId_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder publicUpdatesChannelId(@Nullable Snowflake value) {
      this.publicUpdatesChannelId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder publicUpdatesChannelIdOrNull(@Nullable Snowflake value) {
      this.publicUpdatesChannelId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder preferredLocale(Possible<Optional<Locale>> value) {
      this.preferredLocale_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder preferredLocale(@Nullable Locale value) {
      this.preferredLocale_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder preferredLocaleOrNull(@Nullable Locale value) {
      this.preferredLocale_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addFeature(String element) {
      features_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllFeatures(List<String> elements) {
      features_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder features(Possible<List<String>> elements) {
      this.features_list = null;
      elements.toOptional().ifPresent(e -> features_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder features(List<String> elements) {
      this.features_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder features(Iterable<String> elements) {
      this.features_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder description(Possible<Optional<String>> value) {
      this.description_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder description(@Nullable String value) {
      this.description_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder descriptionOrNull(@Nullable String value) {
      this.description_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    /**
     * Builds a new {@link GuildEditSpec GuildEditSpec}.
     * @return An immutable instance of GuildEditSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GuildEditSpec build() {
      return GuildEditSpec.validate(new GuildEditSpec(
          reason,
          name_build(),
          region_build(),
          verificationLevel_build(),
          defaultMessageNotificationsLevel_build(),
          explicitContentFilter_build(),
          afkChannelId_build(),
          afkTimeout_build(),
          icon_build(),
          ownerId_build(),
          splash_build(),
          discoverySplash_build(),
          banner_build(),
          systemChannelId_build(),
          systemChannelFlags_build(),
          rulesChannelId_build(),
          publicUpdatesChannelId_build(),
          preferredLocale_build(),
          features_build(),
          description_build()));
    }

    private Possible<String> name_build() {
      return this.name_possible;
    }

    private Possible<Optional<Region>> region_build() {
      return this.region_possible;
    }

    private Possible<Optional<Guild.VerificationLevel>> verificationLevel_build() {
      return this.verificationLevel_possible;
    }

    private Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel_build() {
      return this.defaultMessageNotificationsLevel_possible;
    }

    private Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter_build() {
      return this.explicitContentFilter_possible;
    }

    private Possible<Optional<Snowflake>> afkChannelId_build() {
      return this.afkChannelId_possible;
    }

    private Possible<Integer> afkTimeout_build() {
      return this.afkTimeout_possible;
    }

    private Possible<Optional<Image>> icon_build() {
      return this.icon_possible;
    }

    private Possible<Snowflake> ownerId_build() {
      return this.ownerId_possible;
    }

    private Possible<Optional<Image>> splash_build() {
      return this.splash_possible;
    }

    private Possible<Optional<Image>> discoverySplash_build() {
      return this.discoverySplash_possible;
    }

    private Possible<Optional<Image>> banner_build() {
      return this.banner_possible;
    }

    private Possible<Optional<Snowflake>> systemChannelId_build() {
      return this.systemChannelId_possible;
    }

    private Possible<Guild.SystemChannelFlag> systemChannelFlags_build() {
      return this.systemChannelFlags_possible;
    }

    private Possible<Optional<Snowflake>> rulesChannelId_build() {
      return this.rulesChannelId_possible;
    }

    private Possible<Optional<Snowflake>> publicUpdatesChannelId_build() {
      return this.publicUpdatesChannelId_possible;
    }

    private Possible<Optional<Locale>> preferredLocale_build() {
      return this.preferredLocale_possible;
    }

    private Possible<List<String>> features_build() {
      return this.features_list == null ? Possible.absent() :
          Possible.of(this.features_list);
    }

    private List<String> features_getOrCreate() {
      if (this.features_list == null) {
        this.features_list = new ArrayList<>();
      }
      return this.features_list;
    }

    private Possible<Optional<String>> description_build() {
      return this.description_possible;
    }
  }
}
