package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code GuildEditMono.of()}.
 */
@Generated(from = "GuildEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildEditMono extends GuildEditMonoGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final Region region_value;
  private final boolean region_absent;
  private final Guild.VerificationLevel verificationLevel_value;
  private final boolean verificationLevel_absent;
  private final Guild.NotificationLevel defaultMessageNotificationsLevel_value;
  private final boolean defaultMessageNotificationsLevel_absent;
  private final Guild.ContentFilterLevel explicitContentFilter_value;
  private final boolean explicitContentFilter_absent;
  private final Snowflake afkChannelId_value;
  private final boolean afkChannelId_absent;
  private final Integer afkTimeout_value;
  private final boolean afkTimeout_absent;
  private final Image icon_value;
  private final boolean icon_absent;
  private final Snowflake ownerId_value;
  private final boolean ownerId_absent;
  private final Image splash_value;
  private final boolean splash_absent;
  private final Image discoverySplash_value;
  private final boolean discoverySplash_absent;
  private final Image banner_value;
  private final boolean banner_absent;
  private final Snowflake systemChannelId_value;
  private final boolean systemChannelId_absent;
  private final Guild.SystemChannelFlag systemChannelFlags_value;
  private final boolean systemChannelFlags_absent;
  private final Snowflake rulesChannelId_value;
  private final boolean rulesChannelId_absent;
  private final Snowflake publicUpdatesChannelId_value;
  private final boolean publicUpdatesChannelId_absent;
  private final Locale preferredLocale_value;
  private final boolean preferredLocale_absent;
  private final List<String> features_value;
  private final boolean features_absent;
  private final String description_value;
  private final boolean description_absent;
  private final Guild guild;

  private GuildEditMono(Guild guild) {
    this.guild = Objects.requireNonNull(guild, "guild");
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<Optional<Region>> region$impl = Possible.absent();
    Possible<Optional<Guild.VerificationLevel>> verificationLevel$impl = Possible.absent();
    Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel$impl = Possible.absent();
    Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter$impl = Possible.absent();
    Possible<Optional<Snowflake>> afkChannelId$impl = Possible.absent();
    Possible<Integer> afkTimeout$impl = Possible.absent();
    Possible<Optional<Image>> icon$impl = Possible.absent();
    Possible<Snowflake> ownerId$impl = Possible.absent();
    Possible<Optional<Image>> splash$impl = Possible.absent();
    Possible<Optional<Image>> discoverySplash$impl = Possible.absent();
    Possible<Optional<Image>> banner$impl = Possible.absent();
    Possible<Optional<Snowflake>> systemChannelId$impl = Possible.absent();
    Possible<Guild.SystemChannelFlag> systemChannelFlags$impl = Possible.absent();
    Possible<Optional<Snowflake>> rulesChannelId$impl = Possible.absent();
    Possible<Optional<Snowflake>> publicUpdatesChannelId$impl = Possible.absent();
    Possible<Optional<Locale>> preferredLocale$impl = Possible.absent();
    Possible<List<String>> features$impl = Possible.absent();
    Possible<Optional<String>> description$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.region_value = Possible.flatOpt(region$impl).orElse(null);
    this.region_absent = region$impl.isAbsent();
    this.verificationLevel_value = Possible.flatOpt(verificationLevel$impl).orElse(null);
    this.verificationLevel_absent = verificationLevel$impl.isAbsent();
    this.defaultMessageNotificationsLevel_value = Possible.flatOpt(defaultMessageNotificationsLevel$impl).orElse(null);
    this.defaultMessageNotificationsLevel_absent = defaultMessageNotificationsLevel$impl.isAbsent();
    this.explicitContentFilter_value = Possible.flatOpt(explicitContentFilter$impl).orElse(null);
    this.explicitContentFilter_absent = explicitContentFilter$impl.isAbsent();
    this.afkChannelId_value = Possible.flatOpt(afkChannelId$impl).orElse(null);
    this.afkChannelId_absent = afkChannelId$impl.isAbsent();
    this.afkTimeout_value = afkTimeout$impl.toOptional().orElse(null);
    this.afkTimeout_absent = afkTimeout$impl.isAbsent();
    this.icon_value = Possible.flatOpt(icon$impl).orElse(null);
    this.icon_absent = icon$impl.isAbsent();
    this.ownerId_value = ownerId$impl.toOptional().orElse(null);
    this.ownerId_absent = ownerId$impl.isAbsent();
    this.splash_value = Possible.flatOpt(splash$impl).orElse(null);
    this.splash_absent = splash$impl.isAbsent();
    this.discoverySplash_value = Possible.flatOpt(discoverySplash$impl).orElse(null);
    this.discoverySplash_absent = discoverySplash$impl.isAbsent();
    this.banner_value = Possible.flatOpt(banner$impl).orElse(null);
    this.banner_absent = banner$impl.isAbsent();
    this.systemChannelId_value = Possible.flatOpt(systemChannelId$impl).orElse(null);
    this.systemChannelId_absent = systemChannelId$impl.isAbsent();
    this.systemChannelFlags_value = systemChannelFlags$impl.toOptional().orElse(null);
    this.systemChannelFlags_absent = systemChannelFlags$impl.isAbsent();
    this.rulesChannelId_value = Possible.flatOpt(rulesChannelId$impl).orElse(null);
    this.rulesChannelId_absent = rulesChannelId$impl.isAbsent();
    this.publicUpdatesChannelId_value = Possible.flatOpt(publicUpdatesChannelId$impl).orElse(null);
    this.publicUpdatesChannelId_absent = publicUpdatesChannelId$impl.isAbsent();
    this.preferredLocale_value = Possible.flatOpt(preferredLocale$impl).orElse(null);
    this.preferredLocale_absent = preferredLocale$impl.isAbsent();
    this.features_value = features$impl.toOptional().orElse(null);
    this.features_absent = features$impl.isAbsent();
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private GuildEditMono(
      @Nullable String reason,
      Possible<String> name,
      Possible<Optional<Region>> region,
      Possible<Optional<Guild.VerificationLevel>> verificationLevel,
      Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel,
      Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter,
      Possible<Optional<Snowflake>> afkChannelId,
      Possible<Integer> afkTimeout,
      Possible<Optional<Image>> icon,
      Possible<Snowflake> ownerId,
      Possible<Optional<Image>> splash,
      Possible<Optional<Image>> discoverySplash,
      Possible<Optional<Image>> banner,
      Possible<Optional<Snowflake>> systemChannelId,
      Possible<Guild.SystemChannelFlag> systemChannelFlags,
      Possible<Optional<Snowflake>> rulesChannelId,
      Possible<Optional<Snowflake>> publicUpdatesChannelId,
      Possible<Optional<Locale>> preferredLocale,
      Possible<List<String>> features,
      Possible<Optional<String>> description,
      Guild guild) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<Optional<Region>> region$impl = region;
    Possible<Optional<Guild.VerificationLevel>> verificationLevel$impl = verificationLevel;
    Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel$impl = defaultMessageNotificationsLevel;
    Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter$impl = explicitContentFilter;
    Possible<Optional<Snowflake>> afkChannelId$impl = afkChannelId;
    Possible<Integer> afkTimeout$impl = afkTimeout;
    Possible<Optional<Image>> icon$impl = icon;
    Possible<Snowflake> ownerId$impl = ownerId;
    Possible<Optional<Image>> splash$impl = splash;
    Possible<Optional<Image>> discoverySplash$impl = discoverySplash;
    Possible<Optional<Image>> banner$impl = banner;
    Possible<Optional<Snowflake>> systemChannelId$impl = systemChannelId;
    Possible<Guild.SystemChannelFlag> systemChannelFlags$impl = systemChannelFlags;
    Possible<Optional<Snowflake>> rulesChannelId$impl = rulesChannelId;
    Possible<Optional<Snowflake>> publicUpdatesChannelId$impl = publicUpdatesChannelId;
    Possible<Optional<Locale>> preferredLocale$impl = preferredLocale;
    Possible<List<String>> features$impl = features;
    Possible<Optional<String>> description$impl = description;
    this.guild = guild;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.region_value = Possible.flatOpt(region$impl).orElse(null);
    this.region_absent = region$impl.isAbsent();
    this.verificationLevel_value = Possible.flatOpt(verificationLevel$impl).orElse(null);
    this.verificationLevel_absent = verificationLevel$impl.isAbsent();
    this.defaultMessageNotificationsLevel_value = Possible.flatOpt(defaultMessageNotificationsLevel$impl).orElse(null);
    this.defaultMessageNotificationsLevel_absent = defaultMessageNotificationsLevel$impl.isAbsent();
    this.explicitContentFilter_value = Possible.flatOpt(explicitContentFilter$impl).orElse(null);
    this.explicitContentFilter_absent = explicitContentFilter$impl.isAbsent();
    this.afkChannelId_value = Possible.flatOpt(afkChannelId$impl).orElse(null);
    this.afkChannelId_absent = afkChannelId$impl.isAbsent();
    this.afkTimeout_value = afkTimeout$impl.toOptional().orElse(null);
    this.afkTimeout_absent = afkTimeout$impl.isAbsent();
    this.icon_value = Possible.flatOpt(icon$impl).orElse(null);
    this.icon_absent = icon$impl.isAbsent();
    this.ownerId_value = ownerId$impl.toOptional().orElse(null);
    this.ownerId_absent = ownerId$impl.isAbsent();
    this.splash_value = Possible.flatOpt(splash$impl).orElse(null);
    this.splash_absent = splash$impl.isAbsent();
    this.discoverySplash_value = Possible.flatOpt(discoverySplash$impl).orElse(null);
    this.discoverySplash_absent = discoverySplash$impl.isAbsent();
    this.banner_value = Possible.flatOpt(banner$impl).orElse(null);
    this.banner_absent = banner$impl.isAbsent();
    this.systemChannelId_value = Possible.flatOpt(systemChannelId$impl).orElse(null);
    this.systemChannelId_absent = systemChannelId$impl.isAbsent();
    this.systemChannelFlags_value = systemChannelFlags$impl.toOptional().orElse(null);
    this.systemChannelFlags_absent = systemChannelFlags$impl.isAbsent();
    this.rulesChannelId_value = Possible.flatOpt(rulesChannelId$impl).orElse(null);
    this.rulesChannelId_absent = rulesChannelId$impl.isAbsent();
    this.publicUpdatesChannelId_value = Possible.flatOpt(publicUpdatesChannelId$impl).orElse(null);
    this.publicUpdatesChannelId_absent = publicUpdatesChannelId$impl.isAbsent();
    this.preferredLocale_value = Possible.flatOpt(preferredLocale$impl).orElse(null);
    this.preferredLocale_absent = preferredLocale$impl.isAbsent();
    this.features_value = features$impl.toOptional().orElse(null);
    this.features_absent = features$impl.isAbsent();
    this.description_value = Possible.flatOpt(description$impl).orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code region} attribute
   */
  @Override
  public Possible<Optional<Region>> region() {
    return region_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(region_value));
  }

  /**
   * @return The value of the {@code verificationLevel} attribute
   */
  @Override
  public Possible<Optional<Guild.VerificationLevel>> verificationLevel() {
    return verificationLevel_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(verificationLevel_value));
  }

  /**
   * @return The value of the {@code defaultMessageNotificationsLevel} attribute
   */
  @Override
  public Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel() {
    return defaultMessageNotificationsLevel_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(defaultMessageNotificationsLevel_value));
  }

  /**
   * @return The value of the {@code explicitContentFilter} attribute
   */
  @Override
  public Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter() {
    return explicitContentFilter_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(explicitContentFilter_value));
  }

  /**
   * @return The value of the {@code afkChannelId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> afkChannelId() {
    return afkChannelId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(afkChannelId_value));
  }

  /**
   * @return The value of the {@code afkTimeout} attribute
   */
  @Override
  public Possible<Integer> afkTimeout() {
    return afkTimeout_absent ? Possible.absent() : Possible.of(afkTimeout_value);
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @Override
  public Possible<Optional<Image>> icon() {
    return icon_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(icon_value));
  }

  /**
   * @return The value of the {@code ownerId} attribute
   */
  @Override
  public Possible<Snowflake> ownerId() {
    return ownerId_absent ? Possible.absent() : Possible.of(ownerId_value);
  }

  /**
   * @return The value of the {@code splash} attribute
   */
  @Override
  public Possible<Optional<Image>> splash() {
    return splash_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(splash_value));
  }

  /**
   * @return The value of the {@code discoverySplash} attribute
   */
  @Override
  public Possible<Optional<Image>> discoverySplash() {
    return discoverySplash_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(discoverySplash_value));
  }

  /**
   * @return The value of the {@code banner} attribute
   */
  @Override
  public Possible<Optional<Image>> banner() {
    return banner_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(banner_value));
  }

  /**
   * @return The value of the {@code systemChannelId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> systemChannelId() {
    return systemChannelId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(systemChannelId_value));
  }

  /**
   * @return The value of the {@code systemChannelFlags} attribute
   */
  @Override
  public Possible<Guild.SystemChannelFlag> systemChannelFlags() {
    return systemChannelFlags_absent ? Possible.absent() : Possible.of(systemChannelFlags_value);
  }

  /**
   * @return The value of the {@code rulesChannelId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> rulesChannelId() {
    return rulesChannelId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(rulesChannelId_value));
  }

  /**
   * @return The value of the {@code publicUpdatesChannelId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> publicUpdatesChannelId() {
    return publicUpdatesChannelId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(publicUpdatesChannelId_value));
  }

  /**
   * @return The value of the {@code preferredLocale} attribute
   */
  @Override
  public Possible<Optional<Locale>> preferredLocale() {
    return preferredLocale_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(preferredLocale_value));
  }

  /**
   * @return The value of the {@code features} attribute
   */
  @Override
  public Possible<List<String>> features() {
    return features_absent ? Possible.absent() :
        Possible.of(features_value);
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public Possible<Optional<String>> description() {
    return description_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(description_value));
  }

  /**
   * @return The value of the {@code guild} attribute
   */
  @Override
  public Guild guild() {
    return guild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEditMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildEditMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new GuildEditMono(
        value,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        newValue,
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return new GuildEditMono(
        this.reason,
        newValue,
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withRegion(Possible<Optional<Region>> value) {
    Possible<Optional<Region>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        newValue,
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withRegion(@Nullable Region value) {
    Possible<Optional<Region>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        newValue,
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withRegionOrNull(@Nullable Region value) {
    Possible<Optional<Region>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        newValue,
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withVerificationLevel(Possible<Optional<Guild.VerificationLevel>> value) {
    Possible<Optional<Guild.VerificationLevel>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        newValue,
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withVerificationLevel(@Nullable Guild.VerificationLevel value) {
    Possible<Optional<Guild.VerificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        newValue,
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withVerificationLevelOrNull(@Nullable Guild.VerificationLevel value) {
    Possible<Optional<Guild.VerificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        newValue,
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withDefaultMessageNotificationsLevel(Possible<Optional<Guild.NotificationLevel>> value) {
    Possible<Optional<Guild.NotificationLevel>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        newValue,
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withDefaultMessageNotificationsLevel(@Nullable Guild.NotificationLevel value) {
    Possible<Optional<Guild.NotificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        newValue,
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withDefaultMessageNotificationsLevelOrNull(@Nullable Guild.NotificationLevel value) {
    Possible<Optional<Guild.NotificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        newValue,
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withExplicitContentFilter(Possible<Optional<Guild.ContentFilterLevel>> value) {
    Possible<Optional<Guild.ContentFilterLevel>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        newValue,
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withExplicitContentFilter(@Nullable Guild.ContentFilterLevel value) {
    Possible<Optional<Guild.ContentFilterLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        newValue,
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withExplicitContentFilterOrNull(@Nullable Guild.ContentFilterLevel value) {
    Possible<Optional<Guild.ContentFilterLevel>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        newValue,
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withAfkChannelId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        newValue,
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withAfkChannelId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        newValue,
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withAfkChannelIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        newValue,
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withAfkTimeout(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        newValue,
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withAfkTimeout(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        newValue,
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withIcon(Possible<Optional<Image>> value) {
    Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        newValue,
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withIcon(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        newValue,
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withIconOrNull(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        newValue,
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withOwnerId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        newValue,
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withOwnerId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        newValue,
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withSplash(Possible<Optional<Image>> value) {
    Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        newValue,
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withSplash(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        newValue,
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withSplashOrNull(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        newValue,
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withDiscoverySplash(Possible<Optional<Image>> value) {
    Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        newValue,
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withDiscoverySplash(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        newValue,
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withDiscoverySplashOrNull(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        newValue,
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withBanner(Possible<Optional<Image>> value) {
    Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        newValue,
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withBanner(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        newValue,
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withBannerOrNull(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        newValue,
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withSystemChannelId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        newValue,
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withSystemChannelId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        newValue,
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withSystemChannelIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        newValue,
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withSystemChannelFlags(Possible<Guild.SystemChannelFlag> value) {
    Possible<Guild.SystemChannelFlag> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        newValue,
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withSystemChannelFlags(Guild.SystemChannelFlag value) {
    Possible<Guild.SystemChannelFlag> newValue = Possible.of(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        newValue,
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withRulesChannelId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        newValue,
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withRulesChannelId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        newValue,
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withRulesChannelIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        newValue,
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withPublicUpdatesChannelId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        newValue,
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withPublicUpdatesChannelId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        newValue,
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withPublicUpdatesChannelIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        newValue,
        this.preferredLocale(),
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withPreferredLocale(Possible<Optional<Locale>> value) {
    Possible<Optional<Locale>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        newValue,
        this.features(),
        this.description(),
        this.guild);
  }

  @Deprecated
  public GuildEditMono withPreferredLocale(@Nullable Locale value) {
    Possible<Optional<Locale>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        newValue,
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withPreferredLocaleOrNull(@Nullable Locale value) {
    Possible<Optional<Locale>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        newValue,
        this.features(),
        this.description(),
        this.guild);
  }

  public GuildEditMono withFeatures(Possible<List<String>> possible) {
    Possible<List<String>> newValue = Objects.requireNonNull(possible);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        newValue,
        this.description(),
        this.guild);
  }

  public GuildEditMono withFeatures(Iterable<String> elements) {
    Possible<List<String>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        newValue,
        this.description(),
        this.guild);
  }

  @SafeVarargs
  public final GuildEditMono withFeatures(String... elements) {
    Possible<List<String>> newValue = Possible.of(Arrays.asList(elements));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        newValue,
        this.description(),
        this.guild);
  }

  public GuildEditMono withDescription(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        newValue,
        this.guild);
  }

  @Deprecated
  public GuildEditMono withDescription(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        newValue,
        this.guild);
  }

  public GuildEditMono withDescriptionOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        newValue,
        this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildEditMono#guild() guild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guild
   * @return A modified copy of the {@code this} object
   */
  public final GuildEditMono withGuild(Guild value) {
    if (this.guild == value) return this;
    Guild newValue = Objects.requireNonNull(value, "guild");
    return new GuildEditMono(
        this.reason,
        this.name(),
        this.region(),
        this.verificationLevel(),
        this.defaultMessageNotificationsLevel(),
        this.explicitContentFilter(),
        this.afkChannelId(),
        this.afkTimeout(),
        this.icon(),
        this.ownerId(),
        this.splash(),
        this.discoverySplash(),
        this.banner(),
        this.systemChannelId(),
        this.systemChannelFlags(),
        this.rulesChannelId(),
        this.publicUpdatesChannelId(),
        this.preferredLocale(),
        this.features(),
        this.description(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildEditMono
        && equalTo(0, (GuildEditMono) another);
  }

  private boolean equalTo(int synthetic, GuildEditMono another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.region().equals(another.region())
        && this.verificationLevel().equals(another.verificationLevel())
        && this.defaultMessageNotificationsLevel().equals(another.defaultMessageNotificationsLevel())
        && this.explicitContentFilter().equals(another.explicitContentFilter())
        && this.afkChannelId().equals(another.afkChannelId())
        && this.afkTimeout().equals(another.afkTimeout())
        && this.icon().equals(another.icon())
        && this.ownerId().equals(another.ownerId())
        && this.splash().equals(another.splash())
        && this.discoverySplash().equals(another.discoverySplash())
        && this.banner().equals(another.banner())
        && this.systemChannelId().equals(another.systemChannelId())
        && this.systemChannelFlags().equals(another.systemChannelFlags())
        && this.rulesChannelId().equals(another.rulesChannelId())
        && this.publicUpdatesChannelId().equals(another.publicUpdatesChannelId())
        && this.preferredLocale().equals(another.preferredLocale())
        && Objects.equals(features_value, another.features_value)
        && this.description().equals(another.description())
        && guild.equals(another.guild);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code region}, {@code verificationLevel}, {@code defaultMessageNotificationsLevel}, {@code explicitContentFilter}, {@code afkChannelId}, {@code afkTimeout}, {@code icon}, {@code ownerId}, {@code splash}, {@code discoverySplash}, {@code banner}, {@code systemChannelId}, {@code systemChannelFlags}, {@code rulesChannelId}, {@code publicUpdatesChannelId}, {@code preferredLocale}, {@code features}, {@code description}, {@code guild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (region().hashCode());
    h += (h << 5) + (verificationLevel().hashCode());
    h += (h << 5) + (defaultMessageNotificationsLevel().hashCode());
    h += (h << 5) + (explicitContentFilter().hashCode());
    h += (h << 5) + (afkChannelId().hashCode());
    h += (h << 5) + (afkTimeout().hashCode());
    h += (h << 5) + (icon().hashCode());
    h += (h << 5) + (ownerId().hashCode());
    h += (h << 5) + (splash().hashCode());
    h += (h << 5) + (discoverySplash().hashCode());
    h += (h << 5) + (banner().hashCode());
    h += (h << 5) + (systemChannelId().hashCode());
    h += (h << 5) + (systemChannelFlags().hashCode());
    h += (h << 5) + (rulesChannelId().hashCode());
    h += (h << 5) + (publicUpdatesChannelId().hashCode());
    h += (h << 5) + (preferredLocale().hashCode());
    h += (h << 5) + (Objects.hashCode(features_value));
    h += (h << 5) + (description().hashCode());
    h += (h << 5) + guild.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildEditMono{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", region=" + (region().toString())
        + ", verificationLevel=" + (verificationLevel().toString())
        + ", defaultMessageNotificationsLevel=" + (defaultMessageNotificationsLevel().toString())
        + ", explicitContentFilter=" + (explicitContentFilter().toString())
        + ", afkChannelId=" + (afkChannelId().toString())
        + ", afkTimeout=" + (afkTimeout().toString())
        + ", icon=" + (icon().toString())
        + ", ownerId=" + (ownerId().toString())
        + ", splash=" + (splash().toString())
        + ", discoverySplash=" + (discoverySplash().toString())
        + ", banner=" + (banner().toString())
        + ", systemChannelId=" + (systemChannelId().toString())
        + ", systemChannelFlags=" + (systemChannelFlags().toString())
        + ", rulesChannelId=" + (rulesChannelId().toString())
        + ", publicUpdatesChannelId=" + (publicUpdatesChannelId().toString())
        + ", preferredLocale=" + (preferredLocale().toString())
        + ", features=" + (Objects.toString(features_value))
        + ", description=" + (description().toString())
        + ", guild=" + guild
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildEditMono} instance.
   * @param guild The value for the {@code guild} attribute
   * @return An immutable GuildEditMono instance
   */
  public static GuildEditMono of(Guild guild) {
    return new GuildEditMono(guild);
  }

  /**
   * Creates an immutable copy of a {@link GuildEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildEditMono instance
   */
  static GuildEditMono copyOf(GuildEditMonoGenerator instance) {
    if (instance instanceof GuildEditMono) {
      return (GuildEditMono) instance;
    }
    return GuildEditMono.of(instance.guild())
        .withReason(instance.reason())
        .withName(instance.name())
        .withRegion(instance.region())
        .withVerificationLevel(instance.verificationLevel())
        .withDefaultMessageNotificationsLevel(instance.defaultMessageNotificationsLevel())
        .withExplicitContentFilter(instance.explicitContentFilter())
        .withAfkChannelId(instance.afkChannelId())
        .withAfkTimeout(instance.afkTimeout())
        .withIcon(instance.icon())
        .withOwnerId(instance.ownerId())
        .withSplash(instance.splash())
        .withDiscoverySplash(instance.discoverySplash())
        .withBanner(instance.banner())
        .withSystemChannelId(instance.systemChannelId())
        .withSystemChannelFlags(instance.systemChannelFlags())
        .withRulesChannelId(instance.rulesChannelId())
        .withPublicUpdatesChannelId(instance.publicUpdatesChannelId())
        .withPreferredLocale(instance.preferredLocale())
        .withFeatures(instance.features())
        .withDescription(instance.description());
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isRegionPresent() {
    return !region_absent;
  }

  public Region regionOrElse(Region defaultValue) {
    return !region_absent ? region_value : defaultValue;
  }

  public boolean isVerificationLevelPresent() {
    return !verificationLevel_absent;
  }

  public Guild.VerificationLevel verificationLevelOrElse(Guild.VerificationLevel defaultValue) {
    return !verificationLevel_absent ? verificationLevel_value : defaultValue;
  }

  public boolean isDefaultMessageNotificationsLevelPresent() {
    return !defaultMessageNotificationsLevel_absent;
  }

  public Guild.NotificationLevel defaultMessageNotificationsLevelOrElse(Guild.NotificationLevel defaultValue) {
    return !defaultMessageNotificationsLevel_absent ? defaultMessageNotificationsLevel_value : defaultValue;
  }

  public boolean isExplicitContentFilterPresent() {
    return !explicitContentFilter_absent;
  }

  public Guild.ContentFilterLevel explicitContentFilterOrElse(Guild.ContentFilterLevel defaultValue) {
    return !explicitContentFilter_absent ? explicitContentFilter_value : defaultValue;
  }

  public boolean isAfkChannelIdPresent() {
    return !afkChannelId_absent;
  }

  public Snowflake afkChannelIdOrElse(Snowflake defaultValue) {
    return !afkChannelId_absent ? afkChannelId_value : defaultValue;
  }

  public boolean isAfkTimeoutPresent() {
    return !afkTimeout_absent;
  }

  public Integer afkTimeoutOrElse(Integer defaultValue) {
    return !afkTimeout_absent ? afkTimeout_value : defaultValue;
  }

  public boolean isIconPresent() {
    return !icon_absent;
  }

  public Image iconOrElse(Image defaultValue) {
    return !icon_absent ? icon_value : defaultValue;
  }

  public boolean isOwnerIdPresent() {
    return !ownerId_absent;
  }

  public Snowflake ownerIdOrElse(Snowflake defaultValue) {
    return !ownerId_absent ? ownerId_value : defaultValue;
  }

  public boolean isSplashPresent() {
    return !splash_absent;
  }

  public Image splashOrElse(Image defaultValue) {
    return !splash_absent ? splash_value : defaultValue;
  }

  public boolean isDiscoverySplashPresent() {
    return !discoverySplash_absent;
  }

  public Image discoverySplashOrElse(Image defaultValue) {
    return !discoverySplash_absent ? discoverySplash_value : defaultValue;
  }

  public boolean isBannerPresent() {
    return !banner_absent;
  }

  public Image bannerOrElse(Image defaultValue) {
    return !banner_absent ? banner_value : defaultValue;
  }

  public boolean isSystemChannelIdPresent() {
    return !systemChannelId_absent;
  }

  public Snowflake systemChannelIdOrElse(Snowflake defaultValue) {
    return !systemChannelId_absent ? systemChannelId_value : defaultValue;
  }

  public boolean isSystemChannelFlagsPresent() {
    return !systemChannelFlags_absent;
  }

  public Guild.SystemChannelFlag systemChannelFlagsOrElse(Guild.SystemChannelFlag defaultValue) {
    return !systemChannelFlags_absent ? systemChannelFlags_value : defaultValue;
  }

  public boolean isRulesChannelIdPresent() {
    return !rulesChannelId_absent;
  }

  public Snowflake rulesChannelIdOrElse(Snowflake defaultValue) {
    return !rulesChannelId_absent ? rulesChannelId_value : defaultValue;
  }

  public boolean isPublicUpdatesChannelIdPresent() {
    return !publicUpdatesChannelId_absent;
  }

  public Snowflake publicUpdatesChannelIdOrElse(Snowflake defaultValue) {
    return !publicUpdatesChannelId_absent ? publicUpdatesChannelId_value : defaultValue;
  }

  public boolean isPreferredLocalePresent() {
    return !preferredLocale_absent;
  }

  public Locale preferredLocaleOrElse(Locale defaultValue) {
    return !preferredLocale_absent ? preferredLocale_value : defaultValue;
  }

  public boolean isFeaturesPresent() {
    return !features_absent;
  }

  public List<String> featuresOrElse(List<String> defaultValue) {
    return !features_absent ? features_value : defaultValue;
  }

  public boolean isDescriptionPresent() {
    return !description_absent;
  }

  public String descriptionOrElse(String defaultValue) {
    return !description_absent ? description_value : defaultValue;
  }
}
