package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.channel.Channel;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildCreateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GuildCreateSpec.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code GuildCreateSpec.of()}.
 */
@Generated(from = "GuildCreateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildCreateSpec implements GuildCreateSpecGenerator {
  private final String name;
  private final Region region;
  private final @Nullable Image icon;
  private final Guild.VerificationLevel verificationLevel;
  private final Guild.NotificationLevel defaultMessageNotificationLevel;
  private final Guild.ContentFilterLevel explicitContentFilter;
  private final List<RoleCreateSpec> roles;
  private final @Nullable RoleCreateSpec everyoneRole;
  private final List<GuildCreateFields.PartialChannel> channels;

  private GuildCreateSpec(String name, Region region) {
    this.name = Objects.requireNonNull(name, "name");
    this.region = Objects.requireNonNull(region, "region");
    this.icon = null;
    this.everyoneRole = null;
    this.verificationLevel = initShim.verificationLevel();
    this.defaultMessageNotificationLevel = initShim.defaultMessageNotificationLevel();
    this.explicitContentFilter = initShim.explicitContentFilter();
    this.roles = initShim.roles();
    this.channels = initShim.channels();
    this.initShim = null;
  }

  private GuildCreateSpec(GuildCreateSpec.Builder builder) {
    this.name = builder.name;
    this.region = builder.region;
    this.icon = builder.icon;
    this.everyoneRole = builder.everyoneRole;
    if (builder.verificationLevel != null) {
      initShim.verificationLevel(builder.verificationLevel);
    }
    if (builder.defaultMessageNotificationLevel != null) {
      initShim.defaultMessageNotificationLevel(builder.defaultMessageNotificationLevel);
    }
    if (builder.explicitContentFilter != null) {
      initShim.explicitContentFilter(builder.explicitContentFilter);
    }
    if (builder.rolesIsSet()) {
      initShim.roles(createUnmodifiableList(true, builder.roles));
    }
    if (builder.channelsIsSet()) {
      initShim.channels(createUnmodifiableList(true, builder.channels));
    }
    this.verificationLevel = initShim.verificationLevel();
    this.defaultMessageNotificationLevel = initShim.defaultMessageNotificationLevel();
    this.explicitContentFilter = initShim.explicitContentFilter();
    this.roles = initShim.roles();
    this.channels = initShim.channels();
    this.initShim = null;
  }

  private GuildCreateSpec(
      String name,
      Region region,
      @Nullable Image icon,
      Guild.VerificationLevel verificationLevel,
      Guild.NotificationLevel defaultMessageNotificationLevel,
      Guild.ContentFilterLevel explicitContentFilter,
      List<RoleCreateSpec> roles,
      @Nullable RoleCreateSpec everyoneRole,
      List<GuildCreateFields.PartialChannel> channels) {
    this.name = name;
    this.region = region;
    this.icon = icon;
    this.verificationLevel = verificationLevel;
    this.defaultMessageNotificationLevel = defaultMessageNotificationLevel;
    this.explicitContentFilter = explicitContentFilter;
    this.roles = roles;
    this.everyoneRole = everyoneRole;
    this.channels = channels;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildCreateSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private byte verificationLevelBuildStage = STAGE_UNINITIALIZED;
    private Guild.VerificationLevel verificationLevel;

    Guild.VerificationLevel verificationLevel() {
      if (verificationLevelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (verificationLevelBuildStage == STAGE_UNINITIALIZED) {
        verificationLevelBuildStage = STAGE_INITIALIZING;
        this.verificationLevel = Objects.requireNonNull(verificationLevelInitialize(), "verificationLevel");
        verificationLevelBuildStage = STAGE_INITIALIZED;
      }
      return this.verificationLevel;
    }

    void verificationLevel(Guild.VerificationLevel verificationLevel) {
      this.verificationLevel = verificationLevel;
      verificationLevelBuildStage = STAGE_INITIALIZED;
    }

    private byte defaultMessageNotificationLevelBuildStage = STAGE_UNINITIALIZED;
    private Guild.NotificationLevel defaultMessageNotificationLevel;

    Guild.NotificationLevel defaultMessageNotificationLevel() {
      if (defaultMessageNotificationLevelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultMessageNotificationLevelBuildStage == STAGE_UNINITIALIZED) {
        defaultMessageNotificationLevelBuildStage = STAGE_INITIALIZING;
        this.defaultMessageNotificationLevel = Objects.requireNonNull(defaultMessageNotificationLevelInitialize(), "defaultMessageNotificationLevel");
        defaultMessageNotificationLevelBuildStage = STAGE_INITIALIZED;
      }
      return this.defaultMessageNotificationLevel;
    }

    void defaultMessageNotificationLevel(Guild.NotificationLevel defaultMessageNotificationLevel) {
      this.defaultMessageNotificationLevel = defaultMessageNotificationLevel;
      defaultMessageNotificationLevelBuildStage = STAGE_INITIALIZED;
    }

    private byte explicitContentFilterBuildStage = STAGE_UNINITIALIZED;
    private Guild.ContentFilterLevel explicitContentFilter;

    Guild.ContentFilterLevel explicitContentFilter() {
      if (explicitContentFilterBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (explicitContentFilterBuildStage == STAGE_UNINITIALIZED) {
        explicitContentFilterBuildStage = STAGE_INITIALIZING;
        this.explicitContentFilter = Objects.requireNonNull(explicitContentFilterInitialize(), "explicitContentFilter");
        explicitContentFilterBuildStage = STAGE_INITIALIZED;
      }
      return this.explicitContentFilter;
    }

    void explicitContentFilter(Guild.ContentFilterLevel explicitContentFilter) {
      this.explicitContentFilter = explicitContentFilter;
      explicitContentFilterBuildStage = STAGE_INITIALIZED;
    }

    private byte rolesBuildStage = STAGE_UNINITIALIZED;
    private List<RoleCreateSpec> roles;

    List<RoleCreateSpec> roles() {
      if (rolesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rolesBuildStage == STAGE_UNINITIALIZED) {
        rolesBuildStage = STAGE_INITIALIZING;
        this.roles = createUnmodifiableList(false, createSafeList(rolesInitialize(), true, false));
        rolesBuildStage = STAGE_INITIALIZED;
      }
      return this.roles;
    }

    void roles(List<RoleCreateSpec> roles) {
      this.roles = roles;
      rolesBuildStage = STAGE_INITIALIZED;
    }

    private byte channelsBuildStage = STAGE_UNINITIALIZED;
    private List<GuildCreateFields.PartialChannel> channels;

    List<GuildCreateFields.PartialChannel> channels() {
      if (channelsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (channelsBuildStage == STAGE_UNINITIALIZED) {
        channelsBuildStage = STAGE_INITIALIZING;
        this.channels = createUnmodifiableList(false, createSafeList(channelsInitialize(), true, false));
        channelsBuildStage = STAGE_INITIALIZED;
      }
      return this.channels;
    }

    void channels(List<GuildCreateFields.PartialChannel> channels) {
      this.channels = channels;
      channelsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (verificationLevelBuildStage == STAGE_INITIALIZING) attributes.add("verificationLevel");
      if (defaultMessageNotificationLevelBuildStage == STAGE_INITIALIZING) attributes.add("defaultMessageNotificationLevel");
      if (explicitContentFilterBuildStage == STAGE_INITIALIZING) attributes.add("explicitContentFilter");
      if (rolesBuildStage == STAGE_INITIALIZING) attributes.add("roles");
      if (channelsBuildStage == STAGE_INITIALIZING) attributes.add("channels");
      return "Cannot build GuildCreateSpec, attribute initializers form cycle " + attributes;
    }
  }

  private Guild.VerificationLevel verificationLevelInitialize() {
    return GuildCreateSpecGenerator.super.verificationLevel();
  }

  private Guild.NotificationLevel defaultMessageNotificationLevelInitialize() {
    return GuildCreateSpecGenerator.super.defaultMessageNotificationLevel();
  }

  private Guild.ContentFilterLevel explicitContentFilterInitialize() {
    return GuildCreateSpecGenerator.super.explicitContentFilter();
  }

  private List<RoleCreateSpec> rolesInitialize() {
    return GuildCreateSpecGenerator.super.roles();
  }

  private List<GuildCreateFields.PartialChannel> channelsInitialize() {
    return GuildCreateSpecGenerator.super.channels();
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code region} attribute
   */
  @Override
  public Region region() {
    return region;
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @Override
  public @Nullable Image icon() {
    return icon;
  }

  /**
   * @return The value of the {@code verificationLevel} attribute
   */
  @Override
  public Guild.VerificationLevel verificationLevel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.verificationLevel()
        : this.verificationLevel;
  }

  /**
   * @return The value of the {@code defaultMessageNotificationLevel} attribute
   */
  @Override
  public Guild.NotificationLevel defaultMessageNotificationLevel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.defaultMessageNotificationLevel()
        : this.defaultMessageNotificationLevel;
  }

  /**
   * @return The value of the {@code explicitContentFilter} attribute
   */
  @Override
  public Guild.ContentFilterLevel explicitContentFilter() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.explicitContentFilter()
        : this.explicitContentFilter;
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public List<RoleCreateSpec> roles() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.roles()
        : this.roles;
  }

  /**
   * @return The value of the {@code everyoneRole} attribute
   */
  @Override
  public @Nullable RoleCreateSpec everyoneRole() {
    return everyoneRole;
  }

  /**
   * @return The value of the {@code channels} attribute
   */
  @Override
  public List<GuildCreateFields.PartialChannel> channels() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.channels()
        : this.channels;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateSpec#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateSpec withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new GuildCreateSpec(
        newValue,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        this.channels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateSpec#region() region} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for region
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateSpec withRegion(Region value) {
    if (this.region == value) return this;
    Region newValue = Objects.requireNonNull(value, "region");
    return new GuildCreateSpec(
        this.name,
        newValue,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        this.channels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateSpec#icon() icon} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icon (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateSpec withIcon(@Nullable Image value) {
    if (this.icon == value) return this;
    return new GuildCreateSpec(
        this.name,
        this.region,
        value,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        this.channels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateSpec#verificationLevel() verificationLevel} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verificationLevel
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateSpec withVerificationLevel(Guild.VerificationLevel value) {
    Guild.VerificationLevel newValue = Objects.requireNonNull(value, "verificationLevel");
    if (this.verificationLevel == newValue) return this;
    return new GuildCreateSpec(
        this.name,
        this.region,
        this.icon,
        newValue,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        this.channels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateSpec#defaultMessageNotificationLevel() defaultMessageNotificationLevel} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultMessageNotificationLevel
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateSpec withDefaultMessageNotificationLevel(Guild.NotificationLevel value) {
    Guild.NotificationLevel newValue = Objects.requireNonNull(value, "defaultMessageNotificationLevel");
    if (this.defaultMessageNotificationLevel == newValue) return this;
    return new GuildCreateSpec(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        newValue,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        this.channels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateSpec#explicitContentFilter() explicitContentFilter} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for explicitContentFilter
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateSpec withExplicitContentFilter(Guild.ContentFilterLevel value) {
    Guild.ContentFilterLevel newValue = Objects.requireNonNull(value, "explicitContentFilter");
    if (this.explicitContentFilter == newValue) return this;
    return new GuildCreateSpec(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        newValue,
        this.roles,
        this.everyoneRole,
        this.channels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildCreateSpec#roles() roles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildCreateSpec withRoles(RoleCreateSpec... elements) {
    List<RoleCreateSpec> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new GuildCreateSpec(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        newValue,
        this.everyoneRole,
        this.channels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildCreateSpec#roles() roles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of roles elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildCreateSpec withRoles(Iterable<? extends RoleCreateSpec> elements) {
    if (this.roles == elements) return this;
    List<RoleCreateSpec> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new GuildCreateSpec(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        newValue,
        this.everyoneRole,
        this.channels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateSpec#everyoneRole() everyoneRole} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for everyoneRole (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateSpec withEveryoneRole(@Nullable RoleCreateSpec value) {
    if (this.everyoneRole == value) return this;
    return new GuildCreateSpec(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        value,
        this.channels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildCreateSpec#channels() channels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildCreateSpec withChannels(GuildCreateFields.PartialChannel... elements) {
    List<GuildCreateFields.PartialChannel> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new GuildCreateSpec(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildCreateSpec#channels() channels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of channels elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildCreateSpec withChannels(Iterable<? extends GuildCreateFields.PartialChannel> elements) {
    if (this.channels == elements) return this;
    List<GuildCreateFields.PartialChannel> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new GuildCreateSpec(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildCreateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildCreateSpec
        && equalTo(0, (GuildCreateSpec) another);
  }

  private boolean equalTo(int synthetic, GuildCreateSpec another) {
    return name.equals(another.name)
        && region.equals(another.region)
        && Objects.equals(icon, another.icon)
        && verificationLevel.equals(another.verificationLevel)
        && defaultMessageNotificationLevel.equals(another.defaultMessageNotificationLevel)
        && explicitContentFilter.equals(another.explicitContentFilter)
        && roles.equals(another.roles)
        && Objects.equals(everyoneRole, another.everyoneRole)
        && channels.equals(another.channels);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code region}, {@code icon}, {@code verificationLevel}, {@code defaultMessageNotificationLevel}, {@code explicitContentFilter}, {@code roles}, {@code everyoneRole}, {@code channels}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + region.hashCode();
    h += (h << 5) + Objects.hashCode(icon);
    h += (h << 5) + verificationLevel.hashCode();
    h += (h << 5) + defaultMessageNotificationLevel.hashCode();
    h += (h << 5) + explicitContentFilter.hashCode();
    h += (h << 5) + roles.hashCode();
    h += (h << 5) + Objects.hashCode(everyoneRole);
    h += (h << 5) + channels.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildCreateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildCreateSpec{"
        + "name=" + name
        + ", region=" + region
        + ", icon=" + icon
        + ", verificationLevel=" + verificationLevel
        + ", defaultMessageNotificationLevel=" + defaultMessageNotificationLevel
        + ", explicitContentFilter=" + explicitContentFilter
        + ", roles=" + roles
        + ", everyoneRole=" + everyoneRole
        + ", channels=" + channels
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildCreateSpec} instance.
   * @param name The value for the {@code name} attribute
   * @param region The value for the {@code region} attribute
   * @return An immutable GuildCreateSpec instance
   */
  public static GuildCreateSpec of(String name, Region region) {
    return new GuildCreateSpec(name, region);
  }

  /**
   * Creates an immutable copy of a {@link GuildCreateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildCreateSpec instance
   */
  static GuildCreateSpec copyOf(GuildCreateSpecGenerator instance) {
    if (instance instanceof GuildCreateSpec) {
      return (GuildCreateSpec) instance;
    }
    return GuildCreateSpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link GuildCreateSpec GuildCreateSpec}.
   * <pre>
   * GuildCreateSpec.builder()
   *    .name(String) // required {@link GuildCreateSpec#name() name}
   *    .region(discord4j.core.object.Region) // required {@link GuildCreateSpec#region() region}
   *    .icon(discord4j.rest.util.Image | null) // nullable {@link GuildCreateSpec#icon() icon}
   *    .verificationLevel(discord4j.core.object.entity.Guild.VerificationLevel) // optional {@link GuildCreateSpec#verificationLevel() verificationLevel}
   *    .defaultMessageNotificationLevel(discord4j.core.object.entity.Guild.NotificationLevel) // optional {@link GuildCreateSpec#defaultMessageNotificationLevel() defaultMessageNotificationLevel}
   *    .explicitContentFilter(discord4j.core.object.entity.Guild.ContentFilterLevel) // optional {@link GuildCreateSpec#explicitContentFilter() explicitContentFilter}
   *    .addRole|addAllRoles(RoleCreateSpec) // {@link GuildCreateSpec#roles() roles} elements
   *    .everyoneRole(discord4j.core.spec.RoleCreateSpec | null) // nullable {@link GuildCreateSpec#everyoneRole() everyoneRole}
   *    .addChannel|addAllChannels(discord4j.core.spec.GuildCreateFields.PartialChannel) // {@link GuildCreateSpec#channels() channels} elements
   *    .build();
   * </pre>
   * @return A new GuildCreateSpec builder
   */
  public static GuildCreateSpec.Builder builder() {
    return new GuildCreateSpec.Builder();
  }

  /**
   * Builds instances of type {@link GuildCreateSpec GuildCreateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GuildCreateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_REGION = 0x2L;
    private static final long OPT_BIT_ROLES = 0x1L;
    private static final long OPT_BIT_CHANNELS = 0x2L;
    private long initBits = 0x3L;
    private long optBits;

    private String name;
    private Region region;
    private Image icon;
    private Guild.VerificationLevel verificationLevel;
    private Guild.NotificationLevel defaultMessageNotificationLevel;
    private Guild.ContentFilterLevel explicitContentFilter;
    private List<RoleCreateSpec> roles = new ArrayList<RoleCreateSpec>();
    private RoleCreateSpec everyoneRole;
    private List<GuildCreateFields.PartialChannel> channels = new ArrayList<GuildCreateFields.PartialChannel>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GuildCreateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GuildCreateSpec instance) {
      return from((GuildCreateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code GuildCreateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(GuildCreateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      region(instance.region());
      Image iconValue = instance.icon();
      if (iconValue != null) {
        icon(iconValue);
      }
      verificationLevel(instance.verificationLevel());
      defaultMessageNotificationLevel(instance.defaultMessageNotificationLevel());
      explicitContentFilter(instance.explicitContentFilter());
      addAllRoles(instance.roles());
      RoleCreateSpec everyoneRoleValue = instance.everyoneRole();
      if (everyoneRoleValue != null) {
        everyoneRole(everyoneRoleValue);
      }
      addAllChannels(instance.channels());
      return this;
    }

    /**
     * Initializes the value for the {@link GuildCreateSpec#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link GuildCreateSpec#region() region} attribute.
     * @param region The value for region 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder region(Region region) {
      this.region = Objects.requireNonNull(region, "region");
      initBits &= ~INIT_BIT_REGION;
      return this;
    }

    /**
     * Initializes the value for the {@link GuildCreateSpec#icon() icon} attribute.
     * @param icon The value for icon (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder icon(@Nullable Image icon) {
      this.icon = icon;
      return this;
    }

    /**
     * Initializes the value for the {@link GuildCreateSpec#verificationLevel() verificationLevel} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GuildCreateSpec#verificationLevel() verificationLevel}.</em>
     * @param verificationLevel The value for verificationLevel 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder verificationLevel(Guild.VerificationLevel verificationLevel) {
      this.verificationLevel = Objects.requireNonNull(verificationLevel, "verificationLevel");
      return this;
    }

    /**
     * Initializes the value for the {@link GuildCreateSpec#defaultMessageNotificationLevel() defaultMessageNotificationLevel} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GuildCreateSpec#defaultMessageNotificationLevel() defaultMessageNotificationLevel}.</em>
     * @param defaultMessageNotificationLevel The value for defaultMessageNotificationLevel 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultMessageNotificationLevel(Guild.NotificationLevel defaultMessageNotificationLevel) {
      this.defaultMessageNotificationLevel = Objects.requireNonNull(defaultMessageNotificationLevel, "defaultMessageNotificationLevel");
      return this;
    }

    /**
     * Initializes the value for the {@link GuildCreateSpec#explicitContentFilter() explicitContentFilter} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GuildCreateSpec#explicitContentFilter() explicitContentFilter}.</em>
     * @param explicitContentFilter The value for explicitContentFilter 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder explicitContentFilter(Guild.ContentFilterLevel explicitContentFilter) {
      this.explicitContentFilter = Objects.requireNonNull(explicitContentFilter, "explicitContentFilter");
      return this;
    }

    /**
     * Adds one element to {@link GuildCreateSpec#roles() roles} list.
     * @param element A roles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRole(RoleCreateSpec element) {
      this.roles.add(Objects.requireNonNull(element, "roles element"));
      optBits |= OPT_BIT_ROLES;
      return this;
    }

    /**
     * Adds elements to {@link GuildCreateSpec#roles() roles} list.
     * @param elements An array of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRoles(RoleCreateSpec... elements) {
      for (RoleCreateSpec element : elements) {
        this.roles.add(Objects.requireNonNull(element, "roles element"));
      }
      optBits |= OPT_BIT_ROLES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GuildCreateSpec#roles() roles} list.
     * @param elements An iterable of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder roles(Iterable<? extends RoleCreateSpec> elements) {
      this.roles.clear();
      return addAllRoles(elements);
    }

    /**
     * Adds elements to {@link GuildCreateSpec#roles() roles} list.
     * @param elements An iterable of roles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRoles(Iterable<? extends RoleCreateSpec> elements) {
      for (RoleCreateSpec element : elements) {
        this.roles.add(Objects.requireNonNull(element, "roles element"));
      }
      optBits |= OPT_BIT_ROLES;
      return this;
    }

    /**
     * Initializes the value for the {@link GuildCreateSpec#everyoneRole() everyoneRole} attribute.
     * @param everyoneRole The value for everyoneRole (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder everyoneRole(@Nullable RoleCreateSpec everyoneRole) {
      this.everyoneRole = everyoneRole;
      return this;
    }

    /**
     * Adds one element to {@link GuildCreateSpec#channels() channels} list.
     * @param element A channels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addChannel(GuildCreateFields.PartialChannel element) {
      element = ImmutableGuildCreateFields.PartialChannel.copyOf(element);
      this.channels.add(Objects.requireNonNull(element, "channels element"));
      optBits |= OPT_BIT_CHANNELS;
      return this;
    }

    /**
     * Constructs and adds an element for the {@link GuildCreateSpec#channels() channels} list.
     * @param name The value for {@code channels.name} 
     * @param type The value for {@code channels.type} 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChannel(String name, Channel.Type type) {
      return addChannel(ImmutableGuildCreateFields.PartialChannel.of(name, type));
    }

    /**
     * Adds elements to {@link GuildCreateSpec#channels() channels} list.
     * @param elements An array of channels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addChannels(GuildCreateFields.PartialChannel... elements) {
      for (GuildCreateFields.PartialChannel element : elements) {
        element = ImmutableGuildCreateFields.PartialChannel.copyOf(element);
        this.channels.add(Objects.requireNonNull(element, "channels element"));
      }
      optBits |= OPT_BIT_CHANNELS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GuildCreateSpec#channels() channels} list.
     * @param elements An iterable of channels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder channels(Iterable<? extends GuildCreateFields.PartialChannel> elements) {
      this.channels.clear();
      return addAllChannels(elements);
    }

    /**
     * Adds elements to {@link GuildCreateSpec#channels() channels} list.
     * @param elements An iterable of channels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllChannels(Iterable<? extends GuildCreateFields.PartialChannel> elements) {
      for (GuildCreateFields.PartialChannel element : elements) {
        element = ImmutableGuildCreateFields.PartialChannel.copyOf(element);
        this.channels.add(Objects.requireNonNull(element, "channels element"));
      }
      optBits |= OPT_BIT_CHANNELS;
      return this;
    }

    /**
     * Builds a new {@link GuildCreateSpec GuildCreateSpec}.
     * @return An immutable instance of GuildCreateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GuildCreateSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GuildCreateSpec(this);
    }

    private boolean rolesIsSet() {
      return (optBits & OPT_BIT_ROLES) != 0;
    }

    private boolean channelsIsSet() {
      return (optBits & OPT_BIT_CHANNELS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_REGION) != 0) attributes.add("region");
      return "Cannot build GuildCreateSpec, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
