package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildCreateMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code GuildCreateMono.of()}.
 */
@Generated(from = "GuildCreateMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildCreateMono extends GuildCreateMonoGenerator {
  private final String name;
  private final Region region;
  private final @Nullable Image icon;
  private final Guild.VerificationLevel verificationLevel;
  private final Guild.NotificationLevel defaultMessageNotificationLevel;
  private final Guild.ContentFilterLevel explicitContentFilter;
  private final List<RoleCreateSpec> roles;
  private final @Nullable RoleCreateSpec everyoneRole;
  private final List<GuildCreateFields.PartialChannel> channels;
  private final GatewayDiscordClient gateway;

  private GuildCreateMono(
      String name,
      Region region,
      GatewayDiscordClient gateway) {
    this.name = Objects.requireNonNull(name, "name");
    this.region = Objects.requireNonNull(region, "region");
    this.gateway = Objects.requireNonNull(gateway, "gateway");
    this.icon = null;
    this.everyoneRole = null;
    this.verificationLevel = initShim.verificationLevel();
    this.defaultMessageNotificationLevel = initShim.defaultMessageNotificationLevel();
    this.explicitContentFilter = initShim.explicitContentFilter();
    this.roles = initShim.roles();
    this.channels = initShim.channels();
    this.initShim = null;
  }

  private GuildCreateMono(
      String name,
      Region region,
      @Nullable Image icon,
      Guild.VerificationLevel verificationLevel,
      Guild.NotificationLevel defaultMessageNotificationLevel,
      Guild.ContentFilterLevel explicitContentFilter,
      List<RoleCreateSpec> roles,
      @Nullable RoleCreateSpec everyoneRole,
      List<GuildCreateFields.PartialChannel> channels,
      GatewayDiscordClient gateway) {
    this.name = name;
    this.region = region;
    this.icon = icon;
    this.verificationLevel = verificationLevel;
    this.defaultMessageNotificationLevel = defaultMessageNotificationLevel;
    this.explicitContentFilter = explicitContentFilter;
    this.roles = roles;
    this.everyoneRole = everyoneRole;
    this.channels = channels;
    this.gateway = gateway;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildCreateMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private byte verificationLevelBuildStage = STAGE_UNINITIALIZED;
    private Guild.VerificationLevel verificationLevel;

    Guild.VerificationLevel verificationLevel() {
      if (verificationLevelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (verificationLevelBuildStage == STAGE_UNINITIALIZED) {
        verificationLevelBuildStage = STAGE_INITIALIZING;
        this.verificationLevel = Objects.requireNonNull(GuildCreateMono.super.verificationLevel(), "verificationLevel");
        verificationLevelBuildStage = STAGE_INITIALIZED;
      }
      return this.verificationLevel;
    }

    void verificationLevel(Guild.VerificationLevel verificationLevel) {
      this.verificationLevel = verificationLevel;
      verificationLevelBuildStage = STAGE_INITIALIZED;
    }

    private byte defaultMessageNotificationLevelBuildStage = STAGE_UNINITIALIZED;
    private Guild.NotificationLevel defaultMessageNotificationLevel;

    Guild.NotificationLevel defaultMessageNotificationLevel() {
      if (defaultMessageNotificationLevelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultMessageNotificationLevelBuildStage == STAGE_UNINITIALIZED) {
        defaultMessageNotificationLevelBuildStage = STAGE_INITIALIZING;
        this.defaultMessageNotificationLevel = Objects.requireNonNull(GuildCreateMono.super.defaultMessageNotificationLevel(), "defaultMessageNotificationLevel");
        defaultMessageNotificationLevelBuildStage = STAGE_INITIALIZED;
      }
      return this.defaultMessageNotificationLevel;
    }

    void defaultMessageNotificationLevel(Guild.NotificationLevel defaultMessageNotificationLevel) {
      this.defaultMessageNotificationLevel = defaultMessageNotificationLevel;
      defaultMessageNotificationLevelBuildStage = STAGE_INITIALIZED;
    }

    private byte explicitContentFilterBuildStage = STAGE_UNINITIALIZED;
    private Guild.ContentFilterLevel explicitContentFilter;

    Guild.ContentFilterLevel explicitContentFilter() {
      if (explicitContentFilterBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (explicitContentFilterBuildStage == STAGE_UNINITIALIZED) {
        explicitContentFilterBuildStage = STAGE_INITIALIZING;
        this.explicitContentFilter = Objects.requireNonNull(GuildCreateMono.super.explicitContentFilter(), "explicitContentFilter");
        explicitContentFilterBuildStage = STAGE_INITIALIZED;
      }
      return this.explicitContentFilter;
    }

    void explicitContentFilter(Guild.ContentFilterLevel explicitContentFilter) {
      this.explicitContentFilter = explicitContentFilter;
      explicitContentFilterBuildStage = STAGE_INITIALIZED;
    }

    private byte rolesBuildStage = STAGE_UNINITIALIZED;
    private List<RoleCreateSpec> roles;

    List<RoleCreateSpec> roles() {
      if (rolesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rolesBuildStage == STAGE_UNINITIALIZED) {
        rolesBuildStage = STAGE_INITIALIZING;
        this.roles = createUnmodifiableList(false, createSafeList(GuildCreateMono.super.roles(), true, false));
        rolesBuildStage = STAGE_INITIALIZED;
      }
      return this.roles;
    }

    void roles(List<RoleCreateSpec> roles) {
      this.roles = roles;
      rolesBuildStage = STAGE_INITIALIZED;
    }

    private byte channelsBuildStage = STAGE_UNINITIALIZED;
    private List<GuildCreateFields.PartialChannel> channels;

    List<GuildCreateFields.PartialChannel> channels() {
      if (channelsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (channelsBuildStage == STAGE_UNINITIALIZED) {
        channelsBuildStage = STAGE_INITIALIZING;
        this.channels = createUnmodifiableList(false, createSafeList(GuildCreateMono.super.channels(), true, false));
        channelsBuildStage = STAGE_INITIALIZED;
      }
      return this.channels;
    }

    void channels(List<GuildCreateFields.PartialChannel> channels) {
      this.channels = channels;
      channelsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (verificationLevelBuildStage == STAGE_INITIALIZING) attributes.add("verificationLevel");
      if (defaultMessageNotificationLevelBuildStage == STAGE_INITIALIZING) attributes.add("defaultMessageNotificationLevel");
      if (explicitContentFilterBuildStage == STAGE_INITIALIZING) attributes.add("explicitContentFilter");
      if (rolesBuildStage == STAGE_INITIALIZING) attributes.add("roles");
      if (channelsBuildStage == STAGE_INITIALIZING) attributes.add("channels");
      return "Cannot build GuildCreateMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code region} attribute
   */
  @Override
  public Region region() {
    return region;
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @Override
  public @Nullable Image icon() {
    return icon;
  }

  /**
   * @return The value of the {@code verificationLevel} attribute
   */
  @Override
  public Guild.VerificationLevel verificationLevel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.verificationLevel()
        : this.verificationLevel;
  }

  /**
   * @return The value of the {@code defaultMessageNotificationLevel} attribute
   */
  @Override
  public Guild.NotificationLevel defaultMessageNotificationLevel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.defaultMessageNotificationLevel()
        : this.defaultMessageNotificationLevel;
  }

  /**
   * @return The value of the {@code explicitContentFilter} attribute
   */
  @Override
  public Guild.ContentFilterLevel explicitContentFilter() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.explicitContentFilter()
        : this.explicitContentFilter;
  }

  /**
   * @return The value of the {@code roles} attribute
   */
  @Override
  public List<RoleCreateSpec> roles() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.roles()
        : this.roles;
  }

  /**
   * @return The value of the {@code everyoneRole} attribute
   */
  @Override
  public @Nullable RoleCreateSpec everyoneRole() {
    return everyoneRole;
  }

  /**
   * @return The value of the {@code channels} attribute
   */
  @Override
  public List<GuildCreateFields.PartialChannel> channels() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.channels()
        : this.channels;
  }

  /**
   * @return The value of the {@code gateway} attribute
   */
  @Override
  public GatewayDiscordClient gateway() {
    return gateway;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateMono#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateMono withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new GuildCreateMono(
        newValue,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        this.channels,
        this.gateway);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateMono#region() region} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for region
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateMono withRegion(Region value) {
    if (this.region == value) return this;
    Region newValue = Objects.requireNonNull(value, "region");
    return new GuildCreateMono(
        this.name,
        newValue,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        this.channels,
        this.gateway);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateMono#icon() icon} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icon (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateMono withIcon(@Nullable Image value) {
    if (this.icon == value) return this;
    return new GuildCreateMono(
        this.name,
        this.region,
        value,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        this.channels,
        this.gateway);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateMono#verificationLevel() verificationLevel} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verificationLevel
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateMono withVerificationLevel(Guild.VerificationLevel value) {
    Guild.VerificationLevel newValue = Objects.requireNonNull(value, "verificationLevel");
    if (this.verificationLevel == newValue) return this;
    return new GuildCreateMono(
        this.name,
        this.region,
        this.icon,
        newValue,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        this.channels,
        this.gateway);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateMono#defaultMessageNotificationLevel() defaultMessageNotificationLevel} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultMessageNotificationLevel
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateMono withDefaultMessageNotificationLevel(Guild.NotificationLevel value) {
    Guild.NotificationLevel newValue = Objects.requireNonNull(value, "defaultMessageNotificationLevel");
    if (this.defaultMessageNotificationLevel == newValue) return this;
    return new GuildCreateMono(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        newValue,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        this.channels,
        this.gateway);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateMono#explicitContentFilter() explicitContentFilter} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for explicitContentFilter
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateMono withExplicitContentFilter(Guild.ContentFilterLevel value) {
    Guild.ContentFilterLevel newValue = Objects.requireNonNull(value, "explicitContentFilter");
    if (this.explicitContentFilter == newValue) return this;
    return new GuildCreateMono(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        newValue,
        this.roles,
        this.everyoneRole,
        this.channels,
        this.gateway);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildCreateMono#roles() roles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildCreateMono withRoles(RoleCreateSpec... elements) {
    List<RoleCreateSpec> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new GuildCreateMono(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        newValue,
        this.everyoneRole,
        this.channels,
        this.gateway);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildCreateMono#roles() roles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of roles elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildCreateMono withRoles(Iterable<? extends RoleCreateSpec> elements) {
    if (this.roles == elements) return this;
    List<RoleCreateSpec> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new GuildCreateMono(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        newValue,
        this.everyoneRole,
        this.channels,
        this.gateway);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateMono#everyoneRole() everyoneRole} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for everyoneRole (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateMono withEveryoneRole(@Nullable RoleCreateSpec value) {
    if (this.everyoneRole == value) return this;
    return new GuildCreateMono(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        value,
        this.channels,
        this.gateway);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildCreateMono#channels() channels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildCreateMono withChannels(GuildCreateFields.PartialChannel... elements) {
    List<GuildCreateFields.PartialChannel> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new GuildCreateMono(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        newValue,
        this.gateway);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GuildCreateMono#channels() channels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of channels elements to set
   * @return A modified copy of {@code this} object
   */
  public final GuildCreateMono withChannels(Iterable<? extends GuildCreateFields.PartialChannel> elements) {
    if (this.channels == elements) return this;
    List<GuildCreateFields.PartialChannel> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new GuildCreateMono(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        newValue,
        this.gateway);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateMono#gateway() gateway} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gateway
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateMono withGateway(GatewayDiscordClient value) {
    if (this.gateway == value) return this;
    GatewayDiscordClient newValue = Objects.requireNonNull(value, "gateway");
    return new GuildCreateMono(
        this.name,
        this.region,
        this.icon,
        this.verificationLevel,
        this.defaultMessageNotificationLevel,
        this.explicitContentFilter,
        this.roles,
        this.everyoneRole,
        this.channels,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildCreateMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildCreateMono
        && equalTo(0, (GuildCreateMono) another);
  }

  private boolean equalTo(int synthetic, GuildCreateMono another) {
    return name.equals(another.name)
        && region.equals(another.region)
        && Objects.equals(icon, another.icon)
        && verificationLevel.equals(another.verificationLevel)
        && defaultMessageNotificationLevel.equals(another.defaultMessageNotificationLevel)
        && explicitContentFilter.equals(another.explicitContentFilter)
        && roles.equals(another.roles)
        && Objects.equals(everyoneRole, another.everyoneRole)
        && channels.equals(another.channels)
        && gateway.equals(another.gateway);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code region}, {@code icon}, {@code verificationLevel}, {@code defaultMessageNotificationLevel}, {@code explicitContentFilter}, {@code roles}, {@code everyoneRole}, {@code channels}, {@code gateway}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + region.hashCode();
    h += (h << 5) + Objects.hashCode(icon);
    h += (h << 5) + verificationLevel.hashCode();
    h += (h << 5) + defaultMessageNotificationLevel.hashCode();
    h += (h << 5) + explicitContentFilter.hashCode();
    h += (h << 5) + roles.hashCode();
    h += (h << 5) + Objects.hashCode(everyoneRole);
    h += (h << 5) + channels.hashCode();
    h += (h << 5) + gateway.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildCreateMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildCreateMono{"
        + "name=" + name
        + ", region=" + region
        + ", icon=" + icon
        + ", verificationLevel=" + verificationLevel
        + ", defaultMessageNotificationLevel=" + defaultMessageNotificationLevel
        + ", explicitContentFilter=" + explicitContentFilter
        + ", roles=" + roles
        + ", everyoneRole=" + everyoneRole
        + ", channels=" + channels
        + ", gateway=" + gateway
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildCreateMono} instance.
   * @param name The value for the {@code name} attribute
   * @param region The value for the {@code region} attribute
   * @param gateway The value for the {@code gateway} attribute
   * @return An immutable GuildCreateMono instance
   */
  public static GuildCreateMono of(String name, Region region, GatewayDiscordClient gateway) {
    return new GuildCreateMono(name, region, gateway);
  }

  /**
   * Creates an immutable copy of a {@link GuildCreateMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildCreateMono instance
   */
  static GuildCreateMono copyOf(GuildCreateMonoGenerator instance) {
    if (instance instanceof GuildCreateMono) {
      return (GuildCreateMono) instance;
    }
    return GuildCreateMono.of(instance.name(), instance.region(), instance.gateway())
        .withIcon(instance.icon())
        .withVerificationLevel(instance.verificationLevel())
        .withDefaultMessageNotificationLevel(instance.defaultMessageNotificationLevel())
        .withExplicitContentFilter(instance.explicitContentFilter())
        .withRoles(instance.roles())
        .withEveryoneRole(instance.everyoneRole())
        .withChannels(instance.channels());
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
