package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GuildCreateFromTemplateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GuildCreateFromTemplateSpec.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code GuildCreateFromTemplateSpec.of()}.
 */
@Generated(from = "GuildCreateFromTemplateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildCreateFromTemplateSpec
    implements GuildCreateFromTemplateSpecGenerator {
  private final String name;
  private final Image icon_value;
  private final boolean icon_absent;

  private GuildCreateFromTemplateSpec(String name) {
    this.name = Objects.requireNonNull(name, "name");
    Possible<Image> icon$impl = Possible.absent();
    this.icon_value = icon$impl.toOptional().orElse(null);
    this.icon_absent = icon$impl.isAbsent();
    this.initShim = null;
  }

  private GuildCreateFromTemplateSpec(String name, Possible<Image> icon) {
    this.name = name;
    Possible<Image> icon$impl = icon;
    this.icon_value = icon$impl.toOptional().orElse(null);
    this.icon_absent = icon$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildCreateFromTemplateSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildCreateFromTemplateSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @Override
  public Possible<Image> icon() {
    return icon_absent ? Possible.absent() : Possible.of(icon_value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateFromTemplateSpec#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateFromTemplateSpec withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new GuildCreateFromTemplateSpec(newValue, this.icon());
  }

  public GuildCreateFromTemplateSpec withIcon(Possible<Image> value) {
    Possible<Image> newValue = Objects.requireNonNull(value);
    return new GuildCreateFromTemplateSpec(this.name, newValue);
  }

  public GuildCreateFromTemplateSpec withIcon(Image value) {
    Possible<Image> newValue = Possible.of(value);
    return new GuildCreateFromTemplateSpec(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildCreateFromTemplateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildCreateFromTemplateSpec
        && equalTo(0, (GuildCreateFromTemplateSpec) another);
  }

  private boolean equalTo(int synthetic, GuildCreateFromTemplateSpec another) {
    return name.equals(another.name)
        && this.icon().equals(another.icon());
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code icon}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (icon().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code GuildCreateFromTemplateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildCreateFromTemplateSpec{"
        + "name=" + name
        + ", icon=" + (icon().toString())
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildCreateFromTemplateSpec} instance.
   * @param name The value for the {@code name} attribute
   * @return An immutable GuildCreateFromTemplateSpec instance
   */
  public static GuildCreateFromTemplateSpec of(String name) {
    return new GuildCreateFromTemplateSpec(name);
  }

  /**
   * Creates an immutable copy of a {@link GuildCreateFromTemplateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildCreateFromTemplateSpec instance
   */
  static GuildCreateFromTemplateSpec copyOf(GuildCreateFromTemplateSpecGenerator instance) {
    if (instance instanceof GuildCreateFromTemplateSpec) {
      return (GuildCreateFromTemplateSpec) instance;
    }
    return GuildCreateFromTemplateSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isIconPresent() {
    return !icon_absent;
  }

  public Image iconOrElse(Image defaultValue) {
    return !icon_absent ? icon_value : defaultValue;
  }

  /**
   * Creates a builder for {@link GuildCreateFromTemplateSpec GuildCreateFromTemplateSpec}.
   * <pre>
   * GuildCreateFromTemplateSpec.builder()
   *    .name(String) // required {@link GuildCreateFromTemplateSpec#name() name}
   *    .icon(discord4j.discordjson.possible.Possible&amp;lt;discord4j.rest.util.Image&amp;gt;) // {@link GuildCreateFromTemplateSpec#icon() icon}
   *    .build();
   * </pre>
   * @return A new GuildCreateFromTemplateSpec builder
   */
  public static GuildCreateFromTemplateSpec.Builder builder() {
    return new GuildCreateFromTemplateSpec.Builder();
  }

  /**
   * Builds instances of type {@link GuildCreateFromTemplateSpec GuildCreateFromTemplateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GuildCreateFromTemplateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Possible<Image> icon_possible = Possible.absent();
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GuildCreateFromTemplateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GuildCreateFromTemplateSpec instance) {
      return from((GuildCreateFromTemplateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code GuildCreateFromTemplateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(GuildCreateFromTemplateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      icon(instance.icon());
      return this;
    }

    /**
     * Initializes the value for the {@link GuildCreateFromTemplateSpec#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder icon(Possible<Image> value) {
      this.icon_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder icon(Image value) {
      this.icon_possible = Possible.of(value);
      return this;
    }

    /**
     * Builds a new {@link GuildCreateFromTemplateSpec GuildCreateFromTemplateSpec}.
     * @return An immutable instance of GuildCreateFromTemplateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GuildCreateFromTemplateSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GuildCreateFromTemplateSpec(name, icon_build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build GuildCreateFromTemplateSpec, some of required attributes are not set " + attributes;
    }

    private Possible<Image> icon_build() {
      return this.icon_possible;
    }
  }
}
