package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.GuildTemplate;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GuildCreateFromTemplateMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code GuildCreateFromTemplateMono.of()}.
 */
@Generated(from = "GuildCreateFromTemplateMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildCreateFromTemplateMono
    extends GuildCreateFromTemplateMonoGenerator {
  private final String name;
  private final Image icon_value;
  private final boolean icon_absent;
  private final GuildTemplate guildTemplate;

  private GuildCreateFromTemplateMono(String name, GuildTemplate guildTemplate) {
    this.name = Objects.requireNonNull(name, "name");
    this.guildTemplate = Objects.requireNonNull(guildTemplate, "guildTemplate");
    Possible<Image> icon$impl = Possible.absent();
    this.icon_value = icon$impl.toOptional().orElse(null);
    this.icon_absent = icon$impl.isAbsent();
    this.initShim = null;
  }

  private GuildCreateFromTemplateMono(
      String name,
      Possible<Image> icon,
      GuildTemplate guildTemplate) {
    this.name = name;
    Possible<Image> icon$impl = icon;
    this.guildTemplate = guildTemplate;
    this.icon_value = icon$impl.toOptional().orElse(null);
    this.icon_absent = icon$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GuildCreateFromTemplateMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build GuildCreateFromTemplateMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @Override
  public Possible<Image> icon() {
    return icon_absent ? Possible.absent() : Possible.of(icon_value);
  }

  /**
   * @return The value of the {@code guildTemplate} attribute
   */
  @Override
  public GuildTemplate guildTemplate() {
    return guildTemplate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateFromTemplateMono#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateFromTemplateMono withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new GuildCreateFromTemplateMono(newValue, this.icon(), this.guildTemplate);
  }

  public GuildCreateFromTemplateMono withIcon(Possible<Image> value) {
    Possible<Image> newValue = Objects.requireNonNull(value);
    return new GuildCreateFromTemplateMono(this.name, newValue, this.guildTemplate);
  }

  public GuildCreateFromTemplateMono withIcon(Image value) {
    Possible<Image> newValue = Possible.of(value);
    return new GuildCreateFromTemplateMono(this.name, newValue, this.guildTemplate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildCreateFromTemplateMono#guildTemplate() guildTemplate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guildTemplate
   * @return A modified copy of the {@code this} object
   */
  public final GuildCreateFromTemplateMono withGuildTemplate(GuildTemplate value) {
    if (this.guildTemplate == value) return this;
    GuildTemplate newValue = Objects.requireNonNull(value, "guildTemplate");
    return new GuildCreateFromTemplateMono(this.name, this.icon(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildCreateFromTemplateMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildCreateFromTemplateMono
        && equalTo(0, (GuildCreateFromTemplateMono) another);
  }

  private boolean equalTo(int synthetic, GuildCreateFromTemplateMono another) {
    return name.equals(another.name)
        && this.icon().equals(another.icon())
        && guildTemplate.equals(another.guildTemplate);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code icon}, {@code guildTemplate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (icon().hashCode());
    h += (h << 5) + guildTemplate.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildCreateFromTemplateMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildCreateFromTemplateMono{"
        + "name=" + name
        + ", icon=" + (icon().toString())
        + ", guildTemplate=" + guildTemplate
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildCreateFromTemplateMono} instance.
   * @param name The value for the {@code name} attribute
   * @param guildTemplate The value for the {@code guildTemplate} attribute
   * @return An immutable GuildCreateFromTemplateMono instance
   */
  public static GuildCreateFromTemplateMono of(String name, GuildTemplate guildTemplate) {
    return new GuildCreateFromTemplateMono(name, guildTemplate);
  }

  /**
   * Creates an immutable copy of a {@link GuildCreateFromTemplateMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildCreateFromTemplateMono instance
   */
  static GuildCreateFromTemplateMono copyOf(GuildCreateFromTemplateMonoGenerator instance) {
    if (instance instanceof GuildCreateFromTemplateMono) {
      return (GuildCreateFromTemplateMono) instance;
    }
    return GuildCreateFromTemplateMono.of(instance.name(), instance.guildTemplate())
        .withIcon(instance.icon());
  }

  public boolean isIconPresent() {
    return !icon_absent;
  }

  public Image iconOrElse(Image defaultValue) {
    return !icon_absent ? icon_value : defaultValue;
  }
}
