package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link GuildBanQueryMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code GuildBanQueryMono.of()}.
 */
@Generated(from = "GuildBanQueryMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class GuildBanQueryMono extends GuildBanQueryMonoGenerator {
  private final @Nullable String reason;
  private final @Nullable Integer deleteMessageDays;
  private final Snowflake userId;
  private final Guild guild;

  private GuildBanQueryMono(Snowflake userId, Guild guild) {
    this.userId = Objects.requireNonNull(userId, "userId");
    this.guild = Objects.requireNonNull(guild, "guild");
    this.reason = null;
    this.deleteMessageDays = null;
  }

  private GuildBanQueryMono(
      @Nullable String reason,
      @Nullable Integer deleteMessageDays,
      Snowflake userId,
      Guild guild) {
    this.reason = reason;
    this.deleteMessageDays = deleteMessageDays;
    this.userId = userId;
    this.guild = guild;
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code deleteMessageDays} attribute
   */
  @Override
  public @Nullable Integer deleteMessageDays() {
    return deleteMessageDays;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @Override
  public Snowflake userId() {
    return userId;
  }

  /**
   * @return The value of the {@code guild} attribute
   */
  @Override
  public Guild guild() {
    return guild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildBanQueryMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildBanQueryMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new GuildBanQueryMono(value, this.deleteMessageDays, this.userId, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildBanQueryMono#deleteMessageDays() deleteMessageDays} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deleteMessageDays (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GuildBanQueryMono withDeleteMessageDays(@Nullable Integer value) {
    if (Objects.equals(this.deleteMessageDays, value)) return this;
    return new GuildBanQueryMono(this.reason, value, this.userId, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildBanQueryMono#userId() userId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final GuildBanQueryMono withUserId(Snowflake value) {
    if (this.userId == value) return this;
    Snowflake newValue = Objects.requireNonNull(value, "userId");
    return new GuildBanQueryMono(this.reason, this.deleteMessageDays, newValue, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GuildBanQueryMono#guild() guild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guild
   * @return A modified copy of the {@code this} object
   */
  public final GuildBanQueryMono withGuild(Guild value) {
    if (this.guild == value) return this;
    Guild newValue = Objects.requireNonNull(value, "guild");
    return new GuildBanQueryMono(this.reason, this.deleteMessageDays, this.userId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code GuildBanQueryMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GuildBanQueryMono
        && equalTo(0, (GuildBanQueryMono) another);
  }

  private boolean equalTo(int synthetic, GuildBanQueryMono another) {
    return Objects.equals(reason, another.reason)
        && Objects.equals(deleteMessageDays, another.deleteMessageDays)
        && userId.equals(another.userId)
        && guild.equals(another.guild);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code deleteMessageDays}, {@code userId}, {@code guild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + Objects.hashCode(deleteMessageDays);
    h += (h << 5) + userId.hashCode();
    h += (h << 5) + guild.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GuildBanQueryMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GuildBanQueryMono{"
        + "reason=" + reason
        + ", deleteMessageDays=" + deleteMessageDays
        + ", userId=" + userId
        + ", guild=" + guild
        + "}";
  }

  /**
   * Construct a new immutable {@code GuildBanQueryMono} instance.
   * @param userId The value for the {@code userId} attribute
   * @param guild The value for the {@code guild} attribute
   * @return An immutable GuildBanQueryMono instance
   */
  public static GuildBanQueryMono of(Snowflake userId, Guild guild) {
    return new GuildBanQueryMono(userId, guild);
  }

  /**
   * Creates an immutable copy of a {@link GuildBanQueryMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuildBanQueryMono instance
   */
  static GuildBanQueryMono copyOf(GuildBanQueryMonoGenerator instance) {
    if (instance instanceof GuildBanQueryMono) {
      return (GuildBanQueryMono) instance;
    }
    return GuildBanQueryMono.of(instance.userId(), instance.guild())
        .withReason(instance.reason())
        .withDeleteMessageDays(instance.deleteMessageDays());
  }
}
