package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link EmbedCreateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code EmbedCreateSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code EmbedCreateSpec.create()}.
 */
@Generated(from = "EmbedCreateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class EmbedCreateSpec implements EmbedCreateSpecGenerator {
  private final String title_value;
  private final boolean title_absent;
  private final String description_value;
  private final boolean description_absent;
  private final String url_value;
  private final boolean url_absent;
  private final Instant timestamp_value;
  private final boolean timestamp_absent;
  private final Color color_value;
  private final boolean color_absent;
  private final @Nullable ImmutableEmbedCreateFields.Footer footer;
  private final String image_value;
  private final boolean image_absent;
  private final String thumbnail_value;
  private final boolean thumbnail_absent;
  private final @Nullable ImmutableEmbedCreateFields.Author author;
  private final List<EmbedCreateFields.Field> fields;

  private EmbedCreateSpec() {
    Possible<String> title$impl = Possible.absent();
    Possible<String> description$impl = Possible.absent();
    Possible<String> url$impl = Possible.absent();
    Possible<Instant> timestamp$impl = Possible.absent();
    Possible<Color> color$impl = Possible.absent();
    this.footer = null;
    Possible<String> image$impl = Possible.absent();
    Possible<String> thumbnail$impl = Possible.absent();
    this.author = null;
    this.title_value = title$impl.toOptional().orElse(null);
    this.title_absent = title$impl.isAbsent();
    this.description_value = description$impl.toOptional().orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.url_value = url$impl.toOptional().orElse(null);
    this.url_absent = url$impl.isAbsent();
    this.timestamp_value = timestamp$impl.toOptional().orElse(null);
    this.timestamp_absent = timestamp$impl.isAbsent();
    this.color_value = color$impl.toOptional().orElse(null);
    this.color_absent = color$impl.isAbsent();
    this.image_value = image$impl.toOptional().orElse(null);
    this.image_absent = image$impl.isAbsent();
    this.thumbnail_value = thumbnail$impl.toOptional().orElse(null);
    this.thumbnail_absent = thumbnail$impl.isAbsent();
    this.fields = initShim.fields();
    this.initShim = null;
  }

  private EmbedCreateSpec(EmbedCreateSpec.Builder builder) {
    Possible<String> title$impl = builder.title_build();
    Possible<String> description$impl = builder.description_build();
    Possible<String> url$impl = builder.url_build();
    Possible<Instant> timestamp$impl = builder.timestamp_build();
    Possible<Color> color$impl = builder.color_build();
    this.footer = builder.footer == null ? null : ImmutableEmbedCreateFields.Footer.copyOf(builder.footer);
    Possible<String> image$impl = builder.image_build();
    Possible<String> thumbnail$impl = builder.thumbnail_build();
    this.author = builder.author == null ? null : ImmutableEmbedCreateFields.Author.copyOf(builder.author);
    if (builder.fieldsIsSet()) {
      initShim.fields(createUnmodifiableList(true, builder.fields));
    }
    this.title_value = title$impl.toOptional().orElse(null);
    this.title_absent = title$impl.isAbsent();
    this.description_value = description$impl.toOptional().orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.url_value = url$impl.toOptional().orElse(null);
    this.url_absent = url$impl.isAbsent();
    this.timestamp_value = timestamp$impl.toOptional().orElse(null);
    this.timestamp_absent = timestamp$impl.isAbsent();
    this.color_value = color$impl.toOptional().orElse(null);
    this.color_absent = color$impl.isAbsent();
    this.image_value = image$impl.toOptional().orElse(null);
    this.image_absent = image$impl.isAbsent();
    this.thumbnail_value = thumbnail$impl.toOptional().orElse(null);
    this.thumbnail_absent = thumbnail$impl.isAbsent();
    this.fields = initShim.fields();
    this.initShim = null;
  }

  private EmbedCreateSpec(
      Possible<String> title,
      Possible<String> description,
      Possible<String> url,
      Possible<Instant> timestamp,
      Possible<Color> color,
      @Nullable ImmutableEmbedCreateFields.Footer footer,
      Possible<String> image,
      Possible<String> thumbnail,
      @Nullable ImmutableEmbedCreateFields.Author author,
      List<EmbedCreateFields.Field> fields) {
    Possible<String> title$impl = title;
    Possible<String> description$impl = description;
    Possible<String> url$impl = url;
    Possible<Instant> timestamp$impl = timestamp;
    Possible<Color> color$impl = color;
    this.footer = footer;
    Possible<String> image$impl = image;
    Possible<String> thumbnail$impl = thumbnail;
    this.author = author;
    initShim.fields(fields);
    this.title_value = title$impl.toOptional().orElse(null);
    this.title_absent = title$impl.isAbsent();
    this.description_value = description$impl.toOptional().orElse(null);
    this.description_absent = description$impl.isAbsent();
    this.url_value = url$impl.toOptional().orElse(null);
    this.url_absent = url$impl.isAbsent();
    this.timestamp_value = timestamp$impl.toOptional().orElse(null);
    this.timestamp_absent = timestamp$impl.isAbsent();
    this.color_value = color$impl.toOptional().orElse(null);
    this.color_absent = color$impl.isAbsent();
    this.image_value = image$impl.toOptional().orElse(null);
    this.image_absent = image$impl.isAbsent();
    this.thumbnail_value = thumbnail$impl.toOptional().orElse(null);
    this.thumbnail_absent = thumbnail$impl.isAbsent();
    this.fields = initShim.fields();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "EmbedCreateSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private byte fieldsBuildStage = STAGE_UNINITIALIZED;
    private List<EmbedCreateFields.Field> fields;

    List<EmbedCreateFields.Field> fields() {
      if (fieldsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fieldsBuildStage == STAGE_UNINITIALIZED) {
        fieldsBuildStage = STAGE_INITIALIZING;
        this.fields = createUnmodifiableList(false, createSafeList(fieldsInitialize(), true, false));
        fieldsBuildStage = STAGE_INITIALIZED;
      }
      return this.fields;
    }

    void fields(List<EmbedCreateFields.Field> fields) {
      this.fields = fields;
      fieldsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (fieldsBuildStage == STAGE_INITIALIZING) attributes.add("fields");
      return "Cannot build EmbedCreateSpec, attribute initializers form cycle " + attributes;
    }
  }

  private List<EmbedCreateFields.Field> fieldsInitialize() {
    return EmbedCreateSpecGenerator.super.fields();
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @Override
  public Possible<String> title() {
    return title_absent ? Possible.absent() : Possible.of(title_value);
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public Possible<String> description() {
    return description_absent ? Possible.absent() : Possible.of(description_value);
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @Override
  public Possible<String> url() {
    return url_absent ? Possible.absent() : Possible.of(url_value);
  }

  /**
   * @return The value of the {@code timestamp} attribute
   */
  @Override
  public Possible<Instant> timestamp() {
    return timestamp_absent ? Possible.absent() : Possible.of(timestamp_value);
  }

  /**
   * @return The value of the {@code color} attribute
   */
  @Override
  public Possible<Color> color() {
    return color_absent ? Possible.absent() : Possible.of(color_value);
  }

  /**
   * @return The value of the {@code footer} attribute
   */
  @Override
  public @Nullable ImmutableEmbedCreateFields.Footer footer() {
    return footer;
  }

  /**
   * @return The value of the {@code image} attribute
   */
  @Override
  public Possible<String> image() {
    return image_absent ? Possible.absent() : Possible.of(image_value);
  }

  /**
   * @return The value of the {@code thumbnail} attribute
   */
  @Override
  public Possible<String> thumbnail() {
    return thumbnail_absent ? Possible.absent() : Possible.of(thumbnail_value);
  }

  /**
   * @return The value of the {@code author} attribute
   */
  @Override
  public @Nullable ImmutableEmbedCreateFields.Author author() {
    return author;
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @Override
  public List<EmbedCreateFields.Field> fields() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.fields()
        : this.fields;
  }

  public EmbedCreateSpec withTitle(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new EmbedCreateSpec(
        newValue,
        this.description(),
        this.url(),
        this.timestamp(),
        this.color(),
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withTitle(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new EmbedCreateSpec(
        newValue,
        this.description(),
        this.url(),
        this.timestamp(),
        this.color(),
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withDescription(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        newValue,
        this.url(),
        this.timestamp(),
        this.color(),
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withDescription(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        newValue,
        this.url(),
        this.timestamp(),
        this.color(),
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withUrl(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        newValue,
        this.timestamp(),
        this.color(),
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withUrl(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        newValue,
        this.timestamp(),
        this.color(),
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withTimestamp(Possible<Instant> value) {
    Possible<Instant> newValue = Objects.requireNonNull(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        newValue,
        this.color(),
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withTimestamp(Instant value) {
    Possible<Instant> newValue = Possible.of(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        newValue,
        this.color(),
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withColor(Possible<Color> value) {
    Possible<Color> newValue = Objects.requireNonNull(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        this.timestamp(),
        newValue,
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withColor(Color value) {
    Possible<Color> newValue = Possible.of(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        this.timestamp(),
        newValue,
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        this.fields));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmbedCreateSpec#footer() footer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for footer (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final EmbedCreateSpec withFooter(@Nullable EmbedCreateFields.Footer value) {
    if (this.footer == value) return this;
    ImmutableEmbedCreateFields.Footer newValue = value == null ? null : ImmutableEmbedCreateFields.Footer.copyOf(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        this.timestamp(),
        this.color(),
        newValue,
        this.image(),
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withImage(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        this.timestamp(),
        this.color(),
        this.footer,
        newValue,
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withImage(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        this.timestamp(),
        this.color(),
        this.footer,
        newValue,
        this.thumbnail(),
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withThumbnail(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        this.timestamp(),
        this.color(),
        this.footer,
        this.image(),
        newValue,
        this.author,
        this.fields));
  }

  public EmbedCreateSpec withThumbnail(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        this.timestamp(),
        this.color(),
        this.footer,
        this.image(),
        newValue,
        this.author,
        this.fields));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmbedCreateSpec#author() author} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final EmbedCreateSpec withAuthor(@Nullable EmbedCreateFields.Author value) {
    if (this.author == value) return this;
    ImmutableEmbedCreateFields.Author newValue = value == null ? null : ImmutableEmbedCreateFields.Author.copyOf(value);
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        this.timestamp(),
        this.color(),
        this.footer,
        this.image(),
        this.thumbnail(),
        newValue,
        this.fields));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EmbedCreateSpec#fields() fields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final EmbedCreateSpec withFields(EmbedCreateFields.Field... elements) {
    List<EmbedCreateFields.Field> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        this.timestamp(),
        this.color(),
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EmbedCreateSpec#fields() fields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fields elements to set
   * @return A modified copy of {@code this} object
   */
  public final EmbedCreateSpec withFields(Iterable<? extends EmbedCreateFields.Field> elements) {
    if (this.fields == elements) return this;
    List<EmbedCreateFields.Field> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new EmbedCreateSpec(
        this.title(),
        this.description(),
        this.url(),
        this.timestamp(),
        this.color(),
        this.footer,
        this.image(),
        this.thumbnail(),
        this.author,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code EmbedCreateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof EmbedCreateSpec
        && equalTo(0, (EmbedCreateSpec) another);
  }

  private boolean equalTo(int synthetic, EmbedCreateSpec another) {
    return this.title().equals(another.title())
        && this.description().equals(another.description())
        && this.url().equals(another.url())
        && this.timestamp().equals(another.timestamp())
        && this.color().equals(another.color())
        && Objects.equals(footer, another.footer)
        && this.image().equals(another.image())
        && this.thumbnail().equals(another.thumbnail())
        && Objects.equals(author, another.author)
        && fields.equals(another.fields);
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code description}, {@code url}, {@code timestamp}, {@code color}, {@code footer}, {@code image}, {@code thumbnail}, {@code author}, {@code fields}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (title().hashCode());
    h += (h << 5) + (description().hashCode());
    h += (h << 5) + (url().hashCode());
    h += (h << 5) + (timestamp().hashCode());
    h += (h << 5) + (color().hashCode());
    h += (h << 5) + Objects.hashCode(footer);
    h += (h << 5) + (image().hashCode());
    h += (h << 5) + (thumbnail().hashCode());
    h += (h << 5) + Objects.hashCode(author);
    h += (h << 5) + fields.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EmbedCreateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EmbedCreateSpec{"
        + "title=" + (title().toString())
        + ", description=" + (description().toString())
        + ", url=" + (url().toString())
        + ", timestamp=" + (timestamp().toString())
        + ", color=" + (color().toString())
        + ", footer=" + footer
        + ", image=" + (image().toString())
        + ", thumbnail=" + (thumbnail().toString())
        + ", author=" + author
        + ", fields=" + fields
        + "}";
  }

  private static final EmbedCreateSpec INSTANCE = validate(new EmbedCreateSpec());

  /**
   * Returns the default immutable singleton value of {@code EmbedCreateSpec}
   * @return An immutable instance of EmbedCreateSpec
   */
  public static EmbedCreateSpec create() {
    return INSTANCE;
  }

  private static EmbedCreateSpec validate(EmbedCreateSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link EmbedCreateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EmbedCreateSpec instance
   */
  static EmbedCreateSpec copyOf(EmbedCreateSpecGenerator instance) {
    if (instance instanceof EmbedCreateSpec) {
      return (EmbedCreateSpec) instance;
    }
    return EmbedCreateSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isTitlePresent() {
    return !title_absent;
  }

  public String titleOrElse(String defaultValue) {
    return !title_absent ? title_value : defaultValue;
  }

  public boolean isDescriptionPresent() {
    return !description_absent;
  }

  public String descriptionOrElse(String defaultValue) {
    return !description_absent ? description_value : defaultValue;
  }

  public boolean isUrlPresent() {
    return !url_absent;
  }

  public String urlOrElse(String defaultValue) {
    return !url_absent ? url_value : defaultValue;
  }

  public boolean isTimestampPresent() {
    return !timestamp_absent;
  }

  public Instant timestampOrElse(Instant defaultValue) {
    return !timestamp_absent ? timestamp_value : defaultValue;
  }

  public boolean isColorPresent() {
    return !color_absent;
  }

  public Color colorOrElse(Color defaultValue) {
    return !color_absent ? color_value : defaultValue;
  }

  public boolean isImagePresent() {
    return !image_absent;
  }

  public String imageOrElse(String defaultValue) {
    return !image_absent ? image_value : defaultValue;
  }

  public boolean isThumbnailPresent() {
    return !thumbnail_absent;
  }

  public String thumbnailOrElse(String defaultValue) {
    return !thumbnail_absent ? thumbnail_value : defaultValue;
  }

  /**
   * Creates a builder for {@link EmbedCreateSpec EmbedCreateSpec}.
   * <pre>
   * EmbedCreateSpec.builder()
   *    .title(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link EmbedCreateSpec#title() title}
   *    .description(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link EmbedCreateSpec#description() description}
   *    .url(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link EmbedCreateSpec#url() url}
   *    .timestamp(discord4j.discordjson.possible.Possible&amp;lt;java.time.Instant&amp;gt;) // {@link EmbedCreateSpec#timestamp() timestamp}
   *    .color(discord4j.discordjson.possible.Possible&amp;lt;discord4j.rest.util.Color&amp;gt;) // {@link EmbedCreateSpec#color() color}
   *    .footer(discord4j.core.spec.EmbedCreateFields.Footer | null) // nullable {@link EmbedCreateSpec#footer() footer}
   *    .image(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link EmbedCreateSpec#image() image}
   *    .thumbnail(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link EmbedCreateSpec#thumbnail() thumbnail}
   *    .author(discord4j.core.spec.EmbedCreateFields.Author | null) // nullable {@link EmbedCreateSpec#author() author}
   *    .addField|addAllFields(discord4j.core.spec.EmbedCreateFields.Field) // {@link EmbedCreateSpec#fields() fields} elements
   *    .build();
   * </pre>
   * @return A new EmbedCreateSpec builder
   */
  public static EmbedCreateSpec.Builder builder() {
    return new EmbedCreateSpec.Builder();
  }

  /**
   * Builds instances of type {@link EmbedCreateSpec EmbedCreateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EmbedCreateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long OPT_BIT_FIELDS = 0x1L;
    private long optBits;

    private Possible<String> title_possible = Possible.absent();
    private Possible<String> description_possible = Possible.absent();
    private Possible<String> url_possible = Possible.absent();
    private Possible<Instant> timestamp_possible = Possible.absent();
    private Possible<Color> color_possible = Possible.absent();
    private Possible<String> image_possible = Possible.absent();
    private Possible<String> thumbnail_possible = Possible.absent();
    private EmbedCreateFields.Footer footer;
    private EmbedCreateFields.Author author;
    private List<EmbedCreateFields.Field> fields = new ArrayList<EmbedCreateFields.Field>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EmbedCreateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EmbedCreateSpec instance) {
      return from((EmbedCreateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code EmbedCreateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(EmbedCreateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      title(instance.title());
      description(instance.description());
      url(instance.url());
      timestamp(instance.timestamp());
      color(instance.color());
      EmbedCreateFields.Footer footerValue = instance.footer();
      if (footerValue != null) {
        footer(footerValue);
      }
      image(instance.image());
      thumbnail(instance.thumbnail());
      EmbedCreateFields.Author authorValue = instance.author();
      if (authorValue != null) {
        author(authorValue);
      }
      addAllFields(instance.fields());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder title(Possible<String> value) {
      this.title_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder title(String value) {
      this.title_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder description(Possible<String> value) {
      this.description_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder description(String value) {
      this.description_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder url(Possible<String> value) {
      this.url_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder url(String value) {
      this.url_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder timestamp(Possible<Instant> value) {
      this.timestamp_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder timestamp(Instant value) {
      this.timestamp_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder color(Possible<Color> value) {
      this.color_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder color(Color value) {
      this.color_possible = Possible.of(value);
      return this;
    }

    /**
     * Constructs and initializes the value for the {@link EmbedCreateSpec#footer() footer} attribute.
     * @param text The value for {@code footer.text} 
     * @param iconUrl The value for {@code footer.iconUrl} (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder footer(String text, @Nullable String iconUrl) {
      return footer(ImmutableEmbedCreateFields.Footer.of(text, iconUrl));
    }

    /**
     * Initializes the value for the {@link EmbedCreateSpec#footer() footer} attribute.
     * @param footer The value for footer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder footer(@Nullable EmbedCreateFields.Footer footer) {
      this.footer = footer == null ? null : ImmutableEmbedCreateFields.Footer.copyOf(footer);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder image(Possible<String> value) {
      this.image_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder image(String value) {
      this.image_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder thumbnail(Possible<String> value) {
      this.thumbnail_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder thumbnail(String value) {
      this.thumbnail_possible = Possible.of(value);
      return this;
    }

    /**
     * Constructs and initializes the value for the {@link EmbedCreateSpec#author() author} attribute.
     * @param name The value for {@code author.name} 
     * @param url The value for {@code author.url} (can be {@code null})
     * @param iconUrl The value for {@code author.iconUrl} (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder author(String name, @Nullable String url, @Nullable String iconUrl) {
      return author(ImmutableEmbedCreateFields.Author.of(name, url, iconUrl));
    }

    /**
     * Initializes the value for the {@link EmbedCreateSpec#author() author} attribute.
     * @param author The value for author (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder author(@Nullable EmbedCreateFields.Author author) {
      this.author = author == null ? null : ImmutableEmbedCreateFields.Author.copyOf(author);
      return this;
    }

    /**
     * Adds one element to {@link EmbedCreateSpec#fields() fields} list.
     * @param element A fields element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addField(EmbedCreateFields.Field element) {
      element = ImmutableEmbedCreateFields.Field.copyOf(element);
      this.fields.add(Objects.requireNonNull(element, "fields element"));
      optBits |= OPT_BIT_FIELDS;
      return this;
    }

    /**
     * Constructs and adds an element for the {@link EmbedCreateSpec#fields() fields} list.
     * @param name The value for {@code fields.name} 
     * @param value The value for {@code fields.value} 
     * @param inline The value for {@code fields.inline} 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addField(String name, String value, boolean inline) {
      return addField(ImmutableEmbedCreateFields.Field.of(name, value, inline));
    }

    /**
     * Adds elements to {@link EmbedCreateSpec#fields() fields} list.
     * @param elements An array of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFields(EmbedCreateFields.Field... elements) {
      for (EmbedCreateFields.Field element : elements) {
        element = ImmutableEmbedCreateFields.Field.copyOf(element);
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      optBits |= OPT_BIT_FIELDS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link EmbedCreateSpec#fields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fields(Iterable<? extends EmbedCreateFields.Field> elements) {
      this.fields.clear();
      return addAllFields(elements);
    }

    /**
     * Adds elements to {@link EmbedCreateSpec#fields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFields(Iterable<? extends EmbedCreateFields.Field> elements) {
      for (EmbedCreateFields.Field element : elements) {
        element = ImmutableEmbedCreateFields.Field.copyOf(element);
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      optBits |= OPT_BIT_FIELDS;
      return this;
    }

    /**
     * Builds a new {@link EmbedCreateSpec EmbedCreateSpec}.
     * @return An immutable instance of EmbedCreateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public EmbedCreateSpec build() {
      return EmbedCreateSpec.validate(new EmbedCreateSpec(this));
    }

    private boolean fieldsIsSet() {
      return (optBits & OPT_BIT_FIELDS) != 0;
    }

    private Possible<String> title_build() {
      return this.title_possible;
    }

    private Possible<String> description_build() {
      return this.description_possible;
    }

    private Possible<String> url_build() {
      return this.url_possible;
    }

    private Possible<Instant> timestamp_build() {
      return this.timestamp_possible;
    }

    private Possible<Color> color_build() {
      return this.color_possible;
    }

    private Possible<String> image_build() {
      return this.image_possible;
    }

    private Possible<String> thumbnail_build() {
      return this.thumbnail_possible;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
