package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.Category;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link CategoryEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code CategoryEditMono.of()}.
 */
@Generated(from = "CategoryEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class CategoryEditMono extends CategoryEditMonoGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;
  private final Category category;

  private CategoryEditMono(Category category) {
    this.category = Objects.requireNonNull(category, "category");
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.initShim = null;
  }

  private CategoryEditMono(
      @Nullable String reason,
      Possible<String> name,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites,
      Category category) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    this.category = category;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CategoryEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build CategoryEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * @return The value of the {@code category} attribute
   */
  @Override
  public Category category() {
    return category;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CategoryEditMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final CategoryEditMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new CategoryEditMono(value, this.name(), this.position(), this.permissionOverwrites(), this.category);
  }

  public CategoryEditMono withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new CategoryEditMono(this.reason, newValue, this.position(), this.permissionOverwrites(), this.category);
  }

  public CategoryEditMono withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return new CategoryEditMono(this.reason, newValue, this.position(), this.permissionOverwrites(), this.category);
  }

  public CategoryEditMono withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new CategoryEditMono(this.reason, this.name(), newValue, this.permissionOverwrites(), this.category);
  }

  public CategoryEditMono withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new CategoryEditMono(this.reason, this.name(), newValue, this.permissionOverwrites(), this.category);
  }

  public CategoryEditMono withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return new CategoryEditMono(this.reason, this.name(), this.position(), newValue, this.category);
  }

  public CategoryEditMono withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new CategoryEditMono(this.reason, this.name(), this.position(), newValue, this.category);
  }

  @SafeVarargs
  public final CategoryEditMono withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return new CategoryEditMono(this.reason, this.name(), this.position(), newValue, this.category);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CategoryEditMono#category() category} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for category
   * @return A modified copy of the {@code this} object
   */
  public final CategoryEditMono withCategory(Category value) {
    if (this.category == value) return this;
    Category newValue = Objects.requireNonNull(value, "category");
    return new CategoryEditMono(this.reason, this.name(), this.position(), this.permissionOverwrites(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code CategoryEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CategoryEditMono
        && equalTo(0, (CategoryEditMono) another);
  }

  private boolean equalTo(int synthetic, CategoryEditMono another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value)
        && category.equals(another.category);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code position}, {@code permissionOverwrites}, {@code category}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    h += (h << 5) + category.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CategoryEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CategoryEditMono{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + ", category=" + category
        + "}";
  }

  /**
   * Construct a new immutable {@code CategoryEditMono} instance.
   * @param category The value for the {@code category} attribute
   * @return An immutable CategoryEditMono instance
   */
  public static CategoryEditMono of(Category category) {
    return new CategoryEditMono(category);
  }

  /**
   * Creates an immutable copy of a {@link CategoryEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CategoryEditMono instance
   */
  static CategoryEditMono copyOf(CategoryEditMonoGenerator instance) {
    if (instance instanceof CategoryEditMono) {
      return (CategoryEditMono) instance;
    }
    return CategoryEditMono.of(instance.category())
        .withReason(instance.reason())
        .withName(instance.name())
        .withPosition(instance.position())
        .withPermissionOverwrites(instance.permissionOverwrites());
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }
}
