package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.PermissionOverwrite;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link CategoryCreateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CategoryCreateSpec.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code CategoryCreateSpec.of()}.
 */
@Generated(from = "CategoryCreateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class CategoryCreateSpec implements CategoryCreateSpecGenerator {
  private final @Nullable String reason;
  private final String name;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;

  private CategoryCreateSpec(String name) {
    this.name = Objects.requireNonNull(name, "name");
    this.reason = null;
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.initShim = null;
  }

  private CategoryCreateSpec(
      @Nullable String reason,
      String name,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites) {
    this.reason = reason;
    this.name = name;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CategoryCreateSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build CategoryCreateSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CategoryCreateSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final CategoryCreateSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new CategoryCreateSpec(value, this.name, this.position(), this.permissionOverwrites());
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CategoryCreateSpec#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final CategoryCreateSpec withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new CategoryCreateSpec(this.reason, newValue, this.position(), this.permissionOverwrites());
  }

  public CategoryCreateSpec withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new CategoryCreateSpec(this.reason, this.name, newValue, this.permissionOverwrites());
  }

  public CategoryCreateSpec withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new CategoryCreateSpec(this.reason, this.name, newValue, this.permissionOverwrites());
  }

  public CategoryCreateSpec withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return new CategoryCreateSpec(this.reason, this.name, this.position(), newValue);
  }

  public CategoryCreateSpec withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new CategoryCreateSpec(this.reason, this.name, this.position(), newValue);
  }

  @SafeVarargs
  public final CategoryCreateSpec withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return new CategoryCreateSpec(this.reason, this.name, this.position(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code CategoryCreateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CategoryCreateSpec
        && equalTo(0, (CategoryCreateSpec) another);
  }

  private boolean equalTo(int synthetic, CategoryCreateSpec another) {
    return Objects.equals(reason, another.reason)
        && name.equals(another.name)
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code position}, {@code permissionOverwrites}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    return h;
  }

  /**
   * Prints the immutable value {@code CategoryCreateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CategoryCreateSpec{"
        + "reason=" + reason
        + ", name=" + name
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + "}";
  }

  /**
   * Construct a new immutable {@code CategoryCreateSpec} instance.
   * @param name The value for the {@code name} attribute
   * @return An immutable CategoryCreateSpec instance
   */
  public static CategoryCreateSpec of(String name) {
    return new CategoryCreateSpec(name);
  }

  /**
   * Creates an immutable copy of a {@link CategoryCreateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CategoryCreateSpec instance
   */
  static CategoryCreateSpec copyOf(CategoryCreateSpecGenerator instance) {
    if (instance instanceof CategoryCreateSpec) {
      return (CategoryCreateSpec) instance;
    }
    return CategoryCreateSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }

  /**
   * Creates a builder for {@link CategoryCreateSpec CategoryCreateSpec}.
   * <pre>
   * CategoryCreateSpec.builder()
   *    .reason(String | null) // nullable {@link CategoryCreateSpec#reason() reason}
   *    .name(String) // required {@link CategoryCreateSpec#name() name}
   *    .position(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link CategoryCreateSpec#position() position}
   *    .permissionOverwrites(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.object.PermissionOverwrite&amp;gt;&amp;gt;) // {@link CategoryCreateSpec#permissionOverwrites() permissionOverwrites}
   *    .build();
   * </pre>
   * @return A new CategoryCreateSpec builder
   */
  public static CategoryCreateSpec.Builder builder() {
    return new CategoryCreateSpec.Builder();
  }

  /**
   * Builds instances of type {@link CategoryCreateSpec CategoryCreateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CategoryCreateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Possible<Integer> position_possible = Possible.absent();
    private List<PermissionOverwrite> permissionOverwrites_list = null;
    private String reason;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CategoryCreateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CategoryCreateSpec instance) {
      return from((CategoryCreateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code CategoryCreateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(CategoryCreateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      name(instance.name());
      position(instance.position());
      permissionOverwrites(instance.permissionOverwrites());
      return this;
    }

    /**
     * Initializes the value for the {@link CategoryCreateSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the value for the {@link CategoryCreateSpec#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder position(Possible<Integer> value) {
      this.position_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder position(Integer value) {
      this.position_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addPermissionOverwrite(PermissionOverwrite element) {
      permissionOverwrites_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllPermissionOverwrites(List<PermissionOverwrite> elements) {
      permissionOverwrites_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(Possible<List<PermissionOverwrite>> elements) {
      this.permissionOverwrites_list = null;
      elements.toOptional().ifPresent(e -> permissionOverwrites_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(List<PermissionOverwrite> elements) {
      this.permissionOverwrites_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(Iterable<PermissionOverwrite> elements) {
      this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    /**
     * Builds a new {@link CategoryCreateSpec CategoryCreateSpec}.
     * @return An immutable instance of CategoryCreateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CategoryCreateSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CategoryCreateSpec(reason, name, position_build(), permissionOverwrites_build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CategoryCreateSpec, some of required attributes are not set " + attributes;
    }

    private Possible<Integer> position_build() {
      return this.position_possible;
    }

    private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
      return this.permissionOverwrites_list == null ? Possible.absent() :
          Possible.of(this.permissionOverwrites_list);
    }

    private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
      if (this.permissionOverwrites_list == null) {
        this.permissionOverwrites_list = new ArrayList<>();
      }
      return this.permissionOverwrites_list;
    }
  }
}
