package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link CategoryCreateMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code CategoryCreateMono.of()}.
 */
@Generated(from = "CategoryCreateMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class CategoryCreateMono extends CategoryCreateMonoGenerator {
  private final @Nullable String reason;
  private final String name;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;
  private final Guild guild;

  private CategoryCreateMono(String name, Guild guild) {
    this.name = Objects.requireNonNull(name, "name");
    this.guild = Objects.requireNonNull(guild, "guild");
    this.reason = null;
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.initShim = null;
  }

  private CategoryCreateMono(
      @Nullable String reason,
      String name,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites,
      Guild guild) {
    this.reason = reason;
    this.name = name;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    this.guild = guild;
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CategoryCreateMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build CategoryCreateMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * @return The value of the {@code guild} attribute
   */
  @Override
  public Guild guild() {
    return guild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CategoryCreateMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final CategoryCreateMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new CategoryCreateMono(value, this.name, this.position(), this.permissionOverwrites(), this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CategoryCreateMono#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final CategoryCreateMono withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new CategoryCreateMono(this.reason, newValue, this.position(), this.permissionOverwrites(), this.guild);
  }

  public CategoryCreateMono withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new CategoryCreateMono(this.reason, this.name, newValue, this.permissionOverwrites(), this.guild);
  }

  public CategoryCreateMono withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new CategoryCreateMono(this.reason, this.name, newValue, this.permissionOverwrites(), this.guild);
  }

  public CategoryCreateMono withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return new CategoryCreateMono(this.reason, this.name, this.position(), newValue, this.guild);
  }

  public CategoryCreateMono withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new CategoryCreateMono(this.reason, this.name, this.position(), newValue, this.guild);
  }

  @SafeVarargs
  public final CategoryCreateMono withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return new CategoryCreateMono(this.reason, this.name, this.position(), newValue, this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CategoryCreateMono#guild() guild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guild
   * @return A modified copy of the {@code this} object
   */
  public final CategoryCreateMono withGuild(Guild value) {
    if (this.guild == value) return this;
    Guild newValue = Objects.requireNonNull(value, "guild");
    return new CategoryCreateMono(this.reason, this.name, this.position(), this.permissionOverwrites(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code CategoryCreateMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CategoryCreateMono
        && equalTo(0, (CategoryCreateMono) another);
  }

  private boolean equalTo(int synthetic, CategoryCreateMono another) {
    return Objects.equals(reason, another.reason)
        && name.equals(another.name)
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value)
        && guild.equals(another.guild);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code position}, {@code permissionOverwrites}, {@code guild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    h += (h << 5) + guild.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CategoryCreateMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CategoryCreateMono{"
        + "reason=" + reason
        + ", name=" + name
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + ", guild=" + guild
        + "}";
  }

  /**
   * Construct a new immutable {@code CategoryCreateMono} instance.
   * @param name The value for the {@code name} attribute
   * @param guild The value for the {@code guild} attribute
   * @return An immutable CategoryCreateMono instance
   */
  public static CategoryCreateMono of(String name, Guild guild) {
    return new CategoryCreateMono(name, guild);
  }

  /**
   * Creates an immutable copy of a {@link CategoryCreateMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CategoryCreateMono instance
   */
  static CategoryCreateMono copyOf(CategoryCreateMonoGenerator instance) {
    if (instance instanceof CategoryCreateMono) {
      return (CategoryCreateMono) instance;
    }
    return CategoryCreateMono.of(instance.name(), instance.guild())
        .withReason(instance.reason())
        .withPosition(instance.position())
        .withPermissionOverwrites(instance.permissionOverwrites());
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }
}
